/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.AttributeFactory;
import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Deprecatable;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Feature_info
implements Deprecatable,
Visitable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    private Classfile classfile;
    private int accessFlag;
    private int nameIndex;
    private int descriptorIndex;
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Feature_info(Classfile classfile, DataInputStream in) throws IOException {
        this.classfile = classfile;
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " access flag: " + this.accessFlag));
        this.nameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " name: " + this.nameIndex + " (" + this.getName() + ")"));
        this.descriptorIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " Descriptor: " + this.descriptorIndex + " (" + this.getDescriptor() + ")"));
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " " + this.getFeatureType() + " attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getFeatureType() + " attribute " + i + ":"));
            this.attributes.add(AttributeFactory.create(this.getClassfile(), this, in));
        }
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    public int getAccessFlag() {
        return this.accessFlag;
    }

    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getAccessFlag() & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.getAccessFlag() & 2) != 0;
    }

    public boolean isPackage() {
        return (this.getAccessFlag() & 7) == 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlag() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public UTF8_info getRawName() {
        return (UTF8_info)this.getClassfile().getConstantPool().get(this.nameIndex);
    }

    public String getName() {
        return this.getRawName().toString();
    }

    public String getFullName() {
        return this.getClassfile().getClassName() + "." + this.getName();
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public UTF8_info getRawDescriptor() {
        return (UTF8_info)this.getClassfile().getConstantPool().get(this.descriptorIndex);
    }

    public String getDescriptor() {
        return this.getRawDescriptor().toString();
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    public boolean isSynthetic() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Synthetic_attribute;
        }
        return result;
    }

    @Override
    public boolean isDeprecated() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Deprecated_attribute;
        }
        return result;
    }

    public String toString() {
        return this.getFullName();
    }

    public abstract String getFeatureType();

    public abstract String getDeclaration();

    public abstract String getSignature();

    public String getFullSignature() {
        return this.getClassfile().getClassName() + "." + this.getSignature();
    }
}

