/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.NameAndType_info;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class FeatureRef_info
extends ConstantPoolEntry {
    private int classIndex;
    private int nameAndTypeIndex;

    public FeatureRef_info(ConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool);
        this.classIndex = in.readUnsignedShort();
        this.nameAndTypeIndex = in.readUnsignedShort();
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public Class_info getRawClass() {
        return (Class_info)this.getConstantPool().get(this.getClassIndex());
    }

    public String getClassName() {
        return this.getRawClass().toString();
    }

    public String getClassSimpleName() {
        return this.getRawClass().getSimpleName();
    }

    public int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    public NameAndType_info getRawNameAndType() {
        return (NameAndType_info)this.getConstantPool().get(this.getNameAndTypeIndex());
    }

    public String getNameAndType() {
        StringBuffer result = new StringBuffer();
        NameAndType_info nat = this.getRawNameAndType();
        result.append(nat.getName()).append(nat.getType());
        return result.toString();
    }

    public abstract String getName();

    public String getFullName() {
        return this.getClassName() + "." + this.getName();
    }

    public abstract String getSignature();

    public String getFullSignature() {
        return this.getClassName() + "." + this.getSignature();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Class_info c = this.getRawClass();
        NameAndType_info nat = this.getRawNameAndType();
        result.append(c).append(".").append(nat.getName()).append(nat.getType());
        return result.toString();
    }

    public int hashCode() {
        return this.getRawClass().hashCode() ^ this.getRawNameAndType().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            FeatureRef_info other = (FeatureRef_info)object;
            result = this.getRawClass().equals(other.getRawClass()) && this.getRawNameAndType().equals(other.getRawNameAndType());
        }
        return result;
    }
}

