/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exceptions_attribute
extends Attribute_info {
    private Collection<Class_info> exceptions = new LinkedList<Class_info>();

    public Exceptions_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int exceptionCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + exceptionCount + " exception(s) ..."));
        for (int i = 0; i < exceptionCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Exception " + i + ":"));
            Class_info exception = (Class_info)classfile.getConstantPool().get(in.readUnsignedShort());
            this.exceptions.add(exception);
            Logger.getLogger(this.getClass()).debug((Object)("Class " + exception));
        }
    }

    public Collection<Class_info> getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return "Exceptions";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitExceptions_attribute(this);
    }
}

