/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ExceptionHandler
implements Visitable {
    private Code_attribute code;
    private int startPC;
    private int endPC;
    private int handlerPC;
    private int catchTypeIndex;

    public ExceptionHandler(Code_attribute code, DataInputStream in) throws IOException {
        this.code = code;
        this.startPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("start PC: " + this.startPC));
        this.endPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("end PC: " + this.endPC));
        this.handlerPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("handler PC: " + this.handlerPC));
        this.catchTypeIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("catch type index: " + this.catchTypeIndex + " (" + this.getCatchType() + ")"));
    }

    public Code_attribute getCode() {
        return this.code;
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getEndPC() {
        return this.endPC;
    }

    public int getHandlerPC() {
        return this.handlerPC;
    }

    public int getCatchTypeIndex() {
        return this.catchTypeIndex;
    }

    public Class_info getRawCatchType() {
        return (Class_info)this.code.getClassfile().getConstantPool().get(this.getCatchTypeIndex());
    }

    public String getCatchType() {
        String result = "<none>";
        if (this.getCatchTypeIndex() != 0) {
            result = this.getRawCatchType().toString();
        }
        return result;
    }

    public String toString() {
        return "ExceptionHandler for " + this.getCatchType();
    }

    public void accept(Visitor visitor) {
        visitor.visitExceptionHandler(this);
    }
}

