/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderDecorator;
import com.jeantessier.classreader.DirectoryExplorer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class DirectoryClassfileLoader
extends ClassfileLoaderDecorator {
    public DirectoryClassfileLoader(ClassfileLoader loader) {
        super(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String filename) {
        Logger.getLogger(this.getClass()).debug((Object)("Starting group from path \"" + filename + "\""));
        try {
            DirectoryExplorer explorer = new DirectoryExplorer(filename);
            this.fireBeginGroup(filename, explorer.getFiles().size());
            for (File file : explorer.getFiles()) {
                this.fireBeginFile(file.getPath());
                Logger.getLogger(this.getClass()).debug((Object)("Starting file \"" + file.getPath() + "\" (" + file.length() + " bytes)"));
                if (!file.isDirectory()) {
                    try {
                        FileInputStream in = new FileInputStream(file);
                        this.getLoader().load(file.getPath(), in);
                        ((InputStream)in).close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass()).error((Object)("Cannot load file \"" + file.getPath() + "\""), (Throwable)ex);
                    }
                }
                this.fireEndFile(file.getPath());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).error((Object)("Cannot load group \"" + filename + "\""), (Throwable)ex);
        }
        finally {
            this.fireEndGroup(filename);
        }
    }

    protected void load(String filename, InputStream in) {
    }
}

