/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ConstantValue_attribute
extends Attribute_info {
    private int valueIndex;

    public ConstantValue_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.valueIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Constant value: " + this.getRawValue()));
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    public ConstantPoolEntry getRawValue() {
        return (ConstantPoolEntry)this.getClassfile().getConstantPool().get(this.getValueIndex());
    }

    public String toString() {
        return "ConstantValue " + this.getRawValue();
    }

    public int hashCode() {
        return this.getRawValue().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            ConstantValue_attribute other = (ConstantValue_attribute)object;
            result = this.getRawValue().equals(other.getRawValue());
        }
        return result;
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantValue_attribute(this);
    }
}

