/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.TextPrinter;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantPool
extends ArrayList<ConstantPoolEntry>
implements Visitable {
    private Classfile classfile;

    public ConstantPool(Classfile classfile, DataInputStream in) throws IOException {
        this.classfile = classfile;
        int count = in.readUnsignedShort();
        this.ensureCapacity(count);
        this.add(null);
        block13: for (int i = 1; i < count; ++i) {
            byte tag = in.readByte();
            switch (tag) {
                case 7: {
                    this.add(new Class_info(this, in));
                    continue block13;
                }
                case 9: {
                    this.add(new FieldRef_info(this, in));
                    continue block13;
                }
                case 10: {
                    this.add(new MethodRef_info(this, in));
                    continue block13;
                }
                case 11: {
                    this.add(new InterfaceMethodRef_info(this, in));
                    continue block13;
                }
                case 8: {
                    this.add(new String_info(this, in));
                    continue block13;
                }
                case 3: {
                    this.add(new Integer_info(this, in));
                    continue block13;
                }
                case 4: {
                    this.add(new Float_info(this, in));
                    continue block13;
                }
                case 5: {
                    this.add(new Long_info(this, in));
                    ++i;
                    this.add(null);
                    continue block13;
                }
                case 6: {
                    this.add(new Double_info(this, in));
                    ++i;
                    this.add(null);
                    continue block13;
                }
                case 12: {
                    this.add(new NameAndType_info(this, in));
                    continue block13;
                }
                case 1: {
                    this.add(new UTF8_info(this, in));
                    continue block13;
                }
                default: {
                    Logger.getLogger(this.getClass()).info((Object)("Unknown Tag " + tag));
                }
            }
        }
    }

    public Classfile getClassfile() {
        return this.classfile;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    @Override
    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("Constant Pool:");
        TextPrinter printer = new TextPrinter(writer);
        this.accept(printer);
        writer.close();
        return out.toString();
    }
}

