/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.AttributeFactory;
import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CodeIterator;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.text.Hex;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code_attribute
extends Attribute_info {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private Collection<ExceptionHandler> exceptionHandlers = new LinkedList<ExceptionHandler>();
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Code_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.maxStack = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Code max stack: " + this.maxStack));
        this.maxLocals = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Code max locals: " + this.maxLocals));
        int codeLength = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Code length: " + codeLength));
        this.code = new byte[codeLength];
        int bytesRead = in.read(this.code);
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)("Read " + bytesRead + " byte(s): " + Hex.toString(this.code)));
            Iterator ci = this.iterator();
            block3: while (ci.hasNext()) {
                Instruction instr = (Instruction)ci.next();
                int start = instr.getStart();
                int index = instr.getIndex();
                switch (instr.getOpcode()) {
                    case 18: 
                    case 19: 
                    case 20: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 187: 
                    case 189: 
                    case 192: 
                    case 193: 
                    case 197: {
                        Logger.getLogger(this.getClass()).debug((Object)("    " + start + ": " + instr + " " + index + " (" + instr.getIndexedConstantPoolEntry() + ")"));
                        continue block3;
                    }
                }
                Logger.getLogger(this.getClass()).debug((Object)("    " + start + ": " + instr + " (" + instr.getLength() + " byte(s))"));
            }
        }
        int exceptionTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + exceptionTableLength + " exception handler(s) ..."));
        for (int i = 0; i < exceptionTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Exception handler " + i + ":"));
            this.exceptionHandlers.add(new ExceptionHandler(this, in));
        }
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " code attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("code attribute " + i + ":"));
            this.attributes.add(AttributeFactory.create(this.getClassfile(), this, in));
        }
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public byte[] getCode() {
        return this.code;
    }

    public Iterator iterator() {
        return new CodeIterator(this, this.code);
    }

    public Collection<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return "Code";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCode_attribute(this);
    }
}

