/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.AttributeFactory;
import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.Deprecatable;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classfile
implements Deprecatable,
Visitable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private ClassfileLoader loader;
    private int magicNumber;
    private int minorVersion;
    private int majorVersion;
    private ConstantPool constantPool;
    private int accessFlag;
    private int classIndex;
    private int superclassIndex;
    private Map<String, Class_info> interfaces = new TreeMap<String, Class_info>();
    private Map<String, Field_info> fields = new TreeMap<String, Field_info>();
    private Map<String, Method_info> methods = new TreeMap<String, Method_info>();
    private Collection<Attribute_info> attributes = new LinkedList<Attribute_info>();

    public Classfile(ClassfileLoader loader, DataInputStream in) throws IOException {
        this.loader = loader;
        this.magicNumber = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("magic number = " + this.magicNumber));
        if (this.magicNumber != -889275714) {
            throw new IOException("Bad magic number");
        }
        this.minorVersion = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("minor version = " + this.minorVersion));
        this.majorVersion = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("major version = " + this.majorVersion));
        Logger.getLogger(this.getClass()).debug((Object)"Reading the constant pool ...");
        this.constantPool = new ConstantPool(this, in);
        Logger.getLogger(this.getClass()).debug((Object)this.constantPool);
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("accessFlag = " + this.accessFlag));
        this.classIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("thisClass = " + this.classIndex + " (" + this.getClassName() + ")"));
        this.superclassIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("superclass = " + this.superclassIndex + " (" + this.getSuperclassName() + ")"));
        int interfaceCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + interfaceCount + " interface(s)"));
        for (int i = 0; i < interfaceCount; ++i) {
            Class_info interfaceInfo = (Class_info)this.constantPool.get(in.readUnsignedShort());
            Logger.getLogger(this.getClass()).debug((Object)("    " + interfaceInfo.getName()));
            this.interfaces.put(interfaceInfo.getName(), interfaceInfo);
        }
        int fieldCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + fieldCount + " field(s)"));
        for (int i = 0; i < fieldCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Field " + i + ":"));
            Field_info fieldInfo = new Field_info(this, in);
            this.fields.put(fieldInfo.getName(), fieldInfo);
        }
        int methodCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + methodCount + " method(s)"));
        for (int i = 0; i < methodCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Method " + i + ":"));
            Method_info methodInfo = new Method_info(this, in);
            this.methods.put(methodInfo.getSignature(), methodInfo);
        }
        int attributeCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + attributeCount + " class attribute(s)"));
        for (int i = 0; i < attributeCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Attribute " + i + ":"));
            this.attributes.add(AttributeFactory.create(this, this, in));
        }
    }

    public ClassfileLoader getLoader() {
        return this.loader;
    }

    public int getMagicNumber() {
        return this.magicNumber;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getAccessFlag() {
        return this.accessFlag;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public Class_info getRawClass() {
        return (Class_info)this.getConstantPool().get(this.getClassIndex());
    }

    public String getClassName() {
        return this.getRawClass().toString();
    }

    public String getSimpleName() {
        return this.getClassName().substring(this.getClassName().lastIndexOf(".") + 1);
    }

    public int getSuperclassIndex() {
        return this.superclassIndex;
    }

    public Class_info getRawSuperclass() {
        return (Class_info)this.getConstantPool().get(this.getSuperclassIndex());
    }

    public String getSuperclassName() {
        String result = "";
        if (this.getSuperclassIndex() != 0) {
            result = this.getRawSuperclass().toString();
        }
        return result;
    }

    public Class_info getInterface(String name) {
        return this.interfaces.get(name);
    }

    public Collection<Class_info> getAllInterfaces() {
        return this.interfaces.values();
    }

    public Collection<Field_info> getAllFields() {
        return this.fields.values();
    }

    public Field_info getField(String name) {
        return this.fields.get(name);
    }

    public Field_info locateField(String name) {
        Field_info attempt;
        Classfile classfile;
        Field_info result = this.getField(name);
        if (result == null && (classfile = this.getLoader().getClassfile(this.getSuperclassName())) != null && (attempt = classfile.locateField(name)) != null && (attempt.isPublic() || attempt.isProtected())) {
            result = attempt;
        }
        Iterator<Class_info> i = this.getAllInterfaces().iterator();
        while (result == null && i.hasNext()) {
            Field_info attempt2;
            Classfile classfile2 = this.getLoader().getClassfile(((Object)i.next()).toString());
            if (classfile2 == null || (attempt2 = classfile2.locateField(name)) == null || !attempt2.isPublic() && !attempt2.isProtected()) continue;
            result = attempt2;
        }
        return result;
    }

    public Collection<Method_info> getAllMethods() {
        return this.methods.values();
    }

    public Method_info getMethod(String signature) {
        return this.methods.get(signature);
    }

    public Method_info locateMethod(String signature) {
        Method_info attempt;
        Classfile classfile;
        Method_info result = this.getMethod(signature);
        if (result == null && (classfile = this.getLoader().getClassfile(this.getSuperclassName())) != null && (attempt = classfile.locateMethod(signature)) != null && (attempt.isPublic() || attempt.isProtected())) {
            result = attempt;
        }
        Iterator<Class_info> i = this.getAllInterfaces().iterator();
        while (result == null && i.hasNext()) {
            Method_info attempt2;
            Classfile classfile2 = this.getLoader().getClassfile(((Object)i.next()).toString());
            if (classfile2 == null || (attempt2 = classfile2.locateMethod(signature)) == null || !attempt2.isPublic() && !attempt2.isProtected()) continue;
            result = attempt2;
        }
        return result;
    }

    public Collection<Attribute_info> getAttributes() {
        return this.attributes;
    }

    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    public boolean isPackage() {
        return (this.getAccessFlag() & 1) == 0;
    }

    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    public boolean isSuper() {
        return (this.getAccessFlag() & 0x20) != 0;
    }

    public boolean isInterface() {
        return (this.getAccessFlag() & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    public boolean isSynthetic() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Synthetic_attribute;
        }
        return result;
    }

    @Override
    public boolean isDeprecated() {
        boolean result = false;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (!result && i.hasNext()) {
            result = i.next() instanceof Deprecated_attribute;
        }
        return result;
    }

    public String getDeclaration() {
        StringBuffer result;
        block8: {
            block7: {
                result = new StringBuffer();
                if (this.isPublic()) {
                    result.append("public ");
                }
                if (this.isFinal()) {
                    result.append("final ");
                }
                if (!this.isInterface()) break block7;
                result.append("interface ").append(this.getClassName());
                if (this.getAllInterfaces().size() == 0) break block8;
                result.append(" extends ");
                Iterator<Class_info> i = this.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                break block8;
            }
            if (this.isAbstract()) {
                result.append("abstract ");
            }
            result.append("class ").append(this.getClassName());
            if (this.getSuperclassIndex() != 0) {
                result.append(" extends ").append(this.getSuperclassName());
            }
            if (this.getAllInterfaces().size() != 0) {
                result.append(" implements ");
                Iterator<Class_info> i = this.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
            }
        }
        return result.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassfile(this);
    }

    public String toString() {
        return this.getClassName();
    }
}

