/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public class Class_info
extends ConstantPoolEntry {
    private int nameIndex;

    public Class_info(ConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool);
        this.nameIndex = in.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public UTF8_info getRawName() {
        return (UTF8_info)this.getConstantPool().get(this.getNameIndex());
    }

    public String getName() {
        return SignatureHelper.convertClassName(this.getRawName().toString());
    }

    public String getSimpleName() {
        return this.getName().substring(this.getName().lastIndexOf(".") + 1);
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.getRawName().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            Class_info other = (Class_info)object;
            result = this.getRawName().equals(other.getRawName());
        }
        return result;
    }

    public void accept(Visitor visitor) {
        visitor.visitClass_info(this);
    }
}

