/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CollectorBase;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.UTF8_info;

public class ClassDependencyCollector
extends CollectorBase {
    private Class_info thisClass;
    private boolean top = true;

    public void visitClassfile(Classfile classfile) {
        this.thisClass = classfile.getRawClass();
        classfile.getConstantPool().accept(this);
        classfile.getRawSuperclass().accept(this);
        for (Class_info class_info : classfile.getAllInterfaces()) {
            class_info.accept(this);
        }
        for (Field_info field : classfile.getAllFields()) {
            field.accept(this);
        }
        for (Method_info method : classfile.getAllMethods()) {
            method.accept(this);
        }
    }

    public void visitClass_info(Class_info entry) {
        String classname = entry.getName();
        if (entry != this.thisClass) {
            if (classname.startsWith("[")) {
                this.top = false;
                entry.getRawName().accept(this);
                this.top = true;
            } else {
                this.add(classname);
            }
        }
    }

    public void visitFieldRef_info(FieldRef_info entry) {
        if (this.top) {
            if (entry.getRawClass() == this.thisClass) {
                this.top = false;
                entry.getRawNameAndType().accept(this);
                this.top = true;
            }
        } else {
            entry.getRawNameAndType().accept(this);
        }
    }

    public void visitMethodRef_info(MethodRef_info entry) {
        if (this.top) {
            if (entry.getRawClass() == this.thisClass) {
                this.top = false;
                entry.getRawNameAndType().accept(this);
                this.top = true;
            }
        } else {
            entry.getRawNameAndType().accept(this);
        }
    }

    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        if (this.top) {
            if (entry.getRawClass() == this.thisClass) {
                this.top = false;
                entry.getRawNameAndType().accept(this);
                this.top = true;
            }
        } else {
            entry.getRawNameAndType().accept(this);
        }
    }

    public void visitString_info(String_info entry) {
        if (!this.top) {
            entry.getRawValue().accept(this);
        }
    }

    public void visitNameAndType_info(NameAndType_info entry) {
        if (!this.top) {
            entry.getRawType().accept(this);
        }
    }

    public void visitUTF8_info(UTF8_info entry) {
        if (!this.top) {
            this.processSignature(entry.getValue());
        }
    }

    public void visitField_info(Field_info entry) {
        this.processSignature(entry.getDescriptor());
        super.visitField_info(entry);
    }

    public void visitMethod_info(Method_info entry) {
        this.processSignature(entry.getDescriptor());
        super.visitMethod_info(entry);
    }

    public void visitLocalVariable(LocalVariable helper) {
        this.processSignature(helper.getDescriptor());
        super.visitLocalVariable(helper);
    }

    private void processSignature(String str) {
        int startPos;
        int currentPos = 0;
        while ((startPos = str.indexOf(76, currentPos)) != -1) {
            int endPos = str.indexOf(59, startPos);
            if (endPos != -1) {
                String candidate = str.substring(startPos + 1, endPos);
                if (!this.thisClass.getName().equals(candidate)) {
                    this.add(SignatureHelper.path2ClassName(candidate));
                }
                currentPos = endPos + 1;
                continue;
            }
            currentPos = startPos + 1;
        }
    }
}

