/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AttributeFactory {
    private static final String CONSTANT_VALUE = "ConstantValue";
    private static final String CODE = "Code";
    private static final String EXCEPTIONS = "Exceptions";
    private static final String INNER_CLASSES = "InnerClasses";
    private static final String SYNTHETIC = "Synthetic";
    private static final String SOURCE_FILE = "SourceFile";
    private static final String LINE_NUMBER_TABLE = "LineNumberTable";
    private static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    private static final String DEPRECATED = "Deprecated";

    public static Attribute_info create(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        Attribute_info result = null;
        int nameIndex = in.readUnsignedShort();
        if (nameIndex > 0) {
            Object entry = classfile.getConstantPool().get(nameIndex);
            if (entry instanceof UTF8_info) {
                String name = ((UTF8_info)entry).getValue();
                Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name index: " + nameIndex + " (" + name + ")"));
                if (CONSTANT_VALUE.equals(name)) {
                    result = new ConstantValue_attribute(classfile, owner, in);
                } else if (CODE.equals(name)) {
                    result = new Code_attribute(classfile, owner, in);
                } else if (EXCEPTIONS.equals(name)) {
                    result = new Exceptions_attribute(classfile, owner, in);
                } else if (INNER_CLASSES.equals(name)) {
                    result = new InnerClasses_attribute(classfile, owner, in);
                } else if (SYNTHETIC.equals(name)) {
                    result = new Synthetic_attribute(classfile, owner, in);
                } else if (SOURCE_FILE.equals(name)) {
                    result = new SourceFile_attribute(classfile, owner, in);
                } else if (LINE_NUMBER_TABLE.equals(name)) {
                    result = new LineNumberTable_attribute(classfile, owner, in);
                } else if (LOCAL_VARIABLE_TABLE.equals(name)) {
                    result = new LocalVariableTable_attribute(classfile, owner, in);
                } else if (DEPRECATED.equals(name)) {
                    result = new Deprecated_attribute(classfile, owner, in);
                } else {
                    Logger.getLogger(AttributeFactory.class).warn((Object)("Unknown attribute name \"" + name + "\""));
                    result = new Custom_attribute(name, classfile, owner, in);
                }
            } else {
                Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name: " + entry));
                Logger.getLogger(AttributeFactory.class).warn((Object)"Unknown attribute with invalid name");
                result = new Custom_attribute(classfile, owner, in);
            }
        } else {
            Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name index: " + nameIndex));
            Logger.getLogger(AttributeFactory.class).warn((Object)"Unknown attribute with no name");
            result = new Custom_attribute(classfile, owner, in);
        }
        return result;
    }
}

