/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatingClassfileLoader
extends ClassfileLoaderEventSource {
    private Map<String, Classfile> classfiles = new TreeMap<String, Classfile>();

    public AggregatingClassfileLoader() {
    }

    public AggregatingClassfileLoader(ClassfileLoaderDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    public Classfile getClassfile(String name) {
        return this.classfiles.get(name);
    }

    @Override
    public Collection<Classfile> getAllClassfiles() {
        return Collections.unmodifiableCollection(this.classfiles.values());
    }

    @Override
    public Collection<String> getAllClassNames() {
        return Collections.unmodifiableCollection(this.classfiles.keySet());
    }

    @Override
    protected Classfile load(DataInputStream in) throws IOException {
        Classfile result = new Classfile(this, in);
        this.classfiles.put(result.getClassName(), result);
        return result;
    }
}

