/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.nbheaven.sqe.codedefects.core.api.QualityProvider;
import org.nbheaven.sqe.codedefects.core.util.SQECodedefectProperties;
import org.nbheaven.sqe.core.java.search.ClassElementDescriptor;
import org.nbheaven.sqe.core.java.search.JavaElement;
import org.nbheaven.sqe.core.java.search.MethodElementDescriptor;
import org.nbheaven.sqe.core.java.search.SearchUtilities;
import org.nbheaven.sqe.core.java.search.VariableElementDescriptor;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.ClassElementDescriptorImpl;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.MethodElementDescriptorImpl;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.search.impl.VariableElementDescriptorImpl;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettingsProvider;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public class FindBugsHint {
    private static final RequestProcessor HINT_PROCESSOR = new RequestProcessor("FindBugs-Hint-Processor", 1);

    private FindBugsHint() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends EditorAwareJavaSourceTaskFactory {
        public Factory() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.MIN);
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new Task(fileObject);
        }

        private void refreshImpl(FileObject file) {
            this.reschedule(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Task
    extends FileChangeAdapter
    implements CancellableTask<CompilationInfo> {
        private final FileObject fileObject;
        private List<ErrorDescription> errors;

        private Task(FileObject fileObject) {
            this.fileObject = fileObject;
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }

        public void cancel() {
        }

        public void run(CompilationInfo compilationInfo) throws Exception {
            final FileObject fo = compilationInfo.getFileObject();
            final Document document = compilationInfo.getDocument();
            if (null == this.errors && null != fo && null != document) {
                HINT_PROCESSOR.post(new Runnable(){

                    public void run() {
                        try {
                            Task.this.errors = Task.this.computeErrors(fo, document);
                            Task.this.refresh(false);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                this.errors = Collections.emptyList();
            }
            if (null != this.errors && null != fo) {
                HintsController.setErrors((FileObject)fo, (String)Task.class.getName(), this.errors);
            }
        }

        private List<ErrorDescription> computeErrors(FileObject fileObject, Document document) throws Exception {
            FindBugsSession session;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (null != project && null != (session = (FindBugsSession)project.getLookup().lookup(FindBugsSession.class)) && SQECodedefectProperties.isQualityProviderActive((Project)project, (QualityProvider)session.getProvider())) {
                LinkedList<ErrorDescription> computedErrors = new LinkedList<ErrorDescription>();
                Map instanceByClass = session.computeResultAndWait(fileObject).getInstanceByClass(true);
                Collection classes = SearchUtilities.getFQNClassNames((FileObject)fileObject);
                for (String className : classes) {
                    for (FindBugsResult.ClassKey classKey : instanceByClass.keySet()) {
                        if (!classKey.getDisplayName().equals(className)) continue;
                        Collection bugs = (Collection)instanceByClass.get(classKey);
                        computedErrors.addAll(this.getErrors(project, bugs, fileObject, document));
                    }
                }
                return computedErrors;
            }
            return Collections.emptyList();
        }

        private void refresh(boolean deepRefresh) {
            if (deepRefresh) {
                this.errors = null;
            }
            for (JavaSourceTaskFactory f : Lookup.getDefault().lookupAll(JavaSourceTaskFactory.class)) {
                if (!(f instanceof Factory)) continue;
                ((Factory)f).refreshImpl(this.fileObject);
            }
        }

        private List<ErrorDescription> getErrors(Project project, Collection<BugInstance> bugs, FileObject file, Document document) {
            LinkedList<ErrorDescription> errorDescriptions = new LinkedList<ErrorDescription>();
            for (BugInstance bugInstance : bugs) {
                try {
                    int line = 0;
                    for (BugAnnotation annotation : bugInstance.getAnnotations()) {
                        if (!(annotation instanceof SourceLineAnnotation)) continue;
                        line = Math.max(1, bugInstance.getPrimarySourceLineAnnotation().getStartLine());
                        break;
                    }
                    JavaElement findElement = this.locateElement(bugInstance, project);
                    if (line == 0 && findElement != null) {
                        line = Math.max(1, findElement.getLine().getLineNumber() + 1);
                    }
                    if (line <= 0) continue;
                    ArrayList<Object> fixes = new ArrayList<Object>();
                    if (findElement != null) {
                        fixes.add(new SuppressWarningsFix(bugInstance.getType(), findElement.getHandle(), file));
                    }
                    fixes.add(new DisableDetectorFix(bugInstance, project));
                    errorDescriptions.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)("[FindBugs] " + bugInstance.getAbridgedMessage()), fixes, (Document)document, (int)line));
                }
                catch (RuntimeException e) {
                    System.err.println("INFO: Can't create ErrorDescription for FindBugs bug instance: " + bugInstance.getMessage());
                    e.printStackTrace();
                }
            }
            return errorDescriptions;
        }

        private JavaElement locateElement(BugInstance bugInstance, Project project) {
            ClassElementDescriptorImpl desc;
            JavaElement e;
            VariableElementDescriptorImpl desc2;
            JavaElement e2;
            MethodElementDescriptorImpl desc3;
            JavaElement e3;
            MethodAnnotation methodAnnotation = bugInstance.getPrimaryMethod();
            if (methodAnnotation != null && (e3 = SearchUtilities.findMethodElement((MethodElementDescriptor)(desc3 = new MethodElementDescriptorImpl(bugInstance.getPrimaryClass(), methodAnnotation, project)))) != null) {
                return e3;
            }
            FieldAnnotation fieldAnnotation = bugInstance.getPrimaryField();
            if (fieldAnnotation != null && (e2 = SearchUtilities.findVariableElement((VariableElementDescriptor)(desc2 = new VariableElementDescriptorImpl(bugInstance.getPrimaryClass(), fieldAnnotation, project)))) != null) {
                return e2;
            }
            ClassAnnotation classAnnotation = bugInstance.getPrimaryClass();
            if (classAnnotation != null && (e = SearchUtilities.findClassElement((ClassElementDescriptor)(desc = new ClassElementDescriptorImpl(classAnnotation, project)))) != null) {
                return e;
            }
            return null;
        }

        public void fileChanged(FileEvent fe) {
            HINT_PROCESSOR.post(new Runnable(){

                public void run() {
                    Task.this.refresh(true);
                }
            }, 1000);
        }

        private static class DisableDetectorFix
        implements Fix {
            private final BugInstance bugInstance;
            private final Project project;

            public DisableDetectorFix(BugInstance bugInstance, Project project) {
                this.bugInstance = bugInstance;
                this.project = project;
            }

            public String getText() {
                return "Disable detector for \"" + this.bugInstance.getBugPattern().getShortDescription() + "\"";
            }

            public ChangeInfo implement() throws Exception {
                FindBugsSettingsProvider settingsProvider = (FindBugsSettingsProvider)this.project.getLookup().lookup(FindBugsSettingsProvider.class);
                if (settingsProvider != null) {
                    UserPreferences findBugsSettings = settingsProvider.getFindBugsSettings();
                    for (DetectorFactory detectorFactory : NbCollections.iterable((Iterator)DetectorFactoryCollection.instance().factoryIterator())) {
                        if (!detectorFactory.getReportedBugPatterns().contains(this.bugInstance.getBugPattern())) continue;
                        findBugsSettings.enableDetector(detectorFactory, false);
                    }
                    settingsProvider.setFindBugsSettings(findBugsSettings);
                    FindBugsSession qualitySession = (FindBugsSession)this.project.getLookup().lookup(FindBugsSession.class);
                    FindBugsResult result = qualitySession.getResult();
                    if (result != null) {
                        result.removeAllBugInstancesForBugPattern(this.bugInstance.getBugPattern());
                    }
                }
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class SuppressWarningsFix
        implements Fix {
            private final String bugType;
            private final ElementHandle<?> handle;
            private final FileObject file;

            SuppressWarningsFix(String bugType, ElementHandle<?> handle, FileObject file) {
                this.bugType = bugType;
                this.handle = handle;
                this.file = file;
            }

            public String getText() {
                return "Suppress warning";
            }

            public ChangeInfo implement() throws Exception {
                JavaSource.forFileObject((FileObject)this.file).runModificationTask((org.netbeans.api.java.source.Task)new org.netbeans.api.java.source.Task<WorkingCopy>(){

                    public void run(WorkingCopy wc) throws Exception {
                        ModifiersTree old;
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement sw = null;
                        for (ElementHandle swh : wc.getClasspathInfo().getClassIndex().getDeclaredTypes("SuppressWarnings", ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES, ClassIndex.SearchScope.SOURCE))) {
                            Retention retention;
                            TypeElement _sw = (TypeElement)swh.resolve((CompilationInfo)wc);
                            if (_sw.getKind() != ElementKind.ANNOTATION_TYPE || (retention = _sw.getAnnotation(Retention.class)) != null && retention.value() == RetentionPolicy.SOURCE) continue;
                            sw = _sw;
                            break;
                        }
                        if (sw == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"<html>Could not find a <code>@SuppressWarnings</code> with <code>@Retention(CLASS/RUNTIME)</code> in project classpath.<br>Try <code>findbugs:annotations:*</code> for Maven, Common Annotations API for NetBeans modules, etc.", 1));
                            return;
                        }
                        TreeMaker make = wc.getTreeMaker();
                        Element element = SuppressWarningsFix.this.handle.resolve((CompilationInfo)wc);
                        if (element == null) {
                            System.err.println("could not find " + SuppressWarningsFix.this.handle);
                            return;
                        }
                        Tree elementTree = wc.getTrees().getTree(element);
                        if (elementTree.getKind() == Tree.Kind.CLASS) {
                            old = ((ClassTree)elementTree).getModifiers();
                        } else if (elementTree.getKind() == Tree.Kind.METHOD) {
                            old = ((MethodTree)elementTree).getModifiers();
                        } else if (elementTree.getKind() == Tree.Kind.VARIABLE) {
                            old = ((VariableTree)elementTree).getModifiers();
                        } else {
                            System.err.println("unknown tree kind " + (Object)((Object)elementTree.getKind()));
                            return;
                        }
                        ModifiersTree nue = SuppressWarningsFix.this.addSuppressWarnings(make, sw, old);
                        nue = (ModifiersTree)GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)nue);
                        wc.rewrite((Tree)old, (Tree)nue);
                    }
                }).commit();
                return null;
            }

            private ModifiersTree addSuppressWarnings(TreeMaker make, TypeElement sw, ModifiersTree original) {
                LiteralTree toAdd = make.Literal((Object)this.bugType);
                List<? extends AnnotationTree> anns = original.getAnnotations();
                block4: for (int i = 0; i < anns.size(); ++i) {
                    NewArrayTree arr;
                    Name name;
                    AnnotationTree ann = anns.get(i);
                    Tree annotationType = ann.getAnnotationType();
                    Tree.Kind kind = annotationType.getKind();
                    switch (kind) {
                        case IDENTIFIER: {
                            name = ((IdentifierTree)annotationType).getName();
                            break;
                        }
                        case MEMBER_SELECT: {
                            name = ((MemberSelectTree)annotationType).getIdentifier();
                            break;
                        }
                        default: {
                            System.err.println("got strange annotation type (" + (Object)((Object)kind) + "): " + annotationType);
                            continue block4;
                        }
                    }
                    if (!name.contentEquals("SuppressWarnings")) continue;
                    List<? extends ExpressionTree> args = ann.getArguments();
                    if (args.size() != 1) {
                        System.err.println("args list for @SW not of size 1: " + args);
                        return original;
                    }
                    AssignmentTree assign = (AssignmentTree)args.get(0);
                    if (!assign.getVariable().toString().equals("value")) {
                        System.err.println("weird attribute for @SW: " + assign);
                        return original;
                    }
                    ExpressionTree arg = assign.getExpression();
                    if (arg.getKind() == Tree.Kind.STRING_LITERAL) {
                        arr = make.NewArray(null, Collections.emptyList(), Collections.singletonList(arg));
                    } else if (arg.getKind() == Tree.Kind.NEW_ARRAY) {
                        arr = (NewArrayTree)arg;
                    } else {
                        System.err.println("unknown arg kind " + (Object)((Object)arg.getKind()) + ": " + arg);
                        return original;
                    }
                    for (ExpressionTree expressionTree : arr.getInitializers()) {
                        if (!((LiteralTree)expressionTree).getValue().equals(this.bugType)) continue;
                        return original;
                    }
                    arr = make.addNewArrayInitializer(arr, (ExpressionTree)toAdd);
                    ann = make.Annotation(annotationType, Collections.singletonList(arr));
                    return make.insertModifiersAnnotation(make.removeModifiersAnnotation(original, i), i, ann);
                }
                ExpressionTree annotationTypeTree = make.QualIdent((Element)sw);
                ArrayList<LiteralTree> arguments = new ArrayList<LiteralTree>();
                arguments.add(toAdd);
                AnnotationTree annTree = make.Annotation((Tree)annotationTypeTree, arguments);
                return make.addModifiersAnnotation(original, annTree);
            }
        }
    }
}

