/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wseditor;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesPanel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.api.wseditor.WSEditorProviderRegistry;
import org.netbeans.modules.websvc.spi.wseditor.WSEditorProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class EditWSAttributesCookieImpl
implements EditWSAttributesCookie {
    private Set<WSEditorProvider> providers;
    private Set<WSEditor> editors;
    private static Map<EditWSAttributesCookie, EditWSAttributesPanel> cachedTopComponents = new WeakHashMap<EditWSAttributesCookie, EditWSAttributesPanel>();
    private EditWSAttributesPanel tc;
    private Node node;
    private JaxWsModel jaxWsModel;
    private DialogWindowListener windowListener;

    public EditWSAttributesCookieImpl(Node node) {
        this.node = node;
    }

    public void openWSAttributesEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.openEditor();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditWSAttributesCookieImpl.this.openEditor();
                }
            });
        }
    }

    private void openEditor() {
        try {
            this.doOpenEditor();
        }
        catch (InvalidDataException invalidDataException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)invalidDataException.getLocalizedMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private void doOpenEditor() throws InvalidDataException {
        JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
        Cursor cursor = jFrame.getGlassPane().getCursor();
        jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        jFrame.getGlassPane().setVisible(true);
        this.tc = cachedTopComponents.get(this.node);
        if (this.tc == null) {
            this.populateWSEditorProviderRegistry();
            this.providers = WSEditorProviderRegistry.getDefault().getEditorProviders();
            this.tc = new EditWSAttributesPanel();
            cachedTopComponents.put(this, this.tc);
        }
        this.populatePanels();
        this.tc.addTabs(this.editors, this.node, this.jaxWsModel);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.tc, this.node.getName());
        dialogDescriptor.setHelpCtx(new HelpCtx(EditWSAttributesCookieImpl.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        jFrame.getGlassPane().setCursor(cursor);
        jFrame.getGlassPane().setVisible(false);
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.save(this.node);
            }
        } else {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.cancel(this.node);
            }
        }
    }

    private Set getWSEditorProviders() {
        return this.providers;
    }

    private void populatePanels() {
        this.editors = new HashSet<WSEditor>();
        for (WSEditorProvider wSEditorProvider : this.providers) {
            WSEditor wSEditor;
            if (!wSEditorProvider.enable(this.node) || (wSEditor = wSEditorProvider.createWSEditor(this.node.getLookup())) == null) continue;
            this.editors.add(wSEditor);
        }
    }

    private void populateWSEditorProviderRegistry() {
        WSEditorProviderRegistry wSEditorProviderRegistry = WSEditorProviderRegistry.getDefault();
        if (wSEditorProviderRegistry.getEditorProviders().isEmpty()) {
            Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(WSEditorProvider.class));
            Collection collection = result.allInstances();
            for (WSEditorProvider wSEditorProvider : collection) {
                wSEditorProviderRegistry.register(wSEditorProvider);
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        Set<WSEditor> editors;

        public DialogWindowListener(Set<WSEditor> set) {
            this.editors = set;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            for (WSEditor wSEditor : this.editors) {
                wSEditor.cancel(EditWSAttributesCookieImpl.this.node);
            }
        }
    }
}

