/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.wizards;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JaxWsClientCreator
implements ClientCreator {
    private Project project;
    private WizardDescriptor wiz;

    public JaxWsClientCreator(Project project, WizardDescriptor wizardDescriptor) {
        this.project = project;
        this.wiz = wizardDescriptor;
    }

    public void createClient() throws IOException {
        FileObject fileObject;
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)this.project.getProjectDirectory());
        String string = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String string2 = (String)this.wiz.getProperty("wsdlFilePath");
        if (string == null) {
            string = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string2))).getURL().toExternalForm();
        }
        FileObject fileObject2 = jAXWSLightSupport.getWsdlFolder(true);
        boolean bl = false;
        File file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src");
        bl = file.exists() ? true : file.mkdirs();
        if (fileObject2 != null && (fileObject = this.retrieveWsdl(string, fileObject2, bl)) != null) {
            final boolean bl2 = MavenModelUtils.isJaxWs21Library(this.project);
            final String string3 = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
            final String string4 = fileObject.getName();
            Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenWebService.class, (boolean)true);
            if (preferences != null) {
                preferences.put("_C_" + WSUtils.getUniqueId(fileObject.getName(), jAXWSLightSupport.getServices()), string);
            }
            final String string5 = string;
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    if (!bl2) {
                        try {
                            MavenModelUtils.addJaxws21Library(JaxWsClientCreator.this.project, pOMModel);
                            MavenModelUtils.addJavadoc(JaxWsClientCreator.this.project);
                        }
                        catch (Exception exception) {
                            Logger.getLogger(JaxWsClientCreator.class.getName()).log(Level.INFO, "Cannot add Metro libbrary to pom file", exception);
                        }
                    }
                    Plugin plugin = WSUtils.isEJB(JaxWsClientCreator.this.project) ? MavenModelUtils.addJaxWSPlugin(pOMModel, "2.0") : MavenModelUtils.addJaxWSPlugin(pOMModel);
                    MavenModelUtils.addWsimportExecution(plugin, string4, string3, string5);
                    if (WSUtils.isWeb(JaxWsClientCreator.this.project)) {
                        MavenModelUtils.addWarPlugin(pOMModel);
                    } else {
                        MavenModelUtils.addWsdlResources(pOMModel);
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(modelOperation));
            RunConfig runConfig = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (Project)this.project, (String)"JAX-WS:wsimport", Collections.singletonList("compile"));
            RunUtils.executeMaven((RunConfig)runConfig);
        }
    }

    private FileObject retrieveWsdl(final String string, final FileObject fileObject, final boolean bl) {
        final FileObject[] fileObjectArray = new FileObject[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    fileObjectArray[0] = WSUtils.retrieveResource(fileObject, bl ? new URI("src/jax-ws-catalog.xml") : new URI("jax-ws-catalog.xml"), new URI(string));
                }
                catch (URISyntaxException uRISyntaxException) {
                    String string2 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_IncorrectURI", (Object)string);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                catch (UnknownHostException unknownHostException) {
                    String string3 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_UnknownHost", (Object)unknownHostException.getMessage());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                catch (IOException iOException) {
                    String string4 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)string);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string4, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        };
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(JaxWsClientCreator.class, (String)"LBL_RetrieveWSDL"), (AtomicBoolean)atomicBoolean, (boolean)false);
        if (atomicBoolean.get()) {
            return null;
        }
        return fileObjectArray[0];
    }
}

