/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MavenProjectRestSupport
extends WebRestSupport {
    private static final String DEPLOYMENT_GOAL = "package";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    public static final String ACTION_PROPERTY_DEPLOY_OPEN = "netbeans.deploy.open.in.browser";
    private static final String TEST_SERVICES_HTML = "test-services.html";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public MavenProjectRestSupport(Project project) {
        super(project);
    }

    public void ensureRestDevelopmentReady() throws IOException {
        String string = this.getProjectProperty("rest.config.type");
        WebRestSupport.RestConfig restConfig = null;
        if (string == null && this.getApplicationPathFromDD() == null && (restConfig = this.setApplicationConfigProperty(false)) == WebRestSupport.RestConfig.DD) {
            this.addResourceConfigToWebApp(restConfig.getResourcePath());
        }
        if (SwingUtilities.isEventDispatchThread()) {
            final WebRestSupport.RestConfig restConfig2 = restConfig;
            final IOException[] iOExceptionArray = new IOException[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MavenProjectRestSupport.this.addSwdpLibrary(restConfig2);
                    }
                    catch (IOException iOException) {
                        iOExceptionArray[0] = iOException;
                    }
                }
            };
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)runnable, (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"TTL_ExtendProjectClasspath"), (AtomicBoolean)atomicBoolean, (boolean)false);
            if (iOExceptionArray[0] != null) {
                throw iOExceptionArray[0];
            }
        } else {
            this.addSwdpLibrary(restConfig);
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile"});
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    public String getContextRootURL() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String string = j2eeModuleProvider.getServerInstanceID();
        if ("DEV-NULL".equals(string)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RestSupport.class, (String)"MSG_MissingServer"), 0));
            return "";
        }
        return super.getContextRootURL();
    }

    public boolean hasSwdpLibrary() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sourceGroupArray.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            FileObject fileObject = classPath.findResource("javax/ws/rs/core/Context.class");
            return fileObject != null;
        }
        return false;
    }

    public String getBaseURL() throws IOException {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            String string = "";
            String string2 = "";
            int n = 0;
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                string = string + (n > 0 ? "," : "") + servletMapping.getServletName();
                string2 = string2 + (n > 0 ? "," : "") + servletMapping.getUrlPattern();
                ++n;
            }
            return this.getContextRootURL() + "||" + string + "||" + string2;
        }
        throw new IOException("Cannot read web.xml");
    }

    private void addSwdpLibrary(WebRestSupport.RestConfig restConfig) throws IOException {
        JaxRsStackSupport jaxRsStackSupport;
        boolean bl;
        boolean bl2 = false;
        if (!this.hasSwdpLibrary()) {
            bl2 = true;
            bl = false;
            if (restConfig != null && restConfig.isServerJerseyLibSelected() && (jaxRsStackSupport = this.getJaxRsStackSupport()) != null) {
                bl = jaxRsStackSupport.addJsr311Api(this.project);
            }
            if (!bl) {
                JaxRsStackSupport.getDefault().addJsr311Api(this.project);
            }
        }
        if (restConfig != null) {
            bl = false;
            if (restConfig.isServerJerseyLibSelected() && (jaxRsStackSupport = this.getJaxRsStackSupport()) != null) {
                bl = jaxRsStackSupport.extendsJerseyProjectClasspath(this.project);
            }
            if (!bl && restConfig.isJerseyLibSelected()) {
                JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
            }
        } else if (bl2) {
            JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
        }
    }

    public Datasource getDatasource(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return j2eeModuleProvider.getConfigSupport().findDatasource(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public boolean isRestSupportOn() {
        return this.getProjectProperty("rest.config.type") != null;
    }

    public FileObject generateTestClient(File file, String string) throws IOException {
        return this.generateMavenTester(file, string);
    }

    public FileObject generateTestClient(File file) throws IOException {
        return this.generateMavenTester(file, this.getBaseURL());
    }

    public void deploy() {
        RunConfig runConfig = RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (Project)this.project, (String)NbBundle.getMessage(MavenProjectRestSupport.class, (String)"MSG_Deploy", (Object)((ProjectInformation)this.getProject().getLookup().lookup(ProjectInformation.class)).getDisplayName()), Collections.singletonList(DEPLOYMENT_GOAL));
        runConfig.setProperty(ACTION_PROPERTY_DEPLOY_OPEN, Boolean.FALSE.toString());
        RunUtils.executeMaven((RunConfig)runConfig);
    }

    public File getLocalTargetTestRest() {
        try {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("src/main");
            if (fileObject != null) {
                FileObject fileObject2 = fileObject.getFileObject("resources");
                if (fileObject2 == null) {
                    fileObject2 = fileObject.createFolder("resources");
                }
                if (fileObject2 != null) {
                    FileObject fileObject3 = fileObject2.getFileObject("rest");
                    if (fileObject3 == null) {
                        fileObject3 = fileObject2.createFolder("rest");
                    }
                    return FileUtil.toFile((FileObject)fileObject3);
                }
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(MavenProjectRestSupport.class.getName()).log(Level.WARNING, null, iOException);
        }
        return null;
    }

    private FileObject generateMavenTester(File file, String string) throws IOException {
        String[] stringArray = new String[]{"TTL_TEST_RESBEANS", "MSG_TEST_RESBEANS_INFO"};
        String[] stringArray2 = new String[]{"MSG_TEST_RESBEANS_wadlErr", "MSG_TEST_RESBEANS_No_AJAX", "MSG_TEST_RESBEANS_Resource", "MSG_TEST_RESBEANS_See", "MSG_TEST_RESBEANS_No_Container", "MSG_TEST_RESBEANS_Content", "MSG_TEST_RESBEANS_TabularView", "MSG_TEST_RESBEANS_RawView", "MSG_TEST_RESBEANS_ResponseHeaders", "MSG_TEST_RESBEANS_Help", "MSG_TEST_RESBEANS_TestButton", "MSG_TEST_RESBEANS_Loading", "MSG_TEST_RESBEANS_Status", "MSG_TEST_RESBEANS_Headers", "MSG_TEST_RESBEANS_HeaderName", "MSG_TEST_RESBEANS_HeaderValue", "MSG_TEST_RESBEANS_Insert", "MSG_TEST_RESBEANS_NoContents", "MSG_TEST_RESBEANS_AddParamButton", "MSG_TEST_RESBEANS_Monitor", "MSG_TEST_RESBEANS_No_SubResources", "MSG_TEST_RESBEANS_SubResources", "MSG_TEST_RESBEANS_ChooseMethod", "MSG_TEST_RESBEANS_ChooseMime", "MSG_TEST_RESBEANS_Continue", "MSG_TEST_RESBEANS_AdditionalParams", "MSG_TEST_RESBEANS_INFO", "MSG_TEST_RESBEANS_Request", "MSG_TEST_RESBEANS_Sent", "MSG_TEST_RESBEANS_Received", "MSG_TEST_RESBEANS_TimeStamp", "MSG_TEST_RESBEANS_Response", "MSG_TEST_RESBEANS_CurrentSelection", "MSG_TEST_RESBEANS_DebugWindow", "MSG_TEST_RESBEANS_Wadl", "MSG_TEST_RESBEANS_RequestFailed"};
        FileObject fileObject = this.copyFileAndReplaceBaseUrl(file, TEST_SERVICES_HTML, stringArray, string);
        MavenProjectRestSupport.copyFile((File)file, (String)"test-resbeans.js", (String[])stringArray2, (boolean)false);
        MavenProjectRestSupport.copyFile((File)file, (String)"test-resbeans.css");
        MavenProjectRestSupport.copyFile((File)file, (String)"css_master-all.css");
        MavenProjectRestSupport.copyFile((File)file, (String)"expand.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"collapse.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"item.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"cc.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"og.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"cg.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"app.gif");
        File file2 = new File(file, "images");
        file2.mkdir();
        MavenProjectRestSupport.copyFile((File)file, (String)"images/background_border_bottom.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbsel.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/bg_gradient.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pname.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/level1_selected-1lvl.jpg");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/primary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/masthead.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/primary-roll.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbdis.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/secondary-enabled.gif");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbena.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/tbsel.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/pbmou.png");
        MavenProjectRestSupport.copyFile((File)file, (String)"images/tbuns.png");
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject copyFileAndReplaceBaseUrl(File file, String string, String[] stringArray, String string2) throws IOException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            fileObject2 = fileObject.createData(string);
        }
        FileLock fileLock = null;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        try {
            String string3;
            int n;
            fileLock = fileObject2.lock();
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            InputStream inputStream = RestSupport.class.getResourceAsStream("resources/" + string);
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = "\n";
            if (File.separatorChar == '\\') {
                string4 = "\r\n";
            }
            String[] stringArray2 = null;
            if (stringArray != null) {
                stringArray2 = new String[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray2[n] = NbBundle.getMessage(RestSupport.class, (String)stringArray[n]);
                }
            }
            while ((string3 = bufferedReader.readLine()) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    string3 = string3.replaceAll(stringArray[n], stringArray2[n]);
                }
                string3 = string3.replace("${BASE_URL}", string2);
                bufferedWriter.write(string3);
                bufferedWriter.write(string4);
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.flush();
                bufferedWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return fileObject2;
    }

    protected void logResourceCreation(Project project) {
        Object[] objectArray = new Object[]{"JAX-RS", this.project.getClass().getName(), "RESOURCE"};
        LogUtils.logWsDetect((Object[])objectArray);
    }

    public String getProjectProperty(String string) {
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (preferences != null) {
            return preferences.get(string, null);
        }
        return null;
    }

    public void setPrivateProjectProperty(String string, String string2) {
        this.setProjectProperty(string, string2);
    }

    public void setProjectProperty(String string, String string2) {
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (preferences != null) {
            preferences.put(string, string2);
        }
    }

    public void removeProjectProperties(String[] stringArray) {
        Preferences preferences = ProjectUtils.getPreferences((Project)this.project, MavenProjectRestSupport.class, (boolean)true);
        if (preferences != null) {
            for (String string : stringArray) {
                preferences.remove(string);
            }
        }
    }

    public int getProjectType() {
        String string;
        NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject != null && (string = nbMavenProject.getPackagingType()) != null) {
            if ("jar".equals(string)) {
                return 0;
            }
            if ("war".equals(string)) {
                return 1;
            }
            if ("nbm".equals(string) || "nbm-application".equals(string)) {
                return 2;
            }
        }
        return 0;
    }
}

