/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.MavenJAXWSSupportImpl;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportFactory;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportProvider;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.LookupMergerSupport;
import org.netbeans.modules.websvc.project.spi.WebServiceDataProvider;
import org.netbeans.modules.websvc.project.spi.WebServiceFactory;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public class MavenJaxWsSupportProvider
implements JAXWSLightSupportProvider,
WebServiceDataProvider,
PropertyChangeListener {
    private static final RequestProcessor MAVEN_WS_RP = new RequestProcessor("MavenJaxWsSupportProvider.WS_REQUEST_PROCESSOR");
    private static final RequestProcessor rp = new RequestProcessor("MavenJaxWsSupportProvider-request-processor");
    private RequestProcessor.Task pomChangesTask = MAVEN_WS_RP.create(new Runnable(){

        @Override
        public void run() {
            MavenJaxWsSupportProvider.this.reactOnPomChanges();
        }
    });
    private static final Logger LOG = Logger.getLogger(MavenJaxWsSupportProvider.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private PropertyChangeListener pcl;
    private NbMavenProject mp;
    private Project prj;
    private volatile String serverInstance;
    private List<WebService> providers = new LinkedList<WebService>();
    private List<WebService> consumers = new LinkedList<WebService>();

    public MavenJaxWsSupportProvider(final Project project) {
        MavenJAXWSSupportImpl mavenJAXWSSupportImpl = new MavenJAXWSSupportImpl(project);
        this.prj = project;
        this.jaxWsSupport = JAXWSLightSupportFactory.createJAXWSSupport((JAXWSLightSupportImpl)mavenJAXWSSupportImpl);
        this.jaxWsSupport.addPropertyChangeListener((PropertyChangeListener)this);
        final Lookup lookup = project.getLookup();
        final Lookup.Result result = lookup.lookupResult(J2eeModuleProvider.class);
        final LookupListener lookupListener = new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                Lookup.Result result2 = result;
                synchronized (result2) {
                    LOG.log(Level.INFO, "Maven project lookup is changed");
                    result.notifyAll();
                }
            }
        };
        result.addLookupListener(lookupListener);
        LOG.log(Level.INFO, "Lookup listener is added into the Maven project");
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MavenJaxWsSupportProvider.this.registerPCL();
                LOG.log(Level.INFO, "Inside Maven WS request processor");
                Lookup.Result result2 = result;
                synchronized (result2) {
                    boolean bl = true;
                    while (lookup.lookup(J2eeModuleProvider.class) == null) {
                        if (!bl) {
                            MAVEN_WS_RP.post((Runnable)this);
                            return;
                        }
                        try {
                            LOG.log(Level.INFO, "Wait in cycle for J2eeModuleProvider instance in Maven lookup");
                            result.wait(1000L);
                            bl = false;
                        }
                        catch (InterruptedException interruptedException) {
                            LOG.log(Level.INFO, "Lookup change wait is interrupted", interruptedException);
                        }
                    }
                    result.removeLookupListener(lookupListener);
                }
                LOG.log(Level.INFO, "Get out of waiting J2eeModuleProvider instance cycle, listener is removed");
                result2 = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
                LOG.log(Level.INFO, "J2eeModuleProvider instance :" + result2);
                MetadataModel metadataModel = MavenJaxWsSupportProvider.this.jaxWsSupport.getWebservicesMetadataModel();
                LOG.log(Level.INFO, "WS metadata model : " + metadataModel);
                if (metadataModel != null) {
                    MavenJaxWsSupportProvider.this.registerAnnotationListener((MetadataModel<WebservicesMetadata>)metadataModel);
                }
                MavenJaxWsSupportProvider.this.serverInstance = result2 == null ? null : result2.getServerInstanceID();
            }
        };
        MAVEN_WS_RP.post(runnable);
        rp.post(new Runnable(){

            @Override
            public void run() {
                WSUtils.detectWsdlClients(project, MavenJaxWsSupportProvider.this.jaxWsSupport);
            }
        });
    }

    public JAXWSLightSupport findJAXWSSupport() {
        return this.jaxWsSupport;
    }

    public List<WebService> getServiceProviders() {
        return this.providers;
    }

    public List<WebService> getServiceConsumers() {
        return this.consumers;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.jaxWsSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.jaxWsSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static LookupMerger<WebServiceDataProvider> getLookupMerger() {
        return LookupMergerSupport.createWebServiceDataProviderMerger();
    }

    void registerPCL() {
        this.unregisterPCL();
        this.mp = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        this.mp.addPropertyChangeListener((PropertyChangeListener)this);
    }

    void registerAnnotationListener(final MetadataModel<WebservicesMetadata> metadataModel) {
        try {
            metadataModel.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Void>(){

                public Void run(WebservicesMetadata webservicesMetadata) {
                    Webservices webservices = webservicesMetadata.getRoot();
                    if (MavenJaxWsSupportProvider.this.pcl != null) {
                        webservices.removePropertyChangeListener(MavenJaxWsSupportProvider.this.pcl);
                    }
                    MavenJaxWsSupportProvider.this.pcl = new WebservicesChangeListener(MavenJaxWsSupportProvider.this.jaxWsSupport, (MetadataModel<WebservicesMetadata>)metadataModel);
                    webservices.addPropertyChangeListener(MavenJaxWsSupportProvider.this.pcl);
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void unregisterPCL() {
        if (this.mp != null) {
            this.mp.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block6: {
            block8: {
                block7: {
                    if (!"MavenProject".equals(propertyChangeEvent.getPropertyName())) break block7;
                    this.pomChangesTask.schedule(1000);
                    break block6;
                }
                if (!"service-added".equals(propertyChangeEvent.getPropertyName())) break block8;
                MavenWebService mavenWebService = new MavenWebService((JaxWsService)propertyChangeEvent.getNewValue(), this.prj);
                WebService webService = WebServiceFactory.createWebService((WebServiceImplementation)mavenWebService);
                if (webService.isServiceProvider()) {
                    this.providers.add(webService);
                } else {
                    this.consumers.add(webService);
                }
                break block6;
            }
            if (!"service-removed".equals(propertyChangeEvent.getPropertyName())) break block6;
            JaxWsService jaxWsService = (JaxWsService)propertyChangeEvent.getOldValue();
            if (jaxWsService.isServiceProvider()) {
                String string = jaxWsService.getImplementationClass();
                for (WebService webService : this.providers) {
                    if (!string.equals(webService.getIdentifier())) continue;
                    this.providers.remove(webService);
                    break;
                }
            } else {
                String string = jaxWsService.getId();
                for (WebService webService : this.consumers) {
                    if (string == null || !string.equals(webService.getIdentifier())) continue;
                    this.consumers.remove(webService);
                    break;
                }
            }
        }
    }

    private void reactOnPomChanges() {
        WSUtils.updateClients(this.prj, this.jaxWsSupport);
        List list = this.jaxWsSupport.getServices();
        if (list.size() > 0) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.prj.getLookup().lookup(J2eeModuleProvider.class);
            String string = j2eeModuleProvider == null ? null : j2eeModuleProvider.getServerInstanceID();
            boolean bl = false;
            if (string == null) {
                if (this.serverInstance != null) {
                    bl = true;
                }
            } else if (!string.equals(this.serverInstance)) {
                bl = true;
            }
            if (bl) {
                this.serverInstance = string;
                MavenModelUtils.reactOnServerChanges(this.prj);
            }
            if (WSUtils.isWeb(this.prj)) {
                for (JaxWsService jaxWsService : list) {
                    if (!jaxWsService.isServiceProvider()) continue;
                    WSUtils.checkNonJSR109Entries(this.prj);
                    break;
                }
            }
        }
    }

    private class ServiceInfo {
        private String serviceName;
        private String portName;
        private String implClass;
        private String wsdlLocation;

        public ServiceInfo(String string, String string2, String string3, String string4) {
            this.serviceName = string;
            this.portName = string2;
            this.implClass = string3;
            this.wsdlLocation = string4;
        }

        public String getImplClass() {
            return this.implClass;
        }

        public void setImplClass(String string) {
            this.implClass = string;
        }

        public String getPortName() {
            return this.portName;
        }

        public void setPortName(String string) {
            this.portName = string;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public String getWsdlLocation() {
            return this.wsdlLocation;
        }

        public void setWsdlLocation(String string) {
            this.wsdlLocation = string;
        }
    }

    private class WebservicesChangeListener
    implements PropertyChangeListener {
        private JAXWSLightSupport jaxWsSupport;
        private MetadataModel<WebservicesMetadata> wsModel;
        private RequestProcessor.Task updateJaxWsTask = MavenJaxWsSupportProvider.access$200().create(new Runnable(){

            @Override
            public void run() {
                WebservicesChangeListener.this.updateJaxWs();
            }
        });

        WebservicesChangeListener(JAXWSLightSupport jAXWSLightSupport, MetadataModel<WebservicesMetadata> metadataModel) {
            this.jaxWsSupport = jAXWSLightSupport;
            this.wsModel = metadataModel;
            this.updateJaxWsTask.schedule(1000);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateJaxWsTask.schedule(1000);
        }

        private void updateJaxWs() {
            try {
                final Map map = (Map)this.wsModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebservicesMetadata, Map<String, ServiceInfo>>(){

                    public Map<String, ServiceInfo> run(WebservicesMetadata webservicesMetadata) {
                        HashMap<String, ServiceInfo> hashMap = new HashMap<String, ServiceInfo>();
                        Webservices webservices = webservicesMetadata.getRoot();
                        LOG.log(Level.INFO, "Inside update JAX-WS , WS root :" + webservices + " ; number of descriptions :" + webservices.getWebserviceDescription().length);
                        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
                            PortComponent[] portComponentArray;
                            for (PortComponent portComponent : portComponentArray = webserviceDescription.getPortComponent()) {
                                String string = portComponent.getDisplayName();
                                if (!WSUtils.isInSourceGroup(MavenJaxWsSupportProvider.this.prj, string)) continue;
                                QName qName = portComponent.getWsdlPort();
                                hashMap.put(string, new ServiceInfo(webserviceDescription.getWebserviceDescriptionName(), qName == null ? null : qName.getLocalPart(), string, webserviceDescription.getWsdlFile()));
                            }
                        }
                        return hashMap;
                    }
                });
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        WebservicesChangeListener.this.doUpdateJaxWs(map);
                    }
                };
                this.jaxWsSupport.runAtomic(runnable);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void doUpdateJaxWs(Map<String, ServiceInfo> map) {
            Object object;
            Object object22;
            List list = this.jaxWsSupport.getServices();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object object22 : list) {
                if (!object22.isServiceProvider()) continue;
                hashMap.put(object22.getImplementationClass(), object22);
            }
            HashSet hashSet = new HashSet();
            object22 = hashMap.keySet();
            Set<String> set = map.keySet();
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (!set.contains(object)) continue;
                hashSet.add(object);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                hashMap.remove(object);
                map.remove(object);
            }
            boolean bl = false;
            for (String string : hashMap.keySet()) {
                this.jaxWsSupport.removeService((JaxWsService)hashMap.get(string));
            }
            for (String string : map.keySet()) {
                ServiceInfo serviceInfo = map.get(string);
                String string2 = serviceInfo.getWsdlLocation();
                JaxWsService jaxWsService = new JaxWsService(serviceInfo.getServiceName(), string);
                if (string2 != null && string2.length() > 0) {
                    jaxWsService.setWsdlLocation(string2);
                    if (string2.startsWith("WEB-INF/wsdl/")) {
                        jaxWsService.setLocalWsdl(string2.substring(13));
                    } else if (string2.startsWith("META-INF/wsdl/")) {
                        jaxWsService.setLocalWsdl(string2.substring(14));
                    } else {
                        jaxWsService.setLocalWsdl(string2);
                    }
                    FileObject fileObject = WSUtils.getLocalWsdl(this.jaxWsSupport, jaxWsService.getLocalWsdl());
                    if (fileObject != null) {
                        jaxWsService.setId(WSUtils.getUniqueId(fileObject.getName(), list));
                    }
                    jaxWsService.setWsdlUrl(WSUtils.getOriginalWsdlUrl(MavenJaxWsSupportProvider.this.prj, jaxWsService.getId(), true));
                }
                jaxWsService.setPortName(serviceInfo.getPortName());
                this.jaxWsSupport.addService(jaxWsService);
            }
        }
    }
}

