/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxws.light.spi.JAXWSLightSupportImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MavenJAXWSSupportImpl
implements JAXWSLightSupportImpl {
    private Project prj;
    private List<JaxWsService> services = new LinkedList<JaxWsService>();
    public static final String CATALOG_PATH = "src/jax-ws-catalog.xml";
    private static final String SERVLET_CLASS_NAME = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String SERVLET_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";

    MavenJAXWSSupportImpl(Project project) {
        this.prj = project;
    }

    public void addService(JaxWsService jaxWsService) {
        this.services.add(jaxWsService);
        if (jaxWsService.isServiceProvider() && !WSUtils.isJsr109Supported(this.prj)) {
            boolean bl = false;
            FileObject fileObject = this.getDeploymentDescriptorFolder();
            bl = fileObject == null || fileObject.getFileObject("sun-jaxws.xml") == null ? WSUtils.generateNonJsr109Artifacts(this.prj) : true;
            if (bl) {
                try {
                    WSUtils.addServiceToDD(this.prj, jaxWsService);
                }
                catch (IOException iOException) {
                    Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot add service elements to web.xml file", iOException);
                }
                try {
                    this.addSunJaxWsEntries(jaxWsService);
                }
                catch (IOException iOException) {
                    Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", iOException);
                }
            }
        }
    }

    private void addSunJaxWsEntries(JaxWsService jaxWsService) throws IOException {
        FileObject fileObject = this.getDeploymentDescriptorFolder();
        if (fileObject != null) {
            WSUtils.addSunJaxWsEntry(fileObject, jaxWsService);
        } else {
            String string = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public List<JaxWsService> getServices() {
        return this.services;
    }

    public void removeService(JaxWsService jaxWsService) {
        Preferences preferences;
        FileObject fileObject;
        FileObject fileObject2;
        String string = jaxWsService.getLocalWsdl();
        if (string != null && (fileObject2 = this.getWsdlFolder(false)) != null && (fileObject = fileObject2.getFileObject(string)) != null && (preferences = ProjectUtils.getPreferences((Project)this.prj, MavenWebService.class, (boolean)true)) != null) {
            preferences.remove("_C_" + jaxWsService.getId());
            preferences.remove("_S_" + jaxWsService.getId());
        }
        if (jaxWsService.isServiceProvider() && !WSUtils.isJsr109Supported(this.prj)) {
            try {
                WSUtils.removeServiceFromDD(this.prj, jaxWsService);
            }
            catch (IOException iOException) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot remove services from web.xml", iOException);
            }
            try {
                this.removeSunJaxWsEntries(jaxWsService);
            }
            catch (IOException iOException) {
                Logger.getLogger(MavenJAXWSSupportImpl.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", iOException);
            }
        }
        this.services.remove(jaxWsService);
    }

    private void removeSunJaxWsEntries(JaxWsService jaxWsService) throws IOException {
        FileObject fileObject = this.getDeploymentDescriptorFolder();
        if (fileObject != null) {
            WSUtils.removeSunJaxWsEntry(fileObject, jaxWsService);
        } else {
            String string = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    public FileObject getDeploymentDescriptorFolder() {
        File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/main/webapp/WEB-INF");
        if (file.exists()) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public FileObject getWsdlFolder(boolean bl) {
        boolean bl2;
        File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/wsdl");
        if (file.exists()) {
            return FileUtil.toFileObject((File)file);
        }
        if (bl && (bl2 = file.mkdirs())) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public FileObject getBindingsFolder(boolean bl) {
        boolean bl2;
        File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)"src/jaxws-bindings");
        if (file.exists()) {
            return FileUtil.toFileObject((File)file);
        }
        if (bl && (bl2 = file.mkdirs())) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    public URL getCatalog() {
        File file = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.prj.getProjectDirectory()), (String)CATALOG_PATH);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return WSUtils.getModuleProvider(this.prj).getJ2eeModule().getMetadataModel(WebservicesMetadata.class);
    }
}

