/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.common.filters.FilterSet;

public final class DefinedFilterSets {
    private final List definedFilterSets = new ArrayList();

    public DefinedFilterSets() {
    }

    public DefinedFilterSets(DefinedFilterSets filterSets) {
        this();
        this.setValuesFrom(filterSets);
    }

    public FilterSet getFilterSet(String filterSetName) {
        int filterSetIndex = this.getFilterSetIndex(filterSetName);
        if (filterSetIndex == -1) {
            return null;
        }
        return this.getFilterSetAt(filterSetIndex);
    }

    public FilterSet getFilterSetAt(int index) {
        return (FilterSet)this.definedFilterSets.get(index);
    }

    public int getFilterSetIndex(String filterSetName) {
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            if (!this.getFilterSetAt(i).getFilterSetName().equals(filterSetName)) continue;
            return i;
        }
        return -1;
    }

    public int getFilterSetsCount() {
        return this.definedFilterSets.size();
    }

    public void setValuesFrom(DefinedFilterSets filterSets) {
        this.definedFilterSets.clear();
        for (int i = 0; i < filterSets.getFilterSetsCount(); ++i) {
            this.definedFilterSets.add(new FilterSet(filterSets.getFilterSetAt(i)));
        }
    }

    public void addFilterSet(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.definedFilterSets.add(filterSet);
    }

    public void clear() {
        this.definedFilterSets.clear();
    }

    public String debug() {
        StringBuffer sb = new StringBuffer();
        sb.append("DefinedFilterSets:");
        sb.append("\n");
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            sb.append(((FilterSet)this.definedFilterSets.get(i)).debug());
            sb.append("\n");
        }
        return sb.toString();
    }

    public DefinedFilterSets load(Map props) {
        this.clear();
        int index = 0;
        while (props.get("FilterSet-" + index + "-name") != null) {
            this.addFilterSet(new FilterSet().load(props, index));
            ++index;
        }
        return this;
    }

    public void moveFilterSetDown(int index) {
        if (index > this.definedFilterSets.size() - 2) {
            return;
        }
        FilterSet filterSet = (FilterSet)this.definedFilterSets.remove(index);
        this.definedFilterSets.add(index + 1, filterSet);
    }

    public void moveFilterSetUp(int index) {
        if (index < 1) {
            return;
        }
        FilterSet filterSet = (FilterSet)this.definedFilterSets.remove(index);
        this.definedFilterSets.add(index - 1, filterSet);
    }

    public void removeFilterSet(FilterSet filterSet) {
        if (filterSet == null) {
            return;
        }
        this.definedFilterSets.remove(filterSet);
    }

    public void removeFilterSet(int index) {
        this.definedFilterSets.remove(index);
    }

    public void store(Map props) {
        for (int i = 0; i < this.definedFilterSets.size(); ++i) {
            ((FilterSet)this.definedFilterSets.get(i)).store(props, i);
        }
    }
}

