/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class NbmActionGoalProvider
implements MavenActionsProvider {
    static final String NBMRELOAD = "nbmreload";
    private static final String RELOAD_TARGET = "reload-target";
    private static final String PLATFORM_MAPPINGS = "org/netbeans/modules/maven/apisupport/platformActionMappings.xml";
    private static final String IDE_MAPPINGS = "org/netbeans/modules/maven/apisupport/ideActionMappings.xml";
    private AbstractMavenActionsProvider platformDelegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return NbmActionGoalProvider.class.getClassLoader().getResourceAsStream(NbmActionGoalProvider.PLATFORM_MAPPINGS);
        }
    };
    private AbstractMavenActionsProvider ideDelegate = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return NbmActionGoalProvider.class.getClassLoader().getResourceAsStream(NbmActionGoalProvider.IDE_MAPPINGS);
        }
    };

    public Set<String> getSupportedDefaultActions() {
        return new HashSet<String>(Arrays.asList(NBMRELOAD, RELOAD_TARGET));
    }

    public static Action createReloadAction() {
        Action a = ProjectSensitiveActions.projectCommandAction((String)NBMRELOAD, (String)Bundle.ACT_NBM_Reload(), null);
        a.putValue("hideWhenDisabled", true);
        return a;
    }

    public static Action createReloadTargetAction() {
        Action a = ProjectSensitiveActions.projectCommandAction((String)RELOAD_TARGET, (String)Bundle.ACT_NBM_Reload_Target(), null);
        a.putValue("hideWhenDisabled", true);
        return a;
    }

    public synchronized boolean isActionEnable(String action, Project project, Lookup lookup) {
        if (RELOAD_TARGET.equals(action) || NBMRELOAD.equals(action)) {
            return this.hasNbm(project);
        }
        if ("run".equals(action) || "debug".equals(action) || "profile".equals(action)) {
            return this.hasNbm(project) || this.isPlatformApp(project);
        }
        if ("test".equals(action)) {
            return this.isPlatformApp(project);
        }
        return false;
    }

    public RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        if (RELOAD_TARGET.equals(actionName) && this.hasNbm(project)) {
            Project app = MavenNbModuleImpl.findAppProject(project);
            if (app != null) {
                String cluster;
                if (!FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)app.getProjectDirectory()), (String)"target/userdir/lock").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.NbmActionGoalProvider_target_platform_not_running(), 2));
                    return null;
                }
                RunConfig rc = this.platformDelegate.createConfigForDefaultAction(actionName, app, lookup);
                assert (rc != null);
                rc.setPreExecution(RunUtils.createRunConfig((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (Project)project, (String)rc.getTaskDisplayName(), Collections.singletonList("package")));
                MavenProject prj = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
                String nbmBuildDir = PluginPropertyUtils.getPluginProperty((MavenProject)prj, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"nbmBuildDir", (String)"nbm");
                if (nbmBuildDir == null) {
                    Build build = prj.getBuild();
                    String directory = build != null ? build.getDirectory() : null;
                    nbmBuildDir = (directory != null ? directory : "target") + "/nbm";
                }
                if ((cluster = PluginPropertyUtils.getPluginProperty((MavenProject)prj, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"cluster", (String)"nbm")) == null) {
                    cluster = "extra";
                }
                String codeNameBase = ((NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class)).getCodeNameBase();
                File module = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)(nbmBuildDir + "/netbeans/" + cluster + "/modules/" + codeNameBase.replace('.', '-') + ".jar"));
                rc.setProperty("module", "'" + module + "'");
                return rc;
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.NbmActionGoalProvider_no_app_found(), 2));
            return null;
        }
        if (!("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName) || "test".equals(actionName) || NBMRELOAD.equals(actionName))) {
            return null;
        }
        if (this.isPlatformApp(project)) {
            return this.platformDelegate.createConfigForDefaultAction(actionName, project, lookup);
        }
        if (this.hasNbm(project)) {
            return this.ideDelegate.createConfigForDefaultAction(actionName, project, lookup);
        }
        return null;
    }

    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        Project app;
        if (RELOAD_TARGET.equals(actionName) && this.hasNbm(project) && (app = MavenNbModuleImpl.findAppProject(project)) != null) {
            return this.platformDelegate.getMappingForAction(actionName, app);
        }
        if (!("run".equals(actionName) || "debug".equals(actionName) || "profile".equals(actionName) || "test".equals(actionName) || NBMRELOAD.equals(actionName))) {
            return null;
        }
        if (this.isPlatformApp(project)) {
            return this.platformDelegate.getMappingForAction(actionName, project);
        }
        if (this.hasNbm(project)) {
            return this.ideDelegate.getMappingForAction(actionName, project);
        }
        return null;
    }

    private boolean hasNbm(Project project) {
        NbMavenProject watch = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        String pack = watch.getPackagingType();
        boolean hasNbm = "nbm".equals(pack);
        return hasNbm;
    }

    private boolean isPlatformApp(Project p) {
        NbMavenProject watch = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
        String pack = watch.getPackagingType();
        return "nbm-application".equals(pack);
    }
}

