/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectGenerator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.cookies.CloseCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public final class JFXProjectUtils {
    private static Set<ClassIndex.SearchKind> kinds = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
    private static Set<ClassIndex.SearchScope> scopes = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));
    private static final String JFX_BUILD_TEMPLATE = "Templates/JFX/jfx-impl.xml";
    private static volatile String currentJfxImplCRCCache;
    private static final Logger LOGGER;

    public static Map<String, List<String>> getJSCallbacks(String platformName) {
        String[][] c = new String[][]{{"onDeployError", "app", "mismatchEvent"}, {"onGetNoPluginMessage", "app"}, {"onGetSplash", "app"}, {"onInstallFinished", "placeholder", "component", "status", "relaunchNeeded"}, {"onInstallNeeded", "app", "platform", "cb", "isAutoinstall", "needRelaunch", "launchFunc"}, {"onInstallStarted", "placeholder", "component", "isAuto", "restartNeeded"}, {"onJavascriptReady", "id"}, {"onRuntimeError", "id", "code"}};
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        for (int i = 0; i < c.length; ++i) {
            String[] s = c[i];
            assert (s.length > 0);
            ArrayList<String> l = null;
            if (s.length > 1) {
                l = new ArrayList<String>();
                for (int j = 1; j < s.length; ++j) {
                    l.add(s[j]);
                }
            }
            m.put(s[0], l);
        }
        return m;
    }

    public static Map<FileObject, List<ClassPath>> getClassPathMap(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] srcGroups = sources.getSourceGroups("java");
        HashMap<FileObject, List<ClassPath>> classpathMap = new HashMap<FileObject, List<ClassPath>>();
        for (SourceGroup srcGroup : srcGroups) {
            FileObject srcRoot = srcGroup.getRootFolder();
            ClassPath bootCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/boot");
            ClassPath executeCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/execute");
            ClassPath sourceCP = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
            ArrayList<ClassPath> cpList = new ArrayList<ClassPath>();
            if (bootCP != null) {
                cpList.add(bootCP);
            }
            if (executeCP != null) {
                cpList.add(executeCP);
            }
            if (sourceCP != null) {
                cpList.add(sourceCP);
            }
            if (cpList.size() != 3) continue;
            classpathMap.put(srcRoot, cpList);
        }
        return classpathMap;
    }

    public static Set<String> getAppClassNames(Map<FileObject, List<ClassPath>> classpathMap, final String classType) {
        final HashSet<String> appClassNames = new HashSet<String>();
        for (FileObject fo : classpathMap.keySet()) {
            List<ClassPath> paths = classpathMap.get(fo);
            ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)paths.get(0), (ClassPath)paths.get(1), (ClassPath)paths.get(2));
            final ClassIndex classIndex = cpInfo.getClassIndex();
            JavaSource js = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
            try {
                js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void run(CompilationController controller) throws Exception {
                        Elements elems = controller.getElements();
                        TypeElement fxAppElement = elems.getTypeElement(classType);
                        ElementHandle appHandle = ElementHandle.create((Element)fxAppElement);
                        Set appHandles = classIndex.getElements(appHandle, kinds, scopes);
                        for (ElementHandle elemHandle : appHandles) {
                            appClassNames.add(elemHandle.getQualifiedName());
                        }
                    }

                    public void cancel() {
                    }
                }, true);
            }
            catch (Exception e) {}
        }
        return appClassNames;
    }

    public static Set<String> getAppClassNamesInJar(@NonNull FileObject jarFile, String classType) {
        JarFile jf;
        File jarF = FileUtil.toFile((FileObject)jarFile);
        if (jarF == null) {
            return null;
        }
        HashSet<String> appClassNames = new HashSet<String>();
        try {
            jf = new JarFile(jarF);
        }
        catch (IOException x) {
            return null;
        }
        Enumeration<JarEntry> entries = jf.entries();
        if (entries == null) {
            return null;
        }
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class") || entry.getName().contains("$")) continue;
            String classname = entry.getName().substring(0, entry.getName().length() - 6).replace('\\', '/').replace('/', '.');
            if (classname.startsWith(".")) {
                classname = classname.substring(1);
            }
            appClassNames.add(classname);
        }
        return appClassNames;
    }

    public static boolean isFXProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled"));
    }

    public static boolean isFXinSwingProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled")) && JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.swing"));
    }

    public static boolean isFXPreloaderProject(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return false;
        }
        return JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.enabled")) && JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.preloader")) && !JFXProjectProperties.isTrue(ep.evaluator().getProperty("javafx.swing"));
    }

    public static String getFXProjectRunAs(@NonNull Project prj) {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        if (ep == null) {
            return null;
        }
        return ep.evaluator().getProperty("javafx.run.as");
    }

    public static String getRelativePath(@NonNull FileObject sourceFO, @NonNull FileObject targetFO) {
        String path = "";
        FileObject src = sourceFO;
        FileObject tgt = targetFO;
        String targetName = null;
        if (!src.isFolder()) {
            src = src.getParent();
        }
        if (!tgt.isFolder()) {
            targetName = tgt.getNameExt();
            tgt = tgt.getParent();
        }
        LinkedList<String> srcSplit = new LinkedList<String>();
        LinkedList<String> tgtSplit = new LinkedList<String>();
        while (!src.isRoot()) {
            srcSplit.addFirst(src.getName());
            src = src.getParent();
        }
        while (!tgt.isRoot()) {
            tgtSplit.addFirst(tgt.getName());
            tgt = tgt.getParent();
        }
        boolean share = false;
        while (!srcSplit.isEmpty() && !tgtSplit.isEmpty() && ((String)srcSplit.getFirst()).equals(tgtSplit.getFirst())) {
            srcSplit.removeFirst();
            tgtSplit.removeFirst();
            share = true;
        }
        if (!share) {
            return null;
        }
        for (int left = 0; left < srcSplit.size(); ++left) {
            path = left == 0 ? path + ".." : path + "/..";
        }
        while (!tgtSplit.isEmpty()) {
            path = path.isEmpty() ? path + (String)tgtSplit.getFirst() : path + "/" + (String)tgtSplit.getFirst();
            tgtSplit.removeFirst();
        }
        if (targetName != null) {
            path = !path.isEmpty() ? path + "/" + targetName : path + targetName;
        }
        return path;
    }

    public static FileObject getFileObject(@NonNull FileObject sourceDir, @NonNull String relPath) {
        File f;
        String[] split = relPath.split("[\\\\/]+");
        FileObject src = sourceDir;
        String path = "";
        boolean back = true;
        if (split[0].equals("..")) {
            for (int i = 0; i < split.length; ++i) {
                if (back && split[i].equals("..")) {
                    if ((src = src.getParent()) != null) continue;
                    return null;
                }
                if (back) {
                    back = false;
                    path = src.getPath();
                }
                path = path + "/" + split[i];
            }
        } else {
            path = relPath;
        }
        if ((f = new File(path)).exists()) {
            return FileUtil.toFileObject((File)f);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FileObject updateJfxImpl(final @NonNull Project proj) throws IOException {
        FileObject templateFO;
        InputStream in;
        FileObject returnFO = null;
        boolean isJfxCurrent = true;
        FileObject projDir = proj.getProjectDirectory();
        FileObject jfxBuildFile = projDir.getFileObject("nbproject/jfx-impl.xml");
        if (jfxBuildFile != null && (in = jfxBuildFile.getInputStream()) != null) {
            try {
                isJfxCurrent = JFXProjectUtils.isJfxImplCurrentVer(JFXProjectUtils.computeCrc32(in));
            }
            finally {
                in.close();
            }
        }
        if (!isJfxCurrent) {
            DataObject dobj = DataObject.find((FileObject)jfxBuildFile);
            CloseCookie closeCookie = (CloseCookie)dobj.getLookup().lookup(CloseCookie.class);
            if (closeCookie != null) {
                closeCookie.close();
            }
            FileObject nbproject = projDir.getFileObject("nbproject");
            final String backupName = FileUtil.findFreeFileName((FileObject)nbproject, (String)"jfx-impl_backup", (String)"xml");
            FileUtil.moveFile((FileObject)jfxBuildFile, (FileObject)nbproject, (String)backupName);
            LOGGER.log(Level.INFO, "Old build script file jfx-impl.xml has been renamed to: {0}.xml", backupName);
            jfxBuildFile = null;
            try {
                FileObject readmeFO;
                File readme = new File(FileUtil.toFile((FileObject)nbproject), NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_NAME"));
                if (!readme.exists()) {
                    readme.createNewFile();
                }
                returnFO = readmeFO = FileUtil.toFileObject((File)readme);
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void run() throws Exception {
                            OutputStream os = null;
                            FileLock lock = null;
                            try {
                                lock = readmeFO.lock();
                                os = readmeFO.getOutputStream(lock);
                                PrintWriter out = new PrintWriter(os);
                                try {
                                    String headerTemplate = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_CONTENT_HEADER");
                                    String header = MessageFormat.format(headerTemplate, ProjectUtils.getInformation((Project)proj).getDisplayName());
                                    char[] underline = new char[header.length()];
                                    Arrays.fill(underline, '=');
                                    String content = NbBundle.getMessage(JFXProjectUtils.class, (String)"TXT_UPDATED_README_FILE_CONTENT");
                                    out.println(underline);
                                    out.println(header);
                                    out.println(underline);
                                    out.println(MessageFormat.format(content, backupName + ".xml"));
                                }
                                finally {
                                    if (out != null) {
                                        out.close();
                                    }
                                }
                            }
                            finally {
                                if (lock != null) {
                                    lock.releaseLock();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException mux) {
                    throw (IOException)mux.getException();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "Cannot create file readme file. ", ioe);
            }
        }
        if (jfxBuildFile == null && (templateFO = FileUtil.getConfigFile((String)JFX_BUILD_TEMPLATE)) != null) {
            FileUtil.copyFile((FileObject)templateFO, (FileObject)projDir.getFileObject("nbproject"), (String)"jfx-impl");
            LOGGER.log(Level.INFO, "Build script jfx-impl.xml has been updated to the latest version supported by this NetBeans installation.");
        }
        return returnFO;
    }

    static String computeCrc32(InputStream is) throws IOException {
        int curr;
        CRC32 crc = new CRC32();
        int last = -1;
        while ((curr = is.read()) != -1) {
            if (curr != 10 && last == 13) {
                crc.update(10);
            }
            if (curr != 13) {
                crc.update(curr);
            }
            last = curr;
        }
        if (last == 13) {
            crc.update(10);
        }
        int val = (int)crc.getValue();
        String hex = Integer.toHexString(val);
        while (hex.length() < 8) {
            hex = "0" + hex;
        }
        return hex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isJfxImplCurrentVer(String crc) throws IOException {
        FileObject template;
        InputStream in;
        String _currentJfxImplCRC = currentJfxImplCRCCache;
        if (_currentJfxImplCRC == null && (in = (template = FileUtil.getConfigFile((String)JFX_BUILD_TEMPLATE)).getInputStream()) != null) {
            try {
                currentJfxImplCRCCache = _currentJfxImplCRC = JFXProjectUtils.computeCrc32(in);
            }
            finally {
                in.close();
            }
        }
        return _currentJfxImplCRC.equals(crc);
    }

    public static boolean updateDefaultRunAsConfigFile(@NonNull FileObject projDir, JFXProjectProperties.RunAsType runAs, boolean setBrowserProps) throws IOException {
        String privatePath;
        FileObject privateCfgFO;
        EditableProperties privateCfgProps;
        EditableProperties sharedCfgProps;
        boolean updated = false;
        String configName = runAs.getDefaultConfig();
        String configFile = JFXProjectUtils.makeSafe(configName);
        String sharedPath = JFXProjectProperties.getSharedConfigFilePath(configFile);
        FileObject sharedCfgFO = projDir.getFileObject(sharedPath);
        EditableProperties editableProperties = sharedCfgProps = sharedCfgFO != null ? JFXProjectProperties.readFromFile(sharedCfgFO) : new EditableProperties(true);
        assert (sharedCfgProps != null);
        if (sharedCfgProps.isEmpty()) {
            sharedCfgProps.setProperty("$label", configName);
            sharedCfgProps.setComment("$label", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_run_as_defaults")}, false);
            JFXProjectProperties.saveToFile(projDir, sharedPath, sharedCfgProps);
            updated = true;
        }
        EditableProperties editableProperties2 = privateCfgProps = (privateCfgFO = projDir.getFileObject(privatePath = JFXProjectProperties.getPrivateConfigFilePath(configFile))) != null ? JFXProjectProperties.readFromFile(projDir, privatePath) : new EditableProperties(true);
        assert (privateCfgProps != null);
        if (privateCfgProps.isEmpty() || setBrowserProps) {
            Iterator<Map.Entry<String, String>> i$;
            Map<String, String> browserInfo;
            privateCfgProps.setProperty("$label", configName);
            privateCfgProps.setComment("$label", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_run_as_defaults")}, false);
            privateCfgProps.setProperty("javafx.run.as", runAs.getString());
            privateCfgProps.setComment("javafx.run.as", new String[]{"# " + NbBundle.getMessage(JFXProjectGenerator.class, (String)"COMMENT_run_as_defaults")}, false);
            if (setBrowserProps && (browserInfo = JFXProjectUtils.getDefaultBrowserInfo()) != null && !browserInfo.isEmpty() && (i$ = browserInfo.entrySet().iterator()).hasNext()) {
                Map.Entry<String, String> entry = i$.next();
                privateCfgProps.setProperty("javafx.run.inbrowser", entry.getKey());
                privateCfgProps.setProperty("javafx.run.inbrowser.path", entry.getValue());
            }
            JFXProjectProperties.saveToFile(projDir, privatePath, privateCfgProps);
            updated = true;
        }
        return updated;
    }

    public static Map<String, String> getDefaultBrowserInfo() {
        Lookup.Result allBrowsers = Lookup.getDefault().lookupResult(ExtWebBrowser.class);
        HashMap<String, String> browserPaths = new HashMap<String, String>();
        for (Lookup.Item browser : allBrowsers.allItems()) {
            String name = browser.getDisplayName();
            if (name == null || !name.toLowerCase().contains("default")) continue;
            NbProcessDescriptor proc = ((ExtWebBrowser)browser.getInstance()).getBrowserExecutable();
            String path = proc.getProcessName();
            if (!JFXProjectProperties.isNonEmpty(path)) break;
            browserPaths.put(name, path);
            break;
        }
        return browserPaths;
    }

    public static List<Map<String, String>> copyList(List<Map<String, String>> list2Copy) {
        ArrayList<Map<String, String>> list2Return = new ArrayList<Map<String, String>>();
        if (list2Copy != null) {
            for (Map<String, String> map : list2Copy) {
                list2Return.add(JFXProjectUtils.copyMap(map));
            }
        }
        return list2Return;
    }

    public static Map<String, String> copyMap(Map<String, String> map2Copy) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        if (map2Copy != null) {
            for (String key : map2Copy.keySet()) {
                String value = map2Copy.get(key);
                newMap.put(key, value);
            }
        }
        return newMap;
    }

    public static String makeSafe(@NonNull String name) {
        return name.replaceAll("[^a-zA-Z0-9_.-]", "_");
    }

    static {
        LOGGER = Logger.getLogger("javafx");
    }
}

