/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.ui.CustomizerJarComponent;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class JFXProjectProperties {
    private static final Logger LOG = Logger.getLogger(JFXProjectProperties.class.getName());
    public static final String JAVAFX_ENABLED = "javafx.enabled";
    public static final String JAVAFX_PRELOADER = "javafx.preloader";
    public static final String JAVAFX_SWING = "javafx.swing";
    public static final String JAVAFX_DISABLE_AUTOUPDATE = "javafx.disable.autoupdate";
    public static final String JAVAFX_DISABLE_AUTOUPDATE_NOTIFICATION = "javafx.disable.autoupdate.notification";
    public static final String JAVAFX_ENDORSED_ANT_CLASSPATH = "endorsed.javafx.ant.classpath";
    public static final String FXML_EXTENSION = "fxml";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAFX_BINARY_ENCODE_CSS = "javafx.binarycss";
    public static final String JAVAFX_DEPLOY_INCLUDEDT = "javafx.deploy.includeDT";
    public static final String JAVAFX_DEPLOY_EMBEDJNLP = "javafx.deploy.embedJNLP";
    public static final String JAVAFX_REBASE_LIBS = "javafx.rebase.libs";
    public static final String MAIN_CLASS = "javafx.main.class";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String APP_PARAM_PREFIX = "javafx.param.";
    public static final String[] APP_PARAM_SUFFIXES = new String[]{"name", "value"};
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String FALLBACK_CLASS = "javafx.fallback.class";
    public static final String SIGNED_JAR = "dist.signed.jar";
    public static final String PRELOADER_ENABLED = "javafx.preloader.enabled";
    public static final String PRELOADER_TYPE = "javafx.preloader.type";
    public static final String PRELOADER_PROJECT = "javafx.preloader.project.path";
    public static final String PRELOADER_CLASS = "javafx.preloader.class";
    public static final String PRELOADER_JAR_FILENAME = "javafx.preloader.jar.filename";
    public static final String PRELOADER_JAR_PATH = "javafx.preloader.jar.path";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String RUN_APP_WIDTH = "javafx.run.width";
    public static final String RUN_APP_HEIGHT = "javafx.run.height";
    public static final String RUN_IN_HTMLTEMPLATE = "javafx.run.htmltemplate";
    public static final String RUN_IN_HTMLTEMPLATE_PROCESSED = "javafx.run.htmltemplate.processed";
    public static final String RUN_IN_BROWSER = "javafx.run.inbrowser";
    public static final String RUN_IN_BROWSER_PATH = "javafx.run.inbrowser.path";
    public static final String RUN_IN_BROWSER_ARGUMENTS = "javafx.run.inbrowser.arguments";
    public static final String RUN_IN_BROWSER_UNDEFINED = "undefined";
    public static final String RUN_AS = "javafx.run.as";
    public static final String DEFAULT_APP_WIDTH = "800";
    public static final String DEFAULT_APP_HEIGHT = "600";
    public static final String UPDATE_MODE_BACKGROUND = "javafx.deploy.backgroundupdate";
    public static final String ALLOW_OFFLINE = "javafx.deploy.allowoffline";
    public static final String INSTALL_PERMANENTLY = "javafx.deploy.installpermanently";
    public static final String ADD_DESKTOP_SHORTCUT = "javafx.deploy.adddesktopshortcut";
    public static final String ADD_STARTMENU_SHORTCUT = "javafx.deploy.addstartmenushortcut";
    public static final String ICON_FILE = "javafx.deploy.icon";
    public static final String PERMISSIONS_ELEVATED = "javafx.deploy.permissionselevated";
    public static final String JAVAFX_SIGNING_ENABLED = "javafx.signing.enabled";
    public static final String JAVAFX_SIGNING_TYPE = "javafx.signing.type";
    public static final String JAVAFX_SIGNING_KEYSTORE = "javafx.signing.keystore";
    public static final String JAVAFX_SIGNING_KEYSTORE_PASSWORD = "javafx.signing.keystore.password";
    public static final String JAVAFX_SIGNING_KEY = "javafx.signing.keyalias";
    public static final String JAVAFX_SIGNING_KEY_PASSWORD = "javafx.signing.keyalias.password";
    public static final String RUN_CP = "run.classpath";
    public static final String BUILD_CLASSES = "build.classes.dir";
    public static final String DOWNLOAD_MODE_LAZY_JARS = "download.mode.lazy.jars";
    private static final String DOWNLOAD_MODE_LAZY_JAR = "download.mode.lazy.jar.";
    private static final String DOWNLOAD_MODE_LAZY_FORMAT = "download.mode.lazy.jar.%s";
    public static final String JAVASCRIPT_CALLBACK_PREFIX = "javafx.jscallback.";
    public static final String PROJECT_CONFIGS_DIR = "nbproject/configs";
    public static final String PROJECT_PRIVATE_CONFIGS_DIR = "nbproject/private/configs";
    public static final String PROPERTIES_FILE_EXT = "properties";
    public static final String CONFIG_PROPERTIES_FILE = "nbproject/private/config.properties";
    public static final String DEFAULT_CONFIG = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.default.label");
    public static final String DEFAULT_CONFIG_STANDALONE = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.standalone.label");
    public static final String DEFAULT_CONFIG_WEBSTART = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.webstart.label");
    public static final String DEFAULT_CONFIG_BROWSER = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.browser.label");
    private StoreGroup fxPropGroup = new StoreGroup();
    JToggleButton.ToggleButtonModel binaryEncodeCSS;
    private CustomizerJarComponent jarComponent = null;
    private JFXConfigs CONFIGS = null;
    private Map<String, String> browserPaths = null;
    PreloaderClassComboBoxModel preloaderClassModel;
    JToggleButton.ToggleButtonModel runStandalone;
    JToggleButton.ToggleButtonModel runAsWebStart;
    JToggleButton.ToggleButtonModel runInBrowser;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel backgroundUpdateCheck;
    JToggleButton.ToggleButtonModel installPermanently;
    JToggleButton.ToggleButtonModel addDesktopShortcut;
    JToggleButton.ToggleButtonModel addStartMenuShortcut;
    Document iconDocument;
    boolean signingEnabled;
    SigningType signingType;
    String signingKeyStore;
    String signingKeyAlias;
    boolean permissionsElevated;
    char[] signingKeyStorePassword;
    char[] signingKeyPassword;
    List<? extends File> runtimeCP;
    List<? extends File> lazyJars;
    boolean lazyJarsChanged;
    Map<String, String> jsCallbacks;
    boolean jsCallbacksChanged;
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    private static Map<String, JFXProjectProperties> propInstance = new HashMap<String, JFXProjectProperties>();
    private Set<String> instanceMarkers = new TreeSet<String>();
    private static Map<String, Set<PreloaderArtifact>> prelArtifacts = new HashMap<String, Set<PreloaderArtifact>>();

    public JToggleButton.ToggleButtonModel getBinaryEncodeCSSModel() {
        return this.binaryEncodeCSS;
    }

    public CustomizerJarComponent getCustomizerJarComponent() {
        if (this.jarComponent == null) {
            this.jarComponent = new CustomizerJarComponent(this);
        }
        return this.jarComponent;
    }

    public JFXConfigs getConfigs() {
        return this.CONFIGS;
    }

    public Map<String, String> getBrowserPaths() {
        return this.browserPaths;
    }

    public void resetBrowserPaths() {
        this.browserPaths = new HashMap<String, String>();
    }

    public void setBrowserPaths(Map<String, String> browserPaths) {
        this.browserPaths = browserPaths;
    }

    public PreloaderClassComboBoxModel getPreloaderClassModel() {
        return this.preloaderClassModel;
    }

    public JToggleButton.ToggleButtonModel getAllowOfflineModel() {
        return this.allowOfflineModel;
    }

    public JToggleButton.ToggleButtonModel getBackgroundUpdateCheckModel() {
        return this.backgroundUpdateCheck;
    }

    public JToggleButton.ToggleButtonModel getInstallPermanentlyModel() {
        return this.installPermanently;
    }

    public JToggleButton.ToggleButtonModel getAddDesktopShortcutModel() {
        return this.addDesktopShortcut;
    }

    public JToggleButton.ToggleButtonModel getAddStartMenuShortcutModel() {
        return this.addStartMenuShortcut;
    }

    public Document getIconDocumentModel() {
        return this.iconDocument;
    }

    public boolean getSigningEnabled() {
        return this.signingEnabled;
    }

    public void setSigningEnabled(boolean enabled) {
        this.signingEnabled = enabled;
    }

    public boolean getPermissionsElevated() {
        return this.permissionsElevated;
    }

    public void setPermissionsElevated(boolean enabled) {
        this.permissionsElevated = enabled;
    }

    public SigningType getSigningType() {
        return this.signingType;
    }

    public void setSigningType(SigningType type) {
        this.signingType = type;
    }

    public String getSigningKeyStore() {
        return this.signingKeyStore;
    }

    public String getSigningKeyAlias() {
        return this.signingKeyAlias;
    }

    public char[] getSigningKeyStorePassword() {
        return this.signingKeyStorePassword;
    }

    public char[] getSigningKeyPassword() {
        return this.signingKeyPassword;
    }

    public void setSigningKeyAlias(String signingKeyAlias) {
        this.signingKeyAlias = signingKeyAlias;
    }

    public void setSigningKeyPassword(char[] signingKeyPassword) {
        this.signingKeyPassword = signingKeyPassword;
    }

    public void setSigningKeyStore(String signingKeyStore) {
        this.signingKeyStore = signingKeyStore;
    }

    public void setSigningKeyStorePassword(char[] signingKeyStorePassword) {
        this.signingKeyStorePassword = signingKeyStorePassword;
    }

    public List<? extends File> getRuntimeCP() {
        return this.runtimeCP;
    }

    public List<? extends File> getLazyJars() {
        return this.lazyJars;
    }

    public void setLazyJars(List<? extends File> newLazyJars) {
        this.lazyJars = newLazyJars;
    }

    public boolean getLazyJarsChanged() {
        return this.lazyJarsChanged;
    }

    public void setLazyJarsChanged(boolean changed) {
        this.lazyJarsChanged = changed;
    }

    public Map<String, String> getJSCallbacks() {
        return this.jsCallbacks;
    }

    public void setJSCallbacks(Map<String, String> newCallbacks) {
        this.jsCallbacks = newCallbacks;
    }

    public boolean getJSCallbacksChanged() {
        return this.jsCallbacksChanged;
    }

    public void setJSCallbacksChanged(boolean changed) {
        this.jsCallbacksChanged = changed;
    }

    public Project getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void markInstance(@NonNull String marker) {
        this.instanceMarkers.add(marker);
    }

    public boolean isInstanceMarked(@NonNull String marker) {
        return this.instanceMarkers.contains(marker);
    }

    public static JFXProjectProperties getInstance(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
        }
        return prop;
    }

    public static JFXProjectProperties getInstancePerSession(Lookup context, String category) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            if (prop.isInstanceMarked(category)) {
                prop = null;
            } else {
                prop.markInstance(category);
            }
        }
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
            prop.markInstance(category);
        }
        return prop;
    }

    public static JFXProjectProperties getInstanceIfExists(Project proj) {
        assert (proj != null);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            return prop;
        }
        return null;
    }

    public static JFXProjectProperties getInstanceIfExists(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        return JFXProjectProperties.getInstanceIfExists(proj);
    }

    public static void cleanup(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        propInstance.remove(projDir);
    }

    private static Set<PreloaderArtifact> getPreloaderArtifacts(@NonNull Project proj) {
        String projDir = proj.getProjectDirectory().getPath();
        Set<PreloaderArtifact> prels = prelArtifacts.get(projDir);
        if (prels == null) {
            prels = new HashSet<PreloaderArtifact>();
            prelArtifacts.put(projDir, prels);
        }
        return prels;
    }

    private JFXProjectProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.binaryEncodeCSS = this.fxPropGroup.createToggleButtonModel(this.evaluator, JAVAFX_BINARY_ENCODE_CSS);
            this.allowOfflineModel = this.fxPropGroup.createToggleButtonModel(this.evaluator, ALLOW_OFFLINE);
            this.backgroundUpdateCheck = this.fxPropGroup.createToggleButtonModel(this.evaluator, UPDATE_MODE_BACKGROUND);
            this.installPermanently = this.fxPropGroup.createToggleButtonModel(this.evaluator, INSTALL_PERMANENTLY);
            this.addDesktopShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_DESKTOP_SHORTCUT);
            this.addStartMenuShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_STARTMENU_SHORTCUT);
            this.iconDocument = this.fxPropGroup.createStringDocument(this.evaluator, ICON_FILE);
            this.CONFIGS = new JFXConfigs();
            this.CONFIGS.read();
            this.initPreloaderArtifacts(this.project, this.CONFIGS);
            this.CONFIGS.setActive(this.evaluator.getProperty("config"));
            this.preloaderClassModel = new PreloaderClassComboBoxModel();
            this.initSigning(this.evaluator);
            this.initResources(this.evaluator, this.project, this.CONFIGS);
            this.initJSCallbacks(this.evaluator);
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqualText(String s1, String s2) {
        return (s1 == null || s1.isEmpty()) && (s2 == null || s2.isEmpty()) || s1 != null && s2 != null && s1.equals(s2);
    }

    public static String getSharedConfigFilePath(@NonNull String config) {
        return "nbproject/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    public static String getPrivateConfigFilePath(@NonNull String config) {
        return "nbproject/private/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    private FileObject getSrcRoot(@NonNull Project project) {
        FileObject srcRoot = null;
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (JFXProjectProperties.isTest(sg.getRootFolder(), project)) continue;
            srcRoot = sg.getRootFolder();
            break;
        }
        return srcRoot;
    }

    private void initPreloaderArtifacts(@NonNull Project project, @NonNull JFXConfigs configs) {
        Set<PreloaderArtifact> prels = JFXProjectProperties.getPreloaderArtifacts(project);
        prels.clear();
        try {
            prels.addAll(this.getPreloaderArtifactsFromConfigs(configs));
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public boolean hasPreloaderInAnyConfig() {
        return this.hasPreloaderInAnyConfig(this.CONFIGS);
    }

    private boolean hasPreloaderInAnyConfig(@NonNull JFXConfigs configs) {
        if (configs != null) {
            for (String config : configs.getConfigNames()) {
                if (!JFXProjectProperties.isTrue(configs.getProperty(config, PRELOADER_ENABLED))) continue;
                return true;
            }
        }
        return false;
    }

    private PreloaderArtifact getPreloaderArtifactFromConfig(@NonNull JFXConfigs configs, @NonNull String config) throws IOException {
        if (configs.hasConfig(config)) {
            String prelJar;
            PreloaderArtifact preloader = null;
            if (!JFXProjectProperties.isTrue(configs.getProperty(config, PRELOADER_ENABLED))) {
                return null;
            }
            String prelTypeString = configs.getProperty(config, PRELOADER_TYPE);
            String prelProjDir = configs.getProperty(config, PRELOADER_PROJECT);
            if (prelProjDir != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.PROJECT.getString())) {
                FileObject srcRoot;
                File prelProjDirF;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelProjDir);
                File file = prelProjDirF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (JFXProjectProperties.isTrue(configs.getProperty(config, PRELOADER_ENABLED)) && prelProjDirF != null && prelProjDirF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    prelProjDirF = FileUtil.normalizeFile((File)prelProjDirF);
                    FileObject prelProjFO = FileUtil.toFileObject((File)prelProjDirF);
                    Project proj = ProjectManager.getDefault().findProject(prelProjFO);
                    AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)proj, (String)"jar");
                    ArrayList<URI> allURI = new ArrayList<URI>();
                    for (AntArtifact artifact : artifacts) {
                        allURI.addAll(Arrays.asList(artifact.getArtifactLocations()));
                    }
                    if (!allURI.isEmpty()) {
                        URI[] arrayURI = allURI.toArray(new URI[0]);
                        preloader = new PreloaderProjectArtifact(artifacts, arrayURI, srcRoot, "classpath/compile", prelProjDirF.getAbsolutePath());
                    }
                }
            }
            if (preloader == null && (prelJar = configs.getProperty(config, PRELOADER_JAR_PATH)) != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.JAR.getString())) {
                FileObject srcRoot;
                File prelJarF;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelJar);
                File file = prelJarF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (prelJarF != null && prelJarF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    URL[] urls = new URL[]{FileUtil.urlForArchiveOrDir((File)prelJarF)};
                    FileObject[] fos = new FileObject[]{FileUtil.toFileObject((File)prelJarF)};
                    preloader = new PreloaderJarArtifact(urls, fos, srcRoot, "classpath/compile", urls[0].toString());
                }
            }
            return preloader;
        }
        return null;
    }

    private Set<PreloaderArtifact> getPreloaderArtifactsFromConfigs(@NonNull JFXConfigs configs) throws IOException {
        HashSet<PreloaderArtifact> preloaderArtifacts = new HashSet<PreloaderArtifact>();
        for (String config : configs.getConfigNames()) {
            PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, config);
            if (preloader == null) continue;
            preloaderArtifacts.add(preloader);
        }
        return preloaderArtifacts;
    }

    public void updatePreloaderDependencies() {
        try {
            this.updatePreloaderDependencies(this.CONFIGS);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Deprecated
    private void updatePreloaderDependencies(final @NonNull JFXConfigs configs) throws IOException {
        Set<PreloaderArtifact> preloaderArtifacts = JFXProjectProperties.getPreloaderArtifacts(this.getProject());
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            artifact.setValid(false);
        }
        for (final String config : configs.getConfigNames()) {
            final PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, config);
            if (preloader == null) continue;
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (JFXProjectProperties.isEqual(config, configs.getActive())) {
                            preloader.addDependency();
                        } else {
                            preloader.removeDependency();
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Preloader dependency update failed.");
                    }
                }
            });
            boolean updated = false;
            for (PreloaderArtifact a : preloaderArtifacts) {
                if (!a.equals(preloader)) continue;
                a.setValid(true);
                updated = true;
            }
            if (updated) continue;
            preloader.setValid(true);
            preloaderArtifacts.add(preloader);
        }
        HashSet<PreloaderArtifact> toRemove = new HashSet<PreloaderArtifact>();
        for (final PreloaderArtifact artifact : preloaderArtifacts) {
            if (artifact.isValid()) continue;
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        artifact.removeDependency();
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Preloader dependency removal failed.");
                    }
                }
            });
            artifact.removeDependency();
            toRemove.add(artifact);
        }
        for (final PreloaderArtifact artifact : toRemove) {
            preloaderArtifacts.remove(artifact);
        }
    }

    private static boolean isTest(@NonNull FileObject root, @NonNull Project project) {
        assert (root != null);
        assert (project != null);
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] srcRoots;
            for (FileObject srcRoot : srcRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                if (!project.equals(FileOwnerQuery.getOwner((FileObject)srcRoot))) continue;
                return true;
            }
        }
        return false;
    }

    private void storeRest(@NonNull EditableProperties editableProps, @NonNull EditableProperties privProps) {
        editableProps.setProperty(JAVAFX_SIGNING_ENABLED, this.signingEnabled ? "true" : "false");
        editableProps.setProperty(JAVAFX_SIGNING_TYPE, this.signingType.getString());
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEY, this.signingKeyAlias);
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEYSTORE, this.signingKeyStore);
        editableProps.setProperty(PERMISSIONS_ELEVATED, this.permissionsElevated ? "true" : "false");
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEYSTORE_PASSWORD, this.signingKeyStorePassword);
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEY_PASSWORD, this.signingKeyPassword);
        this.storeResources(editableProps);
        this.storeJSCallbacks(editableProps);
        this.storePlatform(editableProps);
    }

    private void setOrRemove(EditableProperties props, String name, char[] value) {
        this.setOrRemove(props, name, value != null ? new String(value) : null);
    }

    private void setOrRemove(@NonNull EditableProperties props, @NonNull String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public static EditableProperties readFromFile(@NonNull Project project, @NonNull String relativePath) throws IOException {
        FileObject dirFO = project.getProjectDirectory();
        return JFXProjectProperties.readFromFile(dirFO, relativePath);
    }

    public static EditableProperties readFromFile(@NonNull FileObject dirFO, @NonNull String relativePath) throws IOException {
        assert (dirFO.isFolder());
        FileObject propsFO = dirFO.getFileObject(relativePath);
        return JFXProjectProperties.readFromFile(propsFO);
    }

    public static EditableProperties readFromFile(@NonNull FileObject propsFO) throws IOException {
        final EditableProperties ep = new EditableProperties(true);
        if (propsFO != null) {
            assert (propsFO.isData());
            try {
                final InputStream is = propsFO.getInputStream();
                ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        try {
                            ep.load(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
        return ep;
    }

    public static void deleteFile(@NonNull Project project, @NonNull String relativePath) throws IOException {
        FileObject propsFO = project.getProjectDirectory().getFileObject(relativePath);
        JFXProjectProperties.deleteFile(propsFO);
    }

    public static void deleteFile(final @NonNull FileObject propsFO) throws IOException {
        if (propsFO != null) {
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    public Void run() throws Exception {
                        propsFO.delete();
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
    }

    public static void saveToFile(@NonNull Project project, @NonNull String relativePath, @NonNull EditableProperties ep) throws IOException {
        FileObject dirFO = project.getProjectDirectory();
        JFXProjectProperties.saveToFile(dirFO, relativePath, ep);
    }

    public static void saveToFile(@NonNull FileObject dirFO, @NonNull String relativePath, @NonNull EditableProperties ep) throws IOException {
        FileObject propsFO;
        assert (dirFO.isFolder());
        FileObject f = dirFO.getFileObject(relativePath);
        if (f == null) {
            propsFO = FileUtil.createData((FileObject)dirFO, (String)relativePath);
            assert (propsFO != null) : "FU.cD must not return null; called on " + dirFO + " + " + relativePath;
        } else {
            propsFO = f;
        }
        JFXProjectProperties.saveToFile(propsFO, ep);
    }

    public static void saveToFile(final @NonNull FileObject propsFO, final @NonNull EditableProperties ep) throws IOException {
        if (propsFO != null) {
            assert (propsFO.isData());
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Void run() throws Exception {
                        OutputStream os = null;
                        FileLock lock = null;
                        try {
                            lock = propsFO.lock();
                            os = propsFO.getOutputStream(lock);
                            ep.store(os);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mux) {
                throw (IOException)mux.getException();
            }
        }
    }

    public void store() throws IOException {
        this.updatePreloaderDependencies(this.CONFIGS);
        this.CONFIGS.storeActive();
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final EditableProperties pep = new EditableProperties(true);
        final FileObject privPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        try {
            final InputStream is = projPropsFO.getInputStream();
            final InputStream pis = privPropsFO.getInputStream();
            ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        ep.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    try {
                        pep.load(pis);
                    }
                    finally {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
        this.fxPropGroup.store(ep);
        this.storeRest(ep, pep);
        this.CONFIGS.store(ep, pep);
        this.updatePreloaderComment(ep);
        JFXProjectProperties.logProps(ep);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    try {
                        lock = privPropsFO.lock();
                        os = privPropsFO.getOutputStream(lock);
                        pep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private void updatePreloaderComment(EditableProperties ep) {
        if (JFXProjectProperties.isTrue(ep.get((Object)PRELOADER_ENABLED))) {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_use_preloader")}, false);
        } else {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_dontuse_preloader")}, false);
        }
    }

    private void initSigning(PropertyEvaluator eval) {
        String enabled = eval.getProperty(JAVAFX_SIGNING_ENABLED);
        String signedProp = eval.getProperty(JAVAFX_SIGNING_TYPE);
        this.signingEnabled = JFXProjectProperties.isTrue(enabled);
        this.signingType = signedProp == null ? SigningType.NOSIGN : (signedProp.equalsIgnoreCase(SigningType.SELF.getString()) ? SigningType.SELF : (signedProp.equalsIgnoreCase(SigningType.KEY.getString()) ? SigningType.KEY : SigningType.NOSIGN));
        this.signingKeyStore = eval.getProperty(JAVAFX_SIGNING_KEYSTORE);
        this.signingKeyAlias = eval.getProperty(JAVAFX_SIGNING_KEY);
        if (eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD) != null) {
            this.signingKeyStorePassword = eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD).toCharArray();
        }
        if (eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD) != null) {
            this.signingKeyPassword = eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD).toCharArray();
        }
        this.permissionsElevated = JFXProjectProperties.isTrue(eval.getProperty(PERMISSIONS_ELEVATED));
    }

    private void initResources(PropertyEvaluator eval, Project prj, JFXConfigs configs) {
        String[] paths;
        String lz = eval.getProperty(DOWNLOAD_MODE_LAZY_JARS);
        String rcp = eval.getProperty(RUN_CP);
        String bc = eval.getProperty(BUILD_CLASSES);
        File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File bcDir = bc == null ? null : PropertyUtils.resolveFile((File)prjDir, (String)bc);
        ArrayList<? extends File> lazyFileList = new ArrayList<File>();
        if (lz != null) {
            for (String p : paths = PropertyUtils.tokenizePath((String)lz)) {
                lazyFileList.add(PropertyUtils.resolveFile((File)prjDir, (String)p));
            }
        }
        paths = PropertyUtils.tokenizePath((String)rcp);
        String mainJar = eval.getProperty(DIST_JAR);
        File mainFile = PropertyUtils.resolveFile((File)prjDir, (String)mainJar);
        ArrayList<FileObject> preloaders = new ArrayList<FileObject>();
        try {
            for (PreloaderArtifact pa : this.getPreloaderArtifactsFromConfigs(configs)) {
                preloaders.addAll(Arrays.asList(pa.getFileObjects()));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        ArrayList<? extends File> resFileList = new ArrayList<File>(paths.length);
        for (String p : paths) {
            File f;
            if (p.startsWith("${") && p.endsWith("}") || (f = PropertyUtils.resolveFile((File)prjDir, (String)p)).equals(mainFile)) continue;
            boolean isPrel = false;
            for (FileObject prelfo : preloaders) {
                File prelf = FileUtil.toFile((FileObject)prelfo);
                if (prelf == null || !prelf.equals(f)) continue;
                isPrel = true;
            }
            if (isPrel || bc != null && bcDir.equals(f)) continue;
            resFileList.add(f);
            if (!JFXProjectProperties.isTrue(eval.getProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, f.getName())))) continue;
            lazyFileList.add(f);
        }
        this.lazyJars = lazyFileList;
        this.runtimeCP = resFileList;
        this.lazyJarsChanged = false;
    }

    private void storeResources(EditableProperties props) {
        if (this.lazyJarsChanged) {
            props.remove((Object)DOWNLOAD_MODE_LAZY_JARS);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(DOWNLOAD_MODE_LAZY_JAR)) continue;
                it.remove();
            }
            for (File file : this.lazyJars) {
                props.setProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, file.getName()), "true");
            }
        }
    }

    private void initJSCallbacks(PropertyEvaluator eval) {
        String platformName = eval.getProperty("platform.active");
        Map<String, List<String>> callbacks = JFXProjectUtils.getJSCallbacks(platformName);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : callbacks.entrySet()) {
            String v = eval.getProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey());
            if (v == null || v.isEmpty()) continue;
            result.put(entry.getKey(), v);
        }
        this.jsCallbacks = result;
        this.jsCallbacksChanged = false;
    }

    private void storeJSCallbacks(EditableProperties props) {
        if (this.jsCallbacksChanged && this.jsCallbacks != null) {
            for (Map.Entry<String, String> entry : this.jsCallbacks.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    props.setProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey(), entry.getValue());
                    continue;
                }
                props.remove((Object)(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey()));
            }
        }
    }

    private void storePlatform(EditableProperties editableProps) {
        JavaPlatform[] installedPlatforms;
        String activePlatform = editableProps.getProperty("platform.active");
        for (JavaPlatform javaPlatform : installedPlatforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String platformName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!JFXProjectProperties.isEqual(platformName, activePlatform) || !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)javaPlatform)) continue;
            editableProps.setProperty("javafx.sdk", JavaFXPlatformUtils.getJavaFXSDKPathReference((String)activePlatform));
            editableProps.setProperty("javafx.runtime", JavaFXPlatformUtils.getJavaFXRuntimePathReference((String)activePlatform));
        }
    }

    static void logProps(EditableProperties ep) {
        LOG.log(Level.INFO, "javafx.preloader.enabled = " + (ep.get((Object)PRELOADER_ENABLED) == null ? "null" : ep.get((Object)PRELOADER_ENABLED)));
        LOG.log(Level.INFO, "javafx.preloader.type = " + (ep.get((Object)PRELOADER_TYPE) == null ? "null" : ep.get((Object)PRELOADER_TYPE)));
        LOG.log(Level.INFO, "javafx.preloader.project.path = " + (ep.get((Object)PRELOADER_PROJECT) == null ? "null" : ep.get((Object)PRELOADER_PROJECT)));
        LOG.log(Level.INFO, "javafx.preloader.class = " + (ep.get((Object)PRELOADER_CLASS) == null ? "null" : ep.get((Object)PRELOADER_CLASS)));
        LOG.log(Level.INFO, "javafx.preloader.jar.filename = " + (ep.get((Object)PRELOADER_JAR_FILENAME) == null ? "null" : ep.get((Object)PRELOADER_JAR_FILENAME)));
        LOG.log(Level.INFO, "javafx.preloader.jar.path = " + (ep.get((Object)PRELOADER_JAR_PATH) == null ? "null" : ep.get((Object)PRELOADER_JAR_PATH)));
    }

    public class JFXConfigs {
        private Map<String, Map<String, String>> RUN_CONFIGS;
        private Set<String> ERASED_CONFIGS;
        private Map<String, List<Map<String, String>>> APP_PARAMS;
        private BoundedPropertyGroups groups = new BoundedPropertyGroups();
        private String active;
        private List<String> PROJECT_PROPERTIES = Arrays.asList("main.class", "javafx.main.class", "run.jvmargs", "javafx.preloader.enabled", "javafx.preloader.type", "javafx.preloader.project.path", "javafx.preloader.jar.path", "javafx.preloader.jar.filename", "javafx.preloader.class", "work.dir", "javafx.run.width", "javafx.run.height", "javafx.run.htmltemplate", "javafx.run.inbrowser", "javafx.run.inbrowser.path", "javafx.run.as");
        private List<String> PRIVATE_PROPERTIES = Arrays.asList("work.dir", "javafx.run.htmltemplate", "javafx.run.inbrowser", "javafx.run.inbrowser.path", "javafx.run.as");
        private List<String> STATIC_PROPERTIES = Arrays.asList("javafx.run.as");
        private String PRELOADER_GROUP_NAME = "preloader";
        private List<String> PRELOADER_PROPERTIES = Arrays.asList("javafx.preloader.enabled", "javafx.preloader.type", "javafx.preloader.project.path", "javafx.preloader.jar.path", "javafx.preloader.jar.filename", "javafx.preloader.class");
        private String BROWSER_GROUP_NAME = "browser";
        private List<String> BROWSER_PROPERTIES = Arrays.asList("javafx.run.inbrowser", "javafx.run.inbrowser.path");

        private Comparator<String> getComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
                }
            };
        }

        public final List<String> getPreloaderProperties() {
            return Collections.unmodifiableList(this.PRELOADER_PROPERTIES);
        }

        public final List<String> getBrowserProperties() {
            return Collections.unmodifiableList(this.BROWSER_PROPERTIES);
        }

        JFXConfigs() {
            this.reset();
            this.defineGroup(this.PRELOADER_GROUP_NAME, this.getPreloaderProperties());
            this.defineGroup(this.BROWSER_GROUP_NAME, this.getBrowserProperties());
        }

        private void reset() {
            this.RUN_CONFIGS = new TreeMap<String, Map<String, String>>(this.getComparator());
            this.ERASED_CONFIGS = null;
            this.APP_PARAMS = new TreeMap<String, List<Map<String, String>>>(this.getComparator());
        }

        private boolean configNameWrong(String config) {
            return config != null && config.contains("default");
        }

        public final void defineGroup(String groupName, Collection<String> props) {
            this.groups.defineGroup(groupName, props);
        }

        public final void clearGroup(String groupName) {
            this.groups.clearGroup(groupName);
        }

        public final void clearAllGroups() {
            this.groups.clearAllGroups();
        }

        public boolean isBound(String prop) {
            return this.groups.isBound(prop);
        }

        public Collection<String> getBoundedProperties(String prop) {
            return this.groups.getBoundedProperties(prop);
        }

        public String getActive() {
            return this.active;
        }

        public void setActive(String config) {
            assert (!this.configNameWrong(config));
            this.active = config;
        }

        public boolean hasConfig(String config) {
            assert (!this.configNameWrong(config));
            return this.RUN_CONFIGS.containsKey(config);
        }

        public boolean isConfigEmpty(String config) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap != null) {
                return configMap.isEmpty();
            }
            return true;
        }

        public boolean isDefaultConfigEmpty() {
            return this.isConfigEmpty(null);
        }

        public boolean isActiveConfigEmpty() {
            return this.isConfigEmpty(this.getActive());
        }

        public Set<String> getConfigNames() {
            return Collections.unmodifiableSet(this.RUN_CONFIGS.keySet());
        }

        private Map<String, String> getConfigUnmodifyable(String config) {
            assert (!this.configNameWrong(config));
            return Collections.unmodifiableMap(this.RUN_CONFIGS.get(config));
        }

        private Map<String, String> getDefaultConfigUnmodifyable() {
            return this.getConfigUnmodifyable(null);
        }

        private Map<String, String> getActiveConfigUnmodifyable() {
            return this.getConfigUnmodifyable(this.getActive());
        }

        private Map<String, String> getConfig(String config) {
            assert (!this.configNameWrong(config));
            return this.RUN_CONFIGS.get(config);
        }

        private Map<String, String> getDefaultConfig() {
            return this.getConfig(null);
        }

        private Map<String, String> getActiveConfig() {
            return this.getConfig(this.getActive());
        }

        private Map<String, String> getConfigNonNull(String config) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap == null) {
                configMap = new TreeMap<String, String>(this.getComparator());
                this.RUN_CONFIGS.put(config, configMap);
            }
            return configMap;
        }

        private Map<String, String> getDefaultConfigNonNull() {
            return this.getConfigNonNull(null);
        }

        private Map<String, String> getActiveConfigNonNull() {
            return this.getConfigNonNull(this.getActive());
        }

        public void addToConfig(String config, Map<String, String> props) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap == null) {
                configMap = new TreeMap<String, String>(this.getComparator());
                this.RUN_CONFIGS.put(config, configMap);
            }
            configMap.putAll(props);
        }

        public void addToDefaultConfig(Map<String, String> props) {
            this.addToConfig(null, props);
        }

        public void addToActiveConfig(Map<String, String> props) {
            this.addToConfig(this.getActive(), props);
        }

        public void addToConfig(String config, EditableProperties props) {
            assert (!this.configNameWrong(config));
            this.addToConfig(config, new HashMap<String, String>((Map<String, String>)props));
        }

        public void addToDefaultConfig(EditableProperties props) {
            this.addToConfig(null, props);
        }

        public void addToActiveConfig(EditableProperties props) {
            this.addToConfig(this.getActive(), props);
        }

        public void eraseConfig(String config) {
            assert (!this.configNameWrong(config));
            assert (config != null);
            this.RUN_CONFIGS.remove(config);
            if (this.ERASED_CONFIGS == null) {
                this.ERASED_CONFIGS = new HashSet<String>();
            }
            this.ERASED_CONFIGS.add(config);
        }

        public boolean isPropertySet(String config, @NonNull String prop) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap != null) {
                return configMap.containsKey(prop);
            }
            return false;
        }

        public boolean isDefaultPropertySet(@NonNull String prop) {
            return this.isPropertySet(null, prop);
        }

        public boolean isActivePropertySet(@NonNull String prop) {
            return this.isPropertySet(this.getActive(), prop);
        }

        private boolean isBoundedToNonemptyProperty(String config, String prop) {
            assert (!this.configNameWrong(config));
            for (String name : this.groups.getBoundedProperties(prop)) {
                if (!this.isPropertySet(config, name)) continue;
                return true;
            }
            return false;
        }

        public String getProperty(String config, @NonNull String prop) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap != null) {
                return configMap.get(prop);
            }
            return null;
        }

        public String getDefaultProperty(@NonNull String prop) {
            return this.getProperty(null, prop);
        }

        public String getActiveProperty(@NonNull String prop) {
            return this.getProperty(this.getActive(), prop);
        }

        public String getPropertyTransparent(String config, @NonNull String prop) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            String value = null;
            if (configMap != null && (value = configMap.get(prop)) == null && config != null) {
                return this.getDefaultProperty(prop);
            }
            return value;
        }

        public String getActivePropertyTransparent(@NonNull String prop) {
            return this.getPropertyTransparent(this.getActive(), prop);
        }

        public void setProperty(String config, @NonNull String prop, String value) {
            this.setPropertyImpl(config, prop, value);
            this.solidifyBoundedGroups(config, prop);
            if (config == null) {
                for (String c : this.getConfigNames()) {
                    if (c == null || !JFXProjectProperties.isEqual(this.getProperty(c, prop), value) || this.STATIC_PROPERTIES.contains(prop) || !this.isBoundedPropertiesEraseable(c, prop)) continue;
                    this.eraseProperty(c, prop);
                }
            }
        }

        private void setPropertyImpl(String config, @NonNull String prop, String value) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfigNonNull(config);
            configMap.put(prop, value);
        }

        public void setDefaultProperty(@NonNull String prop, String value) {
            this.setProperty(null, prop, value);
        }

        public void setActiveProperty(@NonNull String prop, String value) {
            this.setProperty(this.getActive(), prop, value);
        }

        public void setPropertyTransparent(String config, @NonNull String prop, String value) {
            assert (!this.configNameWrong(config));
            if (config != null && JFXProjectProperties.isEqual(this.getDefaultProperty(prop), value) && (!this.STATIC_PROPERTIES.contains(prop) || !this.isPropertySet(config, prop)) && this.isBoundedPropertiesEraseable(config, prop)) {
                this.eraseProperty(config, prop);
            } else {
                this.setProperty(config, prop, value);
            }
        }

        public void setActivePropertyTransparent(@NonNull String prop, String value) {
            this.setPropertyTransparent(this.getActive(), prop, value);
        }

        public boolean solidifyProperty(String config, @NonNull String prop) {
            if (!this.isPropertySet(config, prop)) {
                if (config != null) {
                    this.setPropertyImpl(config, prop, this.getDefaultProperty(prop));
                } else {
                    this.setPropertyImpl(null, prop, "");
                }
                return true;
            }
            return false;
        }

        private boolean solidifyBoundedGroups(String config, @NonNull String prop) {
            boolean solidified = false;
            for (String name : this.groups.getBoundedProperties(prop)) {
                solidified |= this.solidifyProperty(config, name);
            }
            return solidified;
        }

        public void eraseProperty(String config, @NonNull String prop) {
            assert (!this.configNameWrong(config));
            Map<String, String> configMap = this.getConfig(config);
            if (configMap != null) {
                configMap.remove(prop);
                for (String name : this.groups.getBoundedProperties(prop)) {
                    configMap.remove(name);
                }
            }
        }

        public void eraseDefaultProperty(@NonNull String prop) {
            this.eraseProperty(null, prop);
        }

        public void eraseActiveProperty(@NonNull String prop) {
            this.eraseProperty(this.getActive(), prop);
        }

        private boolean isBoundedPropertiesEraseable(String config, String prop) {
            assert (!this.configNameWrong(config));
            if (config == null) {
                return false;
            }
            boolean canErase = true;
            for (String name : this.groups.getBoundedProperties(prop)) {
                if ((!this.isPropertySet(config, name) || JFXProjectProperties.isEqual(this.getDefaultProperty(name), this.getProperty(config, name))) && !this.STATIC_PROPERTIES.contains(name)) continue;
                canErase = false;
                break;
            }
            return canErase;
        }

        public boolean hasParam(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            return this.getParam(config, name) != null;
        }

        public boolean hasDefaultParam(@NonNull String name) {
            return this.hasParam(null, name);
        }

        public boolean hasActiveParam(@NonNull String name) {
            return this.hasParam(this.getActive(), name);
        }

        public boolean hasParamTransparent(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            return this.getParamTransparent(config, name) != null;
        }

        public boolean hasActiveParamTransparent(@NonNull String name) {
            return this.hasParamTransparent(this.getActive(), name);
        }

        public boolean hasParam(String config, @NonNull String name, @NonNull String value) {
            assert (!this.configNameWrong(config));
            String v = this.getParamValue(config, name);
            return JFXProjectProperties.isEqual(v, value);
        }

        public boolean hasDefaultParam(@NonNull String name, @NonNull String value) {
            return this.hasParam(null, name, value);
        }

        public boolean hasActiveParam(@NonNull String name, @NonNull String value) {
            return this.hasParam(this.getActive(), name, value);
        }

        public boolean hasParamTransparent(String config, @NonNull String name, @NonNull String value) {
            assert (!this.configNameWrong(config));
            String v = this.getParamValueTransparent(config, name);
            return JFXProjectProperties.isEqual(v, value);
        }

        public boolean hasParamValue(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            Map<String, String> param = this.getParam(config, name);
            return param != null && param.containsKey(APP_PARAM_SUFFIXES[1]);
        }

        public boolean hasDefaultParamValue(@NonNull String name) {
            return this.hasParamValue(null, name);
        }

        public boolean hasActiveParamValue(@NonNull String name) {
            return this.hasParamValue(this.getActive(), name);
        }

        public boolean hasParamValueTransparent(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            return config != null && this.hasParamValue(config, name) || this.hasDefaultParamValue(name);
        }

        public boolean hasActiveParamValueTransparent(@NonNull String name) {
            return this.hasParamValueTransparent(this.getActive(), name);
        }

        public Map<String, String> getParam(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            return this.getParam(this.getParams(config), name);
        }

        public Map<String, String> getDefaultParam(@NonNull String name) {
            return this.getParam((String)null, name);
        }

        public Map<String, String> getActiveParam(@NonNull String name) {
            return this.getParam(this.getActive(), name);
        }

        public Map<String, String> getParamTransparent(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            Map<String, String> param = this.getParam(config, name);
            if (param == null) {
                param = this.getDefaultParam(name);
            }
            return param;
        }

        public Map<String, String> getActiveParamTransparent(@NonNull String name) {
            return this.getParamTransparent(this.getActive(), name);
        }

        public String getParamValue(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            Map<String, String> param = this.getParam(config, name);
            if (param != null) {
                return param.get(APP_PARAM_SUFFIXES[1]);
            }
            return null;
        }

        public String getDefaultParamValue(@NonNull String name) {
            return this.getParamValue(null, name);
        }

        public String getActiveParamValue(@NonNull String name) {
            return this.getParamValue(this.getActive(), name);
        }

        public String getParamValueTransparent(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            Map<String, String> param = this.getParam(config, name);
            if (param != null) {
                return param.get(APP_PARAM_SUFFIXES[1]);
            }
            return this.getDefaultParamValue(name);
        }

        public String getActiveParamValueTransparent(@NonNull String name) {
            return this.getParamValueTransparent(this.getActive(), name);
        }

        private List<Map<String, String>> getParams(String config) {
            assert (!this.configNameWrong(config));
            return this.APP_PARAMS.get(config);
        }

        private List<Map<String, String>> getDefaultParams() {
            return this.APP_PARAMS.get(null);
        }

        private List<Map<String, String>> getActiveParams() {
            return this.APP_PARAMS.get(this.getActive());
        }

        private List<Map<String, String>> getParamsTransparent(String config) {
            assert (!this.configNameWrong(config));
            List<Map<String, String>> union = JFXProjectUtils.copyList(this.getDefaultParams());
            if (config != null && this.getParams(config) != null) {
                for (Map<String, String> map : this.getParams(config)) {
                    String name = map.get(APP_PARAM_SUFFIXES[0]);
                    String value = map.get(APP_PARAM_SUFFIXES[1]);
                    if (name == null || name.isEmpty()) continue;
                    Map<String, String> old = this.getParam(union, name);
                    if (old != null) {
                        old.put(APP_PARAM_SUFFIXES[0], name);
                        old.put(APP_PARAM_SUFFIXES[1], value);
                        continue;
                    }
                    union.add(map);
                }
            }
            return union;
        }

        public List<Map<String, String>> getActiveParamsTransparent() {
            return this.getParamsTransparent(this.getActive());
        }

        public String getParamsTransparentAsString(String config, boolean commandLine) {
            assert (!this.configNameWrong(config));
            return this.getParamsAsString(this.getParamsTransparent(config), commandLine);
        }

        public String getActiveParamsTransparentAsString(boolean commandLine) {
            return this.getParamsAsString(this.getActiveParamsTransparent(), commandLine);
        }

        public String getParamsAsString(String config, boolean commandLine) {
            return this.getParamsAsString(this.getParams(config), commandLine);
        }

        public String getActiveParamsAsString(boolean commandLine) {
            return this.getParamsAsString(this.getActiveParams(), commandLine);
        }

        public String getDefaultParamsAsString(boolean commandLine) {
            return this.getParamsAsString(this.getDefaultParams(), commandLine);
        }

        private String getParamsAsString(List<Map<String, String>> params, boolean commandLine) {
            StringBuilder sb = new StringBuilder();
            if (params != null) {
                int index = 0;
                for (Map<String, String> m : params) {
                    String name = m.get(APP_PARAM_SUFFIXES[0]);
                    String value = m.get(APP_PARAM_SUFFIXES[1]);
                    if (name == null || name.length() <= 0) continue;
                    if (sb.length() > 0) {
                        if (!commandLine) {
                            sb.append(",");
                        }
                        sb.append(" ");
                    }
                    if (value != null && value.length() > 0) {
                        if (commandLine) {
                            sb.append("--");
                        }
                        sb.append(name);
                        sb.append("=");
                        sb.append(value);
                    } else {
                        sb.append(name);
                    }
                    ++index;
                }
            }
            return sb.toString();
        }

        private Map<String, String> createParam(@NonNull String name) {
            TreeMap<String, String> param = new TreeMap<String, String>(this.getComparator());
            param.put(APP_PARAM_SUFFIXES[0], name);
            return param;
        }

        private Map<String, String> createParam(@NonNull String name, String value) {
            TreeMap<String, String> param = new TreeMap<String, String>(this.getComparator());
            param.put(APP_PARAM_SUFFIXES[0], name);
            param.put(APP_PARAM_SUFFIXES[1], value);
            return param;
        }

        public void addParam(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            List<Map<String, String>> params = this.getParams(config);
            if (params == null) {
                params = new ArrayList<Map<String, String>>();
                this.APP_PARAMS.put(config, params);
            } else {
                this.eraseParam(params, name);
            }
            params.add(this.createParam(name));
        }

        public void addDefaultParam(@NonNull String name) {
            this.addParam(null, name);
        }

        public void addActiveParam(@NonNull String name) {
            this.addParam(this.getActive(), name);
        }

        public void addParamTransparent(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            if (config == null) {
                this.addDefaultParam(name);
            } else if (this.hasDefaultParam(name) && !this.hasDefaultParamValue(name)) {
                this.eraseParam(config, name);
            } else {
                this.addParam(config, name);
            }
        }

        public void addActiveParamTransparent(@NonNull String name) {
            this.addParamTransparent(this.getActive(), name);
        }

        public void addParam(String config, @NonNull String name, String value) {
            assert (!this.configNameWrong(config));
            List<Map<String, String>> params = this.getParams(config);
            if (params == null) {
                params = new ArrayList<Map<String, String>>();
                this.APP_PARAMS.put(config, params);
            } else {
                this.eraseParam(params, name);
            }
            params.add(this.createParam(name, value));
        }

        public void addDefaultParam(@NonNull String name, String value) {
            this.addParam(null, name, value);
        }

        public void addActiveParam(@NonNull String name, String value) {
            this.addParam(this.getActive(), name, value);
        }

        public void addParamTransparent(String config, @NonNull String name, String value) {
            assert (!this.configNameWrong(config));
            if (config == null) {
                this.addDefaultParam(name, value);
            } else if (this.hasDefaultParam(name, value)) {
                this.eraseParam(config, name);
            } else {
                this.addParam(config, name, value);
            }
        }

        public void addActiveParamTransparent(@NonNull String name, String value) {
            this.addParamTransparent(this.getActive(), name, value);
        }

        public void setParamsTransparent(String config, List<Map<String, String>> params) {
            assert (!this.configNameWrong(config));
            if (config == null) {
                this.APP_PARAMS.put(null, params);
            } else {
                ArrayList<Map<String, String>> reduct = new ArrayList<Map<String, String>>();
                List<Map<String, String>> def = JFXProjectUtils.copyList(this.getDefaultParams());
                if (params != null) {
                    for (Map<String, String> map : params) {
                        String name = map.get(APP_PARAM_SUFFIXES[0]);
                        String value = map.get(APP_PARAM_SUFFIXES[1]);
                        Map<String, String> old = this.getDefaultParam(name);
                        if (old != null) {
                            String oldValue = old.get(APP_PARAM_SUFFIXES[1]);
                            if (!JFXProjectProperties.isEqual(value, oldValue)) {
                                reduct.add(JFXProjectUtils.copyMap(old));
                            }
                            def.remove(old);
                            continue;
                        }
                        reduct.add(JFXProjectUtils.copyMap(map));
                    }
                    for (Map<String, String> map : def) {
                        map.put(APP_PARAM_SUFFIXES[1], "");
                        reduct.add(JFXProjectUtils.copyMap(map));
                    }
                }
                this.APP_PARAMS.put(config, reduct);
            }
        }

        public void setActiveParamsTransparent(List<Map<String, String>> params) {
            this.setParamsTransparent(this.getActive(), params);
        }

        public void eraseParam(String config, @NonNull String name) {
            assert (!this.configNameWrong(config));
            this.eraseParam(this.getParams(config), name);
        }

        public void eraseDefaultParam(@NonNull String name) {
            this.eraseParam((String)null, name);
        }

        public void eraseActiveParam(@NonNull String name) {
            this.eraseParam(this.getActive(), name);
        }

        public void eraseParams(String config) {
            assert (!this.configNameWrong(config));
            this.APP_PARAMS.remove(config);
        }

        public void eraseDefaultParams() {
            this.eraseParams(null);
        }

        public void eraseActiveParams() {
            this.eraseParams(this.getActive());
        }

        private Map<String, String> getParam(List<Map<String, String>> params, String paramName) {
            if (params != null) {
                for (Map<String, String> map : params) {
                    String name = map.get(APP_PARAM_SUFFIXES[0]);
                    if (name == null || !name.equals(paramName)) continue;
                    return map;
                }
            }
            return null;
        }

        private void eraseParam(List<Map<String, String>> params, String paramName) {
            if (params != null) {
                Map<String, String> toErase = null;
                for (Map<String, String> map : params) {
                    String name = map.get(APP_PARAM_SUFFIXES[0]);
                    if (name == null || !name.equals(paramName)) continue;
                    toErase = map;
                    break;
                }
                if (toErase != null) {
                    params.remove(toErase);
                }
            }
        }

        public void read() {
            this.reset();
            this.readDefaultConfig("nbproject/project.properties");
            this.readDefaultConfig("nbproject/private/private.properties");
            this.addDefaultsIfMissing();
            this.readNonDefaultConfigs(JFXProjectProperties.PROJECT_CONFIGS_DIR, true);
            this.readNonDefaultConfigs(JFXProjectProperties.PROJECT_PRIVATE_CONFIGS_DIR, false);
        }

        private void readDefaultConfig(String propsFile) {
            EditableProperties ep = null;
            try {
                ep = JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, propsFile);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (ep != null) {
                for (String prop : this.PROJECT_PROPERTIES) {
                    String v = ep.getProperty(prop);
                    if (v == null) continue;
                    this.setDefaultProperty(prop, v);
                }
            }
            this.extractDefaultParams(ep);
        }

        private void addDefaultsIfMissing() {
            if (!this.isDefaultPropertySet(JFXProjectProperties.RUN_APP_WIDTH)) {
                this.setDefaultProperty(JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.DEFAULT_APP_WIDTH);
            }
            if (!this.isDefaultPropertySet(JFXProjectProperties.RUN_APP_HEIGHT)) {
                this.setDefaultProperty(JFXProjectProperties.RUN_APP_HEIGHT, JFXProjectProperties.DEFAULT_APP_HEIGHT);
            }
        }

        private void readNonDefaultConfigs(String subDir, boolean createIfNotExists) {
            FileObject configsFO = JFXProjectProperties.this.project.getProjectDirectory().getFileObject(subDir);
            if (configsFO != null) {
                for (FileObject kid : configsFO.getChildren()) {
                    Map<String, String> c;
                    if (!kid.hasExt(JFXProjectProperties.PROPERTIES_FILE_EXT) || (c = this.getConfig(kid.getName())) == null && !createIfNotExists) continue;
                    EditableProperties cep = null;
                    try {
                        cep = JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, FileUtil.getRelativePath((FileObject)JFXProjectProperties.this.project.getProjectDirectory(), (FileObject)kid));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    this.addToConfig(kid.getName(), cep);
                    this.extractParams(cep, kid.getName());
                }
            }
        }

        private void extractParams(@NonNull EditableProperties ep, String config) {
            if (ep != null) {
                for (String prop : ep.keySet()) {
                    String name;
                    if (!prop.startsWith(JFXProjectProperties.APP_PARAM_PREFIX) || !prop.endsWith(APP_PARAM_SUFFIXES[0]) || (name = ep.getProperty(prop)) == null) continue;
                    String propV = prop.replace(APP_PARAM_SUFFIXES[0], APP_PARAM_SUFFIXES[1]);
                    String value = ep.getProperty(propV);
                    if (value != null) {
                        this.addParam(config, name, value);
                        continue;
                    }
                    this.addParam(config, name);
                }
            }
        }

        private void extractDefaultParams(@NonNull EditableProperties ep) {
            this.extractParams(ep, null);
        }

        private void extractActiveParams(@NonNull EditableProperties ep) {
            this.extractParams(ep, this.getActive());
        }

        public void readActive() {
            try {
                this.setActive(JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, JFXProjectProperties.CONFIG_PROPERTIES_FILE).getProperty("config"));
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Failed to read active configuration from {0}.", JFXProjectProperties.CONFIG_PROPERTIES_FILE);
            }
        }

        public void storeActive() throws IOException {
            String configPath = JFXProjectProperties.CONFIG_PROPERTIES_FILE;
            if (this.active == null) {
                try {
                    JFXProjectProperties.deleteFile(JFXProjectProperties.this.project, configPath);
                }
                catch (IOException ex) {}
            } else {
                EditableProperties configProps = JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, configPath);
                configProps.setProperty("config", this.active);
                JFXProjectProperties.saveToFile(JFXProjectProperties.this.project, configPath, configProps);
            }
        }

        public void store(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
            for (String name : this.PROJECT_PROPERTIES) {
                String string = this.getDefaultProperty(name);
                this.updateProperty(name, string, projectProperties, privateProperties, this.isBoundedToNonemptyProperty(null, name));
            }
            ArrayList<String> paramNamesUsed = new ArrayList<String>();
            this.updateDefaultParamProperties(projectProperties, privateProperties, paramNamesUsed);
            this.storeDefaultParamsAsCommandLine(privateProperties);
            for (Map.Entry<String, Map<String, String>> entry : this.RUN_CONFIGS.entrySet()) {
                String config = entry.getKey();
                if (config == null) continue;
                String sharedPath = JFXProjectProperties.getSharedConfigFilePath(config);
                String privatePath = JFXProjectProperties.getPrivateConfigFilePath(config);
                Map<String, String> configProps = entry.getValue();
                if (configProps == null) {
                    try {
                        JFXProjectProperties.deleteFile(JFXProjectProperties.this.project, sharedPath);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                    }
                    try {
                        JFXProjectProperties.deleteFile(JFXProjectProperties.this.project, privatePath);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                    }
                    continue;
                }
                EditableProperties sharedCfgProps = JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, sharedPath);
                EditableProperties privateCfgProps = JFXProjectProperties.readFromFile(JFXProjectProperties.this.project, privatePath);
                boolean privatePropsChanged = false;
                for (Map.Entry<String, String> prop : configProps.entrySet()) {
                    String name = prop.getKey();
                    String value = prop.getValue();
                    String defaultValue = this.getDefaultProperty(name);
                    boolean storeIfEmpty = defaultValue != null && defaultValue.length() > 0 || this.isBoundedToNonemptyProperty(config, name);
                    privatePropsChanged |= this.updateProperty(name, value, sharedCfgProps, privateCfgProps, storeIfEmpty);
                }
                this.cleanPropertiesIfEmpty(new String[]{JFXProjectProperties.MAIN_CLASS, JFXProjectProperties.RUN_JVM_ARGS, JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS, JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.RUN_APP_HEIGHT}, config, sharedCfgProps);
                privatePropsChanged |= this.cleanPropertiesIfEmpty(new String[]{JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH}, config, privateCfgProps);
                privatePropsChanged |= this.updateParamProperties(config, sharedCfgProps, privateCfgProps, paramNamesUsed);
                JFXProjectProperties.saveToFile(JFXProjectProperties.this.project, sharedPath, sharedCfgProps);
                if (!(privatePropsChanged |= this.storeParamsAsCommandLine(config, privateCfgProps))) continue;
                JFXProjectProperties.saveToFile(JFXProjectProperties.this.project, privatePath, privateCfgProps);
            }
            if (this.ERASED_CONFIGS != null) {
                for (String string : this.ERASED_CONFIGS) {
                    if (this.RUN_CONFIGS.containsKey(string)) continue;
                    String sharedPath = JFXProjectProperties.getSharedConfigFilePath(string);
                    String privatePath = JFXProjectProperties.getPrivateConfigFilePath(string);
                    try {
                        JFXProjectProperties.deleteFile(JFXProjectProperties.this.project, sharedPath);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                    }
                    try {
                        JFXProjectProperties.deleteFile(JFXProjectProperties.this.project, privatePath);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                    }
                }
            }
        }

        private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, boolean storeEmpty) {
            EditableProperties ep;
            boolean changePrivate = this.PRIVATE_PROPERTIES.contains(name) || privateProperties.containsKey((Object)name);
            EditableProperties editableProperties = ep = changePrivate ? privateProperties : projectProperties;
            if (changePrivate) {
                projectProperties.remove((Object)name);
            }
            if (!Utilities.compareObjects((Object)value, (Object)ep.getProperty(name))) {
                if (value != null && (value.length() > 0 || storeEmpty)) {
                    ep.setProperty(name, value);
                } else {
                    ep.remove((Object)name);
                }
                return changePrivate;
            }
            return false;
        }

        private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties) {
            return this.updateProperty(name, value, projectProperties, privateProperties, false);
        }

        private boolean cleanPropertyIfEmpty(@NonNull String name, String config, @NonNull EditableProperties ep) {
            if (!this.isPropertySet(config, name)) {
                ep.remove((Object)name);
                return true;
            }
            return false;
        }

        private boolean cleanPropertiesIfEmpty(@NonNull String[] names, String config, @NonNull EditableProperties ep) {
            boolean updated = false;
            for (String name : names) {
                updated |= this.cleanPropertyIfEmpty(name, config, ep);
            }
            return updated;
        }

        private boolean isParamNameProperty(@NonNull String prop) {
            return prop != null && prop.startsWith(JFXProjectProperties.APP_PARAM_PREFIX) && prop.endsWith(APP_PARAM_SUFFIXES[0]);
        }

        private boolean isParamValueProperty(@NonNull String prop) {
            return prop != null && prop.startsWith(JFXProjectProperties.APP_PARAM_PREFIX) && prop.endsWith(APP_PARAM_SUFFIXES[1]);
        }

        private String getParamValueProperty(String paramNameProperty) {
            if (paramNameProperty != null && this.isParamNameProperty(paramNameProperty)) {
                return paramNameProperty.replace(APP_PARAM_SUFFIXES[0], APP_PARAM_SUFFIXES[1]);
            }
            return null;
        }

        private String getParamNameProperty(int index) {
            return JFXProjectProperties.APP_PARAM_PREFIX + index + "." + APP_PARAM_SUFFIXES[0];
        }

        private String getParamValueProperty(int index) {
            return JFXProjectProperties.APP_PARAM_PREFIX + index + "." + APP_PARAM_SUFFIXES[1];
        }

        private boolean isFreeParamPropertyIndex(int index, @NonNull EditableProperties ep) {
            return !ep.containsKey((Object)this.getParamNameProperty(index));
        }

        private int getFreeParamPropertyIndex(int start, @NonNull EditableProperties ep, @NonNull EditableProperties pep, List<String> paramNamesUsed) {
            int index;
            int n = index = start >= 0 ? start : 0;
            while (index >= 0 && (!this.isFreeParamPropertyIndex(index, ep) || !this.isFreeParamPropertyIndex(index, pep) || paramNamesUsed != null && paramNamesUsed.contains(this.getParamNameProperty(index)))) {
                ++index;
            }
            return index >= 0 ? index : 0;
        }

        private boolean updateParamProperties(String config, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, @NonNull List<String> paramNamesUsed) {
            assert (!this.configNameWrong(config));
            boolean privateUpdated = false;
            List<Map<String, String>> reduce = JFXProjectUtils.copyList(this.getParams(config));
            for (String prop : paramNamesUsed) {
                if (prop == null || prop.length() <= 0) continue;
                projectProperties.remove((Object)prop);
                projectProperties.remove((Object)this.getParamValueProperty(prop));
                privateProperties.remove((Object)prop);
                privateProperties.remove((Object)this.getParamValueProperty(prop));
            }
            this.cleanParamPropertiesIfEmpty(config, privateProperties);
            for (String prop : privateProperties.keySet()) {
                if (!this.isParamNameProperty(prop)) continue;
                paramNamesUsed.add(prop);
            }
            LinkedList<Map<String, String>> toEraseList = new LinkedList<Map<String, String>>();
            for (Map<String, String> map : reduce) {
                String value;
                String name = map.get(APP_PARAM_SUFFIXES[0]);
                if (!this.updateParamPropertyIfExists(name, value = map.get(APP_PARAM_SUFFIXES[1]), privateProperties, true)) continue;
                toEraseList.add(map);
                privateUpdated = true;
            }
            for (Map<String, String> toErase : toEraseList) {
                reduce.remove(toErase);
            }
            this.cleanParamPropertiesNotListed(reduce, projectProperties);
            for (String prop : projectProperties.keySet()) {
                if (!this.isParamNameProperty(prop)) continue;
                paramNamesUsed.add(prop);
            }
            int index = 0;
            for (Map<String, String> map : reduce) {
                String name = map.get(APP_PARAM_SUFFIXES[0]);
                String value = map.get(APP_PARAM_SUFFIXES[1]);
                if (name == null || name.length() <= 0 || this.updateParamPropertyIfExists(name, value, projectProperties, false)) continue;
                index = this.getFreeParamPropertyIndex(index, projectProperties, privateProperties, paramNamesUsed);
                this.exportParamProperty(map, this.getParamNameProperty(index), this.getParamValueProperty(index), projectProperties);
                paramNamesUsed.add(this.getParamNameProperty(index));
            }
            return privateUpdated;
        }

        private boolean updateDefaultParamProperties(@NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, List<String> paramNamesUsed) {
            return this.updateParamProperties(null, projectProperties, privateProperties, paramNamesUsed);
        }

        private boolean updateParamPropertyIfExists(@NonNull String name, String value, EditableProperties ep, boolean storeEmpty) {
            if (name != null && !name.isEmpty()) {
                for (String prop : ep.keySet()) {
                    if (!this.isParamNameProperty(prop) || !JFXProjectProperties.isEqual(name, ep.get((Object)prop))) continue;
                    String propVal = this.getParamValueProperty(prop);
                    if (value != null && (value.length() > 0 || storeEmpty)) {
                        ep.setProperty(propVal, value);
                    } else {
                        ep.remove((Object)propVal);
                    }
                    return true;
                }
            }
            return false;
        }

        private void cleanParamPropertiesIfEmpty(String config, EditableProperties ep) {
            assert (!this.configNameWrong(config));
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String prop : ep.keySet()) {
                String name;
                if (!this.isParamNameProperty(prop) || this.hasParam(config, name = ep.get((Object)prop))) continue;
                toRemove.add(prop);
            }
            for (String prop : toRemove) {
                ep.remove((Object)prop);
                ep.remove((Object)this.getParamValueProperty(prop));
            }
        }

        private void cleanParamPropertiesNotListed(List<Map<String, String>> props, EditableProperties ep) {
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String name : ep.keySet()) {
                if (!this.isParamNameProperty(name)) continue;
                boolean inProps = false;
                for (Map<String, String> map : props) {
                    String prop = map.get(APP_PARAM_SUFFIXES[0]);
                    if (!JFXProjectProperties.isEqual(name, prop)) continue;
                    inProps = true;
                    break;
                }
                if (inProps) continue;
                toRemove.add(name);
            }
            for (String prop : toRemove) {
                ep.remove((Object)prop);
                ep.remove((Object)this.getParamValueProperty(prop));
            }
        }

        private void exportParamProperty(@NonNull Map<String, String> param, String newPropName, String newPropValue, @NonNull EditableProperties ep) {
            String name = param.get(APP_PARAM_SUFFIXES[0]);
            String value = param.get(APP_PARAM_SUFFIXES[1]);
            if (name != null) {
                ep.put(newPropName, name);
                if (value != null && value.length() > 0) {
                    ep.put(newPropValue, value);
                }
            }
        }

        private boolean storeParamsAsCommandLine(String config, EditableProperties projectProperties) {
            assert (!this.configNameWrong(config));
            String params = this.getParamsTransparentAsString(config, true);
            if (config != null && JFXProjectProperties.isEqual(params, this.getDefaultParamsAsString(true))) {
                params = null;
            }
            if (!Utilities.compareObjects((Object)params, (Object)projectProperties.getProperty(JFXProjectProperties.APPLICATION_ARGS))) {
                if (params != null && params.length() > 0) {
                    projectProperties.setProperty(JFXProjectProperties.APPLICATION_ARGS, params);
                    projectProperties.setComment(JFXProjectProperties.APPLICATION_ARGS, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_app_args")}, false);
                } else {
                    projectProperties.remove((Object)JFXProjectProperties.APPLICATION_ARGS);
                }
                return true;
            }
            return false;
        }

        private boolean storeDefaultParamsAsCommandLine(EditableProperties projectProperties) {
            return this.storeParamsAsCommandLine(null, projectProperties);
        }

        private class BoundedPropertyGroups {
            Map<String, Set<String>> groups = new HashMap<String, Set<String>>();

            private BoundedPropertyGroups() {
            }

            public void defineGroup(String groupName, Collection<String> props) {
                HashSet<String> group = new HashSet<String>();
                group.addAll(props);
                this.groups.put(groupName, group);
            }

            public void clearGroup(String groupName) {
                this.groups.remove(groupName);
            }

            public void clearAllGroups() {
                this.groups.clear();
            }

            public boolean isBound(String prop) {
                for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                    Set<String> group = entry.getValue();
                    if (group == null || !group.contains(prop) || group.size() <= 1) continue;
                    return true;
                }
                return false;
            }

            public Collection<String> getBoundedProperties(String prop) {
                HashSet<String> bounded = new HashSet<String>();
                for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                    Set<String> group = entry.getValue();
                    if (group == null || !group.contains(prop)) continue;
                    bounded.addAll(group);
                }
                bounded.remove(prop);
                return bounded;
            }
        }
    }

    abstract class PreloaderArtifact {
        private boolean valid;

        PreloaderArtifact() {
        }

        abstract boolean addDependency() throws IOException, UnsupportedOperationException;

        abstract boolean removeDependency() throws IOException, UnsupportedOperationException;

        abstract FileObject[] getFileObjects();

        void setValid(boolean valid) {
            this.valid = valid;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    public class PreloaderClassComboBoxModel
    extends DefaultComboBoxModel {
        private boolean filling = false;
        private ChangeListener changeListener = null;

        public PreloaderClassComboBoxModel() {
            this.fillNoPreloaderAvailable();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeListener = l;
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeListener = null;
        }

        public final void fillNoPreloaderAvailable() {
            this.removeAllElements();
            this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
        }

        public void fillFromProject(final Project project, final String select, final JFXConfigs configs, final String activeConfig) {
            final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(project);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (project == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Preloader");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        public void fillFromJAR(final FileObject jarFile, final String select, final JFXConfigs configs, final String activeConfig) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (jarFile == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNamesInJar(jarFile, "javafx.application.Preloader");
                        appClassNames.remove("com.javafx.main.Main");
                        appClassNames.remove("com.javafx.main.NoJavaFXFallback");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        private void addElements(Set<String> elems) {
            for (String elem : elems) {
                this.addElement(elem);
            }
        }
    }

    class PreloaderJarArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final URL[] classPathRoots;
        private final FileObject[] fileObjects;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderJarArtifact(@NonNull URL[] classPathRoots, @NonNull FileObject[] fileObjects, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.classPathRoots = classPathRoots;
            this.fileObjects = fileObjects;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderJarArtifact)) {
                return false;
            }
            PreloaderJarArtifact concrete = (PreloaderJarArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            return this.fileObjects;
        }
    }

    class PreloaderProjectArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final AntArtifact[] artifacts;
        private final URI[] artifactElements;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderProjectArtifact(@NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.artifacts = artifacts;
            this.artifactElements = artifactElements;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderProjectArtifact)) {
                return false;
            }
            PreloaderProjectArtifact concrete = (PreloaderProjectArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            ArrayList<FileObject> l = new ArrayList<FileObject>();
            for (AntArtifact a : this.artifacts) {
                l.addAll(Arrays.asList(a.getArtifactFiles()));
            }
            return l.toArray(new FileObject[l.size()]);
        }
    }

    public static enum PreloaderSourceType {
        NONE("none"),
        PROJECT("project"),
        JAR("jar");

        private final String propertyValue;

        private PreloaderSourceType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> props, String[] sfxs, String[] clmns) {
            if (sfxs.length != clmns.length) {
                throw new IllegalArgumentException();
            }
            this.properties = props;
            this.propSuffixes = sfxs;
            this.columnNames = clmns;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.properties.get(rowIndex).put(this.propSuffixes[columnIndex], (String)aValue);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.properties.get(rowIndex).get(this.propSuffixes[columnIndex]);
        }

        public void addRow() {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            for (String suffix : this.propSuffixes) {
                emptyMap.put(suffix, "");
            }
            this.properties.add(emptyMap);
        }

        public void removeRow(int index) {
            this.properties.remove(index);
        }
    }

    public static enum RunAsType {
        STANDALONE("standalone", DEFAULT_CONFIG_STANDALONE),
        ASWEBSTART("webstart", DEFAULT_CONFIG_WEBSTART),
        INBROWSER("embedded", DEFAULT_CONFIG_BROWSER);

        private final String propertyValue;
        private final String defaultConfig;

        private RunAsType(String propertyValue, String defaultConfig) {
            this.propertyValue = propertyValue;
            this.defaultConfig = defaultConfig;
        }

        public String getString() {
            return this.propertyValue;
        }

        public String getDefaultConfig() {
            return this.defaultConfig;
        }
    }

    public static enum SigningType {
        NOSIGN("notsigned"),
        SELF("self"),
        KEY("key");

        private final String propertyValue;

        private SigningType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }
}

