/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectGenerator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class JFXProjectOpenedHook
extends ProjectOpenedHook {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private final Project prj;
    private final J2SEPropertyEvaluator eval;
    private ProjectConfigurationProvider<?> pcp;
    private ConfigChangeListener chl = null;

    public JFXProjectOpenedHook(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
    }

    protected synchronized void projectOpened() {
        if (JFXProjectProperties.isTrue(this.eval.evaluator().getProperty("javafx.enabled"))) {
            Runnable runUpdateJFXImpl;
            JFXProjectGenerator.logUsage(JFXProjectGenerator.Action.OPEN);
            Preferences prefs = ProjectUtils.getPreferences((Project)this.prj, Project.class, (boolean)false);
            prefs.put("issue214819_fx_enabled", "true");
            this.pcp = (ProjectConfigurationProvider)this.prj.getLookup().lookup(ProjectConfigurationProvider.class);
            assert (this.pcp != null);
            LOGGER.log(Level.INFO, "FX PCP: " + this.pcp.toString());
            this.chl = new ConfigChangeListener(this.prj);
            this.pcp.addPropertyChangeListener((PropertyChangeListener)this.chl);
            Runnable runCreateJFXPlatform = this.missingJFXPlatform() ? new Runnable(){

                @Override
                public void run() {
                    JFXProjectOpenedHook.this.createJFXPlatform();
                }
            } : null;
            Runnable runnable = runUpdateJFXImpl = this.isEnabledJFXUpdate() ? new Runnable(){

                @Override
                public void run() {
                    block7: {
                        JFXProjectOpenedHook.this.updateDefaultConfigs();
                        FileObject readmeFO = JFXProjectOpenedHook.this.updateJfxImpl();
                        if (readmeFO != null && JFXProjectOpenedHook.this.isEnabledJFXUpdateNotification()) {
                            try {
                                DataObject dobj = DataObject.find((FileObject)readmeFO);
                                EditCookie ec = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                                OpenCookie oc = (OpenCookie)dobj.getLookup().lookup(OpenCookie.class);
                                if (ec != null) {
                                    ec.edit();
                                } else if (oc != null) {
                                    oc.open();
                                } else {
                                    LOGGER.log(Level.INFO, "No EditCookie nor OpenCookie for {0}", dobj);
                                }
                            }
                            catch (DataObjectNotFoundException donf) {
                                if ($assertionsDisabled) break block7;
                                throw new AssertionError((Object)("DataObject must exist for " + readmeFO));
                            }
                        }
                    }
                }
            } : null;
            if (runCreateJFXPlatform != null && runUpdateJFXImpl != null) {
                this.switchBusy();
                ProjectInformation info = ProjectUtils.getInformation((Project)this.prj);
                String projName = info != null ? info.getName() : null;
                RequestProcessor RP = new RequestProcessor(JFXProjectOpenedHook.class.getName() + projName, 2);
                RequestProcessor.Task taskPlatforms = RP.post(runCreateJFXPlatform);
                RequestProcessor.Task taskJfxImpl = RP.post(runUpdateJFXImpl);
                if (taskPlatforms != null) {
                    taskPlatforms.waitFinished();
                }
                if (taskJfxImpl != null) {
                    taskJfxImpl.waitFinished();
                }
                this.switchDefault();
            } else {
                if (runCreateJFXPlatform != null) {
                    this.switchBusy();
                    runCreateJFXPlatform.run();
                    this.switchDefault();
                }
                if (runUpdateJFXImpl != null) {
                    this.switchBusy();
                    runUpdateJFXImpl.run();
                    this.switchDefault();
                }
            }
        }
    }

    protected void projectClosed() {
        if (JFXProjectProperties.isTrue(this.eval.evaluator().getProperty("javafx.enabled"))) {
            JFXProjectGenerator.logUsage(JFXProjectGenerator.Action.CLOSE);
            assert (this.pcp != null);
            if (this.chl != null) {
                this.pcp.removePropertyChangeListener((PropertyChangeListener)this.chl);
                this.chl = null;
            }
        }
    }

    private boolean missingJFXPlatform() {
        return !JavaFXPlatformUtils.isThereAnyJavaFXPlatform();
    }

    private void createJFXPlatform() {
        try {
            JavaFXPlatformUtils.createDefaultJavaFXPlatform();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
        }
    }

    private boolean isEnabledJFXUpdate() {
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            return !JFXProjectProperties.isTrue(evaluator.getProperty("javafx.disable.autoupdate"));
        }
        LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update.");
        return false;
    }

    private boolean isEnabledJFXUpdateNotification() {
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            return !JFXProjectProperties.isTrue(evaluator.getProperty("javafx.disable.autoupdate.notification"));
        }
        LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update notification.");
        return false;
    }

    private FileObject updateJfxImpl() {
        FileObject readmeFO = null;
        try {
            readmeFO = JFXProjectUtils.updateJfxImpl(this.prj);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't update JavaFX specific build script jfx-impl.xml: {0}", ex);
        }
        return readmeFO;
    }

    private boolean updateDefaultConfigs() {
        boolean updated = false;
        PropertyEvaluator evaluator = this.eval.evaluator();
        if (evaluator != null) {
            try {
                updated |= JFXProjectUtils.updateDefaultRunAsConfigFile(this.prj.getProjectDirectory(), JFXProjectProperties.RunAsType.ASWEBSTART, false);
                updated |= JFXProjectUtils.updateDefaultRunAsConfigFile(this.prj.getProjectDirectory(), JFXProjectProperties.RunAsType.INBROWSER, !JFXProjectProperties.isNonEmpty(evaluator.getProperty("javafx.run.inbrowser")) || !JFXProjectProperties.isNonEmpty(evaluator.getProperty("javafx.run.inbrowser.path")));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't update JavaFX specific RunAs configuration files: {0}", ex);
            }
        } else {
            LOGGER.log(Level.WARNING, "PropertyEvaluator instantiation failed, disabling jfx-impl.xml auto-update.");
        }
        return updated;
    }

    private void switchBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    private void switchDefault() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private static final class ConfigChangeListener
    implements PropertyChangeListener {
        private final Project prj;

        public ConfigChangeListener(Project p) {
            this.prj = p;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("activeConfiguration")) {
                LOGGER.log(Level.FINE, "FX config change: " + evt.toString());
                Lookup look = this.prj.getLookup();
                JFXProjectProperties props = JFXProjectProperties.getInstanceIfExists(look);
                if (props == null || props.hasPreloaderInAnyConfig()) {
                    JFXProjectProperties.cleanup(look);
                    props = JFXProjectProperties.getInstance(look);
                    props.updatePreloaderDependencies();
                }
            }
        }
    }
}

