/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JFXActionProvider
implements ActionProvider {
    private final Project prj;
    private static final Map<String, String> ACTIONS = new HashMap<String, String>(){
        {
            this.put("run", "run");
            this.put("debug", "debug");
            this.put("profile", "profile");
        }
    };

    public JFXActionProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.prj = project;
    }

    @NonNull
    public String[] getSupportedActions() {
        return ACTIONS.keySet().toArray(new String[ACTIONS.size()]);
    }

    public void invokeAction(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        if (command != null) {
            if (JFXProjectUtils.isFXPreloaderProject(this.prj)) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JFXActionProvider.class, (String)"WARN_PreloaderExecutionUnsupported", (Object)ProjectUtils.getInformation((Project)this.prj).getDisplayName()), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            FileObject buildFo = this.findBuildXml();
            assert (buildFo != null && buildFo.isValid());
            String runAs = JFXProjectUtils.getFXProjectRunAs(this.prj);
            if (runAs == null) {
                runAs = JFXProjectProperties.RunAsType.STANDALONE.getString();
            }
            final ActionProgress listener = ActionProgress.start((Lookup)context);
            try {
                String target = runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.STANDALONE.getString()) ? "jfxsa-".concat(command) : (runAs.equalsIgnoreCase(JFXProjectProperties.RunAsType.ASWEBSTART.getString()) ? "jfxws-".concat(command) : "jfxbe-".concat(command));
                Properties props = new Properties();
                this.collectStartupExtenderArgs(props, command, context);
                ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)props).addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        listener.finished(((ExecutorTask)task).result() == 0);
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                listener.finished(false);
            }
        } else {
            throw new IllegalArgumentException(command);
        }
    }

    public boolean isActionEnabled(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        if (!JFXProjectUtils.isFXProject(this.prj)) {
            return false;
        }
        if (this.findBuildXml() == null) {
            return false;
        }
        return JFXActionProvider.findTarget(command) != null;
    }

    @NonNull
    private static String getBuildXmlName(@NonNull PropertyEvaluator evaluator) {
        String buildScriptPath = evaluator.getProperty("buildfile");
        if (buildScriptPath == null) {
            buildScriptPath = "build.xml";
        }
        return buildScriptPath;
    }

    @CheckForNull
    private FileObject findBuildXml() {
        J2SEPropertyEvaluator ep = (J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class);
        assert (ep != null);
        return this.prj.getProjectDirectory().getFileObject(JFXActionProvider.getBuildXmlName(ep.evaluator()));
    }

    @CheckForNull
    private static String findTarget(@NonNull String command) {
        return ACTIONS.get(command);
    }

    private void collectStartupExtenderArgs(Map<? super String, ? super String> p, String command, Lookup context) {
        StringBuilder b = new StringBuilder();
        for (String arg : this.runJvmargsIde(command, context)) {
            b.append(' ').append(arg);
        }
        if (b.length() > 0) {
            p.put("run.jvmargs.ide", b.toString());
        }
    }

    private List<String> runJvmargsIde(String command, Lookup context) {
        StartupExtender.StartMode mode;
        if (command.equals("run") || command.equals("run.single")) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if (command.equals("debug") || command.equals("debug.single") || command.equals("debug.stepinto")) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if (command.equals("profile") || command.equals("profile.single")) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if (command.equals("test") || command.equals("test.single")) {
            mode = StartupExtender.StartMode.TEST_NORMAL;
        } else if (command.equals("debug.test.single")) {
            mode = StartupExtender.StartMode.TEST_DEBUG;
        } else if (command.equals("profile.test.single")) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return Collections.emptyList();
        }
        ArrayList<String> args = new ArrayList<String>();
        for (StartupExtender group : StartupExtender.getExtenders((Lookup)context, (StartupExtender.StartMode)mode)) {
            args.addAll(group.getArguments());
        }
        return args;
    }
}

