/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.FXMLTemplateWizardIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ConfigureFXMLControllerPanelVisual
extends JPanel
implements DocumentListener {
    private Panel observer;
    private File[] srcRoots;
    private File rootFolder;
    private FileObject targetFolder;
    private String fxmlName;
    private ButtonGroup buttonGroup1;
    private JButton chooseButton;
    private JCheckBox controllerCheckBox;
    private JRadioButton createNewRadioButton;
    private JLabel createdNameLabel;
    private JTextField createdNameTextField;
    private JLabel existingNameLabel;
    private JTextField existingNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private Box.Filler filler1;
    private JRadioButton useExistingRadioButton;

    private ConfigureFXMLControllerPanelVisual(Panel observer) {
        this.observer = observer;
        this.setName(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_ControllerNameAndLoc"));
        this.initComponents();
        this.initComponents2();
    }

    private void fireChange() {
        this.observer.fireChangeEvent();
    }

    private void initComponents2() {
        this.createdNameTextField.getDocument().addDocumentListener(this);
        this.existingNameTextField.getDocument().addDocumentListener(this);
    }

    public void initValues(FileObject template, FileObject targetFolder, String fxmlName, File[] srcRoots, File rootFolder) {
        String displayName;
        if (template == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Template_Error"));
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Target_Error"));
        }
        if (srcRoots == null || srcRoots.length < 1) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_SGs_Error"));
        }
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.targetFolder = targetFolder;
        this.fxmlName = fxmlName;
        this.srcRoots = srcRoots;
        this.rootFolder = rootFolder;
        this.updateText();
        this.updateResult();
    }

    boolean isControllerEnabled() {
        return this.controllerCheckBox.isSelected();
    }

    String getNewControllerName() {
        String text = this.createdNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    String getExistingControllerName() {
        String text = this.existingNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    FileObject getTargetFolder() {
        return this.targetFolder;
    }

    FileObject getSourceRootFolder() {
        if (this.srcRoots != null && this.srcRoots[0] != null && this.srcRoots[0].exists()) {
            return FileUtil.toFileObject((File)this.srcRoots[0]);
        }
        return null;
    }

    String getNewControllerFXMLName() {
        String text = this.getNewControllerName();
        if (text != null) {
            String rel;
            FileObject targetFO = this.getTargetFolder();
            FileObject rootFO = this.getSourceRootFolder();
            if (targetFO != null && rootFO != null && (rel = FileUtil.getRelativePath((FileObject)rootFO, (FileObject)targetFO)) != null) {
                rel = rel.replace("\\", ".");
                return (rel = rel.replace("/", ".")).length() > 0 ? rel + "." + text : text;
            }
            return text;
        }
        return null;
    }

    private void radioButtonsStateChanged() {
        if (!this.controllerCheckBox.isSelected()) {
            return;
        }
        this.createdNameLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdNameTextField.setEnabled(this.createNewRadioButton.isSelected());
        this.existingNameLabel.setEnabled(!this.createNewRadioButton.isSelected());
        this.existingNameTextField.setEnabled(!this.createNewRadioButton.isSelected());
        this.chooseButton.setEnabled(!this.createNewRadioButton.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.controllerCheckBox = new JCheckBox();
        this.createdNameLabel = new JLabel();
        this.createdNameTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.createNewRadioButton = new JRadioButton();
        this.useExistingRadioButton = new JRadioButton();
        this.existingNameLabel = new JLabel();
        this.existingNameTextField = new JTextField();
        this.chooseButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(500, 340));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.controllerCheckBox, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.controllerCheckBox.text"));
        this.controllerCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.controllerCheckBoxItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.controllerCheckBox, gridBagConstraints);
        this.controllerCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.controllerCheckBox.AccessibleContext.accessibleDescription"));
        this.createdNameLabel.setLabelFor(this.createdNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdNameLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdNameLabel.text"));
        this.createdNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.createdNameLabel, gridBagConstraints);
        this.createdNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdNameLabel.AccessibleContext.accessibleDescription"));
        this.createdNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.createdNameTextField, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.resultLabel.text"));
        this.fileLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(25, 15, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.fileLabel.AccessibleContext.accessibleDescription"));
        this.fileTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.buttonGroup1.add(this.createNewRadioButton);
        this.createNewRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createNewRadioButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createNewRadioButton.text"));
        this.createNewRadioButton.setEnabled(false);
        this.createNewRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.createNewRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.createNewRadioButton, gridBagConstraints);
        this.createNewRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createNewRadioButton.AccessibleContext.accessibleDescription"));
        this.buttonGroup1.add(this.useExistingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.useExistingRadioButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.useExistingRadioButton.text"));
        this.useExistingRadioButton.setEnabled(false);
        this.useExistingRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.useExistingRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.useExistingRadioButton, gridBagConstraints);
        this.useExistingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.useExistingRadioButton.AccessibleContext.accessibleDescription"));
        this.existingNameLabel.setLabelFor(this.existingNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.existingNameLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.existingNameLabel.text"));
        this.existingNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.existingNameLabel, gridBagConstraints);
        this.existingNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.existingNameLabel.AccessibleContext.accessibleDescription"));
        this.existingNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.existingNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.chooseButton.text"));
        this.chooseButton.setEnabled(false);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.chooseButton, gridBagConstraints);
        this.chooseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.chooseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void controllerCheckBoxItemStateChanged(ItemEvent evt) {
        this.createNewRadioButton.setEnabled(this.controllerCheckBox.isSelected());
        if (this.createNewRadioButton.isSelected()) {
            this.createdNameLabel.setEnabled(this.controllerCheckBox.isSelected());
            this.createdNameTextField.setEnabled(this.controllerCheckBox.isSelected());
        }
        this.useExistingRadioButton.setEnabled(this.controllerCheckBox.isSelected());
        if (this.useExistingRadioButton.isSelected()) {
            this.existingNameLabel.setEnabled(this.controllerCheckBox.isSelected());
            this.existingNameTextField.setEnabled(this.controllerCheckBox.isSelected());
            this.chooseButton.setEnabled(this.controllerCheckBox.isSelected());
        }
        this.fileLabel.setEnabled(this.controllerCheckBox.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new FXMLTemplateWizardIterator.SrcFileSystemView(this.srcRoots));
        chooser.setDialogTitle(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"LBL_ConfigureFXMLPanel_FileChooser_Select_Controller"));
        chooser.setFileFilter(FXMLTemplateWizardIterator.FXMLTemplateFileFilter.createJavaFilter());
        String existingPath = this.existingNameTextField.getText();
        if (existingPath.length() > 0) {
            File f = new File(this.rootFolder.getPath() + File.pathSeparator + existingPath);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            } else {
                chooser.setCurrentDirectory(this.rootFolder);
            }
        } else {
            chooser.setCurrentDirectory(this.rootFolder);
        }
        if (0 == chooser.showOpenDialog(this)) {
            String controllerClass = FileUtil.normalizeFile((File)chooser.getSelectedFile()).getPath();
            String srcPath = FileUtil.normalizeFile((File)this.srcRoots[0]).getPath();
            String relativePath = controllerClass.substring(srcPath.length() + 1);
            String relativePathWithoutExt = relativePath.substring(0, relativePath.indexOf(".java"));
            this.existingNameTextField.setText(relativePathWithoutExt.replace(File.separatorChar, '.'));
        }
    }

    private void createNewRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    private void useExistingRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateResult();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updateText() {
        String controllerName = this.getNewControllerName();
        if (controllerName == null) {
            controllerName = this.fxmlName;
            String firstChar = String.valueOf(controllerName.charAt(0)).toUpperCase();
            String otherChars = controllerName.substring(1);
            controllerName = firstChar + otherChars + NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_FileNameControllerPostfix");
            this.createdNameTextField.setText(controllerName);
        }
    }

    private void updateResult() {
        String controllerName;
        String string = controllerName = this.shouldCreateController() ? this.getNewControllerName() : this.getExistingControllerName();
        if (controllerName == null) {
            this.fileTextField.setText(null);
            return;
        }
        if (this.shouldCreateController()) {
            String file = FileUtil.getFileDisplayName((FileObject)FileUtil.toFileObject((File)this.rootFolder)) + File.separator + controllerName + ".java";
            this.fileTextField.setText(file);
        } else {
            this.fileTextField.setText(this.getPathForExistingController(controllerName));
        }
    }

    private String getPathForExistingController(String controllerName) {
        assert (controllerName != null);
        return FileUtil.normalizeFile((File)this.srcRoots[0]).getPath() + File.separatorChar + controllerName.replace('.', File.separatorChar) + ".java";
    }

    String isControllerValid() {
        if (this.createNewRadioButton.isSelected()) {
            if (!Utilities.isJavaIdentifier((String)this.getNewControllerName())) {
                return NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_Java_Name");
            }
            return FXMLTemplateWizardIterator.canUseFileName(this.rootFolder, this.getNewControllerName());
        }
        if (this.existingNameTextField.getText().isEmpty()) {
            return NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_Java_Name");
        }
        return FXMLTemplateWizardIterator.fileExist(this.getPathForExistingController(this.getExistingControllerName()));
    }

    boolean shouldCreateController() {
        return this.controllerCheckBox.isSelected() && this.createNewRadioButton.isSelected();
    }

    static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private ConfigureFXMLControllerPanelVisual component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private WizardDescriptor settings;

        public Panel() {
            this.component = new ConfigureFXMLControllerPanelVisual(this);
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            String fxmlName = Templates.getTargetName((WizardDescriptor)settings);
            File[] srcRoots = (File[])settings.getProperty("srcRootFolder");
            File rootFolder = (File)settings.getProperty("rootFolder");
            this.component.initValues(Templates.getTemplate((WizardDescriptor)settings), Templates.getTargetFolder((WizardDescriptor)settings), fxmlName, srcRoots, rootFolder);
            Object substitute = this.component.getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                settings.putProperty("NewFileWizard_Title", substitute);
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            Object value = settings.getValue();
            if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
                return;
            }
            if (this.isValid()) {
                settings.putProperty("javaControllerCreate", (Object)this.component.shouldCreateController());
                settings.putProperty("javaController", this.component.shouldCreateController() ? this.component.getNewControllerName() : null);
                settings.putProperty("javaControllerFull", (Object)(this.component.shouldCreateController() ? this.component.getNewControllerFXMLName() : this.component.getExistingControllerName()));
            }
            settings.putProperty("NewFileWizard_Title", null);
        }

        public boolean isValid() {
            if (this.component.isControllerEnabled()) {
                String errorMessage = this.component.isControllerValid();
                this.settings.getNotificationLineSupport().setErrorMessage(errorMessage);
                return errorMessage == null;
            }
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

