/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.ajp;

import com.sun.grizzly.http.ajp.AjpConstants;
import com.sun.grizzly.http.ajp.AjpHttpRequest;
import com.sun.grizzly.http.ajp.AjpHttpResponse;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.CharChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.HttpMessages;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;

final class AjpMessageUtils {
    private static final int BODY_CHUNK_HEADER_SIZE = 7;
    private static final int MAX_BODY_CHUNK_CONTENT_SIZE = 8179;
    private static final byte[] EMPTY_ARRAY = new byte[0];

    AjpMessageUtils() {
    }

    public static int decodeForwardRequest(byte[] buffer, int pos, boolean tomcatAuthentication, AjpHttpRequest request) {
        boolean isSSL;
        byte methodCode;
        if ((methodCode = buffer[pos++]) != -1) {
            String mName = AjpConstants.methodTransArray[methodCode - 1];
            request.method().setString(mName);
        }
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, request.protocol());
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, request.requestURI());
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, request.remoteAddr());
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, request.remoteHost());
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, request.localName());
        request.setLocalPort(AjpMessageUtils.getShort(buffer, pos));
        pos += 2;
        boolean bl = isSSL = buffer[pos++] != 0;
        if (isSSL) {
            request.scheme().setString("https");
        }
        pos = AjpMessageUtils.decodeHeaders(request, buffer, pos);
        pos = AjpMessageUtils.decodeAttributes(buffer, pos, request, tomcatAuthentication);
        request.unparsedURI().setString(request.requestURI() + (request.queryString().getLength() != 0 ? "?" + request.queryString() : ""));
        return pos;
    }

    private static int decodeAttributes(byte[] requestContent, int pos, AjpHttpRequest req, boolean tomcatAuthentication) {
        MessageBytes tmpMessageBytes = req.tmpMessageBytes;
        boolean moreAttr = true;
        while (moreAttr) {
            byte attributeCode;
            if ((attributeCode = requestContent[pos++]) == -1) {
                return pos;
            }
            if (attributeCode == 11) {
                req.setAttribute("javax.servlet.request.key_size", AjpMessageUtils.getShort(requestContent, pos));
                pos += 2;
            }
            if (attributeCode == 10) {
                pos = AjpMessageUtils.setStringAttribute(req, requestContent, pos);
            }
            switch (attributeCode) {
                case 1: {
                    pos = AjpMessageUtils.skipBytes(requestContent, pos);
                    break;
                }
                case 2: {
                    pos = AjpMessageUtils.skipBytes(requestContent, pos);
                    break;
                }
                case 3: {
                    if (tomcatAuthentication) {
                        pos = AjpMessageUtils.skipBytes(requestContent, pos);
                        break;
                    }
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.getRemoteUser());
                    break;
                }
                case 4: {
                    if (tomcatAuthentication) {
                        pos = AjpMessageUtils.skipBytes(requestContent, pos);
                        break;
                    }
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.getAuthType());
                    break;
                }
                case 5: {
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.queryString());
                    break;
                }
                case 6: {
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.instanceId());
                    break;
                }
                case 7: {
                    req.scheme().setString("https");
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.sslCert());
                    break;
                }
                case 8: {
                    req.scheme().setString("https");
                    pos = AjpMessageUtils.setStringAttributeValue(req, "javax.servlet.request.cipher_suite", requestContent, pos);
                    break;
                }
                case 9: {
                    req.scheme().setString("https");
                    pos = AjpMessageUtils.setStringAttributeValue(req, "javax.servlet.request.ssl_session_id", requestContent, pos);
                    break;
                }
                case 12: {
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, tmpMessageBytes);
                    req.setSecret(tmpMessageBytes.toString());
                    tmpMessageBytes.recycle();
                    break;
                }
                case 13: {
                    pos = AjpMessageUtils.getBytesToByteChunk(requestContent, pos, req.method());
                    break;
                }
            }
        }
        return pos;
    }

    public static String getString(ByteBuffer buffer) {
        int length = AjpMessageUtils.getShort(buffer);
        String s = new String(buffer.array(), buffer.position(), length);
        AjpMessageUtils.advance(buffer, length + 1);
        return s;
    }

    public static int decodeHeaders(Request req, byte[] buf, int pos) {
        MimeHeaders headers = req.getMimeHeaders();
        int hCount = AjpMessageUtils.getShort(buf, pos);
        pos += 2;
        for (int i = 0; i < hCount; ++i) {
            MessageBytes valueDC;
            int isc = AjpMessageUtils.getShort(buf, pos);
            int hId = isc & 0xFF;
            pos += 2;
            if (40960 == (isc &= 0xFF00)) {
                String hName = AjpConstants.headerTransArray[hId - 1];
                valueDC = headers.addValue(hName);
            } else {
                hId = -1;
                int length = AjpMessageUtils.getShort(buf, pos -= 2);
                valueDC = headers.addValue(buf, pos += 2, length);
                pos += length + 1;
            }
            pos = AjpMessageUtils.getBytesToByteChunk(buf, pos, valueDC);
            MessageBytes headerNameDC = headers.getName(headers.size() - 1);
            if (hId == 8 || hId == -1 && headerNameDC.equalsIgnoreCase("Content-Length")) {
                ByteChunk bc = valueDC.getByteChunk();
                long cl = Ascii.parseLong((byte[])bc.getBytes(), (int)bc.getStart(), (int)(bc.getEnd() - bc.getStart()));
                if (cl >= Integer.MAX_VALUE) continue;
                req.setContentLength((int)cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !headerNameDC.equalsIgnoreCase("Content-Type"))) continue;
            req.setContentType(valueDC.toString());
        }
        return pos;
    }

    static int getBytesToByteChunk(byte[] buffer, int pos, MessageBytes bytes) {
        int length = AjpMessageUtils.getShort(buffer, pos);
        pos += 2;
        if (length != 65535) {
            bytes.setBytes(buffer, pos, length);
            pos += length + 1;
        }
        return pos;
    }

    private static void advance(ByteBuffer buffer, int length) {
        buffer.position(buffer.position() + length);
    }

    private static int setStringAttribute(AjpHttpRequest req, byte[] buffer, int offset) {
        MessageBytes tmpMessageBytes = req.tmpMessageBytes;
        offset = AjpMessageUtils.getBytesToByteChunk(buffer, offset, tmpMessageBytes);
        String key = tmpMessageBytes.toString();
        tmpMessageBytes.recycle();
        offset = AjpMessageUtils.getBytesToByteChunk(buffer, offset, tmpMessageBytes);
        String value = tmpMessageBytes.toString();
        tmpMessageBytes.recycle();
        req.setAttribute(key, value);
        return offset;
    }

    private static int setStringAttributeValue(AjpHttpRequest req, String key, byte[] buffer, int pos) {
        MessageBytes tmpMessageBytes = req.tmpMessageBytes;
        pos = AjpMessageUtils.getBytesToByteChunk(buffer, pos, tmpMessageBytes);
        String value = tmpMessageBytes.toString();
        tmpMessageBytes.recycle();
        req.setAttribute(key, value);
        return pos;
    }

    public static ByteChunk encodeHeaders(AjpHttpResponse response) {
        try {
            long contentLength;
            String contentLanguage;
            ByteChunk headerBuffer = response.tmpHeaderByteChunk;
            int start = headerBuffer.getStart();
            headerBuffer.setEnd(start + 4);
            headerBuffer.append((byte)4);
            AjpMessageUtils.putShort(headerBuffer, (short)response.getStatus());
            String message = null;
            if (response.isAllowCustomReasonPhrase()) {
                message = response.getMessage();
            }
            if (message == null) {
                message = HttpMessages.getMessage((int)response.getStatus());
            }
            AjpMessageUtils.putBytes(headerBuffer, message);
            MimeHeaders headers = response.getMimeHeaders();
            String contentType = response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
            if ((contentLength = (long)response.getContentLength()) >= 0L) {
                headers.setValue("Content-Length").setLong(contentLength);
            }
            int numHeaders = headers.size();
            AjpMessageUtils.putShort(headerBuffer, (short)numHeaders);
            for (int i = 0; i < numHeaders; ++i) {
                AjpMessageUtils.putBytes(headerBuffer, headers.getName(i));
                AjpMessageUtils.putBytes(headerBuffer, headers.getValue(i));
            }
            byte[] headerBytes = headerBuffer.getBuffer();
            headerBytes[start] = 65;
            headerBytes[start + 1] = 66;
            AjpMessageUtils.putShort(headerBytes, start + 2, (short)(headerBuffer.getLength() - 4));
            return headerBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    private static int skipBytes(byte[] buffer, int pos) {
        int length = AjpMessageUtils.getShort(buffer, pos);
        pos += 2;
        if (!AjpMessageUtils.isNullLength(length)) {
            pos += length;
        }
        return ++pos;
    }

    static int getShort(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    static int getShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + (b[off + 0] << 8)) & 0xFFFF;
    }

    static int getInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off + 0] << 24);
    }

    public static void putShort(ByteChunk chunk, short value) throws IOException {
        chunk.append((byte)(value >> 8));
        chunk.append((byte)(value & 0xFF));
    }

    public static void putShort(byte[] b, int off, short value) {
        b[off] = (byte)(value >> 8);
        b[off + 1] = (byte)(value & 0xFF);
    }

    private static void putBytes(ByteChunk dstBuffer, MessageBytes mb) throws IOException {
        if (mb == null || mb.isNull()) {
            AjpMessageUtils.putBytes(dstBuffer, EMPTY_ARRAY);
            return;
        }
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            AjpMessageUtils.putBytes(dstBuffer, bc.getBytes(), bc.getStart(), bc.getLength());
        } else if (mb.getType() == 3) {
            CharChunk cc = mb.getCharChunk();
            AjpMessageUtils.putBytes(dstBuffer, cc);
        } else {
            AjpMessageUtils.putBytes(dstBuffer, mb.toString());
        }
    }

    private static void putBytes(ByteChunk dstBuffer, byte[] bytes) throws IOException {
        AjpMessageUtils.putBytes(dstBuffer, bytes, 0, bytes.length);
    }

    private static void putBytes(ByteChunk dstBuffer, byte[] bytes, int start, int length) throws IOException {
        dstBuffer.makeSpace(length + 3);
        byte[] dstArray = dstBuffer.getBuffer();
        int pos = dstBuffer.getEnd();
        AjpMessageUtils.putShort(dstArray, pos, (short)length);
        System.arraycopy(bytes, start, dstArray, pos += 2, length);
        pos += length;
        dstArray[pos++] = 0;
        dstBuffer.setEnd(pos);
    }

    private static void putBytes(ByteChunk dstBuffer, CharChunk cc) throws IOException {
        if (cc == null || cc.isNull()) {
            AjpMessageUtils.putBytes(dstBuffer, EMPTY_ARRAY);
            return;
        }
        int length = cc.getLength();
        dstBuffer.makeSpace(length + 3);
        byte[] dstArray = dstBuffer.getBuffer();
        int pos = dstBuffer.getEnd();
        AjpMessageUtils.putShort(dstArray, pos, (short)length);
        pos += 2;
        int start = cc.getStart();
        int end = cc.getEnd();
        char[] cbuf = cc.getBuffer();
        for (int i = start; i < end; ++i) {
            int c = cbuf[i];
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            dstArray[pos++] = (byte)c;
        }
        dstArray[pos++] = 0;
        dstBuffer.setEnd(pos);
    }

    private static void putBytes(ByteChunk dstBuffer, String s) throws IOException {
        if (s == null) {
            AjpMessageUtils.putBytes(dstBuffer, EMPTY_ARRAY);
            return;
        }
        int length = s.length();
        dstBuffer.makeSpace(length + 3);
        byte[] dstArray = dstBuffer.getBuffer();
        int pos = dstBuffer.getEnd();
        AjpMessageUtils.putShort(dstArray, pos, (short)length);
        pos += 2;
        for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            dstArray[pos++] = (byte)c;
        }
        dstArray[pos++] = 0;
        dstBuffer.setEnd(pos);
    }

    private static boolean isNullLength(int length) {
        return length == 65535 || length == -1;
    }

    public static byte[] createAjpPacket(byte type, byte[] payload) {
        int length = payload.length;
        byte[] ajpMessage = new byte[5 + length];
        ajpMessage[0] = 65;
        ajpMessage[1] = 66;
        AjpMessageUtils.putShort(ajpMessage, 2, (short)(length + 1));
        ajpMessage[4] = type;
        System.arraycopy(payload, 0, ajpMessage, 5, length);
        return ajpMessage;
    }

    public static byte[] toBytes(short size) {
        return new byte[]{(byte)(size >> 8), (byte)(size & 0xFF)};
    }
}

