/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.logger.SystemErrLogger;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.catalina.realm.JNDIRealm;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.UserDatabaseRealm;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.apache.catalina.valves.RequestDumperValve;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.tomcat5.CoyoteConnector;

public class MBeanFactory
extends BaseModelMBean {
    private static MBeanServer mserver = MBeanUtils.createServer();
    private static Registry registry = MBeanUtils.createRegistry();

    public String findObjectName(String type) {
        if (type.equals("org.apache.catalina.core.StandardContext")) {
            return "StandardContext";
        }
        if (type.equals("org.apache.catalina.core.StandardDefaultContext")) {
            return "DefaultContext";
        }
        if (type.equals("org.apache.catalina.core.StandardEngine")) {
            return "Engine";
        }
        if (type.equals("org.apache.catalina.core.StandardHost")) {
            return "Host";
        }
        return null;
    }

    private final String getPathStr(String t) {
        if (t == null || t.equals("/")) {
            return "";
        }
        return t;
    }

    private DefaultContext getDefaultContext(ObjectName pname) throws Exception {
        String type = pname.getKeyProperty("type");
        if (type.equals("DefaultContext")) {
            Service service = this.getService(pname);
            StandardEngine engine = (StandardEngine)service.getContainer();
            String hostName = pname.getKeyProperty("host");
            if (hostName != null) {
                StandardHost host = (StandardHost)engine.findChild(hostName);
                return host.getDefaultContext();
            }
            return engine.getDefaultContext();
        }
        return null;
    }

    private ContainerBase getParentContainerFromParent(ObjectName pname) throws Exception {
        String type = pname.getKeyProperty("type");
        String j2eeType = pname.getKeyProperty("j2eeType");
        Service service = this.getService(pname);
        StandardEngine engine = (StandardEngine)service.getContainer();
        if (j2eeType != null && j2eeType.equals("WebModule")) {
            String name = pname.getKeyProperty("name");
            name = name.substring(2);
            int i = name.indexOf("/");
            String hostName = name.substring(0, i);
            String path = name.substring(i);
            Host host = (Host)engine.findChild(hostName);
            String pathStr = this.getPathStr(path);
            StandardContext context = (StandardContext)host.findChild(pathStr);
            return context;
        }
        if (type != null) {
            if (type.equals("Engine")) {
                return engine;
            }
            if (type.equals("Host")) {
                String hostName = pname.getKeyProperty("host");
                StandardHost host = (StandardHost)engine.findChild(hostName);
                return host;
            }
        }
        return null;
    }

    private ContainerBase getParentContainerFromChild(ObjectName oname) throws Exception {
        String hostName = oname.getKeyProperty("host");
        String path = oname.getKeyProperty("path");
        Service service = this.getService(oname);
        StandardEngine engine = (StandardEngine)service.getContainer();
        if (hostName == null) {
            return engine;
        }
        if (path == null) {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            return host;
        }
        StandardHost host = (StandardHost)engine.findChild(hostName);
        path = this.getPathStr(path);
        StandardContext context = (StandardContext)host.findChild(path);
        return context;
    }

    private Service getService(ObjectName oname) throws Exception {
        String domain = oname.getDomain();
        Server server = ServerFactory.getServer();
        Service[] services = server.findServices();
        StandardService service = null;
        for (int i = 0; i < services.length && !domain.equals((service = (StandardService)services[i]).getObjectName().getDomain()); ++i) {
        }
        if (!service.getObjectName().getDomain().equals(domain)) {
            throw new Exception("Service with the domain is not found");
        }
        return service;
    }

    public String createAccessLoggerValve(String parent) throws Exception {
        ObjectName pname = new ObjectName(parent);
        AccessLogValve accessLogger = new AccessLogValve();
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.addValve(accessLogger);
        ObjectName oname = accessLogger.getObjectName();
        return oname.toString();
    }

    public String createAjpConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        try {
            Class<?> cls = Class.forName("org.apache.coyote.tomcat5.CoyoteConnector");
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            if (address != null && address.length() > 0) {
                partypes1[0] = str.getClass();
                Method meth1 = cls.getMethod("setAddress", partypes1);
                Object[] arglist1 = new Object[]{address};
                meth1.invoke(retobj, arglist1);
            }
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
            Class[] partypes3 = new Class[]{str.getClass()};
            Method meth3 = cls.getMethod("setProtocolHandlerClassName", partypes3);
            Object[] arglist3 = new Object[]{new String("org.apache.jk.server.JkCoyoteHandler")};
            meth3.invoke(retobj, arglist3);
            ObjectName pname = new ObjectName(parent);
            Service service = this.getService(pname);
            service.addConnector(retobj);
            Method getObjectName = cls.getMethod("getObjectName", null);
            ObjectName coname = MBeanUtils.createObjectName(pname.getDomain(), retobj);
            return coname.toString();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public String createDefaultContext(String parent) throws Exception {
        StandardDefaultContext context = new StandardDefaultContext();
        ObjectName pname = new ObjectName(parent);
        Service service = this.getService(pname);
        Engine engine = (Engine)service.getContainer();
        String hostName = pname.getKeyProperty("host");
        if (hostName == null) {
            context.setParent(engine);
            engine.addDefaultContext(context);
        } else {
            Host host = (Host)engine.findChild(hostName);
            context.setParent(host);
            host.addDefaultContext(context);
        }
        ManagedBean managed = registry.findManagedBean("DefaultContext");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), context);
        return oname.toString();
    }

    public String createFileLogger(String parent) throws Exception {
        FileLogger fileLogger = new FileLogger();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setLogger(fileLogger);
        ObjectName oname = fileLogger.getObjectName();
        return oname.toString();
    }

    public String createHttpConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        try {
            Class<?> cls = Class.forName("org.apache.coyote.tomcat5.CoyoteConnector");
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            if (address != null && address.length() > 0) {
                partypes1[0] = str.getClass();
                Method meth1 = cls.getMethod("setAddress", partypes1);
                Object[] arglist1 = new Object[]{address};
                meth1.invoke(retobj, arglist1);
            }
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
            ObjectName pname = new ObjectName(parent);
            Service service = this.getService(pname);
            service.addConnector(retobj);
            Method getObjectName = cls.getMethod("getObjectName", null);
            ObjectName coname = (ObjectName)getObjectName.invoke(retobj, null);
            return coname.toString();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public String createHttpsConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        Class<?> cls = Class.forName("org.apache.coyote.tomcat5.CoyoteConnector");
        try {
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            if (address != null && address.length() > 0) {
                partypes1[0] = str.getClass();
                Method meth1 = cls.getMethod("setAddress", partypes1);
                Object[] arglist1 = new Object[]{address};
                meth1.invoke(retobj, arglist1);
            }
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
            Class[] partypes3 = new Class[]{str.getClass()};
            Method meth3 = cls.getMethod("setScheme", partypes3);
            Object[] arglist3 = new Object[]{new String("https")};
            meth3.invoke(retobj, arglist3);
            Class[] partypes4 = new Class[]{Boolean.TYPE};
            Method meth4 = cls.getMethod("setSecure", partypes4);
            Object[] arglist4 = new Object[]{new Boolean(true)};
            meth4.invoke(retobj, arglist4);
            Class<?> serverSocketFactoryCls = Class.forName("org.apache.catalina.net.ServerSocketFactory");
            Class<?> coyoteServerSocketFactoryCls = Class.forName("org.apache.coyote.tomcat5.CoyoteServerSocketFactory");
            Constructor<?> factoryConst = coyoteServerSocketFactoryCls.getConstructor(null);
            Object factoryObj = factoryConst.newInstance(null);
            Class[] partypes5 = new Class[]{serverSocketFactoryCls};
            Method meth5 = cls.getMethod("setFactory", partypes5);
            Object[] arglist5 = new Object[]{factoryObj};
            meth5.invoke(retobj, arglist5);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        try {
            ObjectName pname = new ObjectName(parent);
            Service service = this.getService(pname);
            service.addConnector(retobj);
            Method getObjectName = cls.getMethod("getObjectName", null);
            ObjectName coname = MBeanUtils.createObjectName(pname.getDomain(), retobj);
            return coname.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String createJDBCRealm(String parent, String driverName, String connectionName, String connectionPassword, String connectionURL) throws Exception {
        JDBCRealm realm = new JDBCRealm();
        realm.setDriverName(driverName);
        realm.setConnectionName(connectionName);
        realm.setConnectionPassword(connectionPassword);
        realm.setConnectionURL(connectionURL);
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setRealm((Realm)realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createJNDIRealm(String parent) throws Exception {
        JNDIRealm realm = new JNDIRealm();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setRealm((Realm)realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createMemoryRealm(String parent) throws Exception {
        MemoryRealm realm = new MemoryRealm();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setRealm((Realm)realm);
        ObjectName oname = MBeanUtils.createObjectName(pname.getDomain(), (Realm)realm);
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createRemoteAddrValve(String parent) throws Exception {
        RemoteAddrValve valve = new RemoteAddrValve();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.addValve((Valve)valve);
        ObjectName oname = valve.getObjectName();
        return oname.toString();
    }

    public String createRemoteHostValve(String parent) throws Exception {
        RemoteHostValve valve = new RemoteHostValve();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.addValve((Valve)valve);
        ObjectName oname = valve.getObjectName();
        return oname.toString();
    }

    public String createRequestDumperValve(String parent) throws Exception {
        RequestDumperValve valve = new RequestDumperValve();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.addValve((Valve)valve);
        ObjectName oname = valve.getObjectName();
        return oname.toString();
    }

    public String createSingleSignOn(String parent) throws Exception {
        SingleSignOn valve = new SingleSignOn();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.addValve(valve);
        ObjectName oname = valve.getObjectName();
        return oname.toString();
    }

    public String createStandardContext(String parent, String path, String docBase) throws Exception {
        StandardContext context = new StandardContext();
        path = this.getPathStr(path);
        context.setPath(path);
        context.setDocBase(docBase);
        ContextConfig contextConfig = new ContextConfig();
        context.addLifecycleListener(contextConfig);
        ObjectName pname = new ObjectName(parent);
        Service service = this.getService(pname);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(pname.getKeyProperty("host"));
        host.addChild(context);
        ObjectName oname = MBeanUtils.createObjectName(pname.getDomain(), context);
        return oname.toString();
    }

    public Vector createStandardEngineService(String parent, String engineName, String defaultHost, String serviceName) throws Exception {
        StandardService service = new StandardService();
        service.setName(serviceName);
        StandardEngine engine = new StandardEngine();
        engine.setName(engineName);
        engine.setDefaultHost(defaultHost);
        service.setContainer(engine);
        Server server = ServerFactory.getServer();
        server.addService(service);
        Vector<ObjectName> onames = new Vector<ObjectName>();
        ObjectName oname = MBeanUtils.createObjectName(engineName, engine);
        onames.add(0, oname);
        oname = MBeanUtils.createObjectName(engineName, service);
        onames.add(1, oname);
        return onames;
    }

    public String createStandardHost(String parent, String name, String appBase, boolean autoDeploy, boolean deployXML, boolean liveDeploy, boolean unpackWARs, boolean xmlNamespaceAware, boolean xmlValidation) throws Exception {
        StandardHost host = new StandardHost();
        host.setName(name);
        host.setAppBase(appBase);
        host.setAutoDeploy(autoDeploy);
        host.setDeployXML(deployXML);
        host.setLiveDeploy(liveDeploy);
        host.setUnpackWARs(unpackWARs);
        host.setXmlNamespaceAware(xmlNamespaceAware);
        host.setXmlValidation(xmlValidation);
        HostConfig hostConfig = new HostConfig();
        host.addLifecycleListener(hostConfig);
        ObjectName pname = new ObjectName(parent);
        Service service = this.getService(pname);
        Engine engine = (Engine)service.getContainer();
        engine.addChild(host);
        return host.getObjectName().toString();
    }

    public String createStandardManager(String parent) throws Exception {
        ObjectName oname;
        StandardManager manager = new StandardManager();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        if (containerBase != null) {
            containerBase.setManager(manager);
        }
        if ((oname = manager.getObjectName()) != null) {
            return oname.toString();
        }
        return null;
    }

    public String createStandardService(String parent, String name, String domain) throws Exception {
        StandardService service = new StandardService();
        service.setName(name);
        Server server = ServerFactory.getServer();
        server.addService(service);
        return service.getObjectName().toString();
    }

    public String createSystemErrLogger(String parent) throws Exception {
        SystemErrLogger logger = new SystemErrLogger();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setLogger(logger);
        ObjectName oname = logger.getObjectName();
        return oname.toString();
    }

    public String createSystemOutLogger(String parent) throws Exception {
        SystemOutLogger logger = new SystemOutLogger();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setLogger(logger);
        ObjectName oname = logger.getObjectName();
        return oname.toString();
    }

    public String createUserDatabaseRealm(String parent, String resourceName) throws Exception {
        UserDatabaseRealm realm = new UserDatabaseRealm();
        realm.setResourceName(resourceName);
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        containerBase.setRealm(realm);
        ObjectName oname = realm.getObjectName();
        if (oname != null) {
            return oname.toString();
        }
        return null;
    }

    public String createWebappLoader(String parent) throws Exception {
        WebappLoader loader = new WebappLoader();
        ObjectName pname = new ObjectName(parent);
        ContainerBase containerBase = this.getParentContainerFromParent(pname);
        if (containerBase != null) {
            containerBase.setLoader(loader);
        }
        ObjectName oname = MBeanUtils.createObjectName(pname.getDomain(), loader);
        return oname.toString();
    }

    public void removeConnector(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Server server = ServerFactory.getServer();
        Service service = this.getService(oname);
        String port = oname.getKeyProperty("port");
        Connector[] conns = service.findConnectors();
        for (int i = 0; i < conns.length; ++i) {
            Class<?> cls = conns[i].getClass();
            Method getAddrMeth = cls.getMethod("getAddress", null);
            Object addrObj = getAddrMeth.invoke((Object)conns[i], null);
            String connAddress = null;
            if (addrObj != null) {
                connAddress = addrObj.toString();
            }
            Method getPortMeth = cls.getMethod("getPort", null);
            Object portObj = getPortMeth.invoke((Object)conns[i], null);
            String connPort = new String();
            if (portObj != null) {
                connPort = portObj.toString();
            }
            if (connAddress == null && port.equals(connPort)) {
                service.removeConnector(conns[i]);
                ((CoyoteConnector)conns[i]).destroy();
                break;
            }
            if (!port.equals(connPort)) continue;
            service.removeConnector(conns[i]);
            ((CoyoteConnector)conns[i]).destroy();
            break;
        }
    }

    public void removeContext(String contextName) throws Exception {
        ObjectName oname = new ObjectName(contextName);
        String domain = oname.getDomain();
        StandardService service = (StandardService)this.getService(oname);
        if (!service.getObjectName().getDomain().equals(domain)) {
            throw new Exception("Service with the domain is not found");
        }
        Engine engine = (Engine)service.getContainer();
        String name = oname.getKeyProperty("name");
        name = name.substring(2);
        int i = name.indexOf("/");
        String hostName = name.substring(0, i);
        String path = name.substring(i);
        Host host = (Host)engine.findChild(hostName);
        String pathStr = this.getPathStr(path);
        Context context = (Context)host.findChild(pathStr);
        host.removeChild(context);
    }

    public void removeHost(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String hostName = oname.getKeyProperty("host");
        Service service = this.getService(oname);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        engine.removeChild(host);
    }

    public void removeLogger(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        ContainerBase container = this.getParentContainerFromChild(oname);
        container.setLogger(null);
    }

    public void removeLoader(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        ContainerBase container = this.getParentContainerFromChild(oname);
        container.setLoader(null);
    }

    public void removeManager(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        ContainerBase container = this.getParentContainerFromChild(oname);
        container.setManager(null);
    }

    public void removeRealm(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        ContainerBase container = this.getParentContainerFromChild(oname);
        container.setRealm(null);
    }

    public void removeService(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("serviceName");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        server.removeService(service);
    }

    public void removeValve(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        ContainerBase container = this.getParentContainerFromChild(oname);
        String sequence = oname.getKeyProperty("seq");
        Valve[] valves = container.getValves();
        for (int i = 0; i < valves.length; ++i) {
            ObjectName voname = ((ValveBase)valves[i]).getObjectName();
            if (!voname.equals(oname)) continue;
            container.removeValve(valves[i]);
        }
    }
}

