/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class StandardService
implements Lifecycle,
Service,
MBeanRegistration {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$core$StandardService == null ? (class$org$apache$catalina$core$StandardService = StandardService.class$("org.apache.catalina.core.StandardService")) : class$org$apache$catalina$core$StandardService));
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private int debug = 0;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private boolean initialized = false;
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Server server = null;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String type;
    protected String domain;
    protected String suffix;
    protected ObjectName oname;
    protected ObjectName controller;
    protected MBeanServer mserver;
    static /* synthetic */ Class class$org$apache$catalina$core$StandardService;

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        Connector[] e = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].setContainer(this.container);
            }
            // ** MonitorExit[e] (shouldn't be in output)
            if (this.started && oldContainer != null && oldContainer instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldContainer)).stop();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("container", oldContainer, this.container);
            return;
        }
    }

    public ObjectName getContainerName() {
        if (this.container instanceof ContainerBase) {
            return ((ContainerBase)this.container).getJmxName();
        }
        return null;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("connector", null, connector);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i = 0; i < results.length; ++i) {
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            int j = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (connector != this.connectors[i]) continue;
                j = i;
                break;
            }
            if (j < 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.started && this.connectors[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.connectors[j].setContainer(null);
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i = 0; i < this.connectors.length; ++i) {
                if (i == j) continue;
                results[k++] = this.connectors[i];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start() throws LifecycleException {
        Connector[] connectorArray;
        if (this.started) {
            log.info((Object)sm.getString("standardService.start.started"));
        }
        if (!this.initialized) {
            this.init();
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        log.info((Object)sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container != null) {
            connectorArray = this.container;
            // MONITORENTER : this.container
            if (this.container instanceof Lifecycle) {
                ((Lifecycle)((Object)this.container)).start();
            }
            // MONITOREXIT : connectorArray
        }
        connectorArray = this.connectors;
        // MONITORENTER : this.connectors
        int i = 0;
        while (true) {
            if (i >= this.connectors.length) {
                // MONITOREXIT : connectorArray
                this.lifecycle.fireLifecycleEvent("after_start", null);
                return;
            }
            if (this.connectors[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.connectors[i])).start();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        Object object = this.connectors;
        synchronized (this.connectors) {
            int i;
            for (i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].pause();
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lifecycle.fireLifecycleEvent("stop", null);
            log.info((Object)sm.getString("standardService.stop.name", this.name));
            this.started = false;
            if (this.container != null) {
                object = this.container;
                synchronized (object) {
                    if (this.container instanceof Lifecycle) {
                        ((Lifecycle)((Object)this.container)).stop();
                    }
                }
            }
            object = this.connectors;
            synchronized (this.connectors) {
                for (i = 0; i < this.connectors.length; ++i) {
                    if (!(this.connectors[i] instanceof Lifecycle)) continue;
                    ((Lifecycle)((Object)this.connectors[i])).stop();
                }
                // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                if (this.oname == this.controller) {
                    Registry.getRegistry(null, null).unregisterComponent(this.oname);
                }
                this.lifecycle.fireLifecycleEvent("after_stop", null);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            log.info((Object)sm.getString("standardService.initialize.initialized"));
            return;
        }
        this.initialized = true;
        if (this.oname == null) {
            try {
                Container engine = this.getContainer();
                this.domain = engine.getName();
                this.controller = this.oname = new ObjectName(this.domain + ":type=Service,serviceName=" + this.name);
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Exception e) {
                log.error((Object)"Error registering ", (Throwable)e);
            }
        }
        if (this.server == null) {
            ServerFactory.getServer().addService(this);
        }
        Connector[] connectorArray = this.connectors;
        synchronized (this.connectors) {
            for (int i = 0; i < this.connectors.length; ++i) {
                this.connectors[i].initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void destroy() throws LifecycleException {
        if (this.started) {
            this.stop();
        }
    }

    public void init() {
        try {
            this.initialize();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

