/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.service.FaultInjection;
import com.sun.messaging.bridge.service.MessageTransformer;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.Link;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnectionFactory;

public class DMQ {
    private Logger _logger = null;
    private Object _cf = null;
    private Object _dest = null;
    private MessageProducer _producer = null;
    private Session _session = null;
    private Connection _conn = null;
    private Properties _dmqAttrs = null;
    private Properties _dmqProps = null;
    private JMSBridge _parent = null;
    private int _maxAttempts = 0;
    private long _attemptInterval = 0L;
    private boolean _stayConnected = true;
    private long _timeToLive = 0L;
    private int _maxSendAttempts = 1;
    private long _sendInterval = 5000L;
    private DMQState _state = DMQState.UNINITIALIZED;
    private String _name = null;
    private boolean _connException = false;
    private String _providerName = null;
    private EventNotifier _notifier = null;
    private MessageTransformer<Message, Message> _msgTransformer = null;
    private FaultInjection _fi = FaultInjection.getInjection();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();
    private long msgCount = 0L;

    public synchronized void init(Properties properties, Properties properties2, JMSBridge jMSBridge) throws Exception {
        String string;
        this._dmqAttrs = properties;
        this._dmqProps = properties2;
        this._parent = jMSBridge;
        this._notifier = jMSBridge._notifier;
        if (this._dest == null || this._cf == null) {
            throw new IllegalStateException("DMQ information unknown !");
        }
        if (this._logger == null) {
            throw new IllegalStateException("No logger set for dmq " + this);
        }
        if (this._cf instanceof XAConnectionFactory) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalArgumentException(jMSBridgeResources.getKString("BSJ4004", "XAConnectionFactory"));
        }
        this._maxAttempts = Integer.valueOf(this._dmqAttrs.getProperty("connect-attempts", "-1"));
        this._attemptInterval = Long.valueOf(this._dmqAttrs.getProperty("connect-attempt-interval-in-seconds", "5"));
        if (this._attemptInterval < 0L) {
            this._attemptInterval = 0L;
        }
        this._attemptInterval *= 1000L;
        String string2 = this._dmqAttrs.getProperty("stay-connected", "true");
        this._stayConnected = Boolean.valueOf(string2);
        string2 = this._dmqAttrs.getProperty("time-to-live-in-millis", "0");
        this._timeToLive = Long.valueOf(string2);
        string2 = this._dmqAttrs.getProperty("send-attempts", "3");
        this._maxSendAttempts = Integer.valueOf(string2);
        if (this._maxSendAttempts <= 0) {
            this._maxSendAttempts = 1;
        }
        string2 = this._dmqAttrs.getProperty("send-attempt-interval-in-seconds", "5");
        this._sendInterval = Long.valueOf(string2) * 1000L;
        if (this._sendInterval < 0L) {
            this._sendInterval = 0L;
        }
        if ((string = this._dmqAttrs.getProperty("message-transformer-class")) != null) {
            this._msgTransformer = (MessageTransformer)Class.forName(string).newInstance();
        }
        this._state = DMQState.STOPPED;
    }

    public boolean isEnabled() {
        return Boolean.valueOf(this._dmqAttrs.getProperty("enabled", "true"));
    }

    public synchronized void start(boolean bl) throws Exception {
        if (this._state == DMQState.UNINITIALIZED) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4005", this.toString()));
        }
        if (this._state == DMQState.STARTED) {
            this._logger.log(Level.INFO, JMSBridge.getJMSBridgeResources().getString("BSJ1000", this.toString()));
            return;
        }
        this._state = DMQState.STARTING;
        try {
            if (this._stayConnected) {
                this.initJMS(true, bl);
            }
            this._state = DMQState.STARTED;
        }
        catch (Exception exception) {
            this._logger.log(Level.SEVERE, JMSBridge.getJMSBridgeResources().getKString("BSJ3000", this.toString(), exception.getMessage()), exception);
            try {
                this.stop();
            }
            catch (Throwable throwable) {
                this._logger.log(Level.WARNING, JMSBridge.getJMSBridgeResources().getKString("BSJ2000", this.toString()), throwable);
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Throwable {
        this._notifier.notifyEvent(EventListener.EventType.DMQ_STOP, this);
        DMQ dMQ = this;
        synchronized (dMQ) {
            this._state = DMQState.STOPPING;
            this.closeJMS();
            this._state = DMQState.STOPPED;
        }
    }

    private void initJMS() throws Exception {
        this.initJMS(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJMS(boolean bl, boolean bl2) throws Exception {
        Object object;
        this._connException = false;
        String string = this._dmqAttrs.getProperty("clientid");
        if (this._stayConnected || string != null) {
            String[] stringArray = new String[3];
            stringArray[0] = "DMQ";
            stringArray[1] = this.toString();
            stringArray[2] = string == null ? "" : _jbr.getString("BSJ0000", string);
            object = stringArray;
            this._logger.log(Level.INFO, _jbr.getString("BSJ1001", (Object[])object));
            EventListener eventListener = new EventListener(this);
            try {
                this._notifier.addEventListener(EventListener.EventType.DMQ_STOP, eventListener);
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, eventListener);
                this._conn = JMSBridge.openConnection(this._cf, this._parent.getCFAttributes(this._cf), "DMQ", this, eventListener, this._logger, bl2);
            }
            finally {
                this._notifier.removeEventListener(eventListener);
            }
            if (string != null) {
                this._conn.setClientID(string);
            }
        } else {
            this._conn = this._parent.obtainConnection(this._cf, "DMQ", this, bl2);
        }
        this._conn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException jMSException) {
                Logger logger = DMQ.this._logger;
                JMSBridgeResources jMSBridgeResources = _jbr;
                _jbr;
                logger.log(Level.WARNING, jMSBridgeResources.getKString("BSJ2001", this.toString()), jMSException);
                DMQ.this._connException = true;
                if (DMQ.this._conn instanceof PooledConnection) {
                    ((PooledConnection)((Object)DMQ.this._conn)).invalid();
                } else if (DMQ.this._conn instanceof SharedConnection) {
                    ((SharedConnection)((Object)DMQ.this._conn)).invalid();
                }
            }
        });
        try {
            object = this._conn.getMetaData();
            this._providerName = object.getJMSProviderName();
        }
        catch (Exception exception) {
            this._providerName = null;
            this._logger.log(Level.WARNING, "Unable to get JMSProvider from conn " + this._conn + " in dmq " + this + ": " + exception.getMessage());
        }
        this._session = this._conn.createSession(false, 1);
        if (this._dest instanceof Destination) {
            this._producer = this._session.createProducer((Destination)this._dest);
        } else if (this._dest instanceof AutoDestination) {
            object = (AutoDestination)this._dest;
            this._producer = ((AutoDestination)object).isQueue() ? this._session.createProducer(this._session.createQueue(((AutoDestination)object).getName())) : this._session.createProducer(this._session.createTopic(((AutoDestination)object).getName()));
        } else {
            throw new IllegalArgumentException("Unknown destination type: " + this._dest.getClass().getName() + " in dmq " + this);
        }
    }

    private synchronized void closeJMS() {
        this._connException = false;
        if (this._conn == null) {
            return;
        }
        if (this._conn instanceof SharedConnection || this._conn instanceof PooledConnection) {
            try {
                this._parent.returnConnection(this._conn, this._cf);
            }
            catch (Throwable throwable) {
                this.logWarning(_jbr.getKString("BSJ2002", this._conn, this.toString()), throwable);
            }
            return;
        }
        try {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1075", this._conn.getClass().getName() + '@' + Integer.toHexString(this._conn.hashCode()), this.toString()));
            this._conn.close();
        }
        catch (Throwable throwable) {
            this._logger.log(Level.WARNING, _jbr.getKString("BSJ2003", this._conn, this.toString()), throwable);
        }
    }

    private void logWarning(String string, Throwable throwable) {
        if (this._state == DMQState.STOPPING || this._state == DMQState.STOPPED) {
            this._logger.log(Level.WARNING, string + ": " + throwable.getMessage());
        } else {
            this._logger.log(Level.WARNING, string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(Message message, String string, DMQReason dMQReason, Throwable throwable, Link link) throws Exception {
        if (this._state == DMQState.STOPPING || this._state == DMQState.STOPPED) {
            throw new JMSException(_jbr.getKString("BSJ4006", this.toString()));
        }
        if (this._connException) {
            this.closeJMS();
            this.initJMS();
        } else if (!this._stayConnected) {
            this.initJMS();
        }
        ObjectMessage objectMessage = this._session.createObjectMessage();
        if (string != null) {
            try {
                objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_MESSAGEID.toString(), string);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting JMSMessageID to DMQ message from message " + message + " for link " + link, exception);
            }
        }
        long l = 0L;
        try {
            l = message.getJMSTimestamp();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in getting JMSTimestamp from message " + message + " for link " + link, exception);
        }
        if (l != 0L) {
            try {
                objectMessage.setLongProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_TIMESTAMP.toString(), l);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting source timestamp to DMQ message from message " + message + " for link " + link, exception);
            }
        }
        String string2 = null;
        try {
            string2 = message.getJMSCorrelationID();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in getting JMSCorrelationID from message " + message + " for link " + link, exception);
        }
        if (string2 != null) {
            try {
                objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_CORRELATIONID.toString(), string2);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting source correlation id to DMQ message from message " + message + " for link " + link, exception);
            }
        }
        string2 = null;
        try {
            string2 = message.getJMSType();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in getting JMSType from message " + message + " for " + link, exception);
        }
        if (string2 != null) {
            try {
                objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_JMSTYPE.toString(), string2);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting source JMS type to DMQ message from message " + message + " for link " + link, exception);
            }
        }
        Enumeration enumeration = null;
        try {
            enumeration = message.getPropertyNames();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in getting PropertyNames from message " + message + " in " + link, exception);
        }
        String string3 = null;
        Object object = null;
        while (enumeration != null && enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            object = message.getObjectProperty(string3);
            try {
                objectMessage.setObjectProperty(string3, object);
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{string3 + "=" + object, "" + string, link.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ4007", objectArray), exception);
            }
        }
        try {
            objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_DESTINATION.toString(), link.getSourceDestinationName());
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting source destination to DMQ message for message " + message + " in " + link, exception);
        }
        try {
            objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_DESTINATION.toString(), link.getTargetDestinationName());
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting target destination " + link.getTargetDestinationName() + " to DMQ message for message " + message + " in " + link, exception);
        }
        if (link.getTargetCurrentDestinationName() != null) {
            try {
                objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_CURRENT_DESTINATION.toString(), link.getTargetCurrentDestinationName());
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting target current destination " + link.getTargetCurrentDestinationName() + " to DMQ message for message " + message + " in " + link, exception);
            }
        }
        try {
            objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_PROVIDER.toString(), link.getSourceProviderName());
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting source provider to DMQ message for message " + message + " in " + link, exception);
        }
        try {
            objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_PROVIDER.toString(), link.getTargetProviderName());
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting target provider to DMQ message for message " + message + " in " + link, exception);
        }
        try {
            objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_REASON.toString(), dMQReason.toString());
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting dmq reason " + (Object)((Object)dMQReason) + " to DMQ message for message " + message + " in " + link, exception);
        }
        if (throwable != null && throwable.getMessage() != null) {
            try {
                objectMessage.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_EXCEPTION.toString(), throwable.getMessage());
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Exception in setting dmq reason " + (Object)((Object)dMQReason) + " to DMQ message for message " + message + " in " + link, exception);
            }
        }
        try {
            objectMessage.setLongProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_TIMESTAMP.toString(), new Long(System.currentTimeMillis()));
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in setting dmq timestamp to DMQ message for message " + message + " in " + link, exception);
        }
        int n = 2;
        try {
            n = message.getJMSDeliveryMode();
        }
        catch (Exception exception) {
            n = 2;
            this._logger.log(Level.WARNING, "Exception in getting JMSDeliveryMode: " + exception.getMessage() + " for message " + message + " in " + link, exception);
        }
        int n2 = 4;
        try {
            n2 = message.getJMSPriority();
        }
        catch (Exception exception) {
            n2 = 4;
            this._logger.log(Level.WARNING, "Exception in getting JMSPriority: " + exception.getMessage() + " for message " + message + " in " + link, exception);
        }
        boolean bl = false;
        int n3 = 0;
        EventListener eventListener = new EventListener(this);
        this._notifier.addEventListener(EventListener.EventType.DMQ_STOP, eventListener);
        this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, eventListener);
        Message message2 = message;
        try {
            do {
                Object[] objectArray;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException(_jbr.getKString("BSJ4038", string, this.toString()));
                }
                if (n3 > 0 && this._sendInterval > 0L) {
                    Thread.sleep(this._sendInterval);
                }
                try {
                    if (this._connException) {
                        this.closeJMS();
                        this.initJMS();
                    } else if (!this._stayConnected) {
                        this.initJMS();
                    }
                    if (n3 == 0) {
                        Object[] objectArray2;
                        if (this._msgTransformer != null) {
                            this._msgTransformer.init(this._session, "JMS");
                            try {
                                message2 = this._msgTransformer.transform(message, true, null, link.getSourceProviderName(), link.getTargetProviderName(), this._dmqProps);
                                if (this._fi.FAULT_INJECTION) {
                                    HashMap<String, String> hashMap = new HashMap<String, String>();
                                    hashMap.put("dmqName", this._name);
                                    this._fi.setLogger(this._logger);
                                    this._fi.checkFaultAndThrowException("dmq.transform.2", hashMap, "javax.jms.JMSException", true);
                                }
                            }
                            catch (Exception exception) {
                                message2 = message;
                                objectArray = new String[]{"MessageTransformer", "" + string, link.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2004", objectArray), exception);
                            }
                        }
                        boolean bl2 = true;
                        if (message2 instanceof Serializable) {
                            bl2 = false;
                            try {
                                objectMessage.setObject((Serializable)((Object)message2));
                            }
                            catch (Exception exception) {
                                bl2 = true;
                                objectArray2 = new String[]{"ObjectMessage.setObject()", "" + string, link.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2004", objectArray2), exception);
                            }
                        }
                        if (bl2) {
                            try {
                                objectMessage.setBooleanProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_BODY_TRUNCATED.toString(), Boolean.valueOf("true"));
                            }
                            catch (Exception exception) {
                                this._logger.log(Level.WARNING, "Exception in setting DMQ body-truncated property for DMQ message " + message + "in " + link, exception);
                            }
                            try {
                                objectMessage.setObject((Serializable)((Object)message2.toString()));
                            }
                            catch (Exception exception) {
                                objectArray2 = new String[]{"ObjectMessage.setObject()", "" + string, link.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2005", objectArray2), exception);
                            }
                        }
                    }
                    if (this._fi.FAULT_INJECTION) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("dmqName", this._name);
                        this._fi.setLogger(this._logger);
                        this._fi.checkFaultAndThrowException("dmq.send.1", hashMap, "javax.jms.JMSException", true);
                    }
                    this._producer.send(objectMessage, n, n2, this._timeToLive);
                    ++this.msgCount;
                    bl = true;
                }
                catch (Throwable throwable2) {
                    this._connException = true;
                    objectArray = new String[]{"" + string, this.toString(), link.toString(), ++n3 + "(" + this._sendInterval + ")"};
                    this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3001", objectArray), throwable2);
                }
            } while (!bl && n3 <= this._maxSendAttempts && !eventListener.hasEventOccurred());
        }
        finally {
            this._notifier.removeEventListener(eventListener);
            if (!this._stayConnected) {
                this.closeJMS();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMessage(Message message, String string, Link link, Logger logger) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("Logging message going to DMQ for " + link);
            stringBuffer.append("\n");
            stringBuffer.append("\tJMS Headers:");
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSMessageID=" + message.getJMSMessageID());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSMessageID header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSDestination=" + message.getJMSDestination());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSDestination header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSTimestamp=" + message.getJMSTimestamp());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSTimestamp header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSExpiration=" + message.getJMSExpiration());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSExpiration header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSDeliveryMode=" + message.getJMSDeliveryMode());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSDeliveryMode header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSCorrelationID=" + message.getJMSCorrelationID());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSCorrelationID header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSPriority=" + message.getJMSPriority());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSPriority header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSRedelivered=" + message.getJMSRedelivered());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSRedelivered header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSReplyTo=" + message.getJMSReplyTo());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSReplyTo header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\tJMSType=" + message.getJMSType());
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get JMSType header from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append("\tJMS Properties:");
            stringBuffer.append("\n");
            Enumeration enumeration = null;
            try {
                enumeration = message.getPropertyNames();
            }
            catch (Throwable throwable) {
                stringBuffer.append("Unable to get PropertyNames from message " + string + " for " + link + ": " + throwable.getMessage());
            }
            stringBuffer.append("\n");
            String string2 = null;
            Object var7_18 = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                try {
                    stringBuffer.append("\t" + string2 + "=" + message.getObjectProperty(string2));
                }
                catch (Throwable throwable) {
                    stringBuffer.append("Unable to get property " + string2 + " value from message " + string + " for " + link + ": " + throwable.getMessage());
                }
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
            stringBuffer.append("\tMessage.toString:");
            stringBuffer.append("\n");
            try {
                stringBuffer.append("\ttoString=" + message);
            }
            catch (Throwable throwable) {
                stringBuffer.append("\tUnable to get Message.toString() from message " + string + " for " + link + ": " + throwable.getMessage());
            }
        }
        finally {
            logger.log(Level.INFO, stringBuffer.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("dmq(" + this.getName() + ")[");
        stringBuffer.append(((Refable)this._cf).getRef()).append("::");
        stringBuffer.append(this.getDestinationName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getProviderName() {
        String string = this._providerName;
        if (string != null) {
            return string;
        }
        return ((Refable)this._cf).getRefed().getClass().getName();
    }

    public String getDestinationName() {
        try {
            if (this._dest instanceof Queue) {
                return "queue:" + ((Queue)this._dest).getQueueName();
            }
            if (this._dest instanceof Topic) {
                return "topic:" + ((Topic)this._dest).getTopicName();
            }
            return this._dest.toString();
        }
        catch (Exception exception) {
            this._logger.log(Level.WARNING, "Exception in get destination name for dmq " + this, exception);
            return this._dest.toString();
        }
    }

    public void setConnectionFactory(Object object) {
        this._cf = object;
    }

    public void setDestination(Object object) {
        this._dest = object;
    }

    public Object getDestination() {
        return this._dest;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DMQProperty {
        JMS_SUN_JMSBRIDGE_SOURCE_MESSAGEID,
        JMS_SUN_JMSBRIDGE_SOURCE_TIMESTAMP,
        JMS_SUN_JMSBRIDGE_SOURCE_CORRELATIONID,
        JMS_SUN_JMSBRIDGE_SOURCE_JMSTYPE,
        JMS_SUN_JMSBRIDGE_SOURCE_DESTINATION,
        JMS_SUN_JMSBRIDGE_TARGET_DESTINATION,
        JMS_SUN_JMSBRIDGE_TARGET_CURRENT_DESTINATION,
        JMS_SUN_JMSBRIDGE_SOURCE_PROVIDER,
        JMS_SUN_JMSBRIDGE_TARGET_PROVIDER,
        JMS_SUN_JMSBRIDGE_DMQ_REASON,
        JMS_SUN_JMSBRIDGE_DMQ_EXCEPTION,
        JMS_SUN_JMSBRIDGE_DMQ_TIMESTAMP,
        JMS_SUN_JMSBRIDGE_DMQ_BODY_TRUNCATED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DMQReason {
        MESSAGE_EXPIRED,
        TRANSFORMER_FAILURE,
        FIRST_TRANSFORMER_NOTRANSFER,
        FIRST_TRANSFORMER_BRANCHTO,
        FIRST_TRANSFORMER_AS_SOURCE_CHANGE,
        SEND_FAILURE,
        COMMIT_FAILURE,
        ACK_FAILURE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DMQState {
        UNINITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

