/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddGroupAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        if (nodes != null && nodes.length == 1) {
            SaasGroup g = (SaasGroup)nodes[0].getLookup().lookup(SaasGroup.class);
            return g != null;
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddGroupAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(AddGroupAction.class, (String)"ADD_GROUP");
    }

    protected void performAction(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return;
        }
        String defaultName = NbBundle.getMessage(AddGroupAction.class, (String)"NEW_GROUP");
        NotifyDescriptor.InputLine dlg = new NotifyDescriptor.InputLine(NbBundle.getMessage(AddGroupAction.class, (String)"CTL_GroupLabel"), NbBundle.getMessage(AddGroupAction.class, (String)"CTL_GroupTitle"));
        dlg.setInputText(defaultName);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dlg))) {
            try {
                String newName = dlg.getInputText().trim();
                if (newName == null || newName.length() == 0) {
                    newName = defaultName;
                }
                SaasGroup parent = (SaasGroup)nodes[0].getLookup().lookup(SaasGroup.class);
                try {
                    SaasServicesModel.getInstance().createGroup(parent, newName);
                }
                catch (Exception ex) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
            }
            catch (IllegalArgumentException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }
}

