/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.applications.JavaUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.utils.system.WindowsNativeUtils;
import org.netbeans.installer.utils.system.windows.WindowsRegistry;
import org.netbeans.installer.wizard.components.WizardAction;

public class SearchForJavaAction
extends WizardAction {
    private static List<File> javaLocations = new LinkedList<File>();
    private static List<String> javaLabels = new LinkedList<String>();
    public static final String DEFAULT_TITLE = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.description");
    public static final String PREPARE_JAVA_LIST = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.prepare.list");
    public static final String CHECKING = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.checking");
    public static final String SEARCH_INSTALLED_JAVAS = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.search.java");
    public static final String JAVA_ENTRY_LABEL = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.entry.label");
    public static final String JAVA_ENTRY_LABEL_NO_ARCH = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.entry.label.noarch");
    public static final String JAVA_ENTRY_LABEL_NON_FINAL = ResourceUtils.getString(SearchForJavaAction.class, "SFJA.entry.label.non.final");
    private static final String JDK_PRODUCT_UID = "jdk";
    public static final String[] JAVA_WINDOWS_REGISTRY_ENTRIES = new String[]{"SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JRockit\\Java Development Kit", "SOFTWARE\\IBM\\Java Development Kit", "SOFTWARE\\IBM\\Java2 Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\JRockit\\Java Runtime Environment", "SOFTWARE\\IBM\\Java Runtime Environment", "SOFTWARE\\IBM\\Java2 Runtime Environment"};
    public static final String[] JAVA_ENVIRONMENT_VARIABLES = new String[]{"JAVA_HOME", "JAVAHOME", "JAVA_PATH", "JDK_HOME", "JDKHOME", "ANT_JAVA", "JAVA", "JDK"};
    public static final String[] JAVA_FILESYSTEM_LOCATIONS_COMMON = new String[]{"$S{java.home}", "$S{java.home}/.."};
    public static final String[] JAVA_FILESYSTEM_LOCATIONS_UNIX = new String[]{"$N{home}", "$N{home}/java", "$N{home}/jdk", "$N{home}/Java", "$N{install}", "$N{install}/Java", "/usr", "/usr/jdk", "/usr/jdk/instances", "/usr/java", "/usr/java/jdk", "/usr/j2se", "/usr/j2sdk", "/usr/local", "/usr/local/jdk", "/usr/local/jdk/instances", "/usr/local/java", "/usr/local/j2se", "/usr/local/j2sdk", "/export", "/export/jdk", "/export/jdk/instances", "/export/java", "/export/j2se", "/export/j2sdk", "/opt", "/opt/jdk", "/opt/jdk/instances", "/opt/java", "/opt/j2se", "/opt/j2sdk", "/usr/lib/jvm"};
    public static final String[] JAVA_FILESYSTEM_LOCATIONS_MACOSX = new String[]{"/Library/Java", "/System/Library/Frameworks/JavaVM.framework/Versions/1.5", "/System/Library/Frameworks/JavaVM.framework/Versions/1.5.0", "/System/Library/Frameworks/JavaVM.framework/Versions/1.6", "/System/Library/Frameworks/JavaVM.framework/Versions/1.6.0", "/System/Library/Frameworks/JavaVM.framework/Versions/1.7", "/System/Library/Frameworks/JavaVM.framework/Versions/1.7.0"};
    public static final String[] JAVA_FILESYSTEM_LOCATIONS_WINDOWS = new String[]{"$N{install}", "$N{install}/Java"};

    public SearchForJavaAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
    }

    @Override
    public void execute() {
        this.execute(new Progress());
    }

    public void execute(Progress progress) {
        LogManager.logEntry("search for all java locations");
        this.getWizardUi().setProgress(progress);
        LinkedList<File> locations = new LinkedList<File>();
        progress.setTitle(SEARCH_INSTALLED_JAVAS);
        progress.setDetail("");
        progress.setPercentage(0);
        SystemUtils.sleep(200L);
        progress.setDetail(PREPARE_JAVA_LIST);
        if (SystemUtils.isWindows()) {
            this.fetchLocationsFromWindowsRegistry(locations);
        }
        this.fetchLocationsFromEnvironment(locations);
        this.fetchLocationsFromFilesystem(locations);
        this.fetchLocationsFromRegistry(locations);
        this.getJavaLocationsInfo(locations, progress);
        SearchForJavaAction.sortJavaLocations();
        progress.setDetail("");
        progress.setPercentage(100);
        SystemUtils.sleep(200L);
        LogManager.logExit("... end of search for all java locations");
    }

    @Override
    public boolean canExecuteForward() {
        return javaLocations.size() == 0;
    }

    private static String getLabel(File javaHome) {
        JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
        return SearchForJavaAction.getLabel(javaHome, javaInfo);
    }

    private static String getLabel(File javaHome, JavaUtils.JavaInfo javaInfo) {
        if (javaInfo.isNonFinal()) {
            return StringUtils.format(JAVA_ENTRY_LABEL_NON_FINAL, javaHome, javaInfo.getVersion().toJdkStyle(), javaInfo.getArch(), javaInfo.getVendor());
        }
        return StringUtils.format(JAVA_ENTRY_LABEL, javaHome, javaInfo.getVersion().toJdkStyle(), javaInfo.getArch(), javaInfo.getVendor());
    }

    private static String getLabel(File javaHome, Version version, String vendor) {
        JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
        if (javaInfo == null) {
            return StringUtils.format(JAVA_ENTRY_LABEL_NO_ARCH, javaHome, version.toJdkStyle(), vendor);
        }
        return StringUtils.format(JAVA_ENTRY_LABEL, javaHome, version.toJdkStyle(), javaInfo.getArch(), vendor);
    }

    private void getJavaLocationsInfo(List<File> locations, Progress progress) {
        for (int i = 0; i < locations.size(); ++i) {
            File jreHome;
            File javaHome = locations.get(i).getAbsoluteFile();
            progress.setDetail(StringUtils.format(CHECKING, javaHome));
            if (this.isCanceled()) {
                return;
            }
            LogManager.logIndent("investigating java home candidate: " + javaHome);
            JavaUtils.JavaInfo javaInfo = JavaUtils.getInfo(javaHome);
            if (javaInfo == null && FileUtils.exists(jreHome = new File(javaHome, "jre"))) {
                LogManager.log("investigating java home candidate: " + jreHome);
                javaInfo = JavaUtils.getInfo(jreHome);
                if (javaInfo != null) {
                    javaHome = jreHome;
                }
            }
            if (javaInfo != null) {
                LogManager.logUnindent("... parsed java: " + javaInfo.getVersion() + " " + "by " + javaInfo.getVendor() + "; " + "final=" + !javaInfo.isNonFinal());
                if (javaHome.getName().equals("jre") && JavaUtils.isJdk(javaHome.getParentFile())) continue;
                SearchForJavaAction.addJavaLocation(javaHome);
            } else {
                LogManager.unindent();
            }
            SystemUtils.sleep(5L);
            progress.setPercentage(100 * i / locations.size());
        }
    }

    public static void sortJavaLocations() {
        for (int i = 0; i < javaLocations.size(); ++i) {
            for (int j = javaLocations.size() - 1; j > i; --j) {
                File file1 = javaLocations.get(j);
                File file2 = javaLocations.get(j - 1);
                String label1 = javaLabels.get(j);
                String label2 = javaLabels.get(j - 1);
                JavaUtils.JavaInfo info1 = JavaUtils.getInfo(javaLocations.get(j));
                JavaUtils.JavaInfo info2 = JavaUtils.getInfo(javaLocations.get(j - 1));
                if (info1.isNonFinal() == info2.isNonFinal()) {
                    if (info1.getVersion().equals(info2.getVersion())) {
                        if (file1.getPath().compareTo(file2.getPath()) == 0) {
                            if (info1.getVendor().compareTo(info2.getVendor()) == 0 || info1.getVendor().compareTo(info2.getVendor()) >= 0) continue;
                            SearchForJavaAction.switchNeighbours(j, file2, file1, label2, label1);
                            continue;
                        }
                        if (file1.getPath().length() >= file2.getPath().length()) continue;
                        SearchForJavaAction.switchNeighbours(j, file2, file1, label2, label1);
                        continue;
                    }
                    if (!info1.getVersion().newerThan(info2.getVersion())) continue;
                    SearchForJavaAction.switchNeighbours(j, file2, file1, label2, label1);
                    continue;
                }
                if (info1.isNonFinal() || !info2.isNonFinal()) continue;
                SearchForJavaAction.switchNeighbours(j, file2, file1, label2, label1);
            }
        }
    }

    private static void switchNeighbours(int j, File file2, File file1, String label2, String label1) {
        javaLocations.set(j, file2);
        javaLocations.set(j - 1, file1);
        javaLabels.set(j, label2);
        javaLabels.set(j - 1, label1);
    }

    public static void addJavaLocation(File location, Version version, String vendor) {
        File javaHome = SearchForJavaAction.getCanonicalFile(location);
        if (!javaLocations.contains(javaHome)) {
            javaLocations.add(javaHome);
            javaLabels.add(SearchForJavaAction.getLabel(javaHome, version, vendor));
            JavaUtils.addJavaInfo(javaHome, new JavaUtils.JavaInfo(version, vendor));
        }
    }

    public static void addJavaLocation(File location) {
        File javaHome = SearchForJavaAction.getCanonicalFile(location);
        if (!javaLocations.contains(javaHome)) {
            javaLocations.add(javaHome);
            javaLabels.add(SearchForJavaAction.getLabel(javaHome));
        }
    }

    public static List<File> getJavaLocations() {
        return javaLocations;
    }

    public static List<String> getJavaLabels() {
        return javaLabels;
    }

    private static File getCanonicalFile(File file) {
        File location = file;
        if (SystemUtils.isWindows() && location.getAbsolutePath().matches(".*~[0-9]+.*")) {
            try {
                location = location.getCanonicalFile();
                if (location != file) {
                    LogManager.log("... using " + location + " instead of " + file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return location;
    }

    private void fetchLocationsFromFilesystem(List<File> locations) {
        String parentDir;
        ArrayList<String> candidateLocations = new ArrayList<String>();
        for (String location : JAVA_FILESYSTEM_LOCATIONS_COMMON) {
            candidateLocations.add(location);
        }
        if (SystemUtils.isWindows()) {
            candidateLocations.addAll(Arrays.asList(JAVA_FILESYSTEM_LOCATIONS_WINDOWS));
        } else if (SystemUtils.isMacOS()) {
            candidateLocations.addAll(Arrays.asList(JAVA_FILESYSTEM_LOCATIONS_MACOSX));
        } else {
            candidateLocations.addAll(Arrays.asList(JAVA_FILESYSTEM_LOCATIONS_UNIX));
        }
        File currentJava = SystemUtils.getCurrentJavaHome();
        File currentJavaParentDir = currentJava.getParentFile();
        if (currentJavaParentDir != null && JavaUtils.isJavaHome(currentJava) && JavaUtils.isJdk(currentJavaParentDir) && (parentDir = currentJavaParentDir.getParent()) != null && !candidateLocations.contains(parentDir)) {
            candidateLocations.add(parentDir);
        }
        for (String location : candidateLocations) {
            File parent = SystemUtils.resolvePath(location);
            if (!parent.exists() || !parent.isDirectory()) continue;
            locations.add(parent);
            final boolean isWindows = SystemUtils.isWindows();
            final boolean isSolaris = SystemUtils.isSolaris();
            File[] children = parent.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return !(!pathname.isDirectory() || isSolaris && pathname.equals(new File("/export/sybase")) || !isWindows && pathname.getName().startsWith("."));
                }
            });
            if (children != null) {
                for (File child : children) {
                    locations.add(child);
                }
                continue;
            }
            LogManager.log(4, "Can`t get children of existing directory : " + parent.getPath());
        }
    }

    private void fetchLocationsFromEnvironment(List<File> locations) {
        LogManager.logIndent("checking for possible java locations in environment");
        for (String name : JAVA_ENVIRONMENT_VARIABLES) {
            String value = System.getenv(name);
            if (value == null) continue;
            LogManager.log("found: " + name + " = " + value);
            File file = new File(value).getAbsoluteFile();
            if (locations.contains(file)) continue;
            locations.add(file);
        }
        LogManager.logUnindent("... finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchLocationsFromWindowsRegistry(List<File> locations) {
        LogManager.logIndent("checking for possible java locations in windows registry");
        WindowsNativeUtils nativeUtils = (WindowsNativeUtils)SystemUtils.getNativeUtils();
        WindowsRegistry registry = nativeUtils.getWindowsRegistry();
        int currentMode = registry.getMode();
        ArrayList<Boolean> modes = new ArrayList<Boolean>();
        modes.add(null);
        if (registry.isAlternativeModeSupported()) {
            LogManager.log("... alternative registry view is also supported");
            modes.add(new Boolean(true));
        }
        try {
            for (Boolean mode : modes) {
                registry.setMode(mode);
                for (int section : new int[]{2, 1}) {
                    for (String path : JAVA_WINDOWS_REGISTRY_ENTRIES) {
                        if (!registry.keyExists(section, path)) continue;
                        String[] keys = registry.getSubKeyNames(section, path);
                        for (int i = 0; i < keys.length; ++i) {
                            String key = keys[i];
                            if (!registry.valueExists(section, path + "\\" + key, "JavaHome")) continue;
                            String javaHome = registry.getStringValue(section, path + "\\" + key, "JavaHome", false);
                            LogManager.log("found: " + (section == 2 ? "HKEY_LOCAL_MACHINE" : "HKEY_CURRENT_USER") + "\\" + path + "\\" + key + "\\" + "JavaHome" + " = " + javaHome);
                            File file = new File(javaHome);
                            if (!file.exists() || !file.isDirectory() || locations.contains(file)) continue;
                            locations.add(file);
                        }
                    }
                }
            }
        }
        catch (NativeException e) {
            ErrorManager.notify(4, "Failed to search in the windows registry", e);
        }
        finally {
            registry.setMode(currentMode);
        }
        LogManager.logUnindent("... finished");
    }

    private void fetchLocationsFromRegistry(List<File> locations) {
        for (Product jdk : Registry.getInstance().getProducts(JDK_PRODUCT_UID)) {
            if (jdk.getStatus() != Status.INSTALLED || locations.contains(jdk.getInstallationLocation())) continue;
            locations.add(jdk.getInstallationLocation());
        }
        for (Product product : Registry.getInstance().getProducts(Status.TO_BE_INSTALLED)) {
            File sprop;
            String jdkSysPropName = product.getUid() + "." + "jdk.location";
            String jdkSysProp = System.getProperty(jdkSysPropName);
            if (jdkSysProp == null || locations.contains(sprop = new File(jdkSysProp))) continue;
            locations.add(sprop);
        }
    }
}

