/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.netbeans.installer.Installer;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.NbiThread;
import org.netbeans.installer.utils.helper.UiMode;

public final class UiUtils {
    private static boolean lookAndFeelInitialized = false;
    private static LookAndFeelType lookAndFeelType = null;
    public static final String LAF_CLASS_NAME_PROPERTY = "nbi.look.and.feel";
    public static final String LAF_DECORATED_WINDOWS_PROPERTY = "nbi.look.and.feel.decorate.windows";
    public static final String WINDOWS_XP_THEME_MARKER_PROPERTY = "win.xpstyle.themeActive";
    private static final String RESOURCE_FAILED_TO_PARSE_SYSTEM_PROPERTY = "UI.error.failed.to.parse.property";
    private static final String RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF = "UI.error.failed.to.activate.crossplatform.laf";
    private static final String RESOURCE_FAILED_TO_ACTIVATE_DEFINED_LAF = "UI.error.failed.to.activate.defined.laf";
    private static final String RESOURCE_FAILED_TO_INIT_UI = "UI.error.failed.to.init.ui";
    private static final String RESOURCE_FAILED_TO_INIT_UI_HEADLESS = "UI.error.failed.to.init.ui.headless";
    private static final String RESOURCE_FAILED_TO_FORCE_GTK = "UI.error.failed.to.force.gtk";
    private static final String RESOURCE_SILENT_DEFAULT_YES = "UI.silent.default.yes";
    private static final String RESOURCE_SILENT_DEFAULT_NO = "UI.silent.default.no";
    private static final String RESOURCE_SILENT_DEFAULT_CANCEL = "UI.silent.default.cancel";

    public static boolean showMessageDialog(String message, String title, MessageType messageType) {
        UiUtils.initLAF();
        boolean exitInstaller = false;
        switch (UiMode.getCurrentUiMode()) {
            case SWING: {
                int intMessageType = 1;
                LogManager.logIndent("... show message dialog");
                LogManager.log("title: " + title);
                LogManager.log("message: " + message);
                if (messageType == MessageType.WARNING) {
                    intMessageType = 2;
                } else if (messageType == MessageType.CRITICAL) {
                    intMessageType = 0;
                    exitInstaller = true;
                }
                if (messageType == MessageType.ERROR) {
                    int result = JOptionPane.showOptionDialog(null, message, title, 0, 0, null, null, 0);
                    if (result == 1) {
                        exitInstaller = true;
                        LogManager.logUnindent("... user selected: NO");
                    } else {
                        LogManager.logUnindent("... user selected: YES");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, message, title, intMessageType);
                }
                LogManager.logUnindent("... dialog closed");
                break;
            }
            case SILENT: {
                LogManager.log(message);
                System.err.println(message);
            }
        }
        return exitInstaller;
    }

    public static boolean showYesNoDialog(String title, String message) {
        return UiUtils.showYesNoDialog(title, message, false);
    }

    public static boolean showYesNoDialog(String title, String message, boolean silentDefault) {
        UiUtils.initLAF();
        switch (UiMode.getCurrentUiMode()) {
            case SWING: {
                LogManager.logIndent("... showing Yes/No dialog");
                LogManager.log("title: " + title);
                LogManager.log("message: " + message);
                int result = JOptionPane.showConfirmDialog(null, message, title, 0);
                LogManager.logUnindent("... dialog closed, choice : " + (result == 0 ? "yes" : (result == 1 ? "no" : "closed")));
                return result == 0;
            }
            case SILENT: {
                LogManager.log(message);
                String option = StringUtils.format(ResourceUtils.getString(UiUtils.class, silentDefault ? RESOURCE_SILENT_DEFAULT_YES : RESOURCE_SILENT_DEFAULT_NO), new Object[0]);
                System.err.println(message);
                System.err.println(option);
                LogManager.log(message);
                LogManager.log(option);
                return silentDefault;
            }
        }
        return true;
    }

    public static int showYesNoCancelDialog(String title, String message, int silentDefault) {
        UiUtils.initLAF();
        switch (UiMode.getCurrentUiMode()) {
            case SWING: {
                LogManager.logIndent("... show Yes/No/Cancel dialog");
                LogManager.log("title: " + title);
                LogManager.log("message: " + message);
                int result = JOptionPane.showConfirmDialog(null, message, title, 1);
                LogManager.logUnindent("... dialog closed, choice : " + (result == 0 ? "yes" : (result == 1 ? "no" : (result == 2 ? "cancel" : "closed"))));
                return result;
            }
            case SILENT: {
                String resource;
                LogManager.log(message);
                switch (silentDefault) {
                    case 0: {
                        resource = RESOURCE_SILENT_DEFAULT_YES;
                        break;
                    }
                    case 1: {
                        resource = RESOURCE_SILENT_DEFAULT_NO;
                        break;
                    }
                    case 2: {
                        resource = RESOURCE_SILENT_DEFAULT_CANCEL;
                        break;
                    }
                    default: {
                        resource = "";
                    }
                }
                String option = StringUtils.format(ResourceUtils.getString(UiUtils.class, resource), new Object[0]);
                System.err.println(message);
                System.err.println(option);
                LogManager.log(message);
                LogManager.log(option);
                return silentDefault;
            }
        }
        return silentDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initializeLookAndFeel() throws InitializationException {
        if (lookAndFeelInitialized) {
            return;
        }
        try {
            LogManager.log("... initializing look and feel");
            LogManager.indent();
            switch (UiMode.getCurrentUiMode()) {
                case SWING: {
                    String className = System.getProperty(LAF_CLASS_NAME_PROPERTY);
                    if (className == null) {
                        LogManager.log("... custom look and feel class name was not specified, using system default");
                        className = UiUtils.getDefaultLookAndFeelClassName();
                    } else if (!className.contains(".")) {
                        className = UiUtils.getLookAndFeelClassNameByShortName(className);
                    }
                    LogManager.log("... class name: " + className);
                    if (Boolean.getBoolean(LAF_DECORATED_WINDOWS_PROPERTY)) {
                        JFrame.setDefaultLookAndFeelDecorated(true);
                    }
                    try {
                        Thread jdkFileChooserWarningLogThread = null;
                        try {
                            LogManager.log("... get installed L&Fs");
                            UIManager.getInstalledLookAndFeels();
                            LogManager.log("... set specified L&F");
                            UIManager.setLookAndFeel(className);
                            LogManager.log("... check headless");
                            if (GraphicsEnvironment.isHeadless()) {
                                HeadlessException e = new HeadlessException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_INIT_UI_HEADLESS));
                                System.err.println(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_INIT_UI));
                                System.err.println(e.getMessage());
                                throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_INIT_UI), e);
                            }
                            if (System.getProperty("os.name").startsWith("Windows")) {
                                LogManager.log("... creating JFileChooser object to check possible issues with UI");
                                if (System.getProperty("java.version").startsWith("1.6")) {
                                    File desktop = new File(SystemUtils.getUserHomeDirectory(), "Desktop");
                                    File[] zips = null;
                                    final ArrayList names = new ArrayList();
                                    if (FileUtils.exists(desktop)) {
                                        zips = desktop.listFiles(new FileFilter(){

                                            @Override
                                            public boolean accept(File pathname) {
                                                boolean result;
                                                boolean bl = result = pathname.getName().endsWith(".zip") && pathname.length() > 1000000L;
                                                if (result) {
                                                    names.add(pathname.getName());
                                                }
                                                return result;
                                            }
                                        });
                                    }
                                    if (zips != null && zips.length > 0) {
                                        jdkFileChooserWarningLogThread = new NbiThread(){

                                            @Override
                                            public void run() {
                                                try {
                                                    2.sleep(8000L);
                                                }
                                                catch (InterruptedException e) {
                                                    return;
                                                }
                                                File lock = new File(Installer.getInstance().getLocalDirectory(), ".nbilock");
                                                LogManager.log("\n... !!! WARNING !!!");
                                                LogManager.log("... There are some big zip files on your desktop: " + StringUtils.asString(names));
                                                LogManager.log("... In case installer UI does not appear for a long time:");
                                                LogManager.log("...    1) kill the installer process");
                                                LogManager.log("...    2) move those zip files somewhere from the desktop");
                                                LogManager.log("...    3) delete " + lock);
                                                LogManager.log("...    4) run installer again");
                                                LogManager.log("... For more details see the following bugs descriptions: ");
                                                LogManager.log("... http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6372808");
                                                LogManager.log("... http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5050516");
                                            }
                                        };
                                        jdkFileChooserWarningLogThread.start();
                                    }
                                }
                                if (SwingUtilities.isEventDispatchThread()) {
                                    new JFileChooser();
                                } else {
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            @Override
                                            public void run() {
                                                new JFileChooser();
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable throwable;
                                        if (e.getCause() != null) {
                                            throwable = e.getCause();
                                            throw throwable;
                                        }
                                        throwable = e;
                                        throw throwable;
                                    }
                                }
                                if (jdkFileChooserWarningLogThread != null) {
                                    jdkFileChooserWarningLogThread.interrupt();
                                    jdkFileChooserWarningLogThread = null;
                                }
                                LogManager.log("... getting default Toolkit to check possible issues with UI");
                                Toolkit.getDefaultToolkit();
                                LogManager.log("... creating JProgressBar object to check possible issues with UI");
                                new JProgressBar().getMaximumSize();
                                LogManager.log("... all UI checks done");
                            }
                            LogManager.log("... L&F is set");
                            return;
                        }
                        catch (Throwable e) {
                            Throwable cause;
                            if (jdkFileChooserWarningLogThread != null) {
                                jdkFileChooserWarningLogThread.interrupt();
                                jdkFileChooserWarningLogThread = null;
                            }
                            LogManager.log("... could not activate defined L&F, initializing cross-platfrom one", e);
                            if (e instanceof InternalError) {
                                System.err.println(e.getMessage());
                            } else if (e instanceof ExceptionInInitializerError && (cause = e.getCause()) != null && cause instanceof HeadlessException) {
                                System.err.println(cause.getMessage());
                            }
                            className = UIManager.getCrossPlatformLookAndFeelClassName();
                            LogManager.log("... cross-platform L&F class-name : " + className);
                            UIManager.setLookAndFeel(className);
                            if (System.getProperty(LAF_CLASS_NAME_PROPERTY) == null) return;
                            throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_DEFINED_LAF), e);
                        }
                    }
                    catch (NoClassDefFoundError e) {
                        throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF), e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF), e);
                    }
                    catch (InstantiationException e) {
                        throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF), e);
                    }
                    catch (UnsupportedLookAndFeelException e) {
                        throw new InitializationException(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_ACTIVATE_CROSSPLATFORM_LAF), e);
                    }
                }
            }
            return;
        }
        finally {
            LogManager.unindent();
            LogManager.log("... initializing L&F finished");
            if (Boolean.getBoolean("nbi.look.and.feel.dump.defaults")) {
                try {
                    LogManager.logIndent("... dumping UIManger L&F defaults: ");
                    UIDefaults hash = UIManager.getLookAndFeelDefaults();
                    Enumeration keys = hash.keys();
                    while (keys.hasMoreElements()) {
                        Object key = keys.nextElement();
                        LogManager.log("" + key + " = " + ((Hashtable)hash).get(key));
                    }
                }
                catch (Exception e) {
                    LogManager.log(e);
                }
                finally {
                    LogManager.unindent();
                }
            }
            lookAndFeelInitialized = true;
            lookAndFeelType = UiUtils.getLAF();
        }
    }

    public static String getDefaultLookAndFeelClassName() {
        switch (UiMode.getCurrentUiMode()) {
            case SWING: {
                String className = UIManager.getSystemLookAndFeelClassName();
                if (className.equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
                    try {
                        if (System.getProperty("os.name").contains("Linux") && System.getenv("KDE_FULL_SESSION") != null) {
                            Class.forName(LookAndFeelType.GTK.getClassName());
                            className = LookAndFeelType.GTK.getClassName();
                        }
                    }
                    catch (ClassNotFoundException e) {
                        ErrorManager.notifyDebug(ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_FORCE_GTK), e);
                    }
                }
                return className;
            }
        }
        return null;
    }

    public static final String getLookAndFeelClassNameByShortName(String name) {
        if (name == null) {
            return null;
        }
        for (LookAndFeelType lafType : LookAndFeelType.values()) {
            if (lafType.getId() == null || lafType.getClassName() == null || !name.toLowerCase(Locale.ENGLISH).equals(lafType.getId().toLowerCase(Locale.ENGLISH))) continue;
            return lafType.getClassName();
        }
        return name;
    }

    public static final LookAndFeelType getLAF() {
        if (lookAndFeelType == null) {
            LookAndFeel laf;
            try {
                UiUtils.initializeLookAndFeel();
            }
            catch (InitializationException e) {
                LogManager.log(e);
            }
            lookAndFeelType = LookAndFeelType.DEFAULT;
            if (UiMode.getCurrentUiMode() == UiMode.SWING && (laf = UIManager.getLookAndFeel()) != null) {
                String id = laf.getID();
                for (LookAndFeelType type : LookAndFeelType.values()) {
                    if (id.equals(LookAndFeelType.WINDOWS_XP.getId()) || id.equals(LookAndFeelType.WINDOWS_CLASSIC.getId())) {
                        Object object = Toolkit.getDefaultToolkit().getDesktopProperty(WINDOWS_XP_THEME_MARKER_PROPERTY);
                        boolean xpThemeActive = false;
                        if (object != null) {
                            xpThemeActive = (Boolean)object;
                        }
                        lookAndFeelType = xpThemeActive ? LookAndFeelType.WINDOWS_XP : LookAndFeelType.WINDOWS_CLASSIC;
                        break;
                    }
                    if (!id.equals(type.getId())) continue;
                    lookAndFeelType = type;
                    break;
                }
            }
        }
        return lookAndFeelType;
    }

    private static void initLAF() {
        try {
            UiUtils.initializeLookAndFeel();
        }
        catch (InitializationException e) {
            ErrorManager.notifyWarning(e.getMessage(), e.getCause());
        }
    }

    private UiUtils() {
    }

    public static int getDimension(Properties props, String defaultPropertyName, int defaultValue) {
        int dimension = defaultValue;
        String propertyName = defaultPropertyName;
        if (props.getProperty(propertyName + "." + (Object)((Object)UiUtils.getLAF())) != null) {
            propertyName = propertyName + "." + (Object)((Object)UiUtils.getLAF());
        }
        if (props.getProperty(propertyName) != null) {
            try {
                dimension = Integer.parseInt(props.getProperty(propertyName).trim());
            }
            catch (NumberFormatException e) {
                String warning = ResourceUtils.getString(UiUtils.class, RESOURCE_FAILED_TO_PARSE_SYSTEM_PROPERTY, propertyName, props.getProperty(propertyName));
                ErrorManager.notifyWarning(warning, e);
            }
        }
        return dimension;
    }

    public static enum LookAndFeelType {
        WINDOWS_XP("win.xp", "Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"),
        WINDOWS_CLASSIC("win.classic", "Windows", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"),
        MOTIF("motif", "Motif", "com.sun.java.swing.plaf.motif.MotifLookAndFeel"),
        GTK("gtk", "GTK", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"),
        METAL("metal", "Metal", "javax.swing.plaf.metal.MetalLookAndFeel"),
        AQUA("aqua", "Aqua", "apple.laf.AquaLookAndFeel"),
        NIMBUS("nimbus", "Nimbus", "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"),
        DEFAULT("default", null, null);

        private String name;
        private String className;
        private String id;

        public String toString() {
            return this.name;
        }

        private LookAndFeelType(String name, String id, String className) {
            this.name = name;
            this.id = id;
            this.className = className;
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static enum MessageType {
        INFORMATION,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

