/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.UiUtils;

final class SecurityUtils {
    private static KeyStore caStore;
    private static KeyStore permanentTrustedStore;
    private static KeyStore sessionTrustedStore;
    private static KeyStore deniedStore;
    private static String CACERTS_FILE_PATH;
    private static final int BUFFER_SIZE = 4096;

    SecurityUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJarSignatureVeryfied(File file, String description) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (caStore == null) {
            caStore = KeyStore.getInstance(KeyStore.getDefaultType());
            File cacertsFile = new File(SystemUtils.getCurrentJavaHome(), CACERTS_FILE_PATH);
            caStore.load(new FileInputStream(cacertsFile), null);
            permanentTrustedStore = KeyStore.getInstance(KeyStore.getDefaultType());
            permanentTrustedStore.load(null, null);
            sessionTrustedStore = KeyStore.getInstance(KeyStore.getDefaultType());
            sessionTrustedStore.load(null, null);
            deniedStore = KeyStore.getInstance(KeyStore.getDefaultType());
            deniedStore.load(null, null);
        }
        JarFile jar = new JarFile(file);
        try {
            Certificate[] certificates = null;
            CodeSigner[] codeSigners = null;
            for (JarEntry entry : Collections.list(jar.entries())) {
                SecurityUtils.readFully(jar.getInputStream(entry));
                certificates = entry.getCertificates();
                codeSigners = entry.getCodeSigners();
                if (certificates == null) continue;
                break;
            }
            if (certificates == null) {
                // empty if block
            }
            int chainStart = 0;
            int chainEnd = 0;
            int chainNum = 0;
            while (chainEnd < certificates.length) {
                boolean isIssuer;
                int i;
                for (i = chainStart; i < certificates.length - 1; ++i) {
                    isIssuer = SecurityUtils.isIssuerOf((X509Certificate)certificates[i], (X509Certificate)certificates[i + 1]);
                    if (!(certificates[i] instanceof X509Certificate) || !(certificates[i + 1] instanceof X509Certificate) || !isIssuer) break;
                }
                chainEnd = i + 1;
                if (SecurityUtils.containsCertificate(deniedStore, certificates[chainStart])) {
                    isIssuer = false;
                    return isIssuer;
                }
                if (SecurityUtils.containsCertificate(permanentTrustedStore, certificates[chainStart]) || SecurityUtils.containsCertificate(sessionTrustedStore, certificates[chainStart])) {
                    isIssuer = true;
                    return isIssuer;
                }
                chainStart = chainEnd;
                ++chainNum;
            }
            boolean rootCANotValid = false;
            boolean timeNotValid = false;
            chainStart = 0;
            chainEnd = 0;
            chainNum = 0;
            while (chainEnd < certificates.length) {
                CertificateAcceptanceStatus status;
                int i = chainStart;
                for (i = chainStart; i < certificates.length; ++i) {
                    X509Certificate currentCert = null;
                    X509Certificate issuerCert = null;
                    if (certificates[i] instanceof X509Certificate) {
                        currentCert = (X509Certificate)certificates[i];
                    }
                    issuerCert = i < certificates.length - 1 && certificates[i + 1] instanceof X509Certificate ? (X509Certificate)certificates[i + 1] : currentCert;
                    try {
                        currentCert.checkValidity();
                    }
                    catch (CertificateExpiredException e1) {
                        timeNotValid = true;
                    }
                    catch (CertificateNotYetValidException e2) {
                        timeNotValid = true;
                    }
                    if (!SecurityUtils.isIssuerOf(currentCert, issuerCert)) break;
                    try {
                        currentCert.verify(issuerCert.getPublicKey());
                        continue;
                    }
                    catch (GeneralSecurityException e) {
                        boolean bl = false;
                        jar.close();
                        return bl;
                    }
                }
                chainEnd = i < certificates.length ? i + 1 : i;
                rootCANotValid = !SecurityUtils.verifyCertificate(caStore, certificates[chainEnd - 1]);
                Date timestamp = null;
                if (codeSigners[chainNum].getTimestamp() != null) {
                    timestamp = codeSigners[chainNum].getTimestamp().getTimestamp();
                }
                if ((status = SecurityUtils.showCertificateAcceptanceDialog(certificates, chainStart, chainEnd, rootCANotValid, timeNotValid, timestamp, description)) == CertificateAcceptanceStatus.ACCEPT_PERMANENTLY) {
                    SecurityUtils.addCertificate(permanentTrustedStore, certificates[chainStart]);
                    boolean bl = true;
                    return bl;
                }
                if (status == CertificateAcceptanceStatus.ACCEPT_FOR_THIS_SESSION) {
                    SecurityUtils.addCertificate(sessionTrustedStore, certificates[chainStart]);
                    boolean bl = true;
                    return bl;
                }
                SecurityUtils.addCertificate(deniedStore, certificates[chainStart]);
                chainStart = chainEnd;
                ++chainNum;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            jar.close();
        }
    }

    private static void readFully(InputStream stream) throws IOException {
        byte[] buffer = new byte[4096];
        while (stream.read(buffer) != -1) {
        }
    }

    private static boolean isIssuerOf(X509Certificate certificate1, X509Certificate certificate2) {
        return ((Object)certificate1.getIssuerDN()).equals(certificate2.getSubjectDN());
    }

    private static boolean containsCertificate(KeyStore store, Certificate certificate) throws KeyStoreException {
        return store.getCertificateAlias(certificate) != null;
    }

    private static void addCertificate(KeyStore store, Certificate certificate) throws KeyStoreException {
        if (store.getCertificateAlias(certificate) == null) {
            store.setCertificateEntry("alias" + new Random().nextLong(), certificate);
        }
    }

    private static boolean verifyCertificate(KeyStore store, Certificate certificate) throws KeyStoreException {
        for (String alias : Collections.list(store.aliases())) {
            try {
                certificate.verify(store.getCertificate(alias).getPublicKey());
                return true;
            }
            catch (GeneralSecurityException e) {
            }
        }
        return false;
    }

    private static CertificateAcceptanceStatus showCertificateAcceptanceDialog(Certificate[] certificates, int chainStart, int chainEnd, boolean rootCaIsNotValid, boolean timeIsNotValid, Date timestamp, String description) {
        if (certificates[chainStart] instanceof X509Certificate && certificates[chainEnd - 1] instanceof X509Certificate) {
            DateFormat df;
            X509Certificate firstCert = (X509Certificate)certificates[chainStart];
            X509Certificate lastCert = (X509Certificate)certificates[chainEnd - 1];
            Principal subject = firstCert.getSubjectDN();
            Principal issuer = lastCert.getIssuerDN();
            String subjectName = SecurityUtils.extractName(subject.getName(), "CN=", "Unknown Subject");
            String issuerName = SecurityUtils.extractName(issuer.getName(), "O=", "Unknown Issuer");
            String caption = null;
            String body = "";
            if (!rootCaIsNotValid && !timeIsNotValid) {
                caption = StringUtils.format("The digital signature of {0} has been verified.", description);
                body = body + "The digital signature has been validated by a trusted source. The security certificate was issued by a company that is trusted";
                if (timestamp != null) {
                    df = DateFormat.getDateTimeInstance(1, 1);
                    body = body + StringUtils.format(" and was valid at the time of signing on {0}.", df.format(timestamp));
                } else {
                    body = body + ", has not expired and is still valid.";
                }
                body = body + StringUtils.format("Caution: \"{0}\" asserts that this content is safe.  You should only accept this content if you trust \"{1}\" to make that assertion.", subjectName, subjectName);
            } else {
                if (rootCaIsNotValid) {
                    caption = StringUtils.format("The digital signature of {0} cannot be verified.", description);
                    body = body + "The digital signature cannot be verified by a trusted source. Only continue if you trust the origin of the file. The security certificate was issued by a company that is not trusted.";
                } else {
                    caption = StringUtils.format("The digital signature of {0} has been verified.", description);
                    body = body + "The security certificate was issued by a company that is trusted.";
                }
                if (timeIsNotValid) {
                    body = body + "The digital signature was generated with a trusted certificate but has expired or is not yet valid";
                } else if (timestamp != null) {
                    df = DateFormat.getDateTimeInstance(1, 1);
                    body = body + StringUtils.format("The security certificate was valid at the time of signing on {0}.", df.format(timestamp));
                } else {
                    body = body + "The security certificate has not expired and is still valid.";
                }
            }
            String message = StringUtils.format("<html><b>{0}</b><br>Subject: {1}<br>Issuer: {2}<br><br>{3}<br><br>Click OK to accept the certificate permanently, No to accept it temporary for this session, Cancel to reject the certificate.", caption, subjectName, issuerName, body);
            int option = UiUtils.showYesNoCancelDialog(null, message, 1);
            if (option == 0) {
                return CertificateAcceptanceStatus.ACCEPT_PERMANENTLY;
            }
            if (option == 1) {
                return CertificateAcceptanceStatus.ACCEPT_FOR_THIS_SESSION;
            }
            return CertificateAcceptanceStatus.DENY;
        }
        return CertificateAcceptanceStatus.DENY;
    }

    private static String extractName(String nameString, String prefix, String defaultValue) {
        int i = nameString.indexOf(prefix);
        int j = 0;
        if (i < 0) {
            return defaultValue;
        }
        try {
            j = nameString.charAt(i += prefix.length()) == '\"' ? nameString.indexOf(34, ++i) : nameString.indexOf(44, i);
            if (j < 0) {
                return nameString.substring(i);
            }
            return nameString.substring(i, j);
        }
        catch (IndexOutOfBoundsException e) {
            return defaultValue;
        }
    }

    static {
        CACERTS_FILE_PATH = "lib/security/cacerts";
    }

    public static enum CertificateAcceptanceStatus {
        ACCEPT_PERMANENTLY,
        ACCEPT_FOR_THIS_SESSION,
        DENY;

    }
}

