/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Image;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AvailableTableModel
extends UnitCategoryTableModel {
    private OperationContainer container = Containers.forAvailable();
    private OperationContainer containerCustom = Containers.forCustomInstall();
    private static String col0;
    private static String col1;
    private static String col2;
    private static String col3;

    public AvailableTableModel(List<UpdateUnit> units) {
        this.setUnits(units);
    }

    @Override
    public final void setUnits(List<UpdateUnit> units) {
        this.setData(Utilities.makeAvailableCategories(units, false));
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        if (this.isExpansionControlAtRow(row)) {
            return;
        }
        if (col == 1) {
            return;
        }
        super.setValueAt(anValue, row, col);
        if (anValue == null) {
            return;
        }
        Unit.Available u = (Unit.Available)this.getUnitAtRow(row);
        assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
        boolean beforeMarked = u.isMarked();
        if ((Boolean)anValue != beforeMarked) {
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
            } else if (u.getRelevantElement().getUpdateUnit().getInstalled() != null) {
                this.fireUpdataUnitChange();
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.unit_already_installed(u.getDisplayName()), 2));
            } else {
                String message = this.getBundle("NotificationAlreadyPreparedToIntsall", u.getDisplayName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        if (this.isExpansionControlAtRow(row)) {
            return "";
        }
        Unit.Available u = (Unit.Available)this.getUnitAtRow(row);
        if (u == null) {
            return null;
        }
        switch (col) {
            case 0: {
                res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                res = u.getDisplayName();
                break;
            }
            case 2: {
                res = u.getCategoryName();
                break;
            }
            case 3: {
                res = u.getSourceIcon();
            }
        }
        return res;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = Image.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (col0 == null) {
                    col0 = this.getBundle("AvailableTableModel_Columns_Install", new Object[0]);
                }
                return col0;
            }
            case 1: {
                if (col1 == null) {
                    col1 = this.getBundle("AvailableTableModel_Columns_Name", new Object[0]);
                }
                return col1;
            }
            case 2: {
                if (col2 == null) {
                    col2 = this.getBundle("AvailableTableModel_Columns_Category", new Object[0]);
                }
                return col2;
            }
            case 3: {
                if (col3 == null) {
                    col3 = this.getBundle("AvailableTableModel_Source_Category", new Object[0]);
                }
                return col3;
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public String getToolTipText(int row, int col) {
        if (col == 3) {
            Unit.Available u = (Unit.Available)this.getUnitAtRow(row);
            return u.getSourceDescription();
        }
        return super.getToolTipText(row, col);
    }

    @Override
    public int getPreferredWidth(JTableHeader header, int col) {
        int minWidth = super.getMinWidth(header, col);
        switch (col) {
            case 1: {
                return minWidth * 4;
            }
            case 2: {
                return minWidth * 2;
            }
        }
        return minWidth;
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.AVAILABLE;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isInstall = this.getColumnName(0).equals(columnIdentifier);
        return !isInstall;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (AvailableTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (AvailableTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (AvailableTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.compareCategories(unit1, unit2);
                    }
                    if (AvailableTableModel.this.getColumnName(3).equals(columnIdentifier)) {
                        return Unit.Available.compareSourceCategories(unit1, unit2);
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        int res = 0;
        assert (this.container != null || this.containerCustom != null) : "OperationContainer found when asking for download size.";
        HashSet infos = new HashSet();
        infos.addAll(this.container.listAll());
        infos.addAll(this.containerCustom.listAll());
        HashSet<UpdateElement> elements = new HashSet<UpdateElement>();
        for (OperationContainer.OperationInfo info : infos) {
            elements.add(info.getUpdateElement());
            elements.addAll(info.getRequiredElements());
        }
        for (UpdateElement el : elements) {
            res += el.getDownloadSize();
        }
        return res;
    }

    private String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(this.getClass(), (String)key, (Object[])params);
    }

    @Override
    public String getTabTooltipText() {
        if (this.isTabEnabled()) {
            return super.getTabTooltipText();
        }
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_ToolTip");
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Available_Title");
    }

    @Override
    public int getTabIndex() {
        return 1;
    }

    @Override
    public boolean isTabEnabled() {
        return true;
    }

    @Override
    public boolean needsRestart() {
        return false;
    }
}

