/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.ioprovider;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.ActiveRegion;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.openide.util.Exceptions;
import org.openide.windows.IOContainer;
import org.openide.windows.IOSelect;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;

abstract class Task {
    private static int scheduledTasks;
    private final IOContainer container;
    private final Terminal terminal;

    public final void post() {
        ++scheduledTasks;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Task.this.dispatch();
                }
            });
            return;
        }
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        try {
            if (this.terminal().isDisposed() && !this.isValueTask()) {
                return;
            }
            this.perform();
        }
        finally {
            --scheduledTasks;
        }
    }

    static boolean isQuiescent() {
        return scheduledTasks == 0;
    }

    protected abstract void perform();

    protected boolean isValueTask() {
        return false;
    }

    protected Task(IOContainer container, Terminal terminal) {
        this.container = container;
        this.terminal = terminal;
    }

    protected Task(Terminal terminal) {
        this.container = null;
        this.terminal = terminal;
    }

    protected final IOContainer container() {
        return this.container;
    }

    protected final Terminal terminal() {
        return this.terminal;
    }

    static class Add
    extends Task {
        private final Action[] actions;

        public Add(IOContainer container, Terminal terminal, Action[] actions) {
            super(container, terminal);
            this.actions = actions;
        }

        @Override
        public void perform() {
            this.container().add((JComponent)this.terminal(), this.terminal().callBacks());
            this.container().setToolbarActions((JComponent)this.terminal(), this.actions);
            this.terminal().setVisibleInContainer(true);
            this.terminal().setTitle(this.terminal().name());
        }
    }

    static class BeginActiveRegion
    extends Task {
        private final OutputListener listener;

        public BeginActiveRegion(Terminal terminal, OutputListener listener) {
            super(terminal);
            this.listener = listener;
        }

        @Override
        protected void perform() {
            ActiveRegion ar = this.terminal().term().beginRegion(true);
            ar.setUserObject((Object)this.listener);
            ar.setLink(true);
        }
    }

    static class ClearHistory
    extends Task {
        public ClearHistory(Terminal terminal) {
            super(terminal);
        }

        @Override
        protected void perform() {
            this.terminal().term().clearHistory();
        }
    }

    static class Connect
    extends Task {
        private final OutputStream pin;
        private final InputStream pout;
        private final InputStream perr;

        public Connect(Terminal terminal, OutputStream pin, InputStream pout, InputStream perr) {
            super(terminal);
            this.pin = pin;
            this.pout = pout;
            this.perr = perr;
        }

        @Override
        protected void perform() {
            this.terminal().term().connect(this.pin, this.pout, this.perr);
            this.terminal().setExtConnected(true);
        }
    }

    static class DeSelect
    extends Task {
        public DeSelect(IOContainer container, Terminal terminal) {
            super(container, terminal);
        }

        @Override
        public void perform() {
            this.container().setToolbarActions((JComponent)this.terminal(), new Action[0]);
            this.terminal().closeUnconditionally();
        }
    }

    static class Disconnect
    extends Task {
        private final Runnable continuation;

        public Disconnect(Terminal terminal, Runnable continuation) {
            super(terminal);
            this.continuation = continuation;
        }

        @Override
        protected void perform() {
            this.terminal().term().disconnect(new Runnable(){

                @Override
                public void run() {
                    Disconnect.this.terminal().setExtConnected(false);
                    if (Disconnect.this.continuation != null) {
                        Disconnect.this.continuation.run();
                    }
                }
            });
        }
    }

    static class EndActiveRegion
    extends Task {
        public EndActiveRegion(Terminal terminal) {
            super(terminal);
        }

        @Override
        protected void perform() {
            this.terminal().term().endRegion();
        }
    }

    static class GetIn
    extends ValueTask<Reader>
    implements Callable<Reader> {
        public GetIn(Terminal terminal) {
            super(terminal);
        }

        @Override
        public Reader call() {
            return this.terminal().term().getIn();
        }
    }

    static class GetOut
    extends ValueTask<Writer>
    implements Callable<Writer> {
        public GetOut(Terminal terminal) {
            super(terminal);
        }

        @Override
        public Writer call() {
            return this.terminal().term().getOut();
        }
    }

    static class GetPosition
    extends ValueTask<Coord>
    implements Callable<Coord> {
        public GetPosition(Terminal terminal) {
            super(terminal);
        }

        @Override
        public Coord call() {
            return this.terminal().term().getCursorCoord();
        }
    }

    static class IsClosable
    extends ValueTask<Boolean>
    implements Callable<Boolean> {
        public IsClosable(Terminal terminal) {
            super(terminal);
        }

        @Override
        public Boolean call() {
            return this.terminal().isClosable();
        }
    }

    static class Scroll
    extends Task {
        private final Coord coord;

        public Scroll(Terminal terminal, Coord coord) {
            super(terminal);
            this.coord = coord;
        }

        @Override
        public void perform() {
            this.terminal().scrollTo(this.coord);
        }
    }

    static class Select
    extends Task {
        private final Set<IOSelect.AdditionalOperation> extraOps;

        public Select(IOContainer container, Terminal terminal, Set<IOSelect.AdditionalOperation> extraOps) {
            super(container, terminal);
            this.extraOps = extraOps;
        }

        @Override
        public void perform() {
            if (this.terminal().isDisposed()) {
                return;
            }
            this.terminal().setClosedUnconditionally(false);
            if (!this.terminal().isVisibleInContainer()) {
                this.container().add((JComponent)this.terminal(), this.terminal().callBacks());
                this.terminal().setVisibleInContainer(true);
            }
            if (this.extraOps != null) {
                if (this.extraOps.contains(IOSelect.AdditionalOperation.OPEN)) {
                    this.container().open();
                }
                if (this.extraOps.contains(IOSelect.AdditionalOperation.REQUEST_VISIBLE)) {
                    this.container().requestVisible();
                }
                if (this.extraOps.contains(IOSelect.AdditionalOperation.REQUEST_ACTIVE)) {
                    this.container().requestActive();
                }
            }
            this.container().select((JComponent)this.terminal());
        }
    }

    static class SetClosable
    extends Task {
        private final boolean closable;

        public SetClosable(IOContainer container, Terminal terminal, boolean closable) {
            super(container, terminal);
            this.closable = closable;
        }

        @Override
        public void perform() {
            this.terminal().setClosable(this.closable);
        }
    }

    static class SetCustomColor
    extends Task {
        private final int index;
        private final Color color;

        public SetCustomColor(Terminal terminal, int index, Color color) {
            super(terminal);
            this.index = index;
            this.color = color;
        }

        @Override
        protected void perform() {
            this.terminal().term().setCustomColor(this.index, this.color);
        }
    }

    static class SetDisciplined
    extends Task {
        private final boolean disciplined;

        public SetDisciplined(Terminal terminal, boolean disciplined) {
            super(terminal);
            this.disciplined = disciplined;
        }

        @Override
        public void perform() {
            if (this.disciplined) {
                this.terminal().term().pushStream((TermStream)new LineDiscipline());
            }
        }
    }

    static class SetIcon
    extends Task {
        private final Icon icon;

        public SetIcon(IOContainer container, Terminal terminal, Icon icon) {
            super(container, terminal);
            this.icon = icon;
        }

        @Override
        public void perform() {
            this.container().setIcon((JComponent)this.terminal(), this.icon);
        }
    }

    static class SetToolTipText
    extends Task {
        private final String text;

        public SetToolTipText(IOContainer container, Terminal terminal, String text) {
            super(container, terminal);
            this.text = text;
        }

        @Override
        public void perform() {
            this.container().setToolTipText((JComponent)this.terminal(), this.text);
        }
    }

    static class StrongClose
    extends Task {
        public StrongClose(IOContainer container, Terminal terminal) {
            super(container, terminal);
        }

        @Override
        public void perform() {
            this.terminal().closeUnconditionally();
            this.terminal().dispose();
        }
    }

    static class UpdateName
    extends Task {
        public UpdateName(IOContainer container, Terminal terminal) {
            super(container, terminal);
        }

        @Override
        public void perform() {
            if (!this.terminal().isVisibleInContainer()) {
                return;
            }
            String newTitle = this.terminal().getTitle();
            if (this.terminal().isConnected() && newTitle != null) {
                String escaped;
                try {
                    escaped = XMLUtil.toAttributeValue((String)newTitle);
                }
                catch (CharConversionException ex) {
                    escaped = newTitle;
                }
                newTitle = "<html><b>" + escaped + "</b></html>";
            }
            this.container().setTitle((JComponent)this.terminal(), newTitle);
        }
    }

    public static abstract class ValueTask<V>
    extends Task
    implements Callable<V> {
        private final FutureTask<V> future = new FutureTask(this);

        protected ValueTask(Terminal terminal) {
            super(terminal);
        }

        @Override
        public abstract V call();

        @Override
        protected final void perform() {
            this.future.run();
        }

        @Override
        protected boolean isValueTask() {
            return true;
        }

        public V get() {
            try {
                return this.future.get();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }
}

