/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.jboss;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.TargetPlatform;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.jboss.Bundle;
import org.netbeans.modules.profiler.j2ee.jboss.JBossIntegrationPanel;

public abstract class AbstractJBossIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final String JBOSS_RUN_SCRIPT = "run";
    private static final String JBOSS_HOME_VAR_STRING = "JBOSS_HOME";
    private static final String INSERTION_POINT_NOWIN_0_STRING = "#!/bin/sh";
    private static final String INSERTION_POINT_WIN_1_STRING = "@if not \"%ECHO%\" == \"\"";
    private static final String INSERTION_POINT_NONWIN_1_STRING = "DIRNAME=`dirname $0`";
    private static final String RUN_MOD_EXT_STRING = "_nbprofiler";
    private SettingsPersistor persistor;

    public AbstractJBossIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep("JBoss provider settings", (WizardScreen)new JBossIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "JBossIntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties settings) {
                AbstractJBossIntegrationProvider.this.setTargetJava(settings.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", ""));
                AbstractJBossIntegrationProvider.this.setInstallationPath(settings.getProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                if (AbstractJBossIntegrationProvider.this.getInstallationPath() == null || AbstractJBossIntegrationProvider.this.getInstallationPath().length() == 0) {
                    AbstractJBossIntegrationProvider.this.setInstallationPath(AbstractJBossIntegrationProvider.this.getDefaultInstallationPath());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties settings = new Properties();
                settings.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", AbstractJBossIntegrationProvider.this.getTargetJava());
                settings.setProperty("JBossIntegrationProvider_" + AbstractJBossIntegrationProvider.this.getMagicNumber() + "_InstallDir", AbstractJBossIntegrationProvider.this.getInstallationPath());
                return settings;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean automation) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            instructions.addStep(Bundle.JBossIntegrationProvider_AdditionalStepsStep1DirectMsg(this.getModifiedScriptPath(targetOS, false)));
        } else {
            instructions.addStep(Bundle.JBossIntegrationProvider_AdditionalStepsStep1DynamicMsg(this.getModifiedScriptPath(targetOS, false)));
        }
        instructions.addStep(Bundle.JBossIntegrationProvider_AdditionalStepsStep2Msg());
        if (attachSettings.isDirect()) {
            instructions.addStep(Bundle.JBossIntegrationProvider_AdditionalStepsStep3DirectMsg());
        } else {
            instructions.addStep(Bundle.JBossIntegrationProvider_AdditionalStepsStep3DynamicPidMsg());
            instructions.addWarning(Bundle.JBossIntegrationProvider_DynamicWarningMessage(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        }
        instructions.addHint(Bundle.JBossIntegrationProvider_AdditionalStepsAutoStartMsg());
        return instructions;
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        String agentArgs = IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)attachSettings.getPort());
        instructions.addStep(Bundle.JBossIntegrationProvider_IntegrReviewStep1Msg(new File(this.getScriptPath(targetOS, true)), this.getModifiedScriptPath(targetOS, true)));
        instructions.addStep(Bundle.JBossIntegrationProvider_IntegrReviewStep2Msg(IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + "<br>" + (attachSettings.isDirect() ? "" + IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)agentArgs) + "<br>" : "")));
        this.addLinkWarning(instructions, "JAVA_OPTS", attachSettings);
        return instructions;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        IntegrationProvider.IntegrationHints h = attachSettings.isRemote() ? this.getManualRemoteIntegrationStepsInstructions(targetOS, attachSettings) : (attachSettings.isDirect() ? this.getManualLocalDirectIntegrationStepsInstructions(targetOS, attachSettings) : this.getManualLocalDynamicIntegrationStepsInstructions(targetOS, attachSettings));
        this.addLinkWarning(h, "JAVA_OPTS", attachSettings);
        return h;
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public void setTargetJvm(TargetPlatform javaPlatform) {
        if (javaPlatform == null) {
            return;
        }
        this.setTargetJavaHome(javaPlatform.getHomePath());
        this.setTargetJava(javaPlatform.toString());
    }

    public boolean supportsRemote() {
        return true;
    }

    public ValidationResult validateInstallation(String targetOS, String path) {
        if (!new File(path).exists()) {
            return new ValidationResult(false, "The installation path doesn't exist");
        }
        if (!new File(this.getJbossScriptPath(path, targetOS, "", false)).exists()) {
            return new ValidationResult(false, "Invalid installation directory");
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return false;
    }

    protected ScriptHeaderModifier getHeaderModifier(String targetOS) {
        return new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)targetOS));
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String agentArgs = IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort());
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectDynamicStep1Msg(IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectStep2Msg(IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.JBossIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)agentArgs)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectDynamicStep3Msg(IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectStep4Msg());
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectDynamicStep1Msg(IntegrationUtils.getEnvVariableReference((String)JBOSS_HOME_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDynamicStep2Msg(IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.JBossIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())))));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDirectDynamicStep3Msg(IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualDynamicStep4Msg());
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        instructions.addWarning(Bundle.JBossIntegrationProvider_DynamicWarningMessage(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())));
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(this.getManualRemoteStep1(targetOS));
        instructions.addStep(this.getManualRemoteStep2(targetOS));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualRemoteStep3Msg(IntegrationUtils.getEnvVariableReference((String)"REMOTE_JBOSS_HOME", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualRemoteStep4Msg(IntegrationUtils.getBatchExtensionString((String)targetOS), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)Bundle.JBossIntegrationProvider_PathToJvmDirText(IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()))), IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())), IntegrationUtils.getRemoteAbsolutePathHint()));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualRemoteStep5Msg(IntegrationUtils.getBatchExtensionString((String)targetOS)));
        instructions.addStep(Bundle.JBossIntegrationProvider_ManualRemoteStep6Msg());
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            instructions.addHint(this.EXPORT_SETENV_MSG);
        }
        return instructions;
    }

    protected String getModifiedScriptPath(String targetOS, boolean quoted) {
        return this.getJbossScriptPath(targetOS, RUN_MOD_EXT_STRING, quoted);
    }

    protected String getScriptPath(String targetOS, boolean quoted) {
        return this.getJbossScriptPath(targetOS, "", quoted);
    }

    protected String getWinConsoleString() {
        return Bundle.JBossIntegrationProvider_ProfiledJbossConsoleString();
    }

    protected void generateCommands(String targetOS, Collection commandsArray) {
        commandsArray.add(this.getModifiedScriptPath(targetOS, false));
    }

    protected void modifyScriptFileForDirectAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String debugJavaOpts = "";
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            debugJavaOpts = debugJavaOpts + " -Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true";
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            debugJavaOpts = debugJavaOpts + " -Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true";
        }
        String header = (isReplaceFile ? IntegrationUtils.getProfilerModifiedReplaceFileHeader((String)targetOS) : IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS)) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak;
        String exportNativeLibraries = IntegrationUtils.getAddProfilerLibrariesToPathString((String)targetOS, (String)this.getTargetJava(), (boolean)false, (boolean)false) + lineBreak;
        String javaOpts = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_OPTS", (String)(IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)false, (int)commPort) + debugJavaOpts)) + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        buffer.insert(insertionPoint1 + (currentOffset += exportJavaHome.length()), javaOpts);
        currentOffset += javaOpts.length();
    }

    protected void modifyScriptFileForDynamicAttach(String targetOS, int port, boolean isReplaceFile, StringBuffer buffer) {
        String lineBreak = IntegrationUtils.getLineBreak((String)targetOS);
        int insertionPoint0 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? 0 : buffer.indexOf(INSERTION_POINT_NOWIN_0_STRING) + INSERTION_POINT_NOWIN_0_STRING.length() + 1;
        int insertionPoint1 = IntegrationUtils.isWindowsPlatform((String)targetOS) ? buffer.indexOf(INSERTION_POINT_WIN_1_STRING) : buffer.indexOf(INSERTION_POINT_NONWIN_1_STRING);
        String header = IntegrationUtils.getProfilerModifiedFileHeader((String)targetOS) + lineBreak;
        String exportJavaHome = IntegrationUtils.getAssignEnvVariableValueString((String)targetOS, (String)"JAVA_HOME", (String)this.getTargetJavaHome()) + lineBreak + lineBreak;
        int currentOffset = 0;
        buffer.insert(insertionPoint0 + currentOffset, header);
        buffer.insert(insertionPoint1 + (currentOffset += header.length()), exportJavaHome);
        currentOffset += exportJavaHome.length();
    }

    private String getDefaultInstallationPath() {
        String home = "";
        try {
            File homeDir;
            String homeEnv = System.getenv(JBOSS_HOME_VAR_STRING);
            if (homeEnv != null && homeEnv.length() > 1 && (homeDir = new File(homeEnv)).exists() && homeDir.isDirectory()) {
                home = homeEnv;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return home;
    }

    private String getJbossScriptPath(String targetOS, String scriptPostfix, boolean useQuotas) {
        return this.getJbossScriptPath(this.getInstallationPath(), targetOS, scriptPostfix, useQuotas);
    }

    private String getJbossScriptPath(String dirPath, String targetOS, String scriptPostfix, boolean useQuotas) {
        String separator = System.getProperty("file.separator");
        String ext = IntegrationUtils.getBatchExtensionString((String)targetOS);
        String quotas = "";
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            quotas = "\"";
        }
        StringBuilder path = new StringBuilder();
        path.append(dirPath);
        if (!dirPath.endsWith(separator)) {
            path.append(separator);
        }
        path.append("bin").append(separator).append(JBOSS_RUN_SCRIPT).append(scriptPostfix).append(ext);
        if (useQuotas) {
            path.insert(0, quotas);
            path.append(quotas);
        }
        return path.toString();
    }
}

