/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import javax.swing.text.Document;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JsUtils {
    public static final String HTML_MIME_TYPE = "text/html";
    public static final String[] CALL_KEYWORDS = new String[]{"true", "false", "null"};
    public static final String[] JAVASCRIPT_KEYWORDS = new String[]{"break", "case", "catch", "continue", "default", "delete", "do", "else", "false", "finally", "for", "function", "if", "in", "instanceof", "let", "new", "null", "return", "switch", "this", "throw", "true", "try", "typeof", "undefined", "var", "void", "while", "with", "yield"};
    public static final String[] JAVASCRIPT_RESERVED_WORDS = new String[]{"abstract", "boolean", "byte", "char", "class", "const", "debugger", "double", "enum", "export", "extends", "final", "float", "goto", "implements", "import", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "super", "synchronized", "throws", "transient", "volatile"};

    private JsUtils() {
    }

    public static boolean isJsFile(FileObject fileObject) {
        return "text/javascript".equals(fileObject.getMIMEType());
    }

    public static boolean isJsOrJsonDocument(Document document) {
        String string = (String)document.getProperty("mimeType");
        return "text/javascript".equals(string) || "text/x-json".equals(string);
    }

    public static boolean isJsonFile(FileObject fileObject) {
        return fileObject != null && "json".equals(fileObject.getExt());
    }

    public static boolean isEjsFile(FileObject fileObject) {
        return fileObject != null && "ejs".equals(fileObject.getExt());
    }

    public static boolean isSafeIdentifierName(String string, int n) {
        int n2 = n;
        if (n2 >= string.length()) {
            return n2 != 0;
        }
        if (n2 == 0) {
            if (JsUtils.isJsKeyword(string)) {
                return false;
            }
            if (Character.isDigit(string.charAt(0))) {
                return false;
            }
        }
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\' ? n2 == string.length() - 1 || string.charAt(n2 + 1) != 'u' : c != '$' && c != '_' && !Character.isLetterOrDigit(c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String getIdentifierWarning(String string, int n) {
        if (JsUtils.isSafeIdentifierName(string, n)) {
            return null;
        }
        return NbBundle.getMessage(JsUtils.class, (String)"UnsafeIdentifierName");
    }

    public static boolean isValidJsClassName(String string) {
        if (JsUtils.isJsKeyword(string)) {
            return false;
        }
        if (string.trim().length() == 0) {
            return false;
        }
        if (!Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (JsUtils.isStrictIdentifierChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJsMethodName(String string) {
        return JsUtils.isSafeIdentifierName(string, 0);
    }

    public static boolean isValidJsIdentifier(String string) {
        return JsUtils.isSafeIdentifierName(string, 0);
    }

    public static boolean isJsKeyword(String string) {
        for (String string2 : JAVASCRIPT_KEYWORDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getLineCommentPrefix() {
        return "//";
    }

    public static boolean isIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '\\';
    }

    public static boolean isStrictIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '$' || c == '\\';
    }

    public static String normalizeTypeString(String string) {
        if (string.indexOf("Array<") != -1) {
            String[] stringArray = string.split("\\|");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                if (string2.startsWith("Array<") && string2.endsWith(">")) {
                    stringBuilder.append(string2.substring(6, string2.length() - 1));
                    stringBuilder.append("[]");
                    continue;
                }
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    static void dumpAST(Node node, Appendable appendable) {
        DumpTreeVisitor dumpTreeVisitor = new DumpTreeVisitor(appendable);
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker(dumpTreeVisitor);
        parseTreeWalker.walk(node);
    }

    private static class DumpTreeVisitor
    implements ParseTreeVisitor {
        private int indent = 0;
        private Appendable output;
        private static final String INDENT_STRING = "    ";

        public DumpTreeVisitor(Appendable appendable) {
            this.output = appendable;
        }

        @Override
        public boolean visit(Node node) {
            ++this.indent;
            this.dump(node);
            return false;
        }

        @Override
        public boolean unvisit(Node node) {
            --this.indent;
            return false;
        }

        private void dump(Node node) {
            try {
                for (int i = 0; i < this.indent; ++i) {
                    this.output.append(INDENT_STRING);
                }
                this.output.append(node.toString()).append('\n');
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

