/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.net.URISyntaxException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class JsClassPathProvider
implements ClassPathProvider {
    public static final String BOOT_CP = "JavascriptBootClassPath";
    private static FileObject jsStubsFO;
    private static ClassPath bootClassPath;

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals(BOOT_CP)) {
            return JsClassPathProvider.getBootClassPath();
        }
        return null;
    }

    public static synchronized ClassPath getBootClassPath() {
        FileObject jsstubs;
        if (bootClassPath == null && (jsstubs = JsClassPathProvider.getJsStubs()) != null) {
            bootClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{JsClassPathProvider.getJsStubs()});
        }
        return bootClassPath;
    }

    private static FileObject getJsStubs() {
        if (jsStubsFO == null) {
            File allstubs = InstalledFileLocator.getDefault().locate("jsstubs/allstubs.zip", "org.netbeans.modules.javascript.editing", false);
            if (allstubs == null) {
                try {
                    File moduleJar = new File(JsClassPathProvider.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                    allstubs = new File(moduleJar.getParentFile().getParentFile(), "jsstubs/allstubs.zip");
                }
                catch (URISyntaxException x) {
                    assert (false) : x;
                    return null;
                }
            }
            assert (allstubs.isFile()) : allstubs;
            jsStubsFO = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)allstubs));
        }
        return jsStubsFO;
    }
}

