/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class JsBracesMatcher
implements BracesMatcher {
    MatcherContext context;

    public JsBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence((Document)doc, offset);
            if (ts != null) {
                ts.move(offset);
                if (!ts.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                Token token = ts.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId id = token.id();
                if (id == JsTokenId.STRING_BEGIN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.STRING_END) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.REGEXP_BEGIN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.REGEXP_END) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.LPAREN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.RPAREN) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.LBRACE) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.RBRACE) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.LBRACKET) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
                if (id == JsTokenId.RBRACKET) {
                    int[] nArray = new int[]{ts.offset(), ts.offset() + token.length()};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            BaseDocument doc = (BaseDocument)this.context.getDocument();
            int offset = this.context.getSearchOffset();
            TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence((Document)doc, offset);
            if (ts != null) {
                ts.move(offset);
                if (!ts.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                Token token = ts.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId id = token.id();
                if (id == JsTokenId.STRING_BEGIN) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), false, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.STRING_END) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), true, JsTokenId.STRING_END, JsTokenId.STRING_BEGIN);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.REGEXP_BEGIN) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), false, JsTokenId.REGEXP_BEGIN, JsTokenId.REGEXP_END);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.REGEXP_END) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), true, JsTokenId.REGEXP_END, JsTokenId.REGEXP_BEGIN);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.LPAREN) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), false, JsTokenId.LPAREN, JsTokenId.RPAREN);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.RPAREN) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), true, JsTokenId.RPAREN, JsTokenId.LPAREN);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.LBRACE) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), false, JsTokenId.LBRACE, JsTokenId.RBRACE);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.RBRACE) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), true, JsTokenId.RBRACE, JsTokenId.LBRACE);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.LBRACKET) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), false, JsTokenId.LBRACKET, JsTokenId.RBRACKET);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
                if (id == JsTokenId.RBRACKET) {
                    OffsetRange r = this.findPair(ts.languagePath(), ts.offset(), true, JsTokenId.RBRACKET, JsTokenId.LBRACKET);
                    int[] nArray = new int[]{r.getStart(), r.getEnd()};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private OffsetRange findPair(LanguagePath lPath, int originOffset, boolean backward, TokenId originalId, TokenId pairId) {
        TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
        List list = backward ? th.tokenSequenceList(lPath, 0, originOffset) : th.tokenSequenceList(lPath, originOffset + 1, this.context.getDocument().getLength());
        int counter = 0;
        TokenSequenceIterator tsi = new TokenSequenceIterator(list, backward);
        while (tsi.hasMore()) {
            TokenSequence<?> sq = tsi.getSequence();
            TokenId tokenID = sq.token().id();
            if (originalId == tokenID) {
                ++counter;
                continue;
            }
            if (pairId != tokenID) continue;
            if (counter == 0) {
                return new OffsetRange(sq.offset(), sq.offset() + sq.token().length());
            }
            --counter;
        }
        return OffsetRange.NONE;
    }

    private static final class TokenSequenceIterator {
        private final List<TokenSequence<?>> list;
        private final boolean backward;
        private int index;

        public TokenSequenceIterator(List<TokenSequence<?>> list, boolean backward) {
            this.list = list;
            this.backward = backward;
            this.index = -1;
        }

        public boolean hasMore() {
            return this.backward ? this.hasPrevious() : this.hasNext();
        }

        public TokenSequence<?> getSequence() {
            assert (this.index >= 0 && this.index < this.list.size()) : "No sequence available, call hasMore() first.";
            return this.list.get(this.index);
        }

        private boolean hasPrevious() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = this.list.size() - 1;
                anotherSeq = true;
            }
            while (this.index >= 0) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveEnd();
                }
                if (seq.movePrevious()) {
                    return true;
                }
                anotherSeq = true;
                --this.index;
            }
            return false;
        }

        private boolean hasNext() {
            boolean anotherSeq = false;
            if (this.index == -1) {
                this.index = 0;
                anotherSeq = true;
            }
            while (this.index < this.list.size()) {
                TokenSequence<?> seq = this.list.get(this.index);
                if (anotherSeq) {
                    seq.moveStart();
                }
                if (seq.moveNext()) {
                    return true;
                }
                anotherSeq = true;
                ++this.index;
            }
            return false;
        }
    }
}

