/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.core.api.JspContextInfo;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.deprecated.ELTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspDirectiveTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspMultiTokenContext;
import org.netbeans.modules.web.core.syntax.deprecated.JspTagTokenContext;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.WeakListeners;

public class JspSyntaxSupport
extends ExtSyntaxSupport
implements FileChangeListener {
    static final Logger err = Logger.getLogger("org.netbeans.modules.web.jspsyntax");
    public static final int TAG_COMPLETION_CONTEXT = 1;
    public static final int ENDTAG_COMPLETION_CONTEXT = 2;
    public static final int DIRECTIVE_COMPLETION_CONTEXT = 3;
    public static final int COMMENT_COMPLETION_CONTEXT = 4;
    public static final int TEXT_COMPLETION_CONTEXT = 5;
    public static final int CONTENTL_COMPLETION_CONTEXT = 6;
    public static final int SCRIPTINGL_COMPLETION_CONTEXT = 7;
    public static final int ERROR_COMPLETION_CONTEXT = 8;
    public static final int EL_COMPLETION_CONTEXT = 9;
    private static final String STANDARD_JSP_PREFIX = "jsp";
    private static TagInfo[] standardJspTagDatas;
    private static TagInfo[] standardTagTagDatas;
    private static TagInfo[] xmlJspTagDatas;
    private static TagInfo[] xmlTagFileTagDatas;
    private static TagInfo[] directiveJspData;
    private static TagInfo[] directiveTagFileData;
    private static HashMap helpMap;
    private static final TokenID[] JSP_BRACKET_SKIP_TOKENS;
    protected FileObject fobj = null;
    private boolean useCustomBracketFinder = true;

    public static synchronized JspSyntaxSupport get(Document doc) {
        JspSyntaxSupport sup = (JspSyntaxSupport)((Object)doc.getProperty(JspSyntaxSupport.class));
        if (sup == null) {
            sup = new JspSyntaxSupport((BaseDocument)doc);
            doc.putProperty(JspSyntaxSupport.class, (Object)sup);
        }
        return sup;
    }

    public JspSyntaxSupport(BaseDocument doc) {
        super(doc);
        if (doc != null) {
            this.initFileObject();
        }
    }

    private void initFileObject() {
        DataObject dobj = NbEditorUtilities.getDataObject((Document)this.getDocument());
        if (dobj != null) {
            this.fobj = NbEditorUtilities.getDataObject((Document)this.getDocument()).getPrimaryFile();
            this.fobj.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)this.fobj));
        }
    }

    public String[] getImports() {
        JspParserAPI.ParseResult pre = this.getParseResult();
        if (pre != null) {
            PageInfo pi = pre.getPageInfo();
            if (pi == null) {
                err.log(Level.WARNING, null, new NullPointerException("PageInfo obtained from JspParserAPI.ParseResult is null"));
                return null;
            }
            List imports = pi.getImports();
            return imports.toArray(new String[imports.size()]);
        }
        return null;
    }

    public boolean isXmlSyntax() {
        JspContextInfo jspCO = JspContextInfo.getContextInfo((FileObject)this.fobj);
        if (jspCO == null) {
            return false;
        }
        JspParserAPI.JspOpenInfo jspOpenInfo = jspCO.getCachedOpenInfo(this.fobj, false);
        if (jspOpenInfo == null) {
            return false;
        }
        return jspOpenInfo.isXmlSyntax();
    }

    protected JspParserAPI.ParseResult getParseResult() {
        JspParserAPI.ParseResult result = JspUtils.getCachedParseResult(this.fobj, true, false);
        if (result == null) {
            result = JspUtils.getCachedParseResult(this.fobj, false, false);
        }
        return result;
    }

    protected Map getPrefixMapper() {
        JspParserAPI.ParseResult result = this.getParseResult();
        Map prefixMapper = null;
        if (result != null && result.getPageInfo() != null) {
            if (result.getPageInfo().getXMLPrefixMapper().size() > 0) {
                prefixMapper = result.getPageInfo().getApproxXmlPrefixMapper();
                if (prefixMapper.size() == 0) {
                    prefixMapper = result.getPageInfo().getXMLPrefixMapper();
                }
                prefixMapper.putAll(result.getPageInfo().getJspPrefixMapper());
            } else {
                prefixMapper = result.getPageInfo().getJspPrefixMapper();
            }
        }
        return prefixMapper;
    }

    private Map getTagLibraries(boolean requiresFresh) {
        this.getTagLibraryMappings();
        JspParserAPI.ParseResult result = JspUtils.getCachedParseResult(this.fobj, false, requiresFresh, requiresFresh);
        if (result != null) {
            PageInfo pi = result.getPageInfo();
            if (pi == null) {
                err.log(Level.INFO, null, new NullPointerException("PageInfo obtained from JspParserAPI.ParseResult is null"));
                return null;
            }
            return pi.getTagLibraries();
        }
        return null;
    }

    private TagInfo[] getSortedTagInfos(TagInfo[] tinfos) {
        Arrays.sort(tinfos, new Comparator(){

            public int compare(Object o1, Object o2) {
                String tname2;
                TagInfo ti1 = (TagInfo)o1;
                TagInfo ti2 = (TagInfo)o2;
                String tname1 = ti1.getDisplayName() == null ? ti1.getTagName() : ti1.getDisplayName();
                String string = tname2 = ti2.getDisplayName() == null ? ti2.getTagName() : ti2.getDisplayName();
                if (tname1 == null || tname2 == null) {
                    return 0;
                }
                return tname1.compareTo(tname2);
            }

            @Override
            public boolean equals(Object o) {
                return o.equals(this);
            }
        });
        return tinfos;
    }

    private TagLibraryInfo getTagLibrary(String prefix, boolean requiresFresh) {
        Map taglibs;
        Object uri;
        Map mapper = this.getPrefixMapper();
        if (mapper != null && (uri = mapper.get(prefix)) != null && (taglibs = this.getTagLibraries(requiresFresh)) != null) {
            return (TagLibraryInfo)taglibs.get(uri);
        }
        return null;
    }

    protected SyntaxSupport createSyntaxSupport(Class syntaxSupportClass) {
        SyntaxSupport support = super.createSyntaxSupport(syntaxSupportClass);
        if (support != null) {
            return support;
        }
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/html");
        if (kit instanceof BaseKit && (support = ((BaseKit)kit).createSyntaxSupport(this.getDocument())) != null) {
            return support;
        }
        kit = CloneableEditorSupport.getEditorKit((String)"text/x-java");
        if (kit instanceof BaseKit && (support = ((BaseKit)kit).createSyntaxSupport(this.getDocument())) != null) {
            return support;
        }
        return null;
    }

    public int checkCompletion(JTextComponent target, String typedText, boolean visible) {
        char first = typedText.charAt(0);
        TokenItem item = null;
        try {
            item = this.getItemAtOrBefore(target.getCaret().getDot());
        }
        catch (BadLocationException e) {
            return 4;
        }
        if (item == null) {
            return 4;
        }
        TokenContextPath tcp = item.getTokenContextPath();
        if (tcp.contains(JavaTokenContext.contextPath)) {
            return 1;
        }
        if (tcp.contains(JspTagTokenContext.contextPath)) {
            TokenItem tracking = item;
            int maxBacktrace = 80;
            do {
                if (tracking.getTokenID() == JspTagTokenContext.ERROR) {
                    return 4;
                }
                String image = tracking.getImage();
                if (image.equals("%>")) {
                    return 4;
                }
                if (tracking.getImage().startsWith("<%")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "DIRECTIVE_COMPLETION_CONTEXT");
                    }
                    if (!visible && first == '=' && tracking.getImage().equals("<%")) {
                        return 0;
                    }
                    if (!visible && first == '%' || first == '@' || first == ' ') {
                        return 0;
                    }
                    if (visible && first == '=' || first == '>') {
                        return 4;
                    }
                    return visible ? 3 : 1;
                }
                if (tracking.getImage().equals("<")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "TAG_COMPLETION_CONTEXT");
                    }
                    if (!visible && first == ' ' || first == ':') {
                        return 0;
                    }
                    if (visible && first == '>') {
                        return 4;
                    }
                    return visible ? 3 : 1;
                }
                if (tracking.getImage().equals("</")) {
                    if (err.isLoggable(Level.FINE)) {
                        err.log(Level.FINE, "ENDTAG_COMPLETION_CONTEXT");
                    }
                    if (visible && first == '>') {
                        return 4;
                    }
                    return visible ? 3 : 1;
                }
                if (!tracking.getTokenContextPath().contains(JspTagTokenContext.contextPath)) {
                    if (!err.isLoggable(Level.FINE)) break;
                    err.log(Level.FINE, "We are out of jsp tag without finding any tag start token!");
                    break;
                }
                if (tracking.getImage().equals(">")) {
                    try {
                        SyntaxElement se = this.getElementChain(tracking.getOffset());
                        if (se != null && se instanceof SyntaxElement.Tag) {
                            return 0;
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                    return 4;
                }
                tracking = tracking.getPrevious();
            } while (maxBacktrace-- > 0 && tracking != null);
        }
        if (tcp.contains(ELTokenContext.contextPath) && first == '.') {
            return 0;
        }
        return 4;
    }

    private final int getTokenEnd(TokenItem item) {
        if (item == null) {
            return 0;
        }
        return item.getOffset() + item.getImage().length();
    }

    public static final List<Object> filterList(List<? extends Object> toFilter, String prefix) {
        ArrayList<Object> newList = new ArrayList<Object>();
        for (int i = 0; i < toFilter.size(); ++i) {
            Object item = toFilter.get(i);
            String txt = item instanceof TagInfo ? ((TagInfo)item).getTagName() : (item instanceof TagAttributeInfo ? ((TagAttributeInfo)item).getName() : (String)item);
            if (txt == null || !txt.startsWith(prefix)) continue;
            newList.add(item);
        }
        return newList;
    }

    public static final List<String> filterStrings(List<String> toFilter, String prefix) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String val : toFilter) {
            if (!val.startsWith(prefix)) continue;
            newList.add(val);
        }
        return newList;
    }

    public final List<Object> getTagPrefixes(String complPrefix) {
        return JspSyntaxSupport.filterList(this.getAllTagPrefixes(), complPrefix);
    }

    public final List getTags(String complPrefix) {
        int colonIndex = complPrefix.indexOf(":");
        if (colonIndex == -1) {
            throw new IllegalArgumentException();
        }
        return this.getTags(complPrefix.substring(0, colonIndex), complPrefix.substring(colonIndex + 1));
    }

    public final List getTags(String tagPrefix, String complPrefix) {
        return JspSyntaxSupport.filterList(this.getAllTags(tagPrefix, true), complPrefix);
    }

    public final List getTagAttributes(String tagPrefixName, String complPrefix) {
        int colonIndex = tagPrefixName.indexOf(":");
        if (colonIndex == -1) {
            throw new IllegalArgumentException();
        }
        return this.getTagAttributes(tagPrefixName.substring(0, colonIndex), tagPrefixName.substring(colonIndex + 1), complPrefix);
    }

    protected final List getTagAttributes(String tagPrefix, String tagName, String complPrefix) {
        return JspSyntaxSupport.filterList(this.getAllTagAttributes(tagPrefix, tagName), complPrefix);
    }

    public final List getDirectives(String complPrefix) {
        return JspSyntaxSupport.filterList(this.getAllDirectives(), complPrefix);
    }

    public final List getDirectiveAttributes(String directive, String complPrefix) {
        return JspSyntaxSupport.filterList(this.getAllDirectiveAttributes(directive), complPrefix);
    }

    protected List getAllTagPrefixes() {
        ArrayList<String> items = new ArrayList<String>();
        items.add(STANDARD_JSP_PREFIX);
        Map mapper = this.getPrefixMapper();
        if (mapper != null) {
            TreeSet ts = new TreeSet();
            ts.addAll(mapper.keySet());
            ts.remove(STANDARD_JSP_PREFIX);
            items.addAll(ts);
        }
        return items;
    }

    private TagInfo[] getAllTagInfos(TagLibraryInfo tagLibrary) {
        TagInfo[] allTags = new TagInfo[]{};
        if (tagLibrary != null) {
            int i;
            int tagInfosLength = 0;
            int tagAllInfosLength = 0;
            TagInfo[] tagInfos = tagLibrary.getTags();
            TagFileInfo[] tagFileInfos = tagLibrary.getTagFiles();
            if (tagInfos != null) {
                tagAllInfosLength = tagInfosLength = tagInfos.length;
            }
            if (tagFileInfos != null) {
                tagAllInfosLength += tagFileInfos.length;
            }
            allTags = new TagInfo[tagAllInfosLength];
            if (tagInfos != null) {
                for (i = 0; i < tagInfosLength; ++i) {
                    allTags[i] = tagInfos[i];
                }
            }
            if (tagFileInfos != null) {
                for (i = 0; i < tagFileInfos.length; ++i) {
                    allTags[tagInfosLength + i] = tagFileInfos[i].getTagInfo();
                }
            }
        }
        return allTags;
    }

    protected List getAllTags(String prefix, boolean requiresFresh) {
        ArrayList<TagInfo> items;
        block7: {
            items = new ArrayList<TagInfo>();
            JspSyntaxSupport.initCompletionData();
            if (STANDARD_JSP_PREFIX.equals(prefix)) {
                TagInfo[] stanTagDatas = this.getTagInfos();
                for (int i = 0; i < stanTagDatas.length; ++i) {
                    items.add(stanTagDatas[i]);
                }
            }
            TagLibraryInfo info = this.getTagLibrary(prefix, requiresFresh);
            TagInfo[] tags = null;
            if (info != null) {
                tags = this.getAllTagInfos(info);
            }
            if (tags == null) break block7;
            tags = this.getSortedTagInfos(tags);
            String url = (String)helpMap.get(info.getURI());
            if (url != null && !url.equals("")) {
                for (int i = 0; i < tags.length; ++i) {
                    items.add(new TagInfo(tags[i].getTagName(), tags[i].getTagClassName(), tags[i].getBodyContent(), url + tags[i].getTagName() + ".html#tag-start-" + tags[i].getTagName() + "#tag-end-" + tags[i].getTagName(), info, tags[i].getTagExtraInfo(), tags[i].getAttributes(), tags[i].getDisplayName(), tags[i].getSmallIcon(), tags[i].getLargeIcon(), tags[i].getTagVariableInfos(), tags[i].hasDynamicAttributes()));
                }
            } else {
                for (int i = 0; i < tags.length; ++i) {
                    items.add(tags[i]);
                }
            }
        }
        return items;
    }

    protected List getAllTagAttributes(String prefix, String tag) {
        ArrayList<TagAttributeInfo> items;
        block9: {
            TagFileInfo tagFile;
            TagLibraryInfo info;
            items = new ArrayList<TagAttributeInfo>();
            JspSyntaxSupport.initCompletionData();
            if (STANDARD_JSP_PREFIX.equals(prefix)) {
                TagInfo[] stanTagDatas = this.getTagInfos();
                for (int i = 0; i < stanTagDatas.length; ++i) {
                    if (!stanTagDatas[i].getTagName().equals(tag)) continue;
                    TagAttributeInfo[] attrs = stanTagDatas[i].getAttributes();
                    for (int j = 0; j < attrs.length; ++j) {
                        items.add(attrs[j]);
                    }
                    break;
                }
            }
            if ((info = this.getTagLibrary(prefix, true)) == null) break block9;
            TagInfo tagInfo = info.getTag(tag);
            if (tagInfo == null && (tagFile = info.getTagFile(tag)) != null) {
                tagInfo = tagFile.getTagInfo();
            }
            if (tagInfo != null) {
                TagAttributeInfo[] attributes = tagInfo.getAttributes();
                String url = (String)helpMap.get(tagInfo.getTagLibrary().getURI());
                if (url != null && !url.equals("")) {
                    for (int i = 0; i < attributes.length; ++i) {
                        items.add(new TagAttributeInfo(attributes[i].getName(), attributes[i].isRequired(), url + tagInfo.getTagName() + ".html#attribute-start-" + attributes[i].getName() + "#attribute-end-" + attributes[i].getName(), attributes[i].canBeRequestTime(), attributes[i].isFragment()));
                    }
                } else {
                    for (int i = 0; i < attributes.length; ++i) {
                        items.add(attributes[i]);
                    }
                }
            }
        }
        return items;
    }

    protected List<TagInfo> getAllDirectives() {
        JspSyntaxSupport.initCompletionData();
        ArrayList<TagInfo> items = new ArrayList<TagInfo>();
        if (this.isXmlSyntax()) {
            return items;
        }
        TagInfo[] directiveData = NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? directiveTagFileData : directiveJspData;
        for (int i = 0; i < directiveData.length; ++i) {
            items.add(directiveData[i]);
        }
        return items;
    }

    protected List getAllDirectiveAttributes(String directive) {
        JspSyntaxSupport.initCompletionData();
        ArrayList<TagAttributeInfo> items = new ArrayList<TagAttributeInfo>();
        if (this.isXmlSyntax()) {
            return items;
        }
        TagInfo[] directiveData = NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? directiveTagFileData : directiveJspData;
        for (int i = 0; i < directiveData.length; ++i) {
            if (!directiveData[i].getTagName().equals(directive)) continue;
            TagAttributeInfo[] attrs = directiveData[i].getAttributes();
            for (int j = 0; j < attrs.length; ++j) {
                items.add(attrs[j]);
            }
            break;
        }
        return items;
    }

    public PageInfo.BeanData[] getBeanData() {
        PageInfo pageInfo;
        JspParserAPI.ParseResult result = this.getParseResult();
        if (result != null && (pageInfo = result.getPageInfo()) != null) {
            return pageInfo.getBeans();
        }
        return null;
    }

    public boolean isErrorPage() {
        JspParserAPI.ParseResult result = this.getParseResult();
        if (result != null && result.getPageInfo() != null) {
            return result.getPageInfo().isErrorPage();
        }
        return false;
    }

    public Map getTagLibraryMappings() {
        if (this.fobj == null) {
            return null;
        }
        return JspUtils.getTaglibMap(this.fobj);
    }

    private static void initHelp() {
        if (helpMap == null) {
            URL urll;
            String url = "";
            File f = InstalledFileLocator.getDefault().locate("docs/jstl11-doc.zip", null, false);
            if (f != null) {
                try {
                    urll = f.toURL();
                    urll = FileUtil.getArchiveRoot((URL)urll);
                    url = urll.toString();
                }
                catch (MalformedURLException e) {
                    err.log(Level.WARNING, null, e);
                }
            }
            helpMap = new HashMap();
            helpMap.put("http://java.sun.com/jsp/jstl/core", url + "c/");
            helpMap.put("http://java.sun.com/jstl/core", url + "c/");
            helpMap.put("http://java.sun.com/jstl/core_rt", url + "c_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/fmt", url + "fmt/");
            helpMap.put("http://java.sun.com/jstl/fmt", url + "fmt/");
            helpMap.put("http://java.sun.com/jstl/fmt_rt", url + "fmt_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/functions", url + "fn/");
            helpMap.put("http://java.sun.com/jstl/functions", url + "fn/");
            helpMap.put("http://jakarta.apache.org/taglibs/standard/permittedTaglibs", url + "permittedTaglibs/");
            helpMap.put("http://jakarta.apache.org/taglibs/standard/scriptfree", url + "scriptfree/");
            helpMap.put("http://java.sun.com/jsp/jstl/sql", url + "sql/");
            helpMap.put("http://java.sun.com/jstl/sql", url + "sql/");
            helpMap.put("http://java.sun.com/jstl/sql_rt", url + "sql_rt/");
            helpMap.put("http://java.sun.com/jsp/jstl/xml", url + "x/");
            helpMap.put("http://java.sun.com/jstl/xml", url + "x/");
            helpMap.put("http://java.sun.com/jstl/xml_rt", url + "x_rt/");
            f = InstalledFileLocator.getDefault().locate("docs/jsf12-tlddoc.zip", null, false);
            if (f != null) {
                try {
                    urll = f.toURL();
                    urll = FileUtil.getArchiveRoot((URL)urll);
                    url = urll.toString();
                    helpMap.put("http://java.sun.com/jsf/html", url + "h/");
                    helpMap.put("http://java.sun.com/jsf/core", url + "f/");
                }
                catch (MalformedURLException e) {
                    err.log(Level.WARNING, null, e);
                }
            }
            if ((f = InstalledFileLocator.getDefault().locate("docs/struts-tags.zip", null, false)) != null) {
                try {
                    urll = f.toURL();
                    urll = FileUtil.getArchiveRoot((URL)urll);
                    url = urll.toString();
                    helpMap.put("http://jakarta.apache.org/struts/tags-bean", url + "bean/");
                    helpMap.put("http://struts.apache.org/tags-bean", url + "bean/");
                    helpMap.put("/WEB-INF/struts-bean.tld", url + "bean/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-html", url + "html/");
                    helpMap.put("http://struts.apache.org/tags-html", url + "html/");
                    helpMap.put("/WEB-INF/struts-html.tld", url + "html/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-logic", url + "logic/");
                    helpMap.put("http://struts.apache.org/tags-logic", url + "logic/");
                    helpMap.put("/WEB-INF/struts-logic.tld", url + "logic/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-nested", url + "nested/");
                    helpMap.put("http://struts.apache.org/tags-nested", url + "nested/");
                    helpMap.put("/WEB-INF/struts-nested.tld", url + "nested/");
                    helpMap.put("http://jakarta.apache.org/struts/tags-tiles", url + "tiles/");
                    helpMap.put("http://struts.apache.org/tags-tiles", url + "tiles/");
                    helpMap.put("/WEB-INF/struts-tiles.tld", url + "tiles/");
                }
                catch (MalformedURLException e) {
                    err.log(Level.WARNING, null, e);
                }
            }
        }
    }

    private static void initCompletionData() {
        if (helpMap == null) {
            JspSyntaxSupport.initHelp();
        }
        String url = "";
        if (directiveJspData == null) {
            directiveJspData = new TagInfo[]{new TagInfo("include", null, "empty", url + "syntaxref209.html#1003408#8975", null, null, new TagAttributeInfo[]{new TagAttributeInfo("file", true, url + "syntaxref209.html#16836#10636", false)}), new TagInfo("page", null, "empty", url + "syntaxref2010.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("autoFlush", false, url + "syntaxref2010.html#15673#15675", false), new TagAttributeInfo("buffer", false, url + "syntaxref2010.html#15671#15673", false), new TagAttributeInfo("contentType", false, url + "syntaxref2010.html#15683#1001361", false), new TagAttributeInfo("errorPage", false, url + "syntaxref2010.html#15679#15681", false), new TagAttributeInfo("extends", false, url + "syntaxref2010.html#15665#16862", false), new TagAttributeInfo("import", false, url + "syntaxref2010.html#16862#15669", false), new TagAttributeInfo("info", false, url + "syntaxref2010.html#15677#15679", false), new TagAttributeInfo("isELIgnored", false, url + "syntaxref2010.html#1011216#18865", false), new TagAttributeInfo("isErrorPage", false, url + "syntaxref2010.html#15681#15683", false), new TagAttributeInfo("isThreadSafe", false, url + "syntaxref2010.html#15675#15677", false), new TagAttributeInfo("language", false, url + "syntaxref2010.html#15663#15665", false), new TagAttributeInfo("pageEncoding", false, url + "syntaxref2010.html#1001361#1011216", false), new TagAttributeInfo("session", false, url + "syntaxref2010.html#15669#15671", false)}), new TagInfo("taglib", null, "empty", url + "syntaxref2012.html#1003416#1002041", null, null, new TagAttributeInfo[]{new TagAttributeInfo("prefix", true, url + "syntaxref2012.html#1011290#1002041", false), new TagAttributeInfo("uri", false, url + "syntaxref2012.html#10721#1011294", false), new TagAttributeInfo("tagdir", false, url + "syntaxref2012.html#1011294#1011290", false)})};
        }
        if (directiveTagFileData == null) {
            directiveTagFileData = new TagInfo[]{new TagInfo("attribute", null, "empty", url + "syntaxref208.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("description", false, url + "syntaxref208.html#1004672", false), new TagAttributeInfo("fragment", false, url + "syntaxref208.html#1004657#1004666", false), new TagAttributeInfo("name", true, url + "syntaxref208.html#1004648#1004655", false), new TagAttributeInfo("required", false, url + "syntaxref208.html#1004655#1004657", false), new TagAttributeInfo("rtexprvalue", false, url + "syntaxref208.html#1004666#1004669", false), new TagAttributeInfo("type", false, url + "syntaxref208.html#1004669#1004672", false)}), directiveJspData[0], new TagInfo("tag", null, "empty", url + "syntaxref2011.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("body-content", false, url + "syntaxref2011.html#1005164#005172", false), new TagAttributeInfo("description", false, url + "syntaxref2011.html#1005196#1005198", false), new TagAttributeInfo("display-name", false, url + "syntaxref2011.html#1005161#1005164", false), new TagAttributeInfo("dynamic-attributes", false, url + "syntaxref2011.html#005172#1005190", false), new TagAttributeInfo("example", false, url + "syntaxref2011.html#1005198#1005201", false), new TagAttributeInfo("import", false, url + "syntaxref2011.html#1005203#1005209", false), new TagAttributeInfo("isELIgnored", false, url + "syntaxref2011.html#1005214#1005291#1005291", false), new TagAttributeInfo("large-icon", false, url + "syntaxref2011.html#1005193#1005196", false), new TagAttributeInfo("language", false, url + "syntaxref2011.html#1005201#1005203", false), new TagAttributeInfo("pageEncoding", false, url + "syntaxref2011.html#1005209#1005214", false), new TagAttributeInfo("small-icon", false, url + "syntaxref2011.html#1005190#1005193", false)}), directiveJspData[2], new TagInfo("variable", null, "empty", url + "syntaxref2013.html#15694#1003563", null, null, new TagAttributeInfo[]{new TagAttributeInfo("alias", false, url + "syntaxref2013.html#1005914#1005956", false), new TagAttributeInfo("declare", false, url + "syntaxref2013.html#1006001#1006019", false), new TagAttributeInfo("description", false, url + "syntaxref2013.html#1005991#1003563", false), new TagAttributeInfo("name-given", false, url + "syntaxref2013.html#1003561#1005914", false), new TagAttributeInfo("scope", false, url + "syntaxref2013.html#1006019#1005991", false), new TagAttributeInfo("variable-class", false, url + "syntaxref2013.html#1005956#1006001", false)})};
        }
        if (standardJspTagDatas == null) {
            String helpFiles = "docs/syntaxref20.zip";
            File f = InstalledFileLocator.getDefault().locate("docs/syntaxref20.zip", null, true);
            if (f != null) {
                try {
                    URL urll = f.toURL();
                    urll = FileUtil.getArchiveRoot((URL)urll);
                    url = urll.toString();
                }
                catch (MalformedURLException e) {
                    err.log(Level.WARNING, null, e);
                }
            }
            standardJspTagDatas = new TagInfo[]{new TagInfo("attribute", null, "JSP", url + "syntaxref2014.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, url + "syntaxref2014.html#1003581#1006483", false), new TagAttributeInfo("trim", false, url + "syntaxref2014.html#1006483#1003583", false)}), new TagInfo("body", null, "JSP", url + "syntaxref2015.html#1006731#1003768", null, null, new TagAttributeInfo[0]), new TagInfo("element", null, "JSP", url + "syntaxref2016.html#1003696#1003708", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, url + "syntaxref2016.html#1003706#1003708", false)}), new TagInfo("expression", null, "JSP", url + "syntaxref205.html#1004353#11268", null, null, new TagAttributeInfo[0]), new TagInfo("fallback", null, "JSP", url + "syntaxref2023.html#11583#19029", null, null, new TagAttributeInfo[0]), new TagInfo("forward", null, "JSP", url + "syntaxref2018.html#1003349#15708", null, null, new TagAttributeInfo[]{new TagAttributeInfo("page", true, url + "syntaxref2018.html#15704#15708", true)}), new TagInfo("getProperty", null, "empty", url + "syntaxref2019.html#8820#9201", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, url + "syntaxref2019.html#15748#10919", false), new TagAttributeInfo("property", true, url + "syntaxref2019.html#10919#19482", false)}), new TagInfo("include", null, "JSP", url + "syntaxref2020.html#8828#9228", null, null, new TagAttributeInfo[]{new TagAttributeInfo("flush", true, url + "syntaxref2020.html#17145#18376", false), new TagAttributeInfo("page", true, url + "syntaxref2020.html#10930#17145", true)}), new TagInfo("param", null, "empty", url + "syntaxref2023.html#11538#11583", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, url + "syntaxref2023.html#11538#11583", false), new TagAttributeInfo("value", true, url + "syntaxref2023.html#11538#11583", true)}), new TagInfo("params", null, "JSP", url + "syntaxref2023.html#11538#11583", null, null, new TagAttributeInfo[0]), new TagInfo("plugin", null, "JSP", url + "syntaxref2023.html#1004158#19029", null, null, new TagAttributeInfo[]{new TagAttributeInfo("align", false, url + "syntaxref2023.html#11516#11518", false), new TagAttributeInfo("archive", false, url + "syntaxref2023.html#11553#11516", false), new TagAttributeInfo("code", true, url + "syntaxref2023.html#11514#11515", false), new TagAttributeInfo("codebase", true, url + "syntaxref2023.html#11515#11547", false), new TagAttributeInfo("height", false, url + "syntaxref2023.html#11518#11568", false), new TagAttributeInfo("hspace", false, url + "syntaxref2023.html#11568#11520", false), new TagAttributeInfo("iepluginurl", false, url + "syntaxref2023.html#11526#11538", false), new TagAttributeInfo("jreversion", false, url + "syntaxref2023.html#11520#11525", false), new TagAttributeInfo("name", false, url + "syntaxref2023.html#11547#11553", false), new TagAttributeInfo("nspluginurl", false, url + "syntaxref2023.html#11525#11526", false), new TagAttributeInfo("type", true, url + "syntaxref2023.html#10935#11514", false), new TagAttributeInfo("vspace", false, url + "syntaxref2023.html#11568#11520", false), new TagAttributeInfo("width", false, url + "syntaxref2023.html#11518#11568", false)}), new TagInfo("setProperty", null, "empty", url + "syntaxref2025.html#8856#9329", null, null, new TagAttributeInfo[]{new TagAttributeInfo("name", true, url + "syntaxref2025.html#17612#1001786", true), new TagAttributeInfo("param", false, url + "syntaxref2025.html#9919#20483", false), new TagAttributeInfo("property", false, url + "syntaxref2025.html#1001786#9329", false), new TagAttributeInfo("value", false, url + "syntaxref2025.html#20483#9329", true)}), new TagInfo("text", null, "JSP", url + "syntaxref2026.html", null, null, new TagAttributeInfo[0]), new TagInfo("useBean", null, "JSP", url + "syntaxref2027.html#8865#9359", null, null, new TagAttributeInfo[]{new TagAttributeInfo("beanName", false, url + "syntaxref2027.html#15804#9359", false), new TagAttributeInfo("class", false, url + "syntaxref2027.html#10968#19433", false), new TagAttributeInfo("id", true, url + "syntaxref2027.html#10964#10966", false), new TagAttributeInfo("scope", true, url + "syntaxref2027.html#10966#10968", false), new TagAttributeInfo("type", false, url + "syntaxref2027.html#19433#18019", false)}), new TagInfo("declaration", null, "JSP", url + "syntaxref204.html#10983#10991", null, null, new TagAttributeInfo[0]), new TagInfo("scriptlet", null, "JSP", url + "syntaxref206.html#10996#11007", null, null, new TagAttributeInfo[0]), new TagInfo("directive.page", null, "empty", directiveJspData[1].getInfoString(), null, null, directiveJspData[1].getAttributes()), new TagInfo("directive.include", null, "empty", directiveJspData[1].getInfoString(), null, null, directiveJspData[0].getAttributes())};
            ArrayList<TagInfo> standardTagTagDatasList = new ArrayList<TagInfo>();
            standardTagTagDatasList.addAll(Arrays.asList(standardJspTagDatas));
            standardTagTagDatasList.add(new TagInfo("doBody", null, "empty", url + "syntaxref2017.html", null, null, new TagAttributeInfo[]{new TagAttributeInfo("scope", false, url + "syntaxref2017.html#1006246#syntaxref20.html", false), new TagAttributeInfo("var", false, url + "syntaxref2017.html#1006234#1006240", false), new TagAttributeInfo("varReader", false, url + "syntaxref2017.html#1006240#1006246", false)}));
            standardTagTagDatasList.add(new TagInfo("invoke", null, "JSP", url + "syntaxref2021.html#8837#1003634", null, null, new TagAttributeInfo[]{new TagAttributeInfo("fragment", true, url + "syntaxref2021.html#1007359#1007361", false), new TagAttributeInfo("scope", false, url + "syntaxref2021.html#1007373#1003634", false), new TagAttributeInfo("var", false, url + "syntaxref2021.html#1007361#1007367", false), new TagAttributeInfo("varReader", false, url + "syntaxref2021.html#1007367#1007373", false)}));
            standardTagTagDatasList.add(new TagInfo("directive.tag", null, "empty", directiveTagFileData[2].getInfoString(), null, null, directiveTagFileData[2].getAttributes()));
            standardTagTagDatasList.add(new TagInfo("directive.attribute", null, "empty", directiveTagFileData[0].getInfoString(), null, null, directiveTagFileData[0].getAttributes()));
            standardTagTagDatasList.add(new TagInfo("directive.variable", null, "empty", directiveTagFileData[4].getInfoString(), null, null, directiveTagFileData[4].getAttributes()));
            standardTagTagDatas = standardTagTagDatasList.toArray(new TagInfo[0]);
        }
        if (xmlJspTagDatas == null) {
            TagInfo[] commonXMLTagDatas = new TagInfo[]{new TagInfo("output", null, "JSP", url + "syntaxref2022.html#1004130#1007521", null, null, new TagAttributeInfo[]{new TagAttributeInfo("doctype-public", false, "url + syntaxref2022.html#1007534#1007521", false), new TagAttributeInfo("doctype-root-element", false, "url + syntaxref2022.html#1007528#1007532", false), new TagAttributeInfo("doctype-system", false, url + "syntaxref2022.html#1007532#1007534", false), new TagAttributeInfo("omit-xml-declaration", false, url + "syntaxref2022.html#1007525#1007528", false)}), new TagInfo("root", null, "JSP", url + "syntaxref2024.html#1003283#1003311", null, null, new TagAttributeInfo[]{new TagAttributeInfo("version", false, url + "syntaxref2024.html#1003299#1003301", false), new TagAttributeInfo("xmlns:jsp", false, url + "syntaxref2024.html#1003297#1003299", false), new TagAttributeInfo("xmlns:x", false, url + "syntaxref2024.html#1003301#1003311", false)})};
            ArrayList<TagInfo> xmlJspTagDatasList = new ArrayList<TagInfo>();
            xmlJspTagDatasList.addAll(Arrays.asList(standardJspTagDatas));
            xmlJspTagDatasList.addAll(Arrays.asList(commonXMLTagDatas));
            xmlJspTagDatas = xmlJspTagDatasList.toArray(new TagInfo[0]);
            ArrayList<TagInfo> xmlTagFileTagDatasList = new ArrayList<TagInfo>();
            xmlTagFileTagDatasList.addAll(Arrays.asList(standardTagTagDatas));
            xmlTagFileTagDatasList.addAll(Arrays.asList(commonXMLTagDatas));
            xmlTagFileTagDatas = xmlTagFileTagDatasList.toArray(new TagInfo[0]);
        }
    }

    private TagInfo[] getTagInfos() {
        TagInfo[] rValue = this.fobj != null && ("text/x-jsp".equals(this.fobj.getMIMEType()) || "text/x-tag".equals(this.fobj.getMIMEType())) ? (this.isXmlSyntax() ? (NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? xmlTagFileTagDatas : xmlJspTagDatas) : (NbEditorUtilities.getMimeType((Document)this.getDocument()).equals("text/x-tag") ? standardTagTagDatas : standardJspTagDatas)) : new TagInfo[]{};
        return rValue;
    }

    public String toString() {
        return this.printJspCompletionInfo();
    }

    private String printJspCompletionInfo() {
        StringBuffer output = new StringBuffer();
        output.append("TAGS\n");
        List<Object> tagPrefixes = this.getTagPrefixes("");
        for (int i = 0; i < tagPrefixes.size(); ++i) {
            String prefix = (String)tagPrefixes.get(i);
            output.append("  " + prefix + "\n");
            List tags = this.getTags(prefix, "");
            for (int j = 0; j < tags.size(); ++j) {
                int k;
                Object attributes;
                if (tags.get(j) instanceof TagInfo) {
                    TagInfo ti = (TagInfo)tags.get(j);
                    output.append("    " + ti.getTagName() + "\n");
                    attributes = ti.getAttributes();
                    for (k = 0; k < ((TagAttributeInfo[])attributes).length; ++k) {
                        output.append("      " + attributes[k].getName() + "\n");
                    }
                    continue;
                }
                String tagName = (String)tags.get(j);
                output.append("    " + tagName + "\n");
                attributes = this.getTagAttributes(prefix, tagName, "");
                for (k = 0; k < attributes.size(); ++k) {
                    String attribute = (String)attributes.get(k);
                    output.append("      " + attribute + "\n");
                }
            }
        }
        output.append("DIRECTIVES\n");
        List directives = this.getDirectives("");
        for (int i = 0; i < directives.size(); ++i) {
            int k;
            Object attributes;
            if (directives.get(i) instanceof TagInfo) {
                TagInfo ti = (TagInfo)directives.get(i);
                output.append("    " + ti.getTagName() + "\n");
                attributes = ti.getAttributes();
                for (k = 0; k < ((TagAttributeInfo[])attributes).length; ++k) {
                    output.append("      " + attributes[k].getName() + "\n");
                }
                continue;
            }
            String directive = (String)directives.get(i);
            output.append("  " + directive + "\n");
            attributes = this.getDirectiveAttributes(directive, "");
            for (k = 0; k < attributes.size(); ++k) {
                String attribute = (String)attributes.get(k);
                output.append("      " + attribute + "\n");
            }
        }
        return output.toString();
    }

    @Deprecated
    public TokenItem getItemAtOrBefore(int offset) throws BadLocationException {
        TokenItem item;
        TokenItem backItem = null;
        int chainLength = 100;
        while (backItem == null) {
            backItem = offset < this.getDocument().getLength() ? this.getTokenChain(offset, Math.min(offset + chainLength, this.getDocument().getLength())) : this.getTokenChain(Math.max(offset - 50, 0), offset);
            if (chainLength++ <= 1000) continue;
        }
        if (backItem == null) {
            return null;
        }
        while (true) {
            if ((item = backItem.getNext()) == null) {
                item = backItem;
                break;
            }
            if (item.getOffset() > offset) {
                item = backItem;
                break;
            }
            backItem = item;
        }
        TokenItem adjustedItem = item.getOffset() == offset ? item.getPrevious() : item;
        return adjustedItem;
    }

    public SyntaxElement getElementChain(int offset) throws BadLocationException {
        TokenItem item = this.getItemAtOrBefore(offset);
        if (item == null) {
            return null;
        }
        TokenID id = item.getTokenID();
        if (id == JspTagTokenContext.ERROR || id == JspTagTokenContext.TEXT || id == JspMultiTokenContext.ERROR || id == JspDirectiveTokenContext.ERROR || id == JspDirectiveTokenContext.TEXT) {
            return null;
        }
        if (id == JspTagTokenContext.COMMENT || id == JspDirectiveTokenContext.COMMENT) {
            return this.getCommentChain(item, offset);
        }
        if (item.getTokenContextPath().contains(ELTokenContext.contextPath)) {
            return this.getELChain(item, offset);
        }
        if (id == JspTagTokenContext.SYMBOL2 || id == JspDirectiveTokenContext.SYMBOL2) {
            if (this.isScriptStartToken(item)) {
                return this.getScriptingChain(item, offset);
            }
            if (this.getTokenEnd(item) == offset && this.isScriptEndToken(item)) {
                item.getNext();
                if (!this.isTagDirToken(item)) {
                    return this.getContentChain(item, offset);
                }
            }
            return null;
        }
        if (id == JspTagTokenContext.TAG || id == JspTagTokenContext.SYMBOL || id == JspTagTokenContext.ATTRIBUTE || id == JspTagTokenContext.ATTR_VALUE || id == JspTagTokenContext.WHITESPACE || id == JspTagTokenContext.EOL || id == JspDirectiveTokenContext.TAG || id == JspDirectiveTokenContext.SYMBOL || id == JspDirectiveTokenContext.ATTRIBUTE || id == JspDirectiveTokenContext.ATTR_VALUE || id == JspDirectiveTokenContext.WHITESPACE || id == JspDirectiveTokenContext.EOL) {
            TokenItem elementStart = item;
            while (true) {
                if (elementStart == null) {
                    return null;
                }
                if (elementStart.getTokenID() == JspTagTokenContext.SYMBOL || elementStart.getTokenID() == JspDirectiveTokenContext.SYMBOL) {
                    if (elementStart.getImage().equals("<")) {
                        return this.getTagOrDirectiveChain(true, elementStart, offset);
                    }
                    if (elementStart.getImage().equals("</")) {
                        return this.getEndTagChain(elementStart, offset);
                    }
                    if (elementStart.getImage().equals("<%@")) {
                        return this.getTagOrDirectiveChain(false, elementStart, offset);
                    }
                }
                if (elementStart.getTokenID() == JspTagTokenContext.ERROR || elementStart.getTokenID() == JspDirectiveTokenContext.ERROR) {
                    return null;
                }
                if (elementStart.getTokenID() == JspTagTokenContext.COMMENT || elementStart.getTokenID() == JspDirectiveTokenContext.COMMENT) {
                    return null;
                }
                elementStart = elementStart.getPrevious();
            }
        }
        if (this.isScriptingOrContentToken(item)) {
            TokenItem elementStart = item;
            do {
                if (elementStart.getPrevious() != null) continue;
                return this.getContentChain(elementStart, offset);
            } while (this.isScriptingOrContentToken(elementStart = elementStart.getPrevious()) && elementStart.getTokenID() != JspTagTokenContext.COMMENT && elementStart.getTokenID() != JspDirectiveTokenContext.COMMENT && !elementStart.getTokenContextPath().contains(ELTokenContext.contextPath));
            if (this.isScriptStartToken(elementStart)) {
                return this.getScriptingChain(elementStart.getNext(), offset);
            }
            return this.getContentChain(elementStart.getNext(), offset);
        }
        return null;
    }

    private boolean isScriptStartToken(TokenItem item) {
        String image;
        if (item == null) {
            return false;
        }
        TokenID id = item.getTokenID();
        return !(id != JspTagTokenContext.SYMBOL2 && id != JspDirectiveTokenContext.SYMBOL2 || !(image = item.getImage()).equals("<%") && !image.equals("<%=") && !image.equals("<%!"));
    }

    private boolean isScriptEndToken(TokenItem item) {
        String image;
        if (item == null) {
            return false;
        }
        TokenID id = item.getTokenID();
        return (id == JspTagTokenContext.SYMBOL2 || id == JspDirectiveTokenContext.SYMBOL2) && (image = item.getImage()).equals("%>");
    }

    private boolean isInnerTagDirToken(TokenItem item) {
        String image;
        if (!this.isTagDirToken(item)) {
            return false;
        }
        TokenID id = item.getTokenID();
        return id != JspTagTokenContext.SYMBOL && id != JspDirectiveTokenContext.SYMBOL || !(image = item.getImage()).equals("<") && !image.equals("</") && !image.equals("<%@") && !image.equals("%>") && !image.equals(">") && !image.equals("/>");
    }

    private boolean isTagDirToken(TokenItem item) {
        if (item == null) {
            return false;
        }
        TokenID id = item.getTokenID();
        if (id == null) {
            return false;
        }
        return id == JspTagTokenContext.TEXT || id == JspTagTokenContext.ERROR || id == JspTagTokenContext.TAG || id == JspTagTokenContext.SYMBOL || id == JspTagTokenContext.ATTRIBUTE || id == JspTagTokenContext.ATTR_VALUE || id == JspTagTokenContext.WHITESPACE || id == JspTagTokenContext.EOL || id == JspDirectiveTokenContext.TEXT || id == JspDirectiveTokenContext.ERROR || id == JspDirectiveTokenContext.TAG || id == JspDirectiveTokenContext.SYMBOL || id == JspDirectiveTokenContext.ATTRIBUTE || id == JspDirectiveTokenContext.ATTR_VALUE || id == JspDirectiveTokenContext.WHITESPACE || id == JspDirectiveTokenContext.EOL;
    }

    private boolean isScriptingOrContentToken(TokenItem item) {
        if (item == null) {
            return true;
        }
        TokenID id = item.getTokenID();
        if (id == null) {
            return true;
        }
        return id != JspTagTokenContext.TEXT && id != JspTagTokenContext.ERROR && id != JspTagTokenContext.TAG && id != JspTagTokenContext.SYMBOL && id != JspTagTokenContext.ATTRIBUTE && id != JspTagTokenContext.ATTR_VALUE && id != JspTagTokenContext.SYMBOL2 && id != JspTagTokenContext.EOL && id != JspDirectiveTokenContext.TEXT && id != JspDirectiveTokenContext.ERROR && id != JspDirectiveTokenContext.TAG && id != JspDirectiveTokenContext.SYMBOL && id != JspDirectiveTokenContext.ATTRIBUTE && id != JspDirectiveTokenContext.ATTR_VALUE && id != JspDirectiveTokenContext.SYMBOL2 && id != JspDirectiveTokenContext.EOL && id != JspMultiTokenContext.ERROR;
    }

    public boolean isValueBeginning(String text) {
        if (text.trim().endsWith("\"\"")) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '=' || c == '\"') continue;
            return false;
        }
        return true;
    }

    private SyntaxElement getCommentChain(TokenItem token, int offset) {
        TokenItem start = null;
        TokenItem search = token;
        do {
            if (search == null || !search.getImage().startsWith("<%--")) continue;
            start = search;
            break;
        } while ((search = search.getPrevious()) != null);
        if (start == null) {
            return null;
        }
        TokenItem end = null;
        TokenItem prevNonNullToken = token;
        search = token;
        do {
            if (search != null && search.getImage().endsWith("--%>")) {
                end = search;
                break;
            }
            prevNonNullToken = search;
        } while ((search = search.getNext()) != null);
        if (end == null) {
            end = prevNonNullToken;
        }
        return new SyntaxElement.Comment(this, start.getOffset(), this.getTokenEnd(end));
    }

    private SyntaxElement getELChain(TokenItem token, int offset) {
        TokenItem scan = token;
        TokenItem start = null;
        do {
            start = scan;
        } while ((scan = scan.getPrevious()) != null && scan.getTokenContextPath().contains(ELTokenContext.contextPath));
        TokenItem end = null;
        scan = token;
        do {
            end = scan;
        } while ((scan = scan.getNext()) != null && scan.getTokenContextPath().contains(ELTokenContext.contextPath));
        return new SyntaxElement.ExpressionLanguage(this, start.getOffset(), this.getTokenEnd(end));
    }

    private SyntaxElement getTagOrDirectiveChain(boolean tag, TokenItem firstToken, int offset) {
        TokenItem item;
        String name = this.getWholeWord(item, (TokenID)JspTagTokenContext.TAG);
        for (item = firstToken.getNext(); item != null && (item.getTokenID().getNumericID() == 3 || item.getTokenID().getNumericID() == 11); item = item.getNext()) {
        }
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        while (this.isInnerTagDirToken(item)) {
            if (item.getTokenID().getNumericID() == 7) {
                String attributeName = this.getWholeWord(item, (TokenID)JspTagTokenContext.ATTRIBUTE);
                while (item != null && item.getTokenID().getNumericID() == 7) {
                    item = item.getNext();
                }
                while (item != null && item.getTokenID().getNumericID() == 4 && this.isValueBeginning(item.getImage())) {
                    item = item.getNext();
                }
                StringBuffer value = new StringBuffer();
                while (item != null && (item.getTokenID().getNumericID() == 8 || item.getTokenID().getNumericID() == 9)) {
                    value.append(item.getImage());
                    if (item != null && item.getTokenID().getNumericID() == 5) {
                        for (item = item.getNext(); !this.isScriptEndToken(item) && item != null; item = item.getNext()) {
                            value.append(item.getImage());
                        }
                        if (item != null) {
                            value.append(item.getImage());
                            item = item.getNext();
                        }
                    }
                    if (item == null || !item.getTokenContextPath().contains(ELTokenContext.contextPath)) continue;
                    while (item.getTokenContextPath().contains(ELTokenContext.contextPath) && (item = item.getNext()) != null) {
                        value.append(item.getImage());
                    }
                }
                String vString = value.toString();
                if (vString.startsWith("\"")) {
                    vString = vString.substring(1);
                }
                if (vString.endsWith("\"")) {
                    vString = vString.substring(0, vString.length() - 1);
                }
                attributes.put(attributeName, vString);
                continue;
            }
            if (item.getTokenID().getNumericID() == 5) {
                while (!this.isScriptEndToken(item) && item != null) {
                    item = item.getNext();
                }
                if (item == null) continue;
                item = item.getNext();
                continue;
            }
            item = item.getNext();
        }
        if (tag) {
            boolean endslash = false;
            if (item != null) {
                endslash = item.getImage().equals("/>");
            }
            return new SyntaxElement.Tag(this, firstToken.getOffset(), item != null ? this.getTokenEnd(item) : this.getDocument().getLength(), name, attributes, endslash);
        }
        return new SyntaxElement.Directive(this, firstToken.getOffset(), item != null ? this.getTokenEnd(item) : this.getDocument().getLength(), name, attributes);
    }

    private SyntaxElement getEndTagChain(TokenItem firstToken, int offset) {
        TokenItem item;
        String name = this.getWholeWord(item, (TokenID)JspTagTokenContext.TAG);
        for (item = firstToken.getNext(); item != null && item.getTokenID() == JspTagTokenContext.TAG; item = item.getNext()) {
        }
        while (this.isInnerTagDirToken(item)) {
            item = item.getNext();
        }
        return new SyntaxElement.EndTag(this, firstToken.getOffset(), this.getTokenEnd(item), name);
    }

    private String getWholeWord(TokenItem firstToken, TokenID requestedTokenID) {
        StringBuffer sb = new StringBuffer();
        while (firstToken != null && firstToken.getTokenID().getNumericID() == requestedTokenID.getNumericID()) {
            sb.append(firstToken.getImage());
            firstToken = firstToken.getNext();
        }
        return sb.toString().trim();
    }

    private SyntaxElement getScriptingChain(TokenItem firstToken, int offset) {
        if (firstToken == null) {
            return new SyntaxElement.ScriptingL(this, this.getDocument().getLength(), this.getDocument().getLength());
        }
        TokenItem item = firstToken;
        TokenItem nextItem;
        while ((nextItem = item.getNext()) != null) {
            if (!this.isScriptingOrContentToken(nextItem)) {
                return new SyntaxElement.ScriptingL(this, firstToken.getOffset(), this.getTokenEnd(nextItem));
            }
            item = nextItem;
        }
        return new SyntaxElement.ScriptingL(this, firstToken.getOffset(), this.getDocument().getLength());
    }

    private SyntaxElement getContentChain(TokenItem firstToken, int offset) {
        if (firstToken == null) {
            return new SyntaxElement.ContentL(this, this.getDocument().getLength(), this.getDocument().getLength());
        }
        TokenItem item = firstToken;
        TokenItem nextItem;
        while ((nextItem = item.getNext()) != null) {
            if (!this.isScriptingOrContentToken(nextItem) || nextItem.getTokenID() == JspTagTokenContext.COMMENT || nextItem.getTokenID() == JspDirectiveTokenContext.COMMENT || nextItem.getTokenContextPath().contains(ELTokenContext.contextPath)) {
                return new SyntaxElement.ContentL(this, firstToken.getOffset(), this.getTokenEnd(item));
            }
            item = nextItem;
        }
        return new SyntaxElement.ContentL(this, firstToken.getOffset(), this.getDocument().getLength());
    }

    SyntaxElement getPreviousElement(int offset) throws BadLocationException {
        if (offset == 0) {
            return null;
        }
        SyntaxElement elem = null;
        --offset;
        do {
            if ((elem = this.getElementChain(offset)) != null) continue;
            TokenItem ti = this.getItemAtOrBefore(offset);
            if (ti == null) {
                return null;
            }
            offset = ti.getOffset() - 1;
        } while (elem == null && offset >= 0);
        return elem;
    }

    SyntaxElement getNextElement(int offset) throws BadLocationException {
        int doclen = this.getDocument().getLength();
        if (offset >= doclen) {
            return null;
        }
        SyntaxElement elem = null;
        ++offset;
        do {
            if ((elem = this.getElementChain(offset)) != null) continue;
            TokenItem ti = this.getItemAtOrBefore(offset);
            if (ti == null) {
                return null;
            }
            offset = this.getTokenEnd(ti) + 1;
        } while (elem == null && offset < doclen);
        return elem;
    }

    public List<JspCompletionItem> getPossibleEndTags(int offset, int anchor, String pattern) throws BadLocationException {
        return this.getPossibleEndTags(offset, anchor, pattern, false);
    }

    /*
     * Unable to fully structure code
     */
    public List<JspCompletionItem> getPossibleEndTags(int offset, int anchor, String pattern, boolean firstOnly) throws BadLocationException {
        elem = this.getElementChain(offset);
        stack = new Stack<String>();
        result = new ArrayList<JspCompletionItem>();
        found = new HashSet<String>();
        if (elem != null) {
            elem = elem.getPrevious();
        } else if (offset > 0) {
            elem = this.getElementChain(offset - 1);
        } else {
            return result;
        }
        while (elem != null) {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (!(elem instanceof SyntaxElement.EndTag)) break block12;
                            stack.push(((SyntaxElement.EndTag)elem).getName());
                            break block13;
                        }
                        if (!(elem instanceof SyntaxElement.Tag) || (tag = (SyntaxElement.Tag)elem).isClosed()) break block13;
                        image = tag.getName();
                        prefix = image.substring(0, image.indexOf(58));
                        name = image.substring(image.indexOf(58) + 1);
                        ti = null;
                        tli = this.getTagLibrary(prefix, true);
                        if (tli != null && (ti = tli.getTag(name)) == null && (tagFileInfo = tli.getTagFile(name)) != null) {
                            ti = tagFileInfo.getTagInfo();
                        }
                        if ("jsp".equals(prefix)) {
                            JspSyntaxSupport.initCompletionData();
                            stanTagDatas = this.getTagInfos();
                            for (i = 0; i < stanTagDatas.length; ++i) {
                                if (!stanTagDatas[i].getTagName().equals(name)) continue;
                                ti = stanTagDatas[i];
                                break;
                            }
                        }
                        if (ti == null) break block13;
                        if (!stack.empty()) break block14;
                        if (!image.startsWith(pattern) || found.contains(image)) break block15;
                        found.add(image);
                        if (!ti.getBodyContent().equalsIgnoreCase("empty")) {
                            result.add(JspCompletionItem.createTag("/" + image, anchor, ti));
                            if (firstOnly) {
                                break;
                            } else {
                                ** GOTO lbl44
                            }
                        }
                        break block13;
lbl44:
                        // 2 sources

                        break block15;
                    }
                    if (((String)stack.peek()).equals(image)) {
                        stack.pop();
                    }
                }
                if (ti.getBodyContent().equalsIgnoreCase("empty")) {
                    // empty if block
                }
            }
            elem = elem.getPrevious();
        }
        return result;
    }

    public CompletionItem getAutocompletedEndTag(int offset) {
        try {
            SyntaxElement elem = this.getElementChain(offset - 1);
            if (elem != null && elem instanceof SyntaxElement.Tag) {
                String tagName = ((SyntaxElement.Tag)elem).getName();
                return HtmlCompletionItem.createAutocompleteEndTag((String)tagName, (int)offset);
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.INFO, null, e);
        }
        return null;
    }

    public FileObject getFileObject() {
        return this.fobj;
    }

    protected ExtSyntaxSupport.BracketFinder getMatchingBracketFinder(char bracketChar) {
        if (this.useCustomBracketFinder) {
            BracketFinder bf = new BracketFinder(bracketChar);
            return bf.isValid() ? bf : null;
        }
        return super.getMatchingBracketFinder(bracketChar);
    }

    public int[] findMatchingBlock(int offset, boolean simpleSearch) throws BadLocationException {
        int[] r_value = null;
        TokenItem token = this.getItemAtOrBefore(offset < this.getDocument().getLength() ? offset + 1 : offset);
        if (token != null) {
            if (token.getTokenID() == JspTagTokenContext.COMMENT) {
                return this.findMatchingJspComment(token, offset);
            }
            if (token.getTokenContextPath().contains(JspTagTokenContext.contextPath) && token.getTokenID().getNumericID() == 5) {
                return this.findMatchingScripletDelimiter(token);
            }
            if (token.getTokenContextPath().contains(JspTagTokenContext.contextPath)) {
                return this.findMatchingTag(token);
            }
            this.useCustomBracketFinder = !this.isScriptingOrContentToken(token);
            r_value = super.findMatchingBlock(offset, simpleSearch);
        }
        return r_value;
    }

    private int[] findMatchingJspComment(TokenItem token, int offset) {
        block5: {
            String tokenImage;
            block4: {
                tokenImage = token.getImage();
                if (!tokenImage.startsWith("<%--") || offset >= token.getOffset() + "<%--".length()) break block4;
                while (token != null && (token.getTokenID() == JspTagTokenContext.COMMENT || token.getTokenID() == JspTagTokenContext.EOL)) {
                    if (token.getImage().endsWith("--%>")) {
                        int start = token.getOffset() + token.getImage().length() - "--%>".length();
                        int end = token.getOffset() + token.getImage().length();
                        return new int[]{start, end};
                    }
                    token = token.getNext();
                }
                break block5;
            }
            if (!tokenImage.endsWith("--%>") || offset < token.getOffset() + token.getImage().length() - "--%>".length()) break block5;
            while (token != null && (token.getTokenID() == JspTagTokenContext.COMMENT || token.getTokenID() == JspTagTokenContext.EOL)) {
                if (token.getImage().startsWith("<%--")) {
                    int start = token.getOffset();
                    int end = token.getOffset() + "<%--".length();
                    return new int[]{start, end};
                }
                token = token.getPrevious();
            }
        }
        return null;
    }

    private int[] findMatchingScripletDelimiter(TokenItem token) {
        if (token.getImage().charAt(0) == '<') {
            while (!((token = token.getNext()) == null || token.getTokenContextPath().contains(JspTagTokenContext.contextPath) && token.getTokenID().getNumericID() == 5)) {
            }
        } else {
            while (!((token = token.getPrevious()) == null || token.getTokenContextPath().contains(JspTagTokenContext.contextPath) && token.getTokenID().getNumericID() == 5)) {
            }
        }
        if (token != null) {
            return new int[]{token.getOffset(), token.getOffset() + token.getImage().length()};
        }
        return null;
    }

    private int[] findMatchingTag(TokenItem token) {
        block28: {
            String tag;
            int poss;
            block29: {
                if (token != null && token.getTokenID().getNumericID() == 4 && token.getImage().charAt(token.getImage().length() - 1) == '>') {
                    token = token.getPrevious();
                }
                boolean isInside = false;
                if (token != null && (token.getTokenID().getNumericID() == 3 && token.getImage().trim().length() > 0 || token.getTokenID().getNumericID() == 4 && token.getImage().charAt(0) == '<')) {
                    if (token.getTokenID().getNumericID() == 4) {
                        while (token != null && (token.getTokenID().getNumericID() != 3 || token.getImage().trim().length() <= 0)) {
                            token = token.getNext();
                        }
                    }
                    isInside = true;
                } else if (token != null && (token.getTokenID().getNumericID() != 3 || token.getImage().trim().length() <= 0)) {
                    for (token = token.getPrevious(); !(token == null || token.getTokenID().getNumericID() == 3 && token.getImage().trim().length() > 0 || token.getTokenID().getNumericID() == 4 && token.getImage().charAt(token.getImage().length() - 1) == '>'); token = token.getPrevious()) {
                    }
                    if (token != null && token.getTokenID().getNumericID() == 3) {
                        isInside = true;
                    }
                }
                if (token == null || token.getTokenID().getNumericID() != 3 || !isInside) break block28;
                poss = 0;
                tag = token.getImage().trim();
                while (token != null && token.getTokenID().getNumericID() != 4) {
                    token = token.getPrevious();
                }
                if (token == null) {
                    return null;
                }
                if (token.getImage().length() != 2 || token.getImage().charAt(1) != '/') break block29;
                while (token != null) {
                    if (token.getTokenID().getNumericID() == 3 && token.getImage().trim().equals(tag)) {
                        while (token != null && token.getTokenID().getNumericID() != 4) {
                            token = token.getPrevious();
                        }
                        if (token != null) {
                            if (token.getImage().length() == 1) {
                                if (poss == 0) {
                                    TokenItem next;
                                    int start = token.getOffset();
                                    token = token.getNext();
                                    int end = token.getOffset() + token.getImage().length();
                                    for (next = token.getNext(); !(next == null || next.getTokenID() == JspTagTokenContext.SYMBOL && next.getImage().endsWith(">") || next.getTokenID() == JspTagTokenContext.EOL); next = next.getNext()) {
                                        end += next.getImage().length();
                                    }
                                    if (next != null && next.getTokenID() != JspTagTokenContext.EOL) {
                                        end += next.getImage().length();
                                    }
                                    return new int[]{start, end};
                                }
                                ++poss;
                            }
                            if (token.getImage().length() == 2) {
                                --poss;
                            }
                        }
                    }
                    token = token.getPrevious();
                }
                break block28;
            }
            if (token.getImage().length() != 1 || token.getImage().charAt(0) != '<') break block28;
            poss = 1;
            while (token != null) {
                if (token.getTokenID().getNumericID() == 3 && token.getImage().trim().equals(tag)) {
                    TokenItem hToken = token;
                    while (token != null && token.getTokenID().getNumericID() != 4) {
                        token = token.getPrevious();
                    }
                    if (token != null) {
                        if (token.getImage().length() == 2) {
                            if (poss == 0) {
                                int start = token.getOffset();
                                int end = hToken.getOffset() + hToken.getImage().length() + 1;
                                for (token = token.getNext(); token != null && (token.getTokenID().getNumericID() != 4 || token.getImage().charAt(0) != '>'); token = token.getNext()) {
                                }
                                if (token != null) {
                                    end = token.getOffset() + 1;
                                }
                                return new int[]{start, end};
                            }
                            ++poss;
                        }
                        if (token.getImage().length() == 1) {
                            --poss;
                        }
                    }
                    token = hToken;
                }
                token = token.getNext();
            }
        }
        return null;
    }

    public boolean isSingletonTag(TokenItem tagTokenItem) {
        for (TokenItem ti = tagTokenItem; ti != null; ti = ti.getNext()) {
            if (ti.getTokenID() == JspTagTokenContext.SYMBOL) {
                if ("/>".equals(ti.getImage())) {
                    return true;
                }
                if (">".equals(ti.getImage())) {
                    return false;
                }
            }
            if (ti.getTokenID() == JspTagTokenContext.TEXT) break;
        }
        return false;
    }

    protected TokenID[] getBracketSkipTokens() {
        return JSP_BRACKET_SKIP_TOKENS;
    }

    public static TokenSequence tokenSequence(TokenHierarchy hi, Language language, int offset) {
        TokenSequence ts = hi.tokenSequence(language);
        if (ts == null) {
            ts = hi.tokenSequence();
            if (ts == null) {
                return null;
            }
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return null;
            }
            ts = ts.embedded(language);
        }
        return ts;
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
        this.initFileObject();
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    static {
        helpMap = null;
        JSP_BRACKET_SKIP_TOKENS = new TokenID[]{JavaTokenContext.LINE_COMMENT, JavaTokenContext.BLOCK_COMMENT, JavaTokenContext.CHAR_LITERAL, JavaTokenContext.STRING_LITERAL, JspTagTokenContext.ATTR_VALUE, JspTagTokenContext.COMMENT};
    }

    public class BracketFinder
    extends ExtSyntaxSupport.BracketFinder {
        BracketFinder(char c) {
            super((ExtSyntaxSupport)JspSyntaxSupport.this, c);
        }

        protected boolean updateStatus() {
            if (super.updateStatus()) {
                return true;
            }
            boolean valid = true;
            switch (this.bracketChar) {
                case '<': {
                    this.matchChar = (char)62;
                    this.moveCount = 1;
                    break;
                }
                case '>': {
                    this.matchChar = (char)60;
                    this.moveCount = -1;
                    break;
                }
                default: {
                    valid = false;
                }
            }
            return valid;
        }

        boolean isValid() {
            return this.moveCount != 0;
        }
    }
}

