/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.filesystems.FileObject;

public final class JspELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "JspBeans";

    public String getBeanClass(String beanName, FileObject target, ResolverContext context) {
        for (ELVariableResolver.VariableInfo bean : this.getManagedBeans(target, context)) {
            if (!beanName.equals(bean.name)) continue;
            return bean.clazz;
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (ELVariableResolver.VariableInfo bean : this.getManagedBeans(target, context)) {
            if (!clazz.equals(bean.clazz)) continue;
            return bean.name;
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        JspParserAPI.ParseResult result = JspUtils.getCachedParseResult(target, true, false);
        if (result == null) {
            result = JspUtils.getCachedParseResult(target, false, false);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, this.getBeans(result));
        }
        return (List)context.getContent(CONTENT_NAME);
    }

    public List<ELVariableResolver.VariableInfo> getBeans(JspParserAPI.ParseResult result) {
        PageInfo pageInfo = result.getPageInfo();
        if (pageInfo == null) {
            return Collections.emptyList();
        }
        PageInfo.BeanData[] beans = pageInfo.getBeans();
        ArrayList<ELVariableResolver.VariableInfo> beansVars = new ArrayList<ELVariableResolver.VariableInfo>(beans.length);
        for (PageInfo.BeanData bd : beans) {
            beansVars.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bd.getId(), (String)bd.getClassName()));
        }
        return beansVars;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot snapshot, ResolverContext context) {
        return Collections.emptyList();
    }
}

