/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

public class SPSDescriptor
extends TupleDescriptor
implements UniqueSQLObjectDescriptor,
Dependent,
Provider {
    public static final char SPS_TYPE_TRIGGER = 'T';
    public static final char SPS_TYPE_REGULAR = 'S';
    public static final char SPS_TYPE_EXPLAIN = 'X';
    private static final int RECOMPILE = 1;
    private static final int INVALIDATE = 0;
    private final SchemaDescriptor sd;
    private final String name;
    private final UUID compSchemaId;
    private final char type;
    private String text;
    private final String usingText;
    private final UUID uuid;
    private boolean valid;
    private ExecPreparedStatement preparedStatement;
    private DataTypeDescriptor[] params;
    private Timestamp compileTime;
    private Object[] paramDefaults;
    private boolean initiallyCompilable;
    private boolean lookedUpParams;
    private UUIDFactory uuidFactory;

    public SPSDescriptor(DataDictionary dataDictionary, String string, UUID uUID, UUID uUID2, UUID uUID3, char c, boolean bl, String string2, boolean bl2) throws StandardException {
        this(dataDictionary, string, uUID, uUID2, uUID3, c, bl, string2, null, null, null, bl2);
    }

    public SPSDescriptor(DataDictionary dataDictionary, String string, UUID uUID, UUID uUID2, UUID uUID3, char c, boolean bl, String string2, String string3, Timestamp timestamp, ExecPreparedStatement execPreparedStatement, boolean bl2) throws StandardException {
        super(dataDictionary);
        if (uUID == null) {
            throw new IllegalArgumentException("UUID is null");
        }
        this.name = string;
        this.uuid = uUID;
        this.type = c;
        this.text = string2;
        this.usingText = string3;
        this.valid = bl;
        this.compileTime = timestamp;
        this.sd = dataDictionary.getSchemaDescriptor(uUID2, null);
        this.preparedStatement = execPreparedStatement;
        this.compSchemaId = uUID3;
        this.initiallyCompilable = bl2;
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        this.compileStatement(languageConnectionContext, tableDescriptor, transactionController);
        this.preparedStatement.makeInvalid(11, languageConnectionContext);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        this.prepareAndRelease(languageConnectionContext, tableDescriptor, null);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.prepareAndRelease(languageConnectionContext, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileStatement(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        Object object;
        ContextManager contextManager = languageConnectionContext.getContextManager();
        LanguageConnectionFactory languageConnectionFactory = languageConnectionContext.getLanguageConnectionFactory();
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.type == 'T' && tableDescriptor == null) {
            object = this.name.substring(49);
            tableDescriptor = dataDictionary.getTableDescriptor(this.recreateUUID((String)object));
        }
        if (tableDescriptor != null) {
            languageConnectionContext.pushTriggerTable(tableDescriptor);
        }
        object = languageConnectionFactory.getStatement(dataDictionary.getSchemaDescriptor(this.compSchemaId, null), this.text, true);
        try {
            this.preparedStatement = (ExecPreparedStatement)object.prepareStorable(languageConnectionContext, this.preparedStatement, this.getParameterDefaults(), this.getSchemaDescriptor(), this.type == 'T');
        }
        finally {
            if (tableDescriptor != null) {
                languageConnectionContext.popTriggerTable(tableDescriptor);
            }
        }
        if (this.preparedStatement.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
        this.setCompileTime();
        this.setParams(this.preparedStatement.getParameterTypes());
        if (!((DataDictionaryImpl)dataDictionary).readOnlyUpgrade) {
            dataDictionary.startWriting(languageConnectionContext);
            DependencyManager dependencyManager = dataDictionary.getDependencyManager();
            dependencyManager.clearDependencies(languageConnectionContext, this, transactionController);
            dependencyManager.copyDependencies(this.preparedStatement, this, false, contextManager, transactionController);
        }
        this.valid = true;
    }

    public final String getName() {
        return this.name;
    }

    public final String getQualifiedName() {
        return this.sd.getSchemaName() + "." + this.name;
    }

    public final SchemaDescriptor getSchemaDescriptor() {
        return this.sd;
    }

    public final char getType() {
        return this.type;
    }

    public final String getTypeAsString() {
        return String.valueOf(this.type);
    }

    public boolean initiallyCompilable() {
        return this.initiallyCompilable;
    }

    public static boolean validType(char c) {
        return c == 'S' || c == 'T';
    }

    public final synchronized Timestamp getCompileTime() {
        return this.compileTime;
    }

    public final synchronized void setCompileTime() {
        this.compileTime = new Timestamp(System.currentTimeMillis());
    }

    public final synchronized String getText() {
        return this.text;
    }

    public final synchronized void setText(String string) {
        this.text = string;
    }

    public final String getUsingText() {
        return this.usingText;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    public final synchronized DataTypeDescriptor[] getParams() throws StandardException {
        if (this.params == null && !this.lookedUpParams) {
            ArrayList arrayList = new ArrayList();
            this.params = this.getDataDictionary().getSPSParams(this, arrayList);
            this.paramDefaults = arrayList.toArray();
            this.lookedUpParams = true;
        }
        return this.params;
    }

    public final synchronized void setParams(DataTypeDescriptor[] dataTypeDescriptorArray) {
        this.params = dataTypeDescriptorArray;
    }

    public final synchronized Object[] getParameterDefaults() throws StandardException {
        if (this.paramDefaults == null) {
            this.getParams();
        }
        return this.paramDefaults;
    }

    public final synchronized void setParameterDefaults(Object[] objectArray) {
        this.paramDefaults = objectArray;
    }

    public final ExecPreparedStatement getPreparedStatement() throws StandardException {
        return this.getPreparedStatement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ExecPreparedStatement getPreparedStatement(boolean bl) throws StandardException {
        block12: {
            if (bl && (!this.valid || this.preparedStatement == null)) {
                ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
                LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
                if (!((DataDictionaryImpl)languageConnectionContext.getDataDictionary()).readOnlyUpgrade) {
                    TransactionController transactionController;
                    try {
                        transactionController = languageConnectionContext.getTransactionCompile().startNestedUserTransaction(false);
                        transactionController.setNoLockWait(true);
                    }
                    catch (StandardException standardException) {
                        transactionController = null;
                    }
                    boolean bl2 = this.initiallyCompilable;
                    try {
                        this.prepareAndRelease(languageConnectionContext, null, transactionController);
                        this.updateSYSSTATEMENTS(languageConnectionContext, 1, transactionController);
                    }
                    catch (StandardException standardException) {
                        if (standardException.getMessageId().equals("40XL1")) {
                            if (transactionController != null) {
                                transactionController.commit();
                                transactionController.destroy();
                                transactionController = null;
                            }
                            this.initiallyCompilable = bl2;
                            this.prepareAndRelease(languageConnectionContext, null, null);
                            this.updateSYSSTATEMENTS(languageConnectionContext, 1, null);
                            break block12;
                        }
                        throw standardException;
                    }
                    finally {
                        if (transactionController != null) {
                            transactionController.commit();
                            transactionController.destroy();
                        }
                    }
                }
            }
        }
        return this.preparedStatement;
    }

    public final UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    public final String toString() {
        return "";
    }

    public final DependableFinder getDependableFinder() {
        return this.getDependableFinder(226);
    }

    public final String getObjectName() {
        return this.name;
    }

    public final UUID getObjectID() {
        return this.uuid;
    }

    public final String getClassType() {
        return "StoredPreparedStatement";
    }

    public final synchronized boolean isValid() {
        return this.valid;
    }

    public final void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                break;
            }
            default: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y24.S", (Object)dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)this.name);
            }
        }
    }

    public final synchronized void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            case 10: 
            case 11: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                if (this.valid) {
                    this.valid = false;
                    this.updateSYSSTATEMENTS(languageConnectionContext, 0, null);
                }
                dependencyManager.invalidateFor(this, 14, languageConnectionContext);
                break;
            }
            case 13: {
                dependencyManager.clearDependencies(languageConnectionContext, this);
                break;
            }
        }
    }

    public final synchronized void revalidate(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.valid = false;
        this.makeInvalid(14, languageConnectionContext);
        this.prepareAndRelease(languageConnectionContext);
        this.updateSYSSTATEMENTS(languageConnectionContext, 1, null);
    }

    public void loadGeneratedClass() throws StandardException {
        if (this.preparedStatement != null) {
            ((StorablePreparedStatement)this.preparedStatement).loadGeneratedClass();
        }
    }

    private void updateSYSSTATEMENTS(LanguageConnectionContext languageConnectionContext, int n, TransactionController transactionController) throws StandardException {
        boolean bl;
        boolean bl2;
        boolean bl3 = false;
        if (n == 1) {
            bl2 = true;
            bl = true;
            if (!this.initiallyCompilable) {
                bl3 = true;
                this.initiallyCompilable = true;
            }
        } else {
            bl2 = false;
            bl = false;
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        if (((DataDictionaryImpl)dataDictionary).readOnlyUpgrade) {
            return;
        }
        dataDictionary.startWriting(languageConnectionContext);
        if (transactionController == null) {
            transactionController = languageConnectionContext.getTransactionExecute();
        }
        dataDictionary.updateSPS(this, transactionController, bl2, bl, bl3);
    }

    private UUID recreateUUID(String string) {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory.recreateUUID(string);
    }

    public String getDescriptorType() {
        return "Statement";
    }

    public String getDescriptorName() {
        return this.name;
    }
}

