/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.xml.text.folding.TokenElement;

public class XMLLexerFormatter {
    private static final Logger logger = Logger.getLogger(XMLLexerFormatter.class.getName());
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private final LanguagePath languagePath;
    private int spacesPerTab = 4;

    public XMLLexerFormatter(LanguagePath languagePath) {
        this.languagePath = languagePath;
    }

    protected LanguagePath supportedLanguagePath() {
        return this.languagePath;
    }

    public void reformat(Context context, final int startOffset, final int endOffset) throws BadLocationException {
        final BaseDocument doc = (BaseDocument)context.document();
        doc.render(new Runnable(){

            @Override
            public void run() {
                XMLLexerFormatter.this.doReformat(doc, startOffset, endOffset);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDocument doReformat(BaseDocument doc, int startOffset, int endOffset) {
        this.spacesPerTab = IndentUtils.indentLevelSize((Document)doc);
        try {
            List<TokenIndent> tags = this.getTags(doc, startOffset, endOffset);
            for (int i = tags.size() - 1; i >= 0; --i) {
                if (tags.get(i).isPreserveIndent()) continue;
                TokenElement tag = tags.get(i).getToken();
                int so = tag.getStartOffset();
                int lineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)so);
                String tagName = tag.getName();
                if (tagName.startsWith(TAG_CLOSING_PREFIX)) {
                    Element docElem = doc.getDefaultRootElement().getElement(lineOffset);
                    String lineStr = doc.getText(docElem.getStartOffset(), docElem.getEndOffset() - docElem.getStartOffset());
                    int ndx = lineStr.lastIndexOf(tagName);
                    if (ndx == -1) continue;
                    int ndx2 = (lineStr = lineStr.substring(0, ndx)).lastIndexOf(TAG_OPENING_PREFIX + tagName.substring(2));
                    if (ndx2 == -1) {
                        this.changePrettyText(doc, tag, so);
                        continue;
                    }
                    if ((ndx2 = (lineStr = lineStr.substring(ndx2 + 1)).indexOf(TAG_OPENING_PREFIX)) == -1) continue;
                    this.changePrettyText(doc, tag, so);
                    continue;
                }
                this.changePrettyText(doc, tag, so);
            }
        }
        catch (BadLocationException ble) {
        }
        catch (IOException iox) {
        }
        return doc;
    }

    private void changePrettyText(BaseDocument doc, TokenElement tag, int so) throws BadLocationException {
        int spaces;
        boolean noNewline = false;
        switch (tag.getType()) {
            case TOKEN_ATTR_NAME: {
                spaces = tag.getIndentLevel();
                break;
            }
            case TOKEN_PI_START_TAG: {
                noNewline = true;
            }
            default: {
                spaces = tag.getIndentLevel();
            }
        }
        String newIndentText = IndentUtils.createIndentString((Document)doc, (int)spaces);
        int previousEndOffset = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)so) + 1;
        String temp = doc.getText(previousEndOffset, so - previousEndOffset);
        if (noNewline || so == 0 || temp.indexOf("\n") != -1) {
            int i = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)so);
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)so);
            String currentIndent = doc.getText(rowStart, i - rowStart);
            if (!currentIndent.equals(newIndentText)) {
                doc.insertString(so, newIndentText, null);
                doc.remove(rowStart, i - rowStart);
            }
        } else {
            doc.insertString(so, "\n" + newIndentText, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TokenIndent> getTags(BaseDocument basedoc, int startOffset, int endOffset) throws BadLocationException, IOException {
        ArrayList<TokenIndent> tags = new ArrayList<TokenIndent>();
        LinkedList<Boolean> preserveNesting_outdent = new LinkedList<Boolean>();
        preserveNesting_outdent.add(Boolean.FALSE);
        boolean preserveWhitespace = false;
        boolean settingSpaceValue = false;
        int indentLevel = -this.spacesPerTab;
        basedoc.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)basedoc);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            Token token = tokenSequence.token();
            if (token != null && token.id() == XMLTokenId.TEXT && tokenSequence.moveNext()) {
                token = tokenSequence.token();
            }
            int currentTokensSize = 0;
            Stack<TokenElement> stack = new Stack<TokenElement>();
            int firstAttributeIndent = -1;
            int lineIndent = -1;
            boolean wasNewline = false;
            while (tokenSequence.moveNext()) {
                int indentLineStart = 1;
                token = tokenSequence.token();
                XMLTokenId tokenId = (XMLTokenId)token.id();
                String image = ((Object)token.text()).toString();
                if (tokenSequence.offset() > endOffset) {
                    break;
                }
                boolean tokenInSelectionRange = tokenSequence.offset() >= startOffset || tokenSequence.offset() + token.length() > endOffset;
                TokenElement.TokenType tokenType = TokenElement.TokenType.TOKEN_WHITESPACE;
                switch (tokenId) {
                    case TAG: {
                        int len = image.length();
                        firstAttributeIndent = -1;
                        if (image.charAt(len - 1) == '>') {
                            if (len == 2) {
                                if (!preserveWhitespace) {
                                    indentLevel -= this.spacesPerTab;
                                }
                                if (stack.empty()) break;
                                stack.pop();
                                break;
                            }
                            if (!wasNewline || !tokenInSelectionRange) break;
                            TokenElement tag = new TokenElement(TokenElement.TokenType.TOKEN_ELEMENT_END_TAG, image, tokenSequence.offset(), tokenSequence.offset() + token.length(), indentLevel);
                            tags.add(new TokenIndent(tag, false));
                            break;
                        }
                        tokenType = TokenElement.TokenType.TOKEN_ELEMENT_START_TAG;
                        if (image.startsWith(TAG_CLOSING_PREFIX)) {
                            boolean changeIndent;
                            boolean preservingWhitespaceOnClose;
                            int begin = currentTokensSize;
                            int end = begin + image.length();
                            boolean bl = preservingWhitespaceOnClose = !preserveNesting_outdent.isEmpty() && (Boolean)preserveNesting_outdent.removeLast() != false;
                            if (indentLevel < 0) {
                                indentLevel = 0;
                            }
                            String tagName = image.substring(2);
                            int newIndentLevel = -1;
                            for (int i = stack.size() - 1; newIndentLevel < 0 && i >= 0; --i) {
                                TokenElement el = (TokenElement)stack.get(i);
                                if (!el.getName().equals(tagName)) continue;
                                newIndentLevel = el.getIndentLevel();
                                stack.subList(i, stack.size()).clear();
                            }
                            boolean bl2 = changeIndent = !preserveNesting_outdent.isEmpty() && (Boolean)preserveNesting_outdent.getLast() == false;
                            if (changeIndent) {
                                int n = indentLevel = newIndentLevel >= 0 ? newIndentLevel : indentLevel;
                            }
                            if (tokenInSelectionRange) {
                                TokenElement tag = new TokenElement(tokenType, image, begin, end, indentLevel);
                                tags.add(new TokenIndent(tag, preservingWhitespaceOnClose));
                            }
                            if (changeIndent) {
                                indentLevel -= this.spacesPerTab;
                            }
                            preserveWhitespace = !preserveNesting_outdent.isEmpty() && (Boolean)preserveNesting_outdent.getLast() != false;
                        } else {
                            String tagName = image.substring(1);
                            int begin = currentTokensSize;
                            int end = begin + image.length();
                            boolean bl = preserveWhitespace = !preserveNesting_outdent.isEmpty() && (Boolean)preserveNesting_outdent.getLast() != false;
                            if (!preserveWhitespace) {
                                indentLevel = !tokenInSelectionRange ? Utilities.getVisualColumn((BaseDocument)basedoc, (int)tokenSequence.offset()) : (indentLevel += this.spacesPerTab);
                            }
                            TokenElement tag = new TokenElement(tokenType, tagName, begin, end, indentLevel);
                            preserveNesting_outdent.add(preserveWhitespace);
                            stack.push(tag);
                            if (tokenInSelectionRange) {
                                tags.add(new TokenIndent(tag, preserveWhitespace));
                            }
                        }
                        settingSpaceValue = false;
                        break;
                    }
                    case PI_START: {
                        tokenType = TokenElement.TokenType.TOKEN_PI_START_TAG;
                        indentLevel += this.spacesPerTab;
                        if (!tokenInSelectionRange || preserveWhitespace) break;
                        TokenElement tag = new TokenElement(tokenType, tokenId.name(), tokenSequence.offset(), tokenSequence.offset() + token.length(), indentLevel);
                        tags.add(new TokenIndent(tag, preserveWhitespace));
                        break;
                    }
                    case PI_END: {
                        indentLevel -= this.spacesPerTab;
                        if (!wasNewline || !tokenInSelectionRange) break;
                        TokenElement tag = new TokenElement(TokenElement.TokenType.TOKEN_PI_END_TAG, image, tokenSequence.offset(), tokenSequence.offset() + token.length(), indentLevel);
                        tags.add(new TokenIndent(tag, false));
                        break;
                    }
                    case WS: {
                        int lastNewline = image.lastIndexOf(10);
                        if (lastNewline == -1) break;
                        wasNewline = true;
                        int tokenOffset = tokenSequence.offset();
                        int nextLine = tokenOffset + lastNewline;
                        lineIndent = Utilities.getRowIndent((BaseDocument)basedoc, (int)nextLine);
                        break;
                    }
                    case PI_CONTENT: {
                        indentLineStart = 0;
                    }
                    case TEXT: {
                        int lastNewline = image.lastIndexOf(10);
                        if (lastNewline == -1 || preserveWhitespace || !tokenInSelectionRange) break;
                        String[] lines = image.split("\n");
                        int currentOffset = tokenSequence.offset();
                        for (int lno = indentLineStart; lno < lines.length; ++lno) {
                            int nonWhiteStart;
                            int lineEnd = (currentOffset += lno == 0 ? 0 : lines[lno - 1].length() + 1) + lines[lno].length();
                            if ((nonWhiteStart = Utilities.getFirstNonWhiteFwd((BaseDocument)basedoc, (int)currentOffset, (int)lineEnd)) < startOffset || nonWhiteStart > endOffset) continue;
                            tags.add(new TokenIndent(new TokenElement(TokenElement.TokenType.TOKEN_CHARACTER_DATA, tokenId.name(), nonWhiteStart, lineEnd, indentLevel + this.spacesPerTab), false));
                        }
                        break;
                    }
                    case BLOCK_COMMENT: {
                        int currentOffset = tokenSequence.offset();
                        String[] lines = image.split("\n");
                        int lineStart = Utilities.getRowStart((BaseDocument)basedoc, (int)currentOffset);
                        if (lineStart < currentOffset && Utilities.getFirstNonWhiteBwd((BaseDocument)basedoc, (int)currentOffset, (int)lineStart) > -1) break;
                        int lastLineStart = Utilities.getRowStart((BaseDocument)basedoc, (int)(currentOffset + token.length() - 1));
                        int lastIndent = IndentUtils.lineIndent((Document)basedoc, (int)lastLineStart);
                        int baseIndent = indentLevel + this.spacesPerTab;
                        int indentShift = baseIndent - lastIndent;
                        for (int lno = 0; lno < lines.length; ++lno) {
                            int lineEnd = Utilities.getRowEnd((BaseDocument)basedoc, (int)currentOffset);
                            int desiredIndent = lno == 0 || lno == lines.length - 1 ? baseIndent : IndentUtils.lineIndent((Document)basedoc, (int)currentOffset) + indentShift;
                            if ((currentOffset >= startOffset || currentOffset + lines[lno].length() > endOffset) && currentOffset < endOffset) {
                                tags.add(new TokenIndent(new TokenElement(TokenElement.TokenType.TOKEN_CHARACTER_DATA, tokenId.name(), currentOffset, lineEnd, Math.max(0, desiredIndent)), false));
                            }
                            currentOffset += lines[lno].length() + 1;
                        }
                        break;
                    }
                    case CDATA_SECTION: 
                    case CHARACTER: 
                    case OPERATOR: 
                    case PI_TARGET: 
                    case DECLARATION: {
                        break;
                    }
                    case ARGUMENT: {
                        settingSpaceValue = token.text().equals("xml:space");
                        if (wasNewline) {
                            int attrIndent;
                            if (firstAttributeIndent == -1) {
                                tokenType = TokenElement.TokenType.TOKEN_CHARACTER_DATA;
                                attrIndent = indentLevel + this.spacesPerTab;
                            } else {
                                tokenType = TokenElement.TokenType.TOKEN_ATTR_NAME;
                                attrIndent = firstAttributeIndent;
                            }
                            if (!tokenInSelectionRange) break;
                            tags.add(new TokenIndent(new TokenElement(tokenType, ((Object)token.text()).toString(), tokenSequence.offset(), tokenSequence.offset() + token.length(), attrIndent), false));
                            break;
                        }
                        if (firstAttributeIndent != -1) break;
                        firstAttributeIndent = Utilities.getVisualColumn((BaseDocument)basedoc, (int)tokenSequence.offset());
                        break;
                    }
                    case VALUE: {
                        if (!settingSpaceValue) break;
                        if (token.text().equals("\"preserve\"")) {
                            preserveWhitespace = true;
                        } else if (token.text().equals("\"default\"")) {
                            preserveWhitespace = false;
                        }
                        preserveNesting_outdent.set(preserveNesting_outdent.size() - 1, preserveWhitespace);
                        settingSpaceValue = false;
                        break;
                    }
                    default: {
                        throw new IOException("Invalid token found in document: Please use the text editor to resolve the issues...");
                    }
                }
                currentTokensSize += image.length();
                if (tokenId == XMLTokenId.WS || tokenId == XMLTokenId.TEXT) continue;
                lineIndent = -1;
                wasNewline = false;
            }
        }
        finally {
            basedoc.readUnlock();
        }
        return tags;
    }

    public boolean isOneLiner(int start, int end, BaseDocument doc) {
        try {
            return Utilities.getLineOffset((BaseDocument)doc, (int)start) == Utilities.getLineOffset((BaseDocument)doc, (int)end);
        }
        catch (BadLocationException ex) {
            return false;
        }
    }

    void reformat(Context context) throws BadLocationException {
        this.reformat(context, context.startOffset(), context.endOffset());
    }

    private class TokenIndent {
        private TokenElement token;
        private boolean preserveIndent;

        public TokenIndent(TokenElement token, boolean preserveIndent) {
            this.token = token;
            this.preserveIndent = preserveIndent;
        }

        public TokenElement getToken() {
            return this.token;
        }

        public boolean isPreserveIndent() {
            return this.preserveIndent;
        }

        public void setPreserveIndent(boolean preserveIndent) {
            this.preserveIndent = preserveIndent;
        }

        public String toString() {
            return "TokenIndent: name=" + this.token.getName() + " preserveIndent=" + this.preserveIndent;
        }
    }
}

