/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.bracematch;

import java.util.Stack;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class XMLBraceMatcher
implements BracesMatcher {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String COMMENT_START = "<!--";
    private static final String COMMENT_END = "-->";
    private static final String DECLARATION_START = "<!DOCTYPE";
    private static final String DECLARATION_END = ">";
    private int searchOffset;
    private Document document;
    private MatcherContext context;
    private BracesMatcher defaultMatcher;

    public XMLBraceMatcher(MatcherContext context) {
        this(context.getDocument(), context.getSearchOffset());
        this.context = context;
    }

    XMLBraceMatcher(Document doc, int offset) {
        this.document = doc;
        this.searchOffset = offset;
    }

    public int[] findOrigin() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        int[] origin = this.doFindOrigin();
        if (origin != null) {
            return origin;
        }
        this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)this.context, (int)-1, (int)-1);
        return this.defaultMatcher.findOrigin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] doFindOrigin() throws InterruptedException, BadLocationException {
        AbstractDocument doc = (AbstractDocument)this.document;
        doc.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            Token token = this.atOffset(ts, this.searchOffset);
            token = ts.token();
            int start = ts.offset();
            if (token == null) {
                int[] nArray = null;
                return nArray;
            }
            XMLTokenId id = (XMLTokenId)token.id();
            String tokenText = ((Object)token.text()).toString();
            switch (id) {
                case PI_START: 
                case PI_END: {
                    int[] nArray = new int[]{start, start + token.length()};
                    return nArray;
                }
                case TAG: {
                    if (DECLARATION_END.equals(tokenText)) {
                        while (this.move(ts) && ts.token().id() != XMLTokenId.TAG) {
                        }
                    }
                    int[] nArray = this.findTagPosition(ts, false);
                    return nArray;
                }
                case BLOCK_COMMENT: {
                    if (!tokenText.startsWith(COMMENT_START) && !tokenText.endsWith(COMMENT_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(ts, COMMENT_START, COMMENT_END);
                    return nArray;
                }
                case CDATA_SECTION: {
                    if (!tokenText.startsWith(CDATA_START) && !tokenText.endsWith(CDATA_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(ts, CDATA_START, CDATA_END);
                    return nArray;
                }
                case DECLARATION: {
                    if (!tokenText.startsWith(DECLARATION_START) && !tokenText.endsWith(DECLARATION_END)) {
                        int[] nArray = null;
                        return nArray;
                    }
                    int[] nArray = this.findGenericOrigin(ts, DECLARATION_START, DECLARATION_END);
                    return nArray;
                }
            }
            return null;
        }
        finally {
            doc.readUnlock();
        }
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (MatcherContext.isTaskCanceled()) {
            return null;
        }
        if (this.defaultMatcher != null) {
            return this.defaultMatcher.findMatches();
        }
        return this.doFindMatches();
    }

    private boolean move(TokenSequence s) {
        if (this.context == null || this.context.isSearchingBackward()) {
            return s.movePrevious();
        }
        return s.moveNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] doFindMatches() throws InterruptedException, BadLocationException {
        AbstractDocument doc = (AbstractDocument)this.document;
        doc.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            Token token = this.atOffset(ts, this.searchOffset);
            if (token == null) {
                int[] nArray = null;
                return nArray;
            }
            XMLTokenId id = (XMLTokenId)token.id();
            switch (id) {
                case PI_START: {
                    int[] nArray = this.findMatchingPair(ts, XMLTokenId.PI_END, true);
                    return nArray;
                }
                case PI_END: {
                    int[] nArray = this.findMatchingPair(ts, XMLTokenId.PI_START, false);
                    return nArray;
                }
                case TAG: {
                    String tagName;
                    if (DECLARATION_END.equals(((Object)ts.token().text()).toString())) {
                        while (ts.movePrevious() && ts.token().id() != XMLTokenId.TAG) {
                        }
                    }
                    if ((tagName = ((Object)ts.token().text()).toString()).startsWith("</")) {
                        int[] nArray = this.findMatchingTagBackward(ts, tagName.substring(2));
                        return nArray;
                    }
                    if (tagName.startsWith("<")) {
                        int[] nArray = this.findMatchingTagForward(ts, tagName.substring(1));
                        return nArray;
                    }
                }
                case BLOCK_COMMENT: {
                    int[] nArray = this.findGenericMatch(ts, COMMENT_START, COMMENT_END);
                    return nArray;
                }
                case CDATA_SECTION: {
                    int[] nArray = this.findGenericMatch(ts, CDATA_START, CDATA_END);
                    return nArray;
                }
                case DECLARATION: {
                    int[] nArray = this.findGenericMatch(ts, DECLARATION_START, DECLARATION_END);
                    return nArray;
                }
            }
            return null;
        }
        finally {
            doc.readUnlock();
        }
    }

    private Token atOffset(TokenSequence ts, int offset) {
        int diff = ts.move(offset);
        if (diff == 0 && (this.context == null || this.context.isSearchingBackward()) ? !ts.movePrevious() : !ts.moveNext()) {
            return null;
        }
        if (diff == ts.token().text().length() - 1 && this.context != null && !this.context.isSearchingBackward() && !ts.moveNext()) {
            return null;
        }
        do {
            Token t = ts.token();
            XMLTokenId id = (XMLTokenId)t.id();
            switch (id) {
                case ARGUMENT: 
                case OPERATOR: 
                case VALUE: 
                case WS: {
                    break;
                }
                default: {
                    return t;
                }
            }
        } while (ts.movePrevious());
        return ts.token();
    }

    private static Token findTokenAtContext(TokenSequence ts, int offset) {
        ts.move(offset);
        Token token = ts.token();
        if (token == null) {
            ts.moveNext();
            token = ts.token();
        }
        return token;
    }

    private int[] findTagPosition(TokenSequence ts, boolean tagNameOnly) {
        if ("/>".equals(((Object)ts.token().text()).toString())) {
            return null;
        }
        Token token = ts.token();
        int start = ts.offset();
        int tagNameEnd = start + token.length();
        int end = start + token.length();
        while (ts.moveNext()) {
            Token t = ts.token();
            end += t.length();
            if (t.id() != XMLTokenId.TAG) continue;
            if ("/>".equals(((Object)t.text()).toString())) {
                return null;
            }
            if (DECLARATION_END.equals(((Object)t.text()).toString())) {
                if (tagNameOnly) {
                    return new int[]{start, tagNameEnd, end - 1, end};
                }
                return new int[]{start, end, start, tagNameEnd, end - 1, end};
            }
            return new int[]{start, start + token.length()};
        }
        return null;
    }

    private int[] findMatchingPair(TokenSequence ts, XMLTokenId idToMatch, boolean isForward) {
        while (isForward ? ts.moveNext() : ts.movePrevious()) {
            Token t = ts.token();
            if (t.id() == XMLTokenId.TAG) {
                return null;
            }
            if (t.id() != idToMatch) continue;
            int start = ts.offset();
            int end = start + t.length();
            return new int[]{start, end};
        }
        return null;
    }

    private int[] findMatchingTagForward(TokenSequence ts, String tagToMatch) {
        Stack<String> stack = new Stack<String>();
        while (ts.moveNext()) {
            String tag;
            Token t = ts.token();
            if (XMLTokenId.TAG != t.id() || DECLARATION_END.equals(tag = ((Object)t.text()).toString())) continue;
            if (tag.startsWith("</") || tag.equals("/>")) {
                if (stack.empty()) {
                    if (tag.length() == 3 || tag.equals("</" + tagToMatch)) {
                        return this.findTagPosition(ts, false);
                    }
                    return null;
                }
                stack.pop();
                continue;
            }
            stack.push(tag.substring(1));
        }
        return null;
    }

    private int[] findMatchingTagBackward(TokenSequence ts, String tagToMatch) {
        Stack<String> stack = new Stack<String>();
        while (ts.movePrevious()) {
            String tag;
            Token t = ts.token();
            if (XMLTokenId.TAG != t.id() || DECLARATION_END.equals(tag = ((Object)t.text()).toString()) || "/>".equals(tag)) continue;
            if (stack.empty()) {
                if (("<" + tagToMatch).equals(tag)) {
                    return this.findTagPosition(ts, true);
                }
            } else if (tag.startsWith("<") && ("<" + (String)stack.peek()).equals(tag)) {
                stack.pop();
            }
            if (!tag.startsWith("</")) continue;
            stack.push(tag.substring(2));
        }
        return null;
    }

    private int[] findGenericOrigin(TokenSequence ts, String startTag, String endTag) {
        Token token = ts.token();
        String text = ((Object)token.text()).toString();
        int start = ts.offset();
        int end = start + startTag.length();
        if (text.startsWith(startTag) && start <= this.searchOffset && end > this.searchOffset) {
            return new int[]{start, end};
        }
        start = ts.offset() + token.length() - endTag.length();
        end = start + endTag.length();
        if (text.toString().endsWith(endTag) && start <= this.searchOffset && end >= this.searchOffset) {
            return new int[]{start, end};
        }
        return null;
    }

    private int[] findGenericMatch(TokenSequence ts, String startTag, String endTag) {
        int offset;
        Token token = ts.token();
        int start = offset = ts.offset();
        int end = start + startTag.length();
        if (((Object)token.text()).toString().startsWith(startTag) && start <= this.searchOffset && end > this.searchOffset) {
            return this.findGenericMatchForward(ts, endTag);
        }
        start = offset + token.length() - endTag.length();
        end = start + endTag.length();
        if (((Object)token.text()).toString().endsWith(endTag) && start <= this.searchOffset && end >= this.searchOffset) {
            return this.findGenericMatchBackward(ts, startTag);
        }
        return null;
    }

    private int[] findGenericMatchForward(TokenSequence ts, String endTag) {
        Token token = ts.token();
        int start = ts.offset() + token.length() - endTag.length();
        int end = start + endTag.length();
        if (((Object)token.text()).toString().endsWith(endTag)) {
            return new int[]{start, end};
        }
        while (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() != token.id() || !((Object)t.text()).toString().endsWith(endTag)) continue;
            start = ts.offset() + t.length() - endTag.length();
            end = start + endTag.length();
            return new int[]{start, end};
        }
        return null;
    }

    private int[] findGenericMatchBackward(TokenSequence ts, String startTag) {
        Token token = ts.token();
        int start = ts.offset();
        int end = start + startTag.length();
        if (((Object)token.text()).toString().startsWith(startTag)) {
            return new int[]{start, end};
        }
        while (ts.movePrevious()) {
            Token t = ts.token();
            if (t.id() != token.id() || !((Object)t.text()).toString().startsWith(startTag)) continue;
            start = ts.offset();
            return new int[]{start, start + startTag.length()};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasEndTag(Document document, int offset, String startTag) {
        AbstractDocument doc = (AbstractDocument)document;
        doc.readLock();
        try {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            Token token = XMLBraceMatcher.findTokenAtContext(ts, offset);
            Stack<String> stack = new Stack<String>();
            while (ts.moveNext()) {
                String tag;
                Token t = ts.token();
                if (XMLTokenId.TAG != t.id() || DECLARATION_END.equals(tag = ((Object)t.text()).toString())) continue;
                if (stack.empty()) {
                    if (("</" + startTag).equals(tag)) {
                        stack.empty();
                        stack = null;
                        boolean bl = true;
                        return bl;
                    }
                } else if (tag.equals("/>") || ("</" + (String)stack.peek()).equals(tag)) {
                    stack.pop();
                    continue;
                }
                stack.push(tag.substring(1));
            }
        }
        finally {
            doc.readUnlock();
        }
        return false;
    }
}

