/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.settings.FindBugsSettingsProvider;
import org.netbeans.api.project.Project;

class DisableDetectorAction
extends AbstractAction {
    private final BugInstance bugInstance;
    private final Project project;

    DisableDetectorAction(BugInstance bugInstance, Project project) {
        this.bugInstance = bugInstance;
        this.project = project;
        bugInstance.getBugPattern();
        this.putValue("Name", "Disable Detector");
    }

    public void actionPerformed(ActionEvent e) {
        FindBugsSettingsProvider settingsProvider = (FindBugsSettingsProvider)this.project.getLookup().lookup(FindBugsSettingsProvider.class);
        if (null != settingsProvider) {
            UserPreferences findBugsSettings = settingsProvider.getFindBugsSettings();
            Iterator factoryIterator = DetectorFactoryCollection.instance().factoryIterator();
            while (factoryIterator.hasNext()) {
                DetectorFactory detectorFactory = (DetectorFactory)factoryIterator.next();
                if (!detectorFactory.getReportedBugPatterns().contains(this.bugInstance.getBugPattern())) continue;
                findBugsSettings.enableDetector(detectorFactory, false);
            }
            settingsProvider.setFindBugsSettings(findBugsSettings);
        }
        FindBugsSession qualitySession = (FindBugsSession)((Object)this.project.getLookup().lookup(FindBugsSession.class));
        FindBugsResult result = qualitySession.getResult();
        result.removeAllBugInstancesForBugPattern(this.bugInstance.getBugPattern());
    }
}

