/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugTree;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.RefreshAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class CoreFilterToggleAction
extends AbstractAction
implements PropertyChangeListener {
    private static final Icon coreFilterDisabled = new ImageIcon(ImageUtilities.loadImage((String)"org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/bullseye_off.png"));
    private static final Icon coreFilterEnabled = new ImageIcon(ImageUtilities.loadImage((String)"org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/bullseye.png"));
    private final BugTree bugTreePanel;

    CoreFilterToggleAction(BugTree bugTreePanel) {
        this.bugTreePanel = bugTreePanel;
        this.updateState();
    }

    public void actionPerformed(ActionEvent e) {
        this.bugTreePanel.setCoreFilterEnabled(!this.bugTreePanel.isCoreFilterEnabled());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateState();
    }

    private void updateState() {
        if (this.bugTreePanel.isCoreFilterEnabled()) {
            this.putValue("Name", "Disable Core Filter");
            this.putValue("SmallIcon", coreFilterDisabled);
            this.putValue("ShortDescription", NbBundle.getMessage(RefreshAction.class, (String)"HINT_CORE_FILTER_OFF"));
        } else {
            this.putValue("Name", "Enable Core Filter");
            this.putValue("SmallIcon", coreFilterEnabled);
            this.putValue("ShortDescription", NbBundle.getMessage(RefreshAction.class, (String)"HINT_CORE_FILTER_ON"));
        }
    }
}

