/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.annotations.BugAnnotationProcessor;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugAnnotationNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugCellRenderer;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugGroupNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugInstanceNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.DisableDetectorAction;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.FilterBugPattern;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.SessionNode;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

class BugTree
extends JTree {
    public static final String PROPERTY_ACTIVE_MODE = "ActiveMode";
    public static final String PROPERTY_CORE_FILTER_ENABLED = "CoreFilterEnabled";
    private final RequestProcessor requestProcessor;
    private final FindBugsSession session;
    private FindBugsResult.Mode resultMode = FindBugsResult.Mode.TYPE;
    private boolean isCollapsed = true;
    private boolean coreFilterEnabled = true;

    BugTree(FindBugsSession session) {
        this.session = session;
        this.requestProcessor = new RequestProcessor("BugTree-" + session.getDisplayName(), 1);
        this.session.addPropertyChangeListener(new SessionListener(this));
        this.setCellRenderer(BugCellRenderer.instance());
        this.addMouseListener(new JumpToSourceMouseListener());
        this.addKeyListener(new JumpToSourceKeyListener());
    }

    public FindBugsSession getSession() {
        return this.session;
    }

    public boolean isActiveMode(FindBugsResult.Mode mode) {
        return this.resultMode == mode;
    }

    public void setActiveMode(FindBugsResult.Mode mode) {
        FindBugsResult.Mode oldMode = this.resultMode;
        this.resultMode = mode;
        this.refresh();
        this.firePropertyChange(PROPERTY_ACTIVE_MODE, (Object)oldMode, (Object)this.resultMode);
    }

    public boolean isCoreFilterEnabled() {
        return this.coreFilterEnabled;
    }

    public void setCoreFilterEnabled(boolean coreFilterEnabled) {
        boolean oldCoreFilterEnabled = this.coreFilterEnabled;
        this.coreFilterEnabled = coreFilterEnabled;
        this.refresh();
        this.firePropertyChange(PROPERTY_CORE_FILTER_ENABLED, oldCoreFilterEnabled, this.coreFilterEnabled);
    }

    public void refresh() {
        this.requestProcessor.post(new Runnable(){

            public void run() {
                final TreeNode rootNode = BugTree.createRootTreeNode(BugTree.this.session, BugTree.this.coreFilterEnabled, BugTree.this.resultMode);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BugTree.this.setModel(new DefaultTreeModel(rootNode));
                        if (BugTree.this.isCollapsed) {
                            BugTree.this.collapseAll();
                        } else {
                            BugTree.this.expandAll();
                        }
                    }
                });
            }
        });
    }

    public void collapseAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.collapseRow(row);
        }
    }

    public void expandAll() {
        for (int row = this.getRowCount() - 1; row > 0; --row) {
            this.expandRow(row);
        }
    }

    private static TreeNode createRootTreeNode(FindBugsSession session, boolean coreFilterEnabled, FindBugsResult.Mode resultMode) {
        if (null == session || null == session.getResult()) {
            return new DefaultMutableTreeNode("No result available");
        }
        SessionNode rootNode = new SessionNode(session, session.getResult().getBugCount(coreFilterEnabled));
        rootNode.setUserObject((Object)session);
        Map<?, Collection<BugInstance>> instances = resultMode.getInstanceList(session.getResult(), coreFilterEnabled);
        int typeIndex = 0;
        for (Map.Entry<?, Collection<BugInstance>> entry : instances.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            BugGroupNode typeNode = new BugGroupNode(entry.getKey(), entry.getValue().size());
            int index = 0;
            for (BugInstance bugInstance : entry.getValue()) {
                BugInstanceNode bugInstanceNode = new BugInstanceNode(bugInstance, true);
                typeNode.insert(bugInstanceNode, index);
                ++index;
                int annotationIndex = 0;
                Iterator it = bugInstance.annotationIterator();
                while (it.hasNext()) {
                    BugAnnotation annotation = (BugAnnotation)it.next();
                    bugInstanceNode.insert(new BugAnnotationNode(annotation), annotationIndex);
                    ++annotationIndex;
                }
            }
            rootNode.insert(typeNode, typeIndex);
            ++typeIndex;
        }
        return rootNode;
    }

    public JPopupMenu getComponentPopupMenu() {
        DefaultMutableTreeNode selectedNode;
        Object obj;
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (null != treePath && treePath.getPathCount() > 0 && (obj = (selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof BugInstance) {
            DisableDetectorAction disableDetector = new DisableDetectorAction((BugInstance)obj, this.session.getProject());
            FilterBugPattern filterBugPattern = new FilterBugPattern((BugInstance)obj);
            return Utilities.actionsToPopup((Action[])new Action[]{disableDetector, filterBugPattern}, (Lookup)Utilities.actionsGlobalContext());
        }
        return null;
    }

    private static void jumpToSource(final TreePath treePath) {
        if (null == treePath || treePath.getPathCount() == 0) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BugTree.jumpToSource(treePath);
                }
            });
            return;
        }
        FindBugsSession session = (FindBugsSession)((Object)((DefaultMutableTreeNode)treePath.getPathComponent(0)).getUserObject());
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object obj = selectedNode.getUserObject();
        if (obj instanceof SourceLineAnnotation) {
            BugInstance bugInstance = (BugInstance)((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject();
            BugAnnotationProcessor.openSourceFile(bugInstance, (SourceLineAnnotation)obj, session.getProject());
        } else if (obj instanceof ClassAnnotation) {
            BugInstance bugInstance = (BugInstance)((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject();
            BugAnnotationProcessor.openSourceFile(bugInstance, (ClassAnnotation)obj, session.getProject());
        } else if (obj instanceof MethodAnnotation) {
            BugInstance bugInstance = (BugInstance)((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject();
            BugAnnotationProcessor.openSourceFile(bugInstance, (MethodAnnotation)obj, session.getProject());
        } else if (obj instanceof FieldAnnotation) {
            BugInstance bugInstance = (BugInstance)((DefaultMutableTreeNode)selectedNode.getParent()).getUserObject();
            BugAnnotationProcessor.openSourceFile(bugInstance, (FieldAnnotation)obj, session.getProject());
        } else if (obj instanceof BugInstance) {
            BugInstance bugInstance = (BugInstance)obj;
            BugAnnotationProcessor.openSourceFile(bugInstance, session.getProject());
        }
    }

    private static class JumpToSourceKeyListener
    extends KeyAdapter {
        private JumpToSourceKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTree jTree = (JTree)keyEvent.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTree jTree = (JTree)keyEvent.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }
    }

    private static class JumpToSourceMouseListener
    extends MouseAdapter {
        private JumpToSourceMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            if (2 == evt.getClickCount()) {
                JTree jTree = (JTree)evt.getSource();
                BugTree.jumpToSource(jTree.getSelectionPath());
            }
        }
    }

    private static class SessionListener
    implements PropertyChangeListener {
        private final BugTree bugTreePanel;

        public SessionListener(BugTree bugTreePanel) {
            this.bugTreePanel = bugTreePanel;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            this.bugTreePanel.refresh();
        }
    }
}

