/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsResult;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugAnnotationNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugGroupNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.BugInstanceNode;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.SessionNode;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;

class BugCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color HIGH_PRIORITY_COLOR = new Color(0xFF0000);
    private static final Color NORMAL_PRIORITY_COLOR = new Color(0x9F0000);
    private static final Color LOW_PRIORITY_COLOR = Color.BLACK;
    private static final Color EXP_PRIORITY_COLOR = Color.BLACK;
    private static final Color IGNORE_PRIORITY_COLOR = Color.LIGHT_GRAY;
    private static final BugCellRenderer theInstance = new BugCellRenderer();
    private static final long serialVersionUID = 1L;
    private final ImageIcon bugGroupIcon;
    private final ImageIcon packageIcon;
    private final ImageIcon bugIcon;
    private final ImageIcon classIcon;
    private final ImageIcon methodIcon;
    private final ImageIcon fieldIcon;
    private final ImageIcon localVariableIcon;
    private final ImageIcon sourceFileIcon;
    private Object value;

    private BugCellRenderer() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.bugGroupIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug.png"));
        this.packageIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/package.gif"));
        this.bugIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug2.png"));
        this.classIcon = new ImageIcon(classLoader.getResource("org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/class.gif"));
        this.methodIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/method.png"));
        this.fieldIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/field.png"));
        this.localVariableIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/field.png"));
        this.sourceFileIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/sourcefile.png"));
    }

    public static BugCellRenderer instance() {
        return theInstance;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof BugAnnotationNode) {
            BugAnnotation bugAnnotation = ((BugAnnotationNode)value).getBugAnnotation();
            if (bugAnnotation instanceof ClassAnnotation) {
                this.setIcon(this.classIcon);
            } else if (bugAnnotation instanceof MethodAnnotation) {
                this.setIcon(this.methodIcon);
            } else if (bugAnnotation instanceof FieldAnnotation) {
                this.setIcon(this.fieldIcon);
            } else if (bugAnnotation instanceof SourceLineAnnotation) {
                this.setIcon(this.sourceFileIcon);
            } else {
                this.setIcon(null);
            }
        } else if (value instanceof BugInstanceNode) {
            BugInstance bugInstance = ((BugInstanceNode)value).getBugInstance();
            this.setIcon(this.bugIcon);
            this.setText(bugInstance.getMessage());
        } else if (value instanceof SessionNode) {
            SessionNode sessionNode = (SessionNode)value;
            ProjectInformation information = ProjectUtils.getInformation((Project)sessionNode.getSession().getProject());
            this.setIcon(information.getIcon());
            this.setText(information.getDisplayName() + " (" + sessionNode.getBugCount() + ")");
        } else if (value instanceof BugGroupNode) {
            BugGroupNode bugGroupNode = (BugGroupNode)value;
            Object groupObject = bugGroupNode.getGroupObject();
            if (groupObject instanceof FindBugsResult.ClassKey) {
                this.setIcon(this.classIcon);
                this.setText(((FindBugsResult.ClassKey)groupObject).getDisplayName());
            } else if (groupObject instanceof FindBugsResult.PackageKey) {
                this.setIcon(this.packageIcon);
                this.setText(((FindBugsResult.PackageKey)groupObject).getDisplayName());
            } else if (groupObject instanceof FindBugsResult.CategoryKey) {
                this.setIcon(this.bugGroupIcon);
                this.setText(((FindBugsResult.CategoryKey)groupObject).getDisplayName());
            } else if (groupObject instanceof BugPattern) {
                BugPattern bugPattern = (BugPattern)groupObject;
                this.setIcon(this.bugGroupIcon);
                this.setText(bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription());
                this.setToolTipText(bugPattern.getDetailHTML());
            } else {
                this.setIcon(null);
            }
            this.setText(this.getText() + " (" + bugGroupNode.getSize() + ")");
        } else {
            this.setIcon(null);
        }
        return this;
    }

    public Color getTextNonSelectionColor() {
        return this.getCellTextColor();
    }

    private Color getCellTextColor() {
        Color color = Color.BLACK;
        if (this.value instanceof BugInstance) {
            BugInstance bugInstance = (BugInstance)this.value;
            switch (bugInstance.getPriority()) {
                case 1: {
                    color = HIGH_PRIORITY_COLOR;
                    break;
                }
                case 2: {
                    color = NORMAL_PRIORITY_COLOR;
                    break;
                }
                case 3: {
                    color = LOW_PRIORITY_COLOR;
                    break;
                }
                case 4: {
                    color = EXP_PRIORITY_COLOR;
                    break;
                }
                case 5: {
                    color = IGNORE_PRIORITY_COLOR;
                }
            }
        }
        return color;
    }
}

