/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.tools.findbugs.codedefects.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.nbheaven.sqe.core.api.SQEManager;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.FindBugsSession;
import org.nbheaven.sqe.tools.findbugs.codedefects.core.ui.result.ResultPanel;
import org.netbeans.api.project.Project;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="FindBugsTopComponent", iconBase="org/nbheaven/sqe/tools/findbugs/codedefects/core/resources/findbugs.png", persistenceType=0)
public final class FindBugsTopComponent
extends TopComponent {
    static final String PREFERRED_ID = "FindBugsTopComponent";
    private SQEManagerListener sqeManagerListener = new SQEManagerListener(this);
    private FindBugsSession activeSession = null;
    private final JComponent emptyComponent;
    private JPanel resultPanel;

    private FindBugsTopComponent() {
        this.initComponents();
        this.emptyComponent = new JLabel("<No Results available>");
        this.emptyComponent.setBackground(Color.WHITE);
        this.setName(NbBundle.getMessage(FindBugsTopComponent.class, (String)"CTL_FindBugsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FindBugsTopComponent.class, (String)"HINT_FindBugsTopComponent"));
    }

    private void initComponents() {
        this.resultPanel = new JPanel();
        this.addAncestorListener(new AncestorListener(){

            public void ancestorMoved(AncestorEvent evt) {
            }

            public void ancestorAdded(AncestorEvent evt) {
                FindBugsTopComponent.this.formAncestorAdded(evt);
            }

            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.setLayout(new BorderLayout());
        this.resultPanel.setLayout(new BorderLayout());
        this.add(this.resultPanel, "Center");
    }

    private void formAncestorAdded(AncestorEvent evt) {
    }

    public static synchronized FindBugsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        return win instanceof FindBugsTopComponent ? (FindBugsTopComponent)win : new FindBugsTopComponent();
    }

    public void componentOpened() {
        SQEManager.getDefault().addPropertyChangeListener("PropActiveProject", (PropertyChangeListener)this.sqeManagerListener);
        this.setActiveSessionByProject(SQEManager.getDefault().getActiveProject());
    }

    public void componentClosed() {
        SQEManager.getDefault().removePropertyChangeListener("PropActiveProject", (PropertyChangeListener)this.sqeManagerListener);
        this.setActiveSession(null);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
    }

    private void setActiveSessionByProject(final Project project) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FindBugsTopComponent.this.setActiveSessionByProject(project);
                }
            });
            return;
        }
        if (null != project) {
            this.setActiveSession((FindBugsSession)((Object)project.getLookup().lookup(FindBugsSession.class)));
            AbstractNode node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)project));
            this.setActivatedNodes(new Node[]{node});
        } else {
            this.setActiveSession(null);
            this.setActivatedNodes(new Node[0]);
        }
    }

    private void setActiveSession(FindBugsSession session) {
        assert (EventQueue.isDispatchThread()) : "setActiveSession has to be called on EventQueue";
        if (this.activeSession != session) {
            this.activeSession = session;
            JComponent component = null != this.activeSession ? new ResultPanel(this.activeSession) : this.emptyComponent;
            this.resultPanel.removeAll();
            this.resultPanel.add((Component)component, "Center");
            this.resultPanel.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    private static class SQEManagerListener
    implements PropertyChangeListener {
        private final FindBugsTopComponent component;

        private SQEManagerListener(FindBugsTopComponent component) {
            this.component = component;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("PropActiveProject".equals(evt.getPropertyName())) {
                this.component.setActiveSessionByProject((Project)evt.getNewValue());
            }
        }
    }
}

